#!/bin/bash

# Checks if the OpenStack VMs (virtual machines on VMware) are running on the correct hyperviser
# Usually they are pinned to a specific HV to make sure they are distributed well and that they
# are not migrated randomly since this also creates clock skew on the Ceph monitor nodes.

source ~nagios/.vmwarerc

STATE_OK=0
STATE_WARNING=1
STATE_CRITICAL=2
STATE_UNKNOWN=3

result=$(curl -s -k -X POST -H "Authorization: Basic $AUTH" https://vc-intern01.vmware.noris.de/rest/com/vmware/cis/session)
# result is like {"value":"XXXX"}, remove leading string up to :", then trailing
# string before "
begin=${result#*:\"}
SESSION=${begin%\"*}

shopt -s extglob
case "$SESSION" in
  +([0-9a-f]))
    if [ ${#SESSION} -lt 30 ]; then
      echo "Invalid Session Key: $SESSION"
      exit $STATE_UNKNOWN
    fi
    ;;
  *)
    echo "Invalid Session Key: $SESSION"
    exit $STATE_UNKNOWN
    ;;
esac

STATUS=$STATE_OK

check_vm() {
  vm=$1
  host=$2
  vmname=$3
  hostname=$4

  result=$(curl -k -s -X GET -H "Cookie: vmware-api-session-id=$SESSION;Path=/rest;Secure;HttpOnly" "https://vc-intern01.vmware.noris.de/rest/vcenter/vm?filter.vms=$vm&filter.hosts=$host")
  if ! echo "$result"|grep -q "POWERED_ON"; then
    echo "VM $vmname not running on Host $hostname"
    STATUS=$STATE_CRITICAL
  fi
}

check_vm vm-19012 host-706031 mon01vp.worker.nbg6a esx01-nbg6a-02
check_vm vm-21700 host-159081 mon02vp.worker.nbg6a esx06-nbg3-01
check_vm vm-35116 host-706038 mon03vp.worker.nbg6a esx03-nbg6a-02

check_vm vm-21721 host-174772 mon01vp.worker.nbg6b esx03-nbg3-01
check_vm vm-20577 host-706035 mon02vp.worker.nbg6b esx02-nbg6a-02
check_vm vm-28959 host-158146 mon03vp.worker.nbg6b esx07-nbg3-01

if [ $STATUS -eq $STATE_OK ]; then
  echo "All VMs are placed on the correct HVs"
fi

exit $STATUS
