#!/bin/bash
# Description: Check if there are open puppet changes
# Date: 20.04.2019
# Issue: OS-679
# Author: Marc Vorwerk <marc.vorwerk@noris.de>


# Exit Status Codes
OK=0
WARNING=1
CRITICAL=2
UNKNOWN=3
 
# Config Options
RUN=false
CHECK=false
HELP=false
OUTPUTFILE="/etc/puppet.output"
EXITFILE="/etc/puppet.state"
touch -a $OUTPUTFILE
touch -a $EXITFILE


# Options
while getopts "rch" PARAM
do
    case "$PARAM" in
        r)
            RUN=true
            ;;
        c)
            CHECK=true
            ;;
        h)
            HELP=true
            ;;
    esac
done

# FUNCTION help

f_help(){
   echo "USAGE: ./$0 [-c] [-r] [-h]"
   echo "OPTIONS: -r == run"
   echo "OPTIONS: -c == check"
   echo "OPTIONS: -h == help"
   echo "You can only use -r or -c"
}


# FUNCTION check

f_check(){
   if grep -q "PUPPET-STATE:$CRITICAL" $EXITFILE
   then
        echo "Puppet would like to change something"
        cat $EXITFILE
        cat $OUTPUTFILE
        exit $CRITICAL
   else
       echo "All OK - no Changes available"
       exit $OK
   fi
}


# FUNCTION run

f_run(){
   PUPPET="/opt/puppetlabs/bin/puppet"
   $PUPPET agent -tv --noop > $OUTPUTFILE 2>&1
   EXITCODE="$?"
   echo "Bla bla bla: $EXITCODE"
   if [ "$EXITCODE" -ne "0" ]
   then
      echo "Puppet run in noop mode exited not with return code $EXITCODE:"
      echo "$OUTPUTFILE"
      echo "PUPPET-STATE:$CRITICAL" > $EXITFILE
      exit $CRITICAL
   else
       echo "Puppet run in noop mode with no errors (exit code 0)"
   fi

   SUM_CHANGES=$(cat /opt/puppetlabs/puppet/cache/state/last_run_summary.yaml | grep noop | awk '{ print $2 }')
   
   if [ -z "$SUM_CHANGES" ]
   then
        echo "All OK - no Changes available" > $EXITFILE
        echo "PUPPET-STATE:$OK" >> $EXITFILE
        exit $OK
    fi

   if [ "$SUM_CHANGES" -gt "0" ]
   then
      echo "Puppet would like to change $SUM_CHANGES things" > $EXITFILE
      echo "PUPPET-STATE:$CRITICAL" >> $EXITFILE
      exit $CRITICAL
   fi
}

# MAIN

if [ "$HELP" == "true" ]
then
    f_help
fi

if [ "$CHECK" == "true" ]
then
    f_check
fi

if [ "$RUN" == "true" ]
then
    f_run
fi


