#!/bin/bash

# Ceilometer API monitoring script for Sensu / Nagios
#
# Copyright <C2><A9> 2013-2014 eNovance <licensing@enovance.com>
#
# Author: Guillaume Abrioux <guillaume.abrioux@enovance.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Requirement: curl
#
# set -e

# . `dirname $0`/functions.sh
STATE_OK=0
STATE_WARNING=1
STATE_CRITICAL=2
STATE_UNKNOWN=3
STATE_DEPENDENT=4

usage ()
{
    echo "Usage: $0 [OPTIONS]"
    echo " -h                   Get help"
    echo " -H <Auth URL>        URL for obtaining an auth token. Ex: http://localhost:5000/v2.0"
    echo " -E <Endpoint URL>    URL for ceilometer API. Ex: http://localhost:8777/v1"
    echo " -T <tenant>          Tenant to use to get an auth token"
    echo " -U <username>        Username to use to get an auth token"
    echo " -P <password>        Password to use ro get an auth token"
}

while getopts 'hH:U:T:P:E:' OPTION
do
    case $OPTION in
        h)
            usage
            exit 0
            ;;
        H)
            export OS_AUTH_URL=$OPTARG
            ;;
        E)
            export ENDPOINT_URL=$OPTARG
            ;;
        T)
            export OS_TENANT_NAME=$OPTARG
            ;;
        U)
            export OS_USERNAME=$OPTARG
            ;;
        P)
            export OS_PASSWORD=$OPTARG
            ;;
        *)
            usage
            exit 1
            ;;
    esac
done

# Set default values
OS_AUTH_URL=${OS_AUTH_URL:-"http://control.nbg6.openstack.noris.de:5000/v3"}
# ENDPOINT_URL=${ENDPOINT_URL:-"$(keystone catalog --service metering|grep publicURL|cut -d'|' -f3)"}
ENDPOINT_URL=${ENDPOINT_URL:-"http://control.nbg6.openstack.noris.de:8777"}
OS_USERNAME=${OS_USERNAME:-"monitoring"}
# OS_PASSWORD=${OS_PASSWORD}
OS_TENANT_NAME=${OS_TENANT_NAME:-"monitoring"}


if ! which curl >/dev/null 2>&1
then
    echo "curl is not installed."
    exit $STATE_UNKNOWN
fi

if [ -z "$OS_PASSWORD" ]; then
    echo "no OS_PASSWORD defined."
    exit $STATE_UNKNOWN
fi

TOKEN=$(curl -i -s -X 'POST' ${OS_AUTH_URL}/auth/tokens -d '{"auth": { "identity": { "methods": ["password"], "password": {"user": { "name": "'"$OS_USERNAME"'", "domain": { "name": "Default"}, "password": "'"$OS_PASSWORD"'"}}}}}' -H 'Content-type: application/json' |tee /tmp/check_openstack_ceilometer_api-tok.out 2>&1|grep -o 'X-Subject-Token: .*'|awk '{print $2}')

if [ -z "$TOKEN" ]; then
    echo "Unable to get a token from Keystone API"
    exit $STATE_CRITICAL
fi

RES=$(curl -s -H "X-Auth-Token: $TOKEN" -H 'Content-Type: application/json' ${ENDPOINT_URL}/v2/capabilities |tee /tmp/check_openstack_ceilometer_api.out 2>&1| grep -o statistics:aggregation:standard -c)

if [ -z "$RES" -o "$RES" -lt 1 ]; then
    echo "Unable to get ceilometer resources"
    exit $STATE_CRITICAL
else
    echo "Ceilometer API is working." 
fi

