#!/usr/bin/python3
import argparse
import json
import os
import sys
import subprocess
from datetime import datetime

OK       = 0
WARNING  = 1
CRITICAL = 2
UNKNOWN  = 3

timeout = 900
extra_arg = ''
openstack_env = [
    'OS_PROJECT_DOMAIN_NAME',
    'OS_USER_DOMAIN_NAME',
    'OS_PROJECT_NAME',
    'OS_USERNAME',
    'OS_PASSWORD',
    'OS_AUTH_URL',
    'OS_IDENTITY_API_VERSION',
    'OS_PROJECT_ID',
]

argparser = argparse.ArgumentParser(description="A Nagios check that searches for stuck cinder volumes. If no argument is given, it fallbacks to OS_ environment variables.")
argparser.add_argument("--os-cloud", required=False, nargs=1, dest="cloud", help="Specify the cloud's name. ")
args = argparser.parse_args()

if args.cloud is not None:
    extra_arg = '--os-cloud ' + args.cloud[0]
else:
    for env in openstack_env:
        if not os.environ.get(env):
            print("Unknown: Environment variable '" + env + "' is not set")
            sys.exit(UNKNOWN)

stuck_volumes= []
volumes = json.loads((os.popen("openstack " + extra_arg + " volume list --status='creating' --all-projects --column='ID' --format='json'")).read())

for volume in volumes:
    volume_details = json.loads((os.popen("openstack " + extra_arg + " volume show --format='json' --column 'created_at' --column='updated_at' " + volume['ID'])).read())
    if volume_details['updated_at'] is None:
        volume_timestamp = datetime.strptime(volume_details['created_at'],"%Y-%m-%dT%H:%M:%S.%f")
    else:
        volume_timestamp = datetime.strptime(volume_details['updated_at'],"%Y-%m-%dT%H:%M:%S.%f")

    time_diff = int((datetime.utcnow() - volume_timestamp).total_seconds())
    if time_diff > timeout :
        stuck_volumes.append(volume['ID'])

if stuck_volumes:
    print( str(len(stuck_volumes)) + ' stuck cinder volume(s):', end=' '),
    print(*stuck_volumes),
    sys.exit(CRITICAL)

print('OK')
sys.exit(OK)

