#!/bin/bash

## Issue: OS-426
## Checks that all openstack domains are registered in kunde
## Excpetions can be added via editing ~nagios/.nnis-rest
# updated: 2020-30-25

# Start clean
unset OS_DOMAIN_EXCEPTIONS_FORMATTED
unset OS_DOMAIN_LIST

#Setup Openstack authentication
source ~nagios/.osmonrc-v3

#Setup nnis-rest authentication
source ~nagios/.nnis-rest

# Load an array of non-registed domains in Kunde to exclude from the db-sync test
source ~nagios/.os-domain-exceptions

#Transform non-registered domains array to grep-parsable format
for project in "${OS_DOMAIN_EXCEPTIONS[@]}"; do OS_DOMAIN_EXCEPTIONS_FORMATTED=$(echo -n $OS_DOMAIN_EXCEPTIONS_FORMATTED"$project "); done
OS_DOMAIN_EXCEPTIONS_FORMATTED=$(echo $OS_DOMAIN_EXCEPTIONS_FORMATTED | sed 's/ *$//g' | tr ' ' '|')

#Get openstack domains
OS_DOMAIN_LIST=$(openstack domain list -f value  | grep 'True' | awk '{print $2}' | sort)

#Exclude non-registed domains from selection
if [ ! -z "$OS_DOMAIN_EXCEPTIONS" ]; then
    OS_DOMAIN_LIST=$(echo "$OS_DOMAIN_LIST" | grep -Ewv "$OS_DOMAIN_EXCEPTIONS_FORMATTED")
fi

#Get registered domains from Kunde
KUNDE_DOMAIN_LIST=$(curl -s -k -g -u $NNIS_USERNAME:$NNIS_PASSWORD $NNIS_API | jq '._data[].name' -r | sort)

#If variables are empty, something's wrong
if [ -z "$OS_DOMAIN_LIST" ] || [ -z "$KUNDE_DOMAIN_LIST" ]; then
    echo 'Could not fetch domains.'
    exit 3
fi

if [ "$KUNDE_DOMAIN_LIST" == "$OS_DOMAIN_LIST" ]; then
    echo 'OK'
    exit 0
else

    echo "Not synced domains: $(echo ${KUNDE_DOMAIN_LIST[@]} ${OS_DOMAIN_LIST[@]}| tr ' ' '\n' | sort | uniq -u | tr '\n' ' ')"
    exit 2
fi
