#!/opt/openstacksdk/bin/python
import json
import sys

from pprint import pprint

import openstack
import argparse

parser = argparse.ArgumentParser(description='Find used memory')
parser.add_argument('--cloud', required=True, type=str, help='which cloud to use')
parser.add_argument('--filter', required=True, type=str, help='string to filter hypervisors')
parser.add_argument('--debug', action='store_true', required=False, help='enable debug output')
parser.add_argument('--verbose', action='store_true', required=False, help='be more verbose')
parser.add_argument('--warn_pct', required=False, type=int, default='60', help='percent of used memory to trigger warn-state')
parser.add_argument('--crit_pct', required=False, type=int, default='80', help='percent of used memory to trigger crit-state')

args = parser.parse_args()

def verbose(line):
    if(args.verbose is True):
       print(line)

# Initialize and turn on debug logging
openstack.enable_logging(debug=args.debug)

# Initialize cloud
conn = openstack.connect(cloud=args.cloud, version='2.53')

memory_used = 0
memory_size = 0
exit = 0

print("Checking %s @ %s" % (args.filter, args.cloud))

verbose("HV;MEMORY;USED;FREE;PERCENT")
for hv in conn.compute.hypervisors(details=True):
    if args.filter in hv.name:
        if 'enabled' in hv.status:
                memory_size = memory_size + hv.memory_size
                memory_used = memory_used + hv.memory_used
                verbose("%s;%s;%s;%s;%.2f" %( hv.name, hv.memory_used, hv.memory_size, hv.memory_size-hv.memory_used, hv.memory_used/hv.memory_size))

percent = (memory_used / memory_size) * 100;
memory_size_gb = memory_size / 1024;
memory_used_gb = memory_used / 1024;
memory_free_gb = (memory_size - memory_used) / 1024;

if (percent > args.crit_pct):
    print("CRIT: more than %0.f%% memory reserved/used" % args.crit_pct)
    exit=2
elif(percent > args.warn_pct):
    print("WARN: more than %0.f%% memory reserved/used" % args.warn_pct)
    exit=1
else:
    print("OK: %s")

print ("Size: %.1f GB, Used: %.1f GB, Free: %.1f GB" % (memory_size_gb, memory_used_gb, memory_free_gb))
print ("%.2f%% used memory" % (percent))
sys.exit(exit)
