package noris::CGI::setRemoteHost;

$VERSION = 20000220.0; # by Martin H. Sluka <sluka@noris.net>

use vars '$VERSION';
use Socket;
$ENV{REMOTE_HOST} ||= gethostbyaddr(inet_aton($ENV{REMOTE_ADDR}), AF_INET) ||
                      $ENV{REMOTE_ADDR}
  if $ENV{REMOTE_ADDR};

42;

=cut

=head1 NAME

noris::CGI::setRemoteHost -- set $ENV{REMOTE_HOST} if missing
 
=head1 SYNOPSIS

    use noris::CGI::setRemoteHost;

=head1 DESCRIPTION

Sets C<$ENV{REMOTE_HOST}> if it's not provided by the web server.

=head1 AUTHOR

Martin H. Sluka <sluka@noris.net>
for noris network GmbH, 2000-02-20

=cut
