package noris::CallNumber::Utils;

use strict;
use utf8;
use warnings;

use base 'Exporter';
our @EXPORT_OK = 'normalize_numbers';

sub normalize_numbers {
    local our @numbers;
    if ( defined wantarray ) { @numbers = @_ }
    else { *numbers = \@_ }
    for (@numbers) {
        s/^00// or s/^0/49/;
        y/0-9//cd;
        $_ = "+$_";
    }
    @numbers;
}

1;

__END__

=head1 NAME

noris::CallNumber::Utils - Hilfsfunktionen für rufnummernbasierte Gateways

=head1 SYNOPSE

    use noris::CallNumber::Utils 'normalize_numbers';

    normalize_numbers(@rufnummern); # Array wird verändert

    # Array wird _nicht_ verändert:
    my @normalisiert = normalize_numbers(@rufnummern);

=head1 EXPORTIERBARE FUNKTIONEN

=head2 normalize_number

C<normalize_number> versucht, übergebene Rufnummern nach folgendem Schema
in ein einheitliches Format zu bringen:

=over 4

=item *

Beginnt die Rufnummer mit mindestens zwei Nullen, so werden diese verworfen.

=item *

Beginnt die Rufnummer mit nur einer Null, so wird diese durch "49" ersetzt.

=item *

Sodann werden alle nicht-numerischen Zeichen entfernt.

=item *

Schließlich wird ein Pluszeichen vorangestellt.

=back

Beim Aufruf in einem Void-Kontext werden dabei die übergebenen Parameter direkt
verändert, andernfalls gibt die Funktion eine Liste der vereinheitlichten
Rufnummern zurück.

=head1 AUTOR

 Martin H. Sluka <fany@noris.net>
 für die noris network AG
