package Pc;

use warnings;
use strict;

use 5.006_000; use 5.6.0; 
use Readonly;
use Carp; use Carp::Heavy;
use Data::Dumper;
use List::MoreUtils qw{firstidx};
    
    
use NagTools2 qw( 
    :debug
    :special_chars
    :nagios
    dump_mock 
    $MICRO_SECOND
);

#me
Readonly our $CREATE_DUMP_FOR_MOCKING => 0;


#me	 	              
#me
#me
#me
#me
#me
#me	 	              
#me
#me
#me
#me

our $VERSION = '2.4.0';


#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me


#me
#me
#me


sub new {


#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me	 	              
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my ($class, %args) = @_;
    my $self = {};                  #me
    $self->{'_name'}     = $args{'name'}; #me
    $self->{'_object'}   = $args{'object'} || croak 'missing arg object';
    $self->{'_session'}  = $args{'session'} || croak 'missing arg session';
    $self->{'_instance'} = $args{'instance'};
    $self->{'_delta'}    = $args{'delta'};
    $self->{'_p'}        = $args{'p'};
    $self->{'_base_counter'}  = $args{'base_counter'};
    $self->{'_counter_type'}  = $args{'counter_type'} || 'scalar';
    $self->{'_counter_label'} = $args{'counter_label'};
    
    #me
    if ( $self->{'_counter_type'} eq 'array' and not defined $self->{'_counter_label'} ) {
        croak q{counter_label required, if counter_type is 'array'};
    }
    
    #me
    if (not defined $self->{'_instance'}) {


        if ( defined $self->{'_p'} and defined $self->{'_p'}->opts->instance ) {
            i('... found. Setting instance to ' 
                . $self->{'_p'}->opts->instance);
            $self->{'_instance'} = $self->{'_p'}->opts->instance;
        } else {

        }
    }
    #me
    if (not defined $self->{'_delta'}) {


        if ( defined $self->{'_p'} and defined $self->{'_p'}->opts->delta ) {
            i('... found. Setting delta to ' 
                . $self->{'_p'}->opts->delta);
            $self->{'_delta'} = $self->{'_p'}->opts->delta;
        } else {

        }
    }
    
    bless $self, $class;
    return $self;
}
sub set_instance {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    my $instance = shift;
    return if not defined $instance;
    $self->{'_instance'} = $instance;
}
sub get_name {


#me
#me
#me
#me
#me

    my $self = shift;
    return $self->{'_name'};
}

sub get_unit {


#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    my $format = shift; #me
    my $name = $self->{'_name'};
    #me

    my $counter_info = _object_counter_list( $self->{'_session'}, 
                                             $self->{'_object'},
                                             $self->{'_name'},
                                           );

    my $return;
    if (not defined $format) {

        $return = $counter_info->{"$name"}{'unit'};
    } elsif ($format eq 'pretty') {

        $return = _pretty($counter_info->{"$name"}{'unit'});
    }
    debug(1, '$return in Pc->get_unit: ' . $return);
    return $return;
}

sub list_perf_counters {


#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $class = shift;
    my $session = shift;
    my $object = shift;
    croak 'Classmethode used for object.' if ref $class;
    my $infos = _object_counter_list($session, "$object", undef);
    return $infos;
}

sub list_perf_counter_labels {
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $class = shift;
    my $session = shift || croak 'missing session';
    my $object = shift  || croak 'missing object';
    my $counter = shift || croak 'missing counter';
    croak 'Classmethode used for object.' if ref $class;
    my $infos = _object_counter_list($session, "$object",  "$counter");
    return $infos;
}

sub get_instances {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    my $delta = shift;
    my $s = $self->{'_session'};
    croak 'undefined session' if not defined $s;
    

    my $in = NaElement->new('perf-object-get-instances');
    

    $in->child_add_string('objectname', $self->{'_object'});
    

    my $out = $s->invoke_elem($in);
    if ($out->results_status() eq 'failed') {
			croak( 'perf-object-get-instances on failed: ' 
				   . $out->results_reason(),
			);
	} else {

	}

	if ($CREATE_DUMP_FOR_MOCKING) {
        dump_mock(
            data => $out,
            file => 'Pc__get_instances__perf-object-get-instances_t1',
            in => $in,
            desc => 'perf-object-get-instances from sub get_instances().'
                . ' Lists all instances of a given object.',
        );
    }

    $self->{'_out'}{'t1'} = $out;
    
    my $out_2;
    if (defined $delta) {


        sleep $delta;
        $out_2 = $s->invoke_elem($in);
        if ($out_2->results_status() eq 'failed') {
    			croak( 'second perf-object-get-instances on failed: ' 
    				   . $out_2->results_reason(),
    			);
    	} else {

    	}

    	$self->{'_out'}{'t2'} = $out_2;
    }
    if ($CREATE_DUMP_FOR_MOCKING) {
        dump_mock(
            data => $out_2,
            file => 'Pc__get_instances__perf-object-get-instances_t2',
            in => $in,
            desc => 'perf-object-get-instances from sub get_instances().'
                . ' Lists all instances of a given object.',
        );
    }

    my $instances_list = $out->child_get('instances');
    if (not defined $instances_list) {
        croak 'instance-list undefined';
    } else {

    }
	my @instances = $instances_list->children_get();
	if (@instances == 0) {
	    die "No $self->{'_object'} instances found!" . "\n";
	}
	my @instance_names;

	foreach my $i (@instances) {
	    push @instance_names, $i->child_get_string('name');
	}

	return \@instance_names;
}

sub get_raw {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
    my $self = shift;
    my $instance = shift;
    my ($ts1, $cv1);
    if (defined $self->{'_out'}) {

        ($ts1, $cv1) =  $self->_read_value($instance, $self->{'_out'}{'t1'});
         debug(1, 'Timestamp  / value 1: ' . $ts1 . q{ / } . $cv1);
    } else {

        ($ts1, $cv1) = $self->get_value($instance);
        debug(1, 'Timestamp  / value 1: ' . $ts1 . q{ / } . $cv1);
    }

    if (not defined $ts1) {
        return; #me
    } else {
        my $time_stamp = $ts1;
        my $value = $cv1;
        return ($value, $time_stamp);
    };
    croak 'FATAL: This line should never get executed!'
}

sub get_rate {

#me
#me
#me
#me
#me
#me
#me
#me
    my $self = shift;
    my $instance = shift;

    my $delta = $self->{'_delta'};
    my ($ts1, $ts2, $cv1, $cv2) = $self->_get_values($instance);
    if (not defined $ts1) {
        return; #me
    } else {
        my $rate = ($cv2 - $cv1) / ($ts2 - $ts1);
        return ($rate, $ts2);
    };
    croak 'FATAL: This line should never get executed!'
}

sub get_average {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
    my $self = shift;
    my $instance = shift or croak ('missing $instance in get_average()');
    my $delta = $self->{'_delta'};
    if (not defined $self->{'_base_counter'}) {
        croak 'missing base_counter (mandatory for averages)';
    }
    my ($ts1, $ts2, $cv1, $cv2, $bc1, $bc2) = $self->_get_values($instance);
    return if not defined $ts1; #me
    if (   not defined $bc1 
        or not defined $bc2
        or not defined $cv1
        or not defined $cv2
        or not defined $ts2
        ) { croak 'Can not continue with undefined values'}; 
    if ($bc1 == $bc2) {

        return(0, $ts2);
    } else {
        my $avg = ($cv2 - $cv1) / ($bc2 - $bc1);
        return ($avg, $ts2);
    }
    croak 'FATAL: This line should never get executed!'
}

sub get_percent {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    my $instance = shift or croak ('missing $instance in get_average()');
    my $delta = $self->{'_delta'};
    if (not defined $self->{'_base_counter'}) {
        croak 'missing base_counter (mandatory for averages)';
    }
    my ($ts1, $ts2, $cv1, $cv2, $bc1, $bc2) = $self->_get_values($instance);
    return if not defined $ts1; #me
    if (   not defined $bc1 
        or not defined $bc2
        or not defined $cv1
        or not defined $cv2
        or not defined $ts2
        ) { croak 'Can not continue with undefined values'}; 
    if ($bc1 == $bc2) {

        return(0, $ts2);
    } else {
        my $avg = 100 * ($cv2 - $cv1) / ($bc2 - $bc1);
        return ($avg, $ts2);
    }
    croak 'FATAL: This line should never get executed!'
}

sub _get_values {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    my $instance = shift;
    my $delta = $self->{'_delta'};
    my ($ts1, $ts2, $bc1, $bc2, $cv1, $cv2);
    if (defined $self->{'_out'}) {

        ($ts1, $cv1, $bc1) = 
            $self->_read_value($instance, $self->{'_out'}{'t1'});
        debug(1, "$ts1 counter-value: $cv1");
        if ( defined $bc1) { debug(1, "base-counter-value: $bc1")};
        ($ts2, $cv2, $bc2) = 
            $self->_read_value($instance, $self->{'_out'}{'t2'});
        debug(1, "$ts2 counter-value: $cv2");
        if ( defined $bc2) { debug(1, "base-counter-value: $bc2")};
    } else {

        ($ts1, $cv1, $bc1) = $self->get_value($instance);
        debug(1, 'Timestamp  / value 1: ' . $ts1 . q{ / } . $cv1);
        if (defined $bc1) {
            debug(1, 'basecounter1: ' . $bc1);
        }
        sleep $delta;
        ($ts2, $cv2, $bc2) = $self->get_value($instance);
        debug(1, 'Timestamp / value 2: ' . $ts2 . q{ / } . $cv2);
        if (defined $bc2) {
            debug(1, 'basecounter2: ' . $bc2);
        }
    }
    if ($ts2 <= $ts1) {
        croak('ERROR: timestamp 2 is older than timestamp 1');
    } 
    if ($cv2 < $cv1) {
        #me
        debug(1, 'Possible counter-overrun - if this problem persists, '
                                . 'contact the developer of the plugin.');
        return;
    }
    if (defined $bc1 and defined $bc2) {
        if ($bc2 < $bc1) {
            #me
            debug(1, 'Possible base-counter-overrun-if this problem persists,'
                                    . ' contact the developer of the plugin.');
            return;
        }
        if ($bc2 == $bc1) {
            #me
            debug(1, 'lazy filer ... no operations at all');
            #me
        }
    }
    return ($ts1, $ts2, $cv1, $cv2, $bc1, $bc2);
}

sub _read_value {
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
    my $self     = shift;
    my $instance = shift || croak('missing $instance');
    my $out      = shift || croak('missing $out');

    if (not defined $self->{'_name'}) {
        croak '_name not defined';
    }
    
    my $s = $self->{'_session'};
    my $p = $self->{'_p'};
    croak '$out is undef' if not defined $out;
    my $instances_list = $out->child_get('instances');
    my $timestamp = $out->child_get_int('timestamp');

    my @instances = $instances_list->children_get();

    if (@instances == 0) {
        my $errmsg = 'No instance with this name here!';
        if (defined $p) {
            $p->nagios_die("$errmsg");
        };
        croak "$errmsg";
    }
    foreach my $i (@instances) {

        my $inst_name = $i->child_get_string('name');
        next if "$inst_name" ne "$instance";

        my $counters_list = $i->child_get('counters');
        my @counters =  $counters_list->children_get();

        if ( @counters == 0 ) {
            croak ('Counter ' . $self->{'_name'} 
                    . ' not available on this system.'
                  );
        };
        if ( @counters > 1 ) {

            my ($cv, $bcv);
            foreach my $c (@counters) {

                if (defined $self->{'_base_counter'}) {

                    if ($c->child_get_string('name') eq $self->{'_name'}) {

                        $cv = $c->child_get_string('value');
                    } elsif ( $c->child_get_string('name') 
                                            eq $self->{'_base_counter'}
                            ) {

                        $bcv = $c->child_get_string('value');
                    } else {

                    }
                    
                } else {

                    if ($c->child_get_string('name') eq $self->{'_name'}) {

                        $cv = $c->child_get_string('value');
                    } else {

                    }
                }
            }
            return ($timestamp, $cv, $bcv);
        } else {

            my $counter_name  = $counters[0]->child_get_string('name');
            my $counter_value = $counters[0]->child_get_string('value');
            debug(2, 'Countername and -Value: ' 
                        . "$counter_name \t $counter_value");
            #me
            if ($self->{'_name'} ne "$counter_name") {
                carp ('WARNING: The name in the counter-objects data does not '
                    . 'match the name of the counter we asked for.');
            }
            my $counter_type = $self->{'_counter_type'}; 
            my $counter_label = $self->{'_counter_label'};
            if ($counter_type eq 'array') {

                my @values = split /$COMMA/, $counter_value;
                #me
                my $labels = _object_counter_list($s, $self->{'_object'}, "$counter_name", return_label_array => 1);
                my @counter_labels = @{$labels};


                my $idx = firstidx { $_ eq "$counter_label" } @counter_labels; 
                croak q{No matching label found} if $idx == -1;

                return ($timestamp, $values[$idx]);
            } else {

                return ($timestamp, $counter_value);
            }
        }
    }
    carp 'no instance found with that name' ;
    return;
}

sub get_value {

#me
#me
#me
#me
#me
#me
#me
#me
    my $self = shift;
    my $instance = shift || $self->{'_instance'};
    my $s = $self->{'_session'};
    my $p = $self->{'_p'};
    

    my $in = NaElement->new('perf-object-get-instances');
    

    $in->child_add_string('objectname', $self->{'_object'});
    
    if (defined $instance) {

        my $instances = NaElement->new('instances');
        $instances->child_add_string('instance', $instance);
        $in->child_add($instances);
    } else {
        croak 'missing instance - do not use this methode for overallchecks.'
    }
   

    my $counters = NaElement->new('counters');
    $counters->child_add_string('counter', $self->{'_name'});
    if (defined $self->{'_base_counter'}) {

         $counters->child_add_string('counter', $self->{'_base_counter'});
     }
    $in->child_add($counters);
    i('... finished. Now getting data for counter ' 
        . $self->{'_name'} . ' ...');

    my $out = $s->invoke_elem($in);
    if ($CREATE_DUMP_FOR_MOCKING) {
        dump_mock(
            data => $out,
            file => 'Pc__get_value__perf-object-get-instances',
            in => $in,
            desc => 'perf-object-get-instances in get_value() ',
        );
    }
    if ($out->results_status() eq 'failed') {
            croak( 'perf-object-get-instances on failed: ' 
                   . $out->results_reason(),
            );
    } else {

    }


    my ($timestamp, $cv, $bcv) = $self->_read_value("$instance", $out);
    croak '_read_value failed' if (not defined $timestamp or not defined $cv);

    return ($timestamp, $cv, $bcv);
}

#me
#me
#me

sub _object_counter_list {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $s = shift;      #me
    my $object = shift;
    my $counter = shift;
    my %args = @_;
    
    #me
    #me
    #me
	my $in = NaElement->new('perf-object-counter-list-info');
	$in->child_add_string('objectname',$object);

	my $out = $s->invoke_elem($in);
    if ($CREATE_DUMP_FOR_MOCKING) {
        dump_mock(
            data => $out,
            file => 'Pc___object_counter_list__perf-object-counter-list-info',
            in => $in,
            desc => 'perf-object-counter-list-info from sub _object_counter_list()'
                . ' Returns info for exactly one object and all counters.'
                . ' Filtering for a specific counter is done later in the sub.'
            , #me
        );
    }
    debug(3, q{Dump of $out in sub _object_counter_list()} . q{: } . "\n" 
	        . Dumper($out));
	if ($out->results_status() eq 'failed') {
		croak('perf-object-counter-list-info failed '
		        . $out->results_reason()
		      );
	}
	else {

	}

    my $counters = $out->child_get('counters');
    if (not defined $counters) {
        croak 'FATAL: perf-object-counter-list-info returned undef';
    } else {

    }
	my @results = $counters->children_get();

    my $results = shift;
    my $ref;

	COUNTER: foreach my $ctr_info (@results) {
		my $name = $ctr_info->child_get_string('name');

		if (defined $counter) {

		    debug(2, 'counter-name shifted of @_: ' . $counter . q{,  }
		             . 'counter-name out of @results: ' . $name);
		    if ("$name" eq "$counter") {

		        $ref = undef; #me

		        if ( defined $ctr_info->child_get_string('type') ) {
		            if ( $ctr_info->child_get_string('type') eq 'array') {

    		            my $label_ref = $ctr_info->child_get('labels');
    		            my @labels = split /$COMMA/, $label_ref->child_get_string('label-info');

    		            if ($args{'return_label_array'}) {

    		                return \@labels;
    		            }
    		            foreach (@labels) {
    		                #me
    		                #me
    		                #me
    		                $ref->{$_}{'desc'} = $ctr_info->child_get_string('desc');
    		                $ref->{$_}{'unit'} = $ctr_info->child_get_string('unit');
    		                $ref->{$_}{'priv'} = $ctr_info->child_get_string('privilege-level');
    		            }
		            }
		        } else {

		            $ref->{"$name"}{'desc'} = $ctr_info->child_get_string('desc');
            		$ref->{"$name"}{'unit'} = $ctr_info->child_get_string('unit');
            		$ref->{"$name"}{'priv'} = $ctr_info->child_get_string('privilege-level');
		        }

		        return $ref;
		    } else {

		        next COUNTER;
		    }
		}

		$ref->{"$name"}{'desc'} = $ctr_info->child_get_string('desc');
		$ref->{"$name"}{'unit'} = $ctr_info->child_get_string('unit');
		$ref->{"$name"}{'priv'} = $ctr_info->child_get_string('privilege-level');
	}
	return $ref;
}

sub _pretty {
    my $unit = shift;
    my %conversion = (  per_sec     => q{/s}, 
                        b_per_sec   => q(B/s), 
                        kb_per_sec  => q(kiB/s), 
                        mb_per_sec  => q(MiB/s), 
                        percent     => q{%}, 
                        millisec    => q{ms}, 
                        microsec    => qq{$MICRO_SECOND}, 
                        sec         => q{s}, 
                        none        => q{},
                      );
    return $conversion{"$unit"};
}



1;
__END__
