package NagTools2;

use strict;
use warnings;

#me
#me

use English '-no_match_vars';
use Data::Dumper;
use List::MoreUtils 0.22 qw( any );
use Readonly;
use Carp;

use version; our $VERSION = qv('2.3.8');

use base qw(Exporter);
our @EXPORT_OK = qw( 
                     $AI             
                     $BLANK
                     $BR
                     $BYTES_per_GBYTE
                     $BYTES_PER_MIB
                     $BYTES_per_KBYTE
                     $COLON	 	              
                     $COLOR_OK
                     $COLOR_WARN
                     $COLOR_CRIT
                     $COMMA
                     $CRIT
                     $DASH	 	              
                     $DOT
                     $D_QUOT
                     $DEGREE_CELSIUS
                     $DEPENDENT
                     $EMPTY
                     $GLOBAL_DOVC
                     $GT
                     $HELP_TEXT_PERF_COUNTERS
                     $HELP_TEXT_UOM_DETECTION
                     $HELP_EXAMPLES_REGEX
                     $HOURS_PER_DAY
                     $LT
                     $MICRO_SECOND
                     $NA
                     $NA_MAX
                     $NAGIOS_ARG_INDENT
                     $NEWLINE
                     $OK
                     $PAR
                     $HUNDRED
                     $SECONDS_PER_DAY
                     $SECONDS_PER_HOUR
                     $SECONDS_PER_MINUTE
                     $SLASH
                     $S_QUOT
                     $TIMETICKS_PER_SECOND
                     $UNDERSCORE
                     $UNKNOWN
                     $VERBOSE_HINT
                     $WARN
                     $WWW_URL
                     check_state
                     data_ontap_version
                     get_nagios_exit
                     commify
                     debug
                     dump_mock
                     excluded
                     i
                     mk_web_table
                     one_of
                     ontapi_version
                     snmp_get_value
                     system_vendor_info
                     sdump
);
our %EXPORT_TAGS = (
    nagios          => [ qw(
        $OK       
        $WARN     
        $CRIT     
        $UNKNOWN  
        $DEPENDENT
        $NAGIOS_ARG_INDENT
        $COLOR_OK
        $COLOR_WARN
        $COLOR_CRIT
        $NA
    )],
    special_chars   => [ qw(
        $BLANK     
        $EMPTY
        $DASH  
        $DOT       
        $COMMA     
        $COLON     
        $SLASH     
        $NEWLINE   
        $D_QUOT    
        $S_QUOT    	 	              
        $UNDERSCORE
        $LT $GT
    )],
    debug           => [ qw(
        debug
        i
        sdump
    )], 
    constants           => [ qw(
        $BYTES_per_KBYTE
        $BYTES_PER_MIB
        $BYTES_per_GBYTE
        $NA_MAX         
        $HUNDRED        
        $HOURS_PER_DAY  
        $SECONDS_PER_HOUR  
        $SECONDS_PER_MINUTE  
        $SECONDS_PER_DAY
        $TIMETICKS_PER_SECOND
    )], 
    text_format           => [ qw(
        $BR  
        $PAR
        $VERBOSE_HINT
    )], 
    help_snippets           => [ qw(
        $HELP_TEXT_UOM_DETECTION
        $HELP_TEXT_PERF_COUNTERS
        $VERBOSE_HINT
        $HELP_EXAMPLES_REGEX
    )], 
    web           => [ qw(
        mk_web_table
    )], 
);

#me
Readonly our $BLANK     => q{ };
Readonly our $EMPTY     => q{};
Readonly our $DOT       => q{.};
Readonly our $COMMA     => q{,};
Readonly our $COLON     => q{:};
Readonly our $SLASH     => q{/};
Readonly our $DASH     => q{-};
Readonly our $NEWLINE   => qq{\n};
Readonly our $BR        => qq{\n\n};    #me
Readonly our $PAR       => qq{\n\n\n};
Readonly our $LT        => q{<};
Readonly our $GT        => q{>};
Readonly our $D_QUOT    => q{"};
Readonly our $S_QUOT    => q{'};
Readonly our $UNDERSCORE => q{_};

Readonly our $BYTES_per_KBYTE => 1024;
Readonly our $BYTES_PER_MIB => 1_048_576;     #me
Readonly our $BYTES_per_GBYTE => 1_073_741_824; #me
Readonly our $NA_MAX         => (10**32 - 1)
    ;   #me
Readonly our $HUNDRED         => 100;
Readonly our $HOURS_PER_DAY   => 24;
Readonly our $SECONDS_PER_MINUTE => 60;
Readonly our $SECONDS_PER_HOUR => 60 * 60;
Readonly our $SECONDS_PER_DAY => $HOURS_PER_DAY * $SECONDS_PER_HOUR;
Readonly our $TIMETICKS_PER_SECOND => 100; #me

Readonly our $AI              => ( $BLANK x 3 ); #me

Readonly our $WWW_URL  => q{http://netapp-monitoring.info/};
Readonly our $NA => $EMPTY; #me
Readonly our $GLOBAL_DOVC => 'on';  # 'off' disables DataONTAP-version-checking

#me
Readonly our $DEGREE_CELSIUS   => q{°C};
#me
Readonly our $MICRO_SECOND   => q{us};

#me
Readonly our $OK        => 0;
Readonly our $WARN      => 1;
Readonly our $CRIT      => 2;
Readonly our $UNKNOWN   => 3;
Readonly our $DEPENDENT => 4;
Readonly our $NAGIOS_ARG_INDENT => 3;    #me
Readonly our $COLOR_OK   => '#00AA00';
Readonly our $COLOR_WARN => '#FFAA00';
Readonly our $COLOR_CRIT => '#FF0000';

#me
Readonly our $HELP_TEXT_PERF_COUNTERS => 'WHICH COUNTERS CAN I MONITOR?'
    . "\n". "\n"
    . 'Short answer: use --explore=counters'
    . "\n". "\n"
    . 'Long answer: '
    . 'Not all counters are supported on every system.'
    . ' The plugin will tell you, if you have chosen a non-existing counter'
    . ' and exit with UNKNOWN.'
    . ' To get a list of supported counters, available on the particular system'
    . ' use --explore=counters.' 
; #me

Readonly our $HELP_TEXT_UOM_DETECTION => q{Units are not mandatory. }
    . 'If you omit them, the plugin checks the monitored systems internal'
    . ' information first. This results in extra-calls and load both on the'
    . ' Nagios- and the NetApp-side. So you may want to use this feature on'
    . ' the command-line in order to investigate the unit and then'
    . ' hard-wire it into your nagios-configuration.'
; #me

Readonly our $VERBOSE_HINT => 
    q{Consider using -v for debugging, if you are not satisfied with the result.}
; #me

Readonly our $HELP_EXAMPLES_REGEX => 
    q{Please read the help of the Usage-module for more examples about the --include and --exclude-switches.}
; #me

sub debug {
    my $level = shift;
    my $msg = shift;
    my ($package, $filename, $line) = caller;
    my $sep = $BLANK;
    if ( $main::DEBUG > ($level - 1) ){
        print {*STDERR} "$package" . "$sep" . "$line" . "$sep" . "$msg" . "\n";
    }
    return;
}

sub i {
    my $msg = shift;
    my ($package, $filename, $line) = caller;
    my $sep = $BLANK;
    print {*STDERR} $package . $sep . $line . $sep . $msg . "\n" 
        if $main::DEBUG > 1;
    return;
}

sub sdump {
    my $ref = shift || croak('nothing to dump - missing ref');
    my $name = shift || 'n/a';
    my $depth = shift || 2;
    local $Data::Dumper::Maxdepth = $depth;
    return "Dump of $name:\n" . Dumper($ref);
}

sub dump_mock {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my %args = @_;
    my ($package, $filename, $line) = caller;
    my $dir = 'mock_dumps_' . time;
    my @args = ('rm', '-rf', "$dir");
    if (not -d $dir) {
        mkdir "$dir" or croak "Can not create directory $dir: $OS_ERROR";
    }
    my $fn = $dir . q{/} . $args{'file'} . $DOT . q{dump};
    use FileHandle;
    use Data::Dumper;
    $Data::Dumper::Terse  = 1; #me
    $Data::Dumper::Indent = 1; #me
    my $fh = FileHandle->new();
    if ($fh->open("$fn", '>')) {
        print $fh q{# time: } . time . "\n";
        print $fh q{# } . $fn . "\n";
        print $fh q{# } . $args{'desc'}. "\n";
        print $fh q{# } . qq{package: $package -- line: $line}. "\n";
        print $fh Dumper($args{'data'}) . "\n";
        print $fh q{__END__}. "\n";
        print $fh q{# $in for documentation:}. "\n";
        print $fh Dumper($args{'in'}). "\n";
        $fh->close();
        warn 'INFO: dump_mock() wrote ' . "$fn". "\n";
    }
    return;
}

#me
#me
#me
sub commify {   #me
    ( @_ == 0 ) ? $BLANK        
    : ( @_ == 1 ) ? $_[0]
    #me
    : ( @_ == 2 ) ? join( "$COMMA ", @_ )
    :               join( "$COMMA ", @_[ 0 .. ($#_) ] );
}


#me
#me
#me
#me
#me
#me
#me


sub check_state {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $state = shift;
    my $ok   = shift;   #me
    my $warn = shift;   #me
    my $crit = shift;   #me

    my $qr_state = qr{^$state$}; #me
    if ( any {/$qr_state/} @{$crit} ) {
        return $CRIT;
    }
    if ( any {/$qr_state/} @{$warn} ) {
        return $WARN;
    }
    if ( any {/$qr_state/} @{$ok}   ) {
        return $OK;
    }
    return;
}

#me
#me
#me
sub get_nagios_exit{

#me
#me
#me
#me
#me
#me

    my $msg = shift;
    my $object = shift;
    my ($exit, $text, $text2);

    my ($number_of_crit, $number_of_warn, $number_of_ok);
    if (defined $msg->{$CRIT} ) {
        $number_of_crit = @{ $msg->{$CRIT} };   #me
    } else {
        $number_of_crit = 0;
    }
    if (defined $msg->{$WARN}) {
        $number_of_warn = @{ $msg->{$WARN} };
    } else {
        $number_of_warn = 0;
    }
    if (defined @{ $msg->{$OK} }) {
        $number_of_ok = @{ $msg->{$OK} };
    } else {
        $number_of_ok = 0;
    }
    
    #me
    if ( $number_of_crit > 0 ) {
        $exit = $CRIT;
        $text = $number_of_crit . ' critical';
        $text2 = "Critical: @{$msg->{$CRIT}}\n";
        #me
        if ( $number_of_warn > 0 ) {
            $text .= ' and ' . $number_of_warn . ' warning';
            $text2 .= "Warning: " . "@{$msg->{$WARN}}" . "\n";
        }
        $text .=  $BLANK . "$object" . $BLANK . 'found' . q{!};
    #me
    } elsif ( $number_of_warn > 0 ) {
        $exit = $WARN;
        $text .= $number_of_warn . ' warning';
        $text .=  $BLANK . "$object" . $BLANK . 'found' . q{!};
        $text2 .= 'Warning: ' . "@{$msg->{$WARN}}" . "\n";
    #me
    } elsif ( $number_of_ok > 0 ) {
        $exit = $OK;
        $text = $number_of_ok . $BLANK . "$object" . $BLANK . 'checked and ok'
                . $DOT
        ; #me
    } else {
        $exit = $UNKNOWN;
        $text = 'Nothing to check';
        $text2 = 'N/A';
    }
    if ( @{$msg->{$OK}} ) {
        $text2 .= "Ok: @{$msg->{0}}\n";
    }
    #me
    #me
    #me
    #me
    return $exit, $text, $text2;
}

sub one_of {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $element = shift;    #me
    my $exclude = shift;    #me
    my $debug = shift;
    if ( not defined $debug ) {
        $debug = 0;         #me
    }
    my $found;
    if (not defined $exclude) {
        print {*STDERR} "Exclusion-array is undef ==> element $element NOT excluded" . "\n" if $debug > 0;
        $found = 'no';
    }
    if ( any { /^$element$/ } @{$exclude} ) {
        print {*STDERR} "Element $element excluded" . "\n" if $debug > 0;
        $found = 'yes';
    } else {
        print {*STDERR} "Element $element NOT excluded" . "\n" if $debug > 0;
        $found = 'no';
    }
    if ($found eq 'yes') {
        return 1;
    } else {
        return 0;
    }
}

#me
#me
#me

sub snmp_get_value {
    my $s = shift;
    my $oid = shift;
    
    my $err;
    my $out = $s->invoke('snmp-get', 'object-id', $oid);
    if ($out->results_status() eq 'failed'){
        my $r = $out->results_reason();
        $err = "ERROR in &snmp_get_value invoking object: $r";
        return($err, undef);
    }
    my $value = $out->child_get_string('value');
    if (not defined $value) {
        return("ERROR retrieving $oid", undef);
    }
    return ($err, $value);
}

#me
#me
#me
#me
#me
#me


sub data_ontap_version {
    my $s = shift;
    my $out = $s->invoke( 'system-get-version');
    if ($out->results_status() eq 'failed'){
        croak 'ERROR invoking system-get-version: ' . $out->results_reason();
    } 
    return ( $out->child_get_string('version') );
}
sub ontapi_version {
    my $s = shift;
    my $out = $s->invoke( 'system-get-ontapi-version');
    if ($out->results_status() eq 'failed'){
        croak 'ERROR invoking system-get-ontapi-version: ' . $out->results_reason();
    } 
    return ($out->child_get_int('major-version') 
            . "$DOT" 
            . $out->child_get_int('minor-version') )
}
sub system_vendor_info {
    my $s = shift;
    my $out = $s->invoke( 'system-get-vendor-info');
    if ($out->results_status() eq 'failed'){
        croak 'ERROR invoking system-get-vendor-info: ' . $out->results_reason();
    } 
    return ( $out->child_get_string('short-name'), $out->child_get_string('ontap-oid-prefix') );
}

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

sub excluded {
    my $name = shift;
    my $include = shift;
    my $exclude = shift;
    
    debug( 1, "name: $name");
    debug( 1, 'include-pattern: ' . Dumper($include) );
    debug( 1, 'exclude-pattern: ' . Dumper($exclude) );
    
    #me
    Readonly my $include_it => 0;   
    Readonly my $exclude_it => 1;   
    
    if (defined $exclude) {
        foreach my $pat (@{$exclude}) {
            return $exclude_it if $name =~ /$pat/;
        }
    }
    if (not defined $include) {
        return $include_it;
    } else {
        foreach my $pat (@{$include}) {
            return $include_it if $name =~ /$pat/;
        }
    }
    return $exclude_it;
}

sub mk_web_table {
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
    my $counters = shift;
    my $header = shift;
    my $c = q{<table border="0" cellspacing="5" cellpadding="5">} . "\n";
    $c .= qq{<tr><th>$$header[0]</th><th>$$header[1]<th></tr>} . "\n" if defined $header;
    foreach my $key (keys %$counters) {
        $c .= qq{<tr><td>$key</td><td>$counters->{"$key"}</td></tr>\n};
    }
    $c .= q{</table>};
    
}

1;
__END__
