package CheckNetApp;

#me

use strict;
use warnings;

use version; our $VERSION = qv('2.1.3');

#me
use Data::Dumper;

#me
use Carp;
use Readonly;
use English qw(-no_match_vars);
use List::MoreUtils qw( any );

#me
Readonly my $CREATE_DUMP_FOR_MOCKING => 0;

#me
use FindBin qw($Bin);
Readonly our $CHECK_DIR => 'netapp_monitoring/checks' ; #me
use lib "$Bin/netapp_monitoring/checks"; 	 	              
use lib "$Bin/../Nagios-Plugin_99.33/lib";
use lib "$Bin/netapp_monitoring/modules/Nagios-Plugin_99.33/lib";
my $status_an;

use Nagios::Plugin 99.33;
use lib "$Bin/../Na"; #me
use lib "$Bin/netapp_monitoring/modules/Na"; #me
use NaServer;	 	              
use NaElement;
use NagTools2 2.3.3 qw( 
    :debug 
    dump_mock
    :special_chars 
    :nagios 
    $AI $WWW_URL
);

sub new {
    my ($an4, %an0) = @_;
    my $an5 = bless{
        #me
        _progname                   => $an0{'progname'} || 'netapp_monitoring.pl',
        _decimal_precision_output   => $an0{'decimal_precision_output'} || 1,
        _decimal_precision_perfdata => $an0{'decimal_precision_perfdata'} || 0,
        _max_length_single_line     => $an0{'max_length_single_line'} || 340,
        _max_length_multi_line      => $an0{'max_length_multi_line'} || 4096,
        _max_length_cmd             => $an0{'max_length_cmd'} || 4096,
        _credentials_max_length     => $an0{'credentials_max_length'} || 256,
        _ontapi_major_version       => $an0{'ontapi_major_version'}
            || croak('CheckNetApp.pm: missing ontapi_major_version'),
        _ontapi_minor_version       => $an0{'ontapi_minor_version'}
            || croak('CheckNetApp.pm: missing ontapi_minor_version'),
        _screen_width               => $an0{'screen_width'} || 80,
        _version => $main::VERSION || croak('no $VERSION in main'),
        _timeout => $an0{'timeout'} || croak('CheckNetApp: missing arg timeout'),
        _debug => $main::DEBUG,
    }, $an4;
    croak 'no $DEBUG in main' if not defined $main::DEBUG;
    #me
    if ( defined $ENV{'COLUMNS'} ) {

        $an5->{'_screen_width'} = $ENV{'COLUMNS'};
    }
    return $an5;
}

#me
our $PLUG;  #me

#me
use Text::Wrap qw( $columns &wrap &fill );
local $Text::Wrap::unexpand = 0;  #me
                                  #me
                                  #me

sub run {

#me
#me
#me
#me
#me
#me
#me
#me

    my ($an5, @an1) = @_;
    $columns = $an5->{'_screen_width'}; #me
    #me
    if (defined $an1[0] ) {
        if ($an1[0] =~ /--help|-h/ms) {
            print {*STDERR} wrap($EMPTY,$EMPTY,
             "\n". 'WELCOME TO THE NAGIOS PLUGINS FOR NETAPP!'. "\n"
             . "\n"
             . 'netapp_monitoring.pl is a wrapper script calling other modules. '. "\n"
             . "\n"
             . 'To run a check or get help about a checks parameters type '. "\n"
             . 'netapp_monitoring.pl <Checkname> <arguments> | --help'. "\n"	 	              
             . "\n"
             . 'EXAMPLES:' . "\n"
             . 'This help:                  $ netapp_monitoring.pl --help'           . "\n"
             . 'Explore available checks:   $ netapp_monitoring.pl --explore'        . "\n"
             . 'Help on the Quotas-check:   $ netapp_monitoring.pl Quotas --help'    . "\n"
             . "\n"
             . 'HINT: You get a list of available checks (together with a short description) with --explore'
             . "\n" . "\n"
             . 'EXPLANATION:' . "\n"
             . 'The first argument must be a check-name, like \'Usage\' or \'Quotas\' '
             . 'and the corrsponding modules (f.e. \'Usage.pm\' or \'Quotas.pm\') must '
             . 'be present in the same directory as the wrapper script or in one of '
             . 'the @INC- or lib-pathes (usually ./' . "$CHECK_DIR" . ').'
             . "\n" );
            exit $UNKNOWN;
        #me
        #me
        #me
        } elsif ( $an1[0] =~ /--explore/ms ) {
            Readonly my @an2 => qw(
                BufferCache
                Cluster
                ConsistencyPoints
                FlashCache
                FlexCache
                FlexCacheConnections
                Hardware
                IfConfig
                iSCSI
                LunLatency
                NVRAM
                OvercommitAggr
                PerfAggr
                PerfCpu
                PerfDisk
                PerfIf
                PerfSys
                PerfVolume
                Quotas
                Raidstatus
                SnapMirror
                Snapshots
                SnapVault
                Status
                StorageAdapter
                StorageUtilization
                Uptime
                Usage
                vFiler
            );
            
            opendir my $an6, "$Bin/$CHECK_DIR"
                or die 'Can not open' . $BLANK  #me
                    . "$CHECK_DIR" . q{: } . "!OS_ERROR"; 
            print {*STDERR} 'Available Check-Plugins:' . "\n";
            my @an3;
            while ( defined(my $an7 = readdir($an6)) ){
                $an7 =~ s/\.pm$//;
                push @an3, $an7;
            }   
            closedir $an6;

            Readonly my $an8 => 4;
            Readonly my $an9 => 25;
            foreach my $an10 (@an2) {
                my $an11;
                my $an12 = $an9 - length $an10;
                croak 'Pluginname too long' if $an12 < 1;
                $an11 .= "$an10" . $BLANK x $an12;
                #me
                if ( any {$an10 eq $_ } @an3 ) {
                    eval {require "$an10.pm"} or croak "Could not eval $an10"; #me
                    $an11 .= "$an10"->blurb();
                } else {
                    $an11 .= 'not licensed' . $BLANK;
                }
                print {*STDERR} wrap(
                                        $BLANK x $an8, 
                                        $BLANK x ($an8 + $an9),
                                        "$an11"
                                    );
                print "\n";
            }
            print {*STDERR} 'Available plugins and how to license'
                . "$BLANK" . "$WWW_URL" . "\n";
            exit $UNKNOWN;
        #me
        #me
        #me
        } elsif ($an1[0] =~ /^[^-]/ms) { #me
            $an5->{'plug'} = $an1[0];
            $PLUG = $an1[0];
            
            #me
            eval {
                require "$PLUG.pm"; #me
            };
            if ($EVAL_ERROR) {
                print "ERROR: Could not find the check-module for $PLUG. "
                     . "May be it is not installed or you mistyped its name?\n"
                     . "Message from eval:  $EVAL_ERROR" . "\n"
                ;
                exit $UNKNOWN;
            }
        } else {
            die 'First argument must be a check-name' . "\n";
        }
    } else {
        die 'Needs an argument! You may want to start with --help :-)' . "\n";
    }
    if ( not $PLUG->can('new') ) {
        #me
        print ("The check-module $PLUG is not installed. Maybe you misspelled the name (case-sensitive!).\n");
        exit $UNKNOWN;
    }
    my $an13 = $PLUG->new(  progname => $an5->{'_progname'},
                             dp_out => $an5->{'_decimal_precision_output'},
                             dp_perf => $an5->{'_decimal_precision_perfdata'},
                             screen_width => $an5->{'_screen_width'},
                             credentials_max_length => $an5->{'_credentials_max_length'},
                             argument_indent => $AI,
                             nagios_arg_indent => $NAGIOS_ARG_INDENT,
                             ontapi_major_version => $an5->{'_ontapi_major_version'},
                             ontapi_minor_version => $an5->{'_ontapi_minor_version'},
                             max_length_single_line => $an5->{'_max_length_single_line'},
                             max_length_multi_line => $an5->{'_max_length_multi_line'},
                             max_length_cmd => $an5->{'_max_length_cmd'},
                             version => $an5->{'_version'},
                             timeout => $an5->{'_timeout'},
                             dovc => $an5->{'_dovc'},
                             #me
    );
    $an13->init_p();
    $an13->add_args_to_p(); #me
    $an13->getopts();       #me
    $main::DEBUG = $an13->get_debug(); #me
    $an13->define_output_format();     #me

    if ($CREATE_DUMP_FOR_MOCKING) {
        dump_mock(
            data => $an5,
            file => 'check-object_self',
            in => 'n/a',
            desc => 'check-object prepared',
        );
    }
    

    debug( 1,'Timeout: ' . $an13->get_timeout() );
    alarm $an13->get_timeout();
    $an13->run();
    alarm 0;  #me
    croak 'FATAL: This line should never get executed';
}

1;
