package PerfDisk;
use base qw( CheckPlugin );
use strict;
use warnings;

#me
#me
#me
#me
#me

use version; our $VERSION = qv('2.1.0');

#me
use Carp; use Carp::Heavy;
use Data::Dumper;
use Readonly;
use List::MoreUtils qw( any );

#me
use Text::Wrap qw($columns &wrap &fill);
local $Text::Wrap::unexpand = 0; #me
            #me
            #me
	 	              
#me
use FindBin qw($Bin);
my $status_an;

use lib "$Bin/modules2";
use NagTools2 2.2.2 qw(
    :debug 
    dump_mock commify one_of	 	              
    :special_chars
    :text_format
    $NA
    $HUNDRED
    :help_snippets
);
use Examples;
use ThresholdExt;
use Pc;
use Output 2.3.0;

#me
Readonly our $CREATE_DUMP_FOR_MOCKING => 0;
Readonly our $PERF_OBJECT => 'disk';
our $TH = ThresholdExt->new();
    $TH->set_allowed_uoms([ q{%}, $EMPTY ]); 
    $TH->set_default_uom(q{%});          

Readonly our $COUNTERS_SUPPORTED => {
    disk_busy => {
        uom => '%', #me
        base => 'base_for_disk_busy',
    },
};
my @an2;
foreach (keys %{$COUNTERS_SUPPORTED}) {
    push @an2, $_;
}
Readonly our @ALLOWED_COUNTER_STRINGS => @an2;
@an2 = undef;
Readonly our $DELTA_MIN_LIMIT => 1;     #me
Readonly our $DELTA_MAX_LIMIT => 30;    #me
Readonly our $MAX_TRIES => 3;   #me

#me
__PACKAGE__->require_dox('Dox');

sub usage {
    my $an4 = ' [-z disk_busy] [-w -c ] '
                . '[--help] [...]';
    return $an4;
}

#me
sub extra {
    my $an5 = __PACKAGE__->Dox::extra();
    $an5 .= 
        q{The counters supported by this plugin are: } 
        . commify(@ALLOWED_COUNTER_STRINGS)
        . $PAR
        . qq{$HELP_TEXT_PERF_COUNTERS}
        . $PAR
        . qq{$VERBOSE_HINT}
    ; #me
}

sub add_args_to_p {
    my $an6 = shift;
    my $an7 = $an6->{'_ai'};
    $columns = $columns - $an6->{'_nag_ai'};
    my $an8 = $an6->{'_p'};
    
    $an8->add_arg(
        spec => 'counter|z=s',
        required => 0,
        default => 'disk_busy',
        help =>
        wrap($EMPTY, $an7,
            q{One of the following counters: }
            . commify(@ALLOWED_COUNTER_STRINGS)	 	              
            . "\n"
            . q{Defaults to 'disk_busy'.}
            . q{ Use '--explore=counters' for details about the }
            . q{unit used on the monitored system.}
            )
        , #me
    );

    $an8->add_arg(
        spec => 'explore=s',
        help =>
        wrap($EMPTY, $an7,
            q{Explore instances or counters available on the monitored system}
            . q{ and supported by the plugin.}
            )
        , #me
    );

    $an8->add_arg(
        spec => 'instance|n=s',
        default => undef,  #me
        help =>
        wrap($EMPTY, $an7,
            q{UNSUPPORTED}
            )
        , #me
    );
    
    $an8->add_arg(
        spec => 'delta|d=i',
        default => 5,
        help =>
        wrap($EMPTY, $an7,
            'Delta (seconds) between calls, defaults to 5 and must be between '
            . " $DELTA_MIN_LIMIT and $DELTA_MAX_LIMIT."
            )
        , #me
    );

    $an8->add_arg(
        spec => 'warning|w=s',
        default => '80%',
        help =>
        wrap($EMPTY, $an7,
            'Warning threshold. Append the unit according to --counter|-z '
            . "\n"
            . "$HELP_TEXT_UOM_DETECTION"
            )
        , #me
    );

    $an8->add_arg(
        spec => 'critical|c=s',
        default => '95%',
        help =>
        wrap($EMPTY, $an7,
            'Critical threshold, see also --warning|-w.'
            )
        , #me
    );
    
    $an8->add_arg(
        spec => 'aggr=s',
        help =>
        wrap($EMPTY, $an7,
            'Check only disks in the specified aggregate.'
            )
        , #me
    );
    
    $an6->{'_pout'} = Output->new( 
        p => $an8,
        ai => $an7,
    );
    
    return $an6;
}

sub run {
    my $an6 = shift;
    my ($an9, $an10) = $an6->get_credentials();
    $an6->init_session_object($an9, $an10);
    $an6->_run_check();
    croak 'FATAL ERROR - this line should never get executed';
}

sub _run_check {    #me
    my $an6 = shift;

    my $an11 = $an6->{'_session'};
    my $an8 = $an6->{'_p'};
    my $an12 = $an6->{'_dp_out'};         #me
    my $an13 = $an6->{'_dp_perf'};   #me
    my $an14 = $an6->{'_pout'};         #me


    $an14->set_format(
        sort_criterion  => $an8->opts->sort_criterion,
        sort_order      => $an8->opts->sort_order,
        show_status      => $an8->opts->show_status,
        color           => $an8->opts->color,
        progname        => $an6->get_progname(),
        key_value_seperator => $an6->get_output_formspec('key_value_seperator'),
        line_break => $an6->get_output_formspec('br'),
        svc_output_seperator => $an6->get_output_formspec('short_long_service_seperator'),
        max_msg_length => $an6->get_output_formspec('max_msg_length'),
        precision => $an12,
    );


    
    
    my $an15 = $an8->opts->counter;
    my $an16 = Pc->new( 
        session => $an11,
        object  => "$PERF_OBJECT",
        p       => $an8,    #me
        name    => "$an15",
        base_counter => $COUNTERS_SUPPORTED->{$an15}{'base'},
    );

    
    my ($an17, $an18) = $an6->_get_disknames(
                    #me
                    #me
                )
        ;  #me
    

    if (defined $an8->opts->explore) { 
        if ($an8->opts->explore eq 'counters') {
            $an6->print_available_counters(
                \@ALLOWED_COUNTER_STRINGS, 
                "$PERF_OBJECT"
            );
            $an8->nagios_die('Counters printed - now configure your nagios ...')
        } elsif ($an8->opts->explore eq 'instances') {
            foreach my $an19 (@{$an16->get_instances()}) {
                print ${$an17}{"$an19"} . q{ (} . ${$an18}{"$an19"} . q{)} . "\n";
            }
            $an8->nagios_die(
                'Instance-list printed - now configure your nagios ...'
            );
        } else {
            $an8->nagios_die('Invalid option for --explore');
        } 
    }
    

    if (not any {/^$an15$/} @ALLOWED_COUNTER_STRINGS)  {
        $an8->nagios_die("$an15 is not one of the allowed counter-names: "
        . commify(@ALLOWED_COUNTER_STRINGS) );
    }
    

    my $an20 = $an8->opts->delta;
    if ($an20 < $DELTA_MIN_LIMIT or $an20 > $DELTA_MAX_LIMIT) {
        $an8->nagios_die('Delta is out of range'
            . " ($DELTA_MIN_LIMIT to $DELTA_MAX_LIMIT seconds)"
        );
    }
    

    if (defined $an8->opts->aggr) {
        my $an21 = $an11->invoke('aggr-list-info', 'aggregate', $an8->opts->aggr );

        if ($CREATE_DUMP_FOR_MOCKING) {
            dump_mock(
                data => $an21,
                file => 'PerfDisk__aggr-list-info',
                in => 'n/a',
                desc => q{$an11->invoke(aggr-list-info, aggregate, $an8->opts->aggr)}
                    . ' Checks if aggr is existing on this filer.'
                , #me
            );
        }
        
        if ($an21->results_status() eq 'failed'){
            my $an22 = $an21->results_reason();
            $an8->nagios_die( "$an22" );
        }
        
    }
    
    #me
    $TH->set_thresholds($an8);

    my $an23 = $TH->get_uom();
    

    if ($an23 eq $EMPTY) {
        $an23 = $an16->get_unit('pretty');
    }
    
    #me
    if (defined $COUNTERS_SUPPORTED->{$an15}{'uom'}) {
        if ($an23 ne $COUNTERS_SUPPORTED->{$an15}{'uom'}) {
            $an8->nagios_die("$an23 " . 'is not an allowed unit for' . " $an15");
        };
        
    } else {
        $an8->nagios_die('No uom for this counter defined - can not continue');
    }

    $an14->set_object_name('disk', 'disks', 'Highest utilization: ');
    

    my $an24;
    if (defined $an8->opts->instance) {

        my $an19;
        NAME: foreach my $an25 (keys %{$an17}) {
            if ( ${$an17}{$an25} eq {$an8->opts->instance} ) {
                $an19 = $an25;
                last NAME;
            }
        }

        push @{$an24}, $an19;
    } else {

        $an24 = $an16->get_instances($an8->opts->delta);
        if (@{$an24} == 0) {
            $an8->nagios_die('No such instances on this filer') 
        }
    }
    

    INSTANCE: foreach my $an26 (@{$an24}) {

        

        if (defined $an8->opts->aggr) {

            if (not defined ${$an18}{"$an26"}) {

                next INSTANCE;
            }
            if ( ${$an18}{"$an26"} ne $an8->opts->aggr ) {

                next INSTANCE;
            }
        }

        my ($an27, $ts2, $an28);

        while (not defined $an27) {
            if (defined $COUNTERS_SUPPORTED->{$an15}{'base'}) {

                ($an27, $ts2) = $an16->get_average($an26);
            } else {

                ($an27, $ts2) = $an16->get_rate($an26);
            }
            if ($an28++ > $MAX_TRIES) {
                $an8->nagios_die(
                    'Persistent counter overruns or missing activity.'
                );
            };
        }

        $an27 = $an27 * $HUNDRED;
        debug(1, 'Rate/average for counter ' . $an15 . ': ' . $an27);
        my $an3 = $an8->check_threshold($an27);
        $an14->add_val(${$an17}{"$an26"}, $an27, $an3, "$an23");
        $an8->add_perfdata(
            multi_label => ${$an17}{"$an26"} . $UNDERSCORE . 'disk',
 		    plugin_name => $NA . __PACKAGE__,
            label => $an8->opts->perf_format eq 'multi_label' 
                        ? "$an15"
                        : ${$an17}{"$an26"}
            , #me
            value   => sprintf ("%.${an13}f", $an27),
            uom     => "$an23",
            threshold   => $an8->threshold(),
            min => 0,
            max  => $HUNDRED,
        );
    }
    
    if (defined $an8->opts->instance) {
        $an8->nagios_exit(
            return_code => $an14->get_overall_exit(),
            message => $an14->get_instance_message(
                'utilization of O_NAME I_NAME: I_VAL' . 'I_UOM'
            ), #me
        );
    } else {
        $an8->nagios_exit(
            return_code => $an14->get_overall_exit(),
            message => $an14->get_overall_message()
        );
    }
    croak 'FATAL ERROR at l330'; 
}


#me
#me
#me
sub _get_disknames {

#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $an6 = shift;
    my $an11 = $an6->{'_session'}; my $an8 = $an6->{'_p'};
    #me
    #me

    #me
    my $an21 = $an11->invoke('disk-list-info');
    if ($an21->results_status() eq 'failed'){
        my $an22 = $an21->results_reason();
        $an8->nagios_die( "ERROR invoking disk-list-info: $an22");
    }
    if ($CREATE_DUMP_FOR_MOCKING) {
        dump_mock(
            data => $an21,
            file => 'PerfDisk_disk-list-info',
            in => 'n/a',
            desc => q{$an11->invoke(disk-list-info) from sub get_disknames()}
                . ' Lists all disks. Key = the disks UUID.',
        );
    }

    #me
    my (%an0, %an1);
    my $an29 = $an21->child_get('disk-details');
    if (not defined $an29) { $an8->nagios_die( 'ERROR child_get disk-details') }
    my @an3 = $an29->children_get();

    DISK: foreach my $an30 (@an3){
        my $an31 = $an30->child_get_string('name');
        my $an32 = $an30->child_get_string('disk-uid');
        my $an33 = $an30->child_get_string('aggregate');

        $an0{$an32} = $an31;
        $an1{$an32} = $an33;
    }
    
    #me
    #me
    return (\%an0, \%an1);
}
1;
__END__
