<?php
/**
 * Internationalization file for magic words in the SubPageList extension.
 *
 * @file
 * @ingroup SPL
 *
 * @licence GNU GPL v2+
 *
 * @author Jeroen De Dauw < jeroendedauw@gmail.com >
 */

$magicWords = array();

/** English (English) */
$magicWords['en'] = array(
	'splist' => array( 0, 'splist' ),
	'subpages' => array( 0, 'subpages' ),
	'subpagelist' => array( 0, 'subpagelist' ),
	'subpagecount' => array( 0, 'subpagecount' ),
);

/** Arabic (العربية) */
$magicWords['ar'] = array(
	'splist' => array( 0, 'قائمة_صف' ),
	'subpages' => array( 0, 'صفحات_فرعية' ),
	'subpagelist' => array( 0, 'قائمة_صفحة_فرعية' ),
	'subpagecount' => array( 0, 'عداد_صفحة_فرعية' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$magicWords['arz'] = array(
	'splist' => array( 0, 'قايمه_صف' ),
	'subpages' => array( 0, 'صفحات_فرعيه' ),
	'subpagelist' => array( 0, 'قايمه_صفحات_فرعيه' ),
	'subpagecount' => array( 0, 'عداد_صفحه_فرعيه' ),
);

/** Bulgarian (български) */
$magicWords['bg'] = array(
	'subpages' => array( 0, 'подстраници' ),
);

/** Breton (brezhoneg) */
$magicWords['br'] = array(
	'subpages' => array( 0, 'ispajennoù' ),
);

/** German (Deutsch) */
$magicWords['de'] = array(
	'splist' => array( 0, 'usliste' ),
	'subpages' => array( 0, 'unterseiten' ),
	'subpagelist' => array( 0, 'unterseitenliste' ),
	'subpagecount' => array( 0, 'unterseitenanzahl' ),
);

/** Zazaki (Zazaki) */
$magicWords['diq'] = array(
	'splist' => array( 0, 'listeybp' ),
	'subpages' => array( 0, 'peleyêbıni' ),
	'subpagelist' => array( 0, 'listeyêpelandêbınan' ),
	'subpagecount' => array( 0, 'zerreypelandêbınan' ),
);

/** Spanish (español) */
$magicWords['es'] = array(
	'subpages' => array( 0, 'subpáginas' ),
);

/** French (français) */
$magicWords['fr'] = array(
	'splist' => array( 0, 'listesp' ),
	'subpages' => array( 0, 'souspages' ),
	'subpagelist' => array( 0, 'listesouspages' ),
	'subpagecount' => array( 0, 'nbsouspages' ),
);

/** Italian (italiano) */
$magicWords['it'] = array(
	'subpages' => array( 0, 'sottopagine' ),
	'subpagelist' => array( 0, 'elencosottopagine' ),
	'subpagecount' => array( 0, 'contosottopagine' ),
);

/** Korean (한국어) */
$magicWords['ko'] = array(
	'splist' => array( 0, 'sp목록' ),
	'subpages' => array( 0, '하위문서' ),
	'subpagelist' => array( 0, '하위문서목록' ),
	'subpagecount' => array( 0, '하위문서갯수' ),
);

/** Kurdish (Latin script) (Kurdî (latînî)‎) */
$magicWords['ku-latn'] = array(
	'subpages' => array( 0, 'binrûpel' ),
);

/** Macedonian (македонски) */
$magicWords['mk'] = array(
	'splist' => array( 0, 'пссписок' ),
	'subpages' => array( 0, 'потстраници' ),
	'subpagelist' => array( 0, 'списокнапотстраници' ),
	'subpagecount' => array( 0, 'бројнапотстраници' ),
);

/** Malayalam (മലയാളം) */
$magicWords['ml'] = array(
	'splist' => array( 0, 'ഉപതാൾപട്ടിക' ),
	'subpages' => array( 0, 'ഉപതാളുകൾ' ),
	'subpagelist' => array( 0, 'ഉപതാളുകളുടെപട്ടിക' ),
	'subpagecount' => array( 0, 'ഉപതാളുകളുടെയെണ്ണം' ),
);

/** Low Saxon (Netherlands) (Nedersaksies) */
$magicWords['nds-nl'] = array(
	'splist' => array( 0, 'splieste' ),
);

/** Dutch (Nederlands) */
$magicWords['nl'] = array(
	'splist' => array( 0, 'splijst' ),
	'subpages' => array( 0, 'subpaginas', 'subpagina\'s' ),
	'subpagelist' => array( 0, 'subpaginalijst' ),
	'subpagecount' => array( 0, 'pubpaginaaantal' ),
);

/** Polish (polski) */
$magicWords['pl'] = array(
	'subpages' => array( 0, 'podstrony' ),
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎) */
$magicWords['sr-ec'] = array(
	'splist' => array( 0, 'подсписак', 'под_списак' ),
	'subpages' => array( 0, 'подстранице', 'подстране' ),
);

/** Serbian (Latin script) (srpski (latinica)‎) */
$magicWords['sr-el'] = array(
	'splist' => array( 0, 'podspisak', 'pod_spisak' ),
	'subpages' => array( 0, 'podstranice', 'podstrane' ),
);

/** Urdu (اردو) */
$magicWords['ur'] = array(
	'subpages' => array( 0, 'ذیلی_صفحات' ),
);

/** Simplified Chinese (中文（简体）‎) */
$magicWords['zh-hans'] = array(
	'splist' => array( 0, '子列表' ),
	'subpages' => array( 0, '子页面' ),
	'subpagelist' => array( 0, '子页面列表' ),
	'subpagecount' => array( 0, '子页面计数' ),
);

/** Traditional Chinese (中文（繁體）‎) */
$magicWords['zh-hant'] = array(
	'subpages' => array( 0, '子頁面' ),
	'subpagelist' => array( 0, '子頁面清單' ),
	'subpagecount' => array( 0, '子頁面數' ),
);