# SubPageList

SubPageList is a [MediaWiki](https://www.mediawiki.org) extension to display lists of subpages.

Features:

* Adds a <code>subpages</code> parser hook that you can use to list subpages.
* Backward compatible with the [SubPageList3 extension](https://www.mediawiki.org/wiki/Extension:SubPageList3).
* Supports various parameters that enable you to customize the subpage list both in content and in layout.
* Adds a <code>subpagecount</code> parser hook for counting the number of subpages.
* Fully tested codebase (which minimizes the chance of regressions in the future).
* Flexible internal API that allows developers to easily add in new behavior.

View the [release notes](doc/RELEASE-NOTES.md) for recent changes to SubPageList.

### User manual

* [Installation and configuration](doc/INSTALL.md)
* [Usage instructions and examples](doc/USAGE.md)

## Project status

[![Build Status](https://secure.travis-ci.org/JeroenDeDauw/SubPageList.png?branch=master)](http://travis-ci.org/JeroenDeDauw/SubPageList)
[![Code Coverage](https://scrutinizer-ci.com/g/JeroenDeDauw/SubPageList/badges/coverage.png?b=master)](https://scrutinizer-ci.com/g/JeroenDeDauw/SubPageList/?branch=master)
[![Scrutinizer Quality Score](https://scrutinizer-ci.com/g/JeroenDeDauw/SubPageList/badges/quality-score.png?s=1a8e0586f15cd4f3aac116e204a2d266a054540c)](https://scrutinizer-ci.com/g/JeroenDeDauw/SubPageList/)
[![Dependency Status](https://www.versioneye.com/package/php--mediawiki--sub-page-list/badge.png)](https://www.versioneye.com/package/php--mediawiki--sub-page-list)

On Packagist: [![Latest Stable Version](https://poser.pugx.org/mediawiki/sub-page-list/version.png)](https://packagist.org/packages/mediawiki/sub-page-list)
[![Download count](https://poser.pugx.org/mediawiki/sub-page-list/d/total.png)](https://packagist.org/packages/mediawiki/sub-page-list)

* [Open issues](https://github.com/JeroenDeDauw/SubPageList/issues)
* [Latest merged code changes](https://github.com/JeroenDeDauw/SubPageList/commits/master)
* [Proposed code changes](https://github.com/JeroenDeDauw/SubPageList/pulls)
* [SubPageList posts on Jeroens blog](http://www.bn2vs.com/blog/tag/subpagelist/)

## Further links

* [SubPageList on Packagist](https://packagist.org/packages/mediawiki/sub-page-list)
* [SubPageList on Ohloh](https://www.ohloh.net/p/subpagelist)
* [SubPageList on TravisCI](https://travis-ci.org/JeroenDeDauw/SubPageList/builds)
* [SubPageList on Scrutinizer CI](https://scrutinizer-ci.com/g/JeroenDeDauw/SubPageList/)
* [SubPageList on WikiApiary](http://wikiapiary.com/wiki/Extension:SubPageList)

<img src="doc/subpagelist.png" />
