Semantic MediaWiki 1.8 is a stable release.

Released December 2nd, 2012.

=== Compatibility changes ===

* Changed minimum MediaWiki version from 1.16 to 1.17.
* Full compatibility with MediaWiki 1.19 and forward-compatibility with 1.20.
* Changed minimum Validator version from 0.4 to 0.5.
* The structure of the JSON result format has been altered (bug 37418).
* The default database layout has changed. Please read the upgrade instructions for existing sites.

=== New features ===

* The #subobject function now supports the use of empty subobject names ("-" has the same effect). A new anonymous subobject will be created in this case. (bug 36634)
* Added atom printer (bug 38636)
* SMW now collects data about all queries, and this data can be queried to get an overview of queries used on the wiki. Information about queries is stored in subobjects of the page they are on. The property [[Property:Has query]] links a page to a query. The query subobject currently holds values for the following properties: [[Property:Query string]], [[Property:Query format]], [[Property:Query size]], [[Property:Query depth]].
* Added new info tooltip (bug 37361)
* Added two new output formats for properties of type Time, "Gr" and "Jl", to set the desired calendar model for display in #ask results. If nothing is given, SMW will select the calendar based on the date as before (Julian calendar defaults from until 4th Oct 1582). As before. the same behavior is used when entering dates, and "Jl" and "Gr" also work in this case.
* Added new output format "nowiki" to properties of type URL, which will format a URL in such a way that it will not be autolinked by MediaWiki.

=== Enhancements ===

* Significanlty less database write activity on wiki edits that do not change semantic data
* Less database read activity (esp. for displaying long query results and special pages) due to new and improved caching mechanisms
* Improved database table layout for more efficient access and better use of storage space
* Significant performance improvements for Special:Properties and Special:UnusedProperties
* Support for configuring dedicated tables for more efficient handling of frequently used properties, see http://semantic-mediawiki.org/wiki/Fixed_properties
* Improved JSON export (bug 37418).
* Improved Special:Ask UI.
** Enabled Special:Ask parameters form to be collapsible.
** Added individual format help links to enable access to online help manuals.
* Added continuation support to the Ask API.
* Added possibility to change the appearance of the service link icon via CSS (bug 40644)

=== Dropped features ===

* Special:QueryCreator got disabled pending fixes.
* Values of type Time can no longer be selected by string pattern matching (the string was unspecified and has an internal format that is not useful to match against). This safes database memory (fewer indexes).

=== Bug fixes ===

* Fixed automatic running of SMW updating script when running maitenance/update.php.
* Fixed page parameter handling on Special:ExportPDF (bug 35180).
* Fixed handling of #set_recurring_event for 'month' and 'year' time units.
* Fixed error on Special:URIResolver (bug 35643).
* Fixed 'badtitle' error on Special:URIResolver (bug 39967).
* Fixed alternative query source ($smwgQuerySources) (bug 38292).
* Fixed getMaxIncludeSize() on a non-object error in Special:Ask (bug 40650)
* Fixed markup issue with the display of service links (bug 39445)
* Fixed tooltip size issue (bug 29764)
* Fixed Special:Ask autocomplete issue (bug 40676)
* Fixed serialisation of Category namespace queries (bug 37065)
* Fixed non-linked output of URL values in query results (bug 39392)
* Avoid malformed SPARQL when default graph is not set (bug 37575)
* Do not batch process pages when using SMW_refreshData.php with delay option (bug 38136)
* Avoid use of hash_init PHP functions; use md5() instead (bug 38185)
* Fixed parsing of malformed printout requests that could cause exception (bug 38489)
* Don't confuse Julian an Gregorian dates internally (bug 41126)
* Avoid MediaWiki problem that can cause errors when refreshing data and using _LEDT (last editor is) (bug 35962)
* Fixed Special:PageProperty, which was broken

=== Technical improvements and code quality ===

* Added tests for the query processor, the store, data items and result printers, including base test classes for the later two that can be used by extensions.
* Refactored large portions of the SQLStore implementation (SMWSQLStore3).
** More, shorter files for various task groups (SQLStore3_Writers, SQLStore3_Readers, SQLStore3_SpecialPageHandlers, SQLStore_SetupHandler, and others)
** Different types of data now handled modularly by DIHandler classes
** Completely rewritten writing methods that compute a full diff on a database level to decide which write activities are needed (if any)
* No more inline CSS and JavaScript on special pages (now all resource loader modules).
* Added SMWExportPrinter class to facilitate creating export printers and simplify handling code.
* Added SMWIResultPrinter interface to type hint result printers against.
* Migrated Validator parameter definitions to new Validator 0.5 array style.
* Transformed SMW_custom.css, SMW_tooltip.js, and the skin folder to comply with the ResourceLoader environment
* Made query link generation completely generic. Links for all formats will now contain all provided arguments.

=== Extended translations ===

As usual, translations have been extended thanks to the [[Translatewiki.net|Translatewiki.net project]].
