<?php
# This file was automatically generated by the MediaWiki 1.24.2
# installer. If you make manual changes, please keep track in case you
# need to recreate them later.
#
# See includes/DefaultSettings.php for all configurable settings
# and their default values, but don't forget to make changes in _this_
# file, not there.
#
# Further documentation for configuration settings may be found at:
# https://www.mediawiki.org/wiki/Manual:Configuration_settings

# Protect against web entry
if (!defined('MEDIAWIKI')) {
    exit;
}

## Uncomment this to disable output compression
# $wgDisableOutputCompression = true;

## The URL base path to the directory containing the wiki;
## defaults for all runtime URL paths are based off of this.
## For more information on customizing the URLs
## (like /w/index.php/Page_title to /wiki/Page_title) please see:
## https://www.mediawiki.org/wiki/Manual:Short_URL
$wgScriptPath = "/wiki";
$wgScriptExtension = ".php";

## The relative URL path to the skins directory
$wgStylePath = "$wgScriptPath/skins";

## The relative URL path to the logo.  Make sure you change this from the default,
## or else you'll overwrite your logo when you upgrade!
$wgLogo = "$wgScriptPath/resources/assets/wiki.png";

## UPO means: this is also a user preference option

$wgEnableEmail = true;
$wgEnableUserEmail = true; # UPO

$wgEnotifUserTalk = true; # UPO
$wgEnotifWatchlist = true; # UPO
$wgEmailAuthentication = true;

# MySQL specific settings
$wgDBprefix = "";

# MySQL table options to use during installation or update
$wgDBTableOptions = "ENGINE=InnoDB, DEFAULT CHARSET=binary";

# Experimental charset support for MySQL 5.0.
$wgDBmysql5 = true;

## Shared memory settings
$wgMainCacheType = CACHE_NONE;
$wgMemCachedServers = array();

## To enable image uploads, make sure the 'images' directory
## is writable, then set this to true:
$wgEnableUploads = true;
$wgVerifyMimeType = false;
$wgFileExtensions = array('png', 'PNG', 'JPG', 'JPEG', 'jpg', 'jpeg', 'gif', 'GIF', 'doc', 'DOC', 'xls', 'XLS', 'ppt', 'PPT', 'pdf', 'PDF', 'zip', 'ZIP', 'odp', 'ODP', 'gz', 'rpm', 'deb', 'dmg', 'DMG', 'doc', 'DOC', 'docx', 'DOCX', 'xlsx', 'XLSX', 'pptx', 'PPTX', 'svg', 'ogg');
$wgAllowTitlesInSVG = true;
$wgUseImageMagick = true;
$wgImageMagickConvertCommand = "/usr/bin/convert";

# InstantCommons allows wiki to use images from http://commons.wikimedia.org
$wgUseInstantCommons = false;

## If you use ImageMagick (or any other shell command) on a
## Linux server, this will need to be set to the name of an
## available UTF-8 locale
$wgShellLocale = "en_US.utf8";

## If you want to use image uploads under safe mode,
## create the directories images/archive, images/thumb and
## images/temp, and make them all writable. Then uncomment
## this, if it's not already uncommented:
#$wgHashedUploadDirectory = false;

## Set $wgCacheDirectory to a writable directory on the web server
## to make your wiki go slightly faster. The directory should not
## be publically accessible from the web.
#$wgCacheDirectory = "$IP/cache";

# Site language code, should be one of the list in ./languages/Names.php
$wgLanguageCode = "de";

## For attaching licensing metadata to pages, and displaying an
## appropriate copyright notice / icon. GNU Free Documentation
## License and Creative Commons licenses are supported so far.
$wgRightsPage = ""; # Set to the title of a wiki page that describes your license/copyright
$wgRightsUrl = "";
$wgRightsText = "";
$wgRightsIcon = "";

# Path to the GNU diff3 utility. Used for conflict resolution.
$wgDiff3 = "/usr/bin/diff3";

## Default skin: you can change the default skin. Use the internal symbolic
## names, ie 'vector', 'monobook':
$wgDefaultSkin = "vector";

# Enabled skins.
# The following skins were automatically enabled:
require_once "$IP/skins/CologneBlue/CologneBlue.php";
require_once "$IP/skins/Modern/Modern.php";
require_once "$IP/skins/MonoBook/MonoBook.php";
require_once "$IP/skins/Vector/Vector.php";

# End of automatically generated settings.
# Add more configuration options below.

/*****************************************************************************
 * Above is configuration generated by MediaWiki. Below from noris network.  *
 *****************************************************************************/

/*
 * Memcached configuration.
 * Notiz: -
 */
$wgMainCacheType = CACHE_MEMCACHED;
$wgParserCacheType = CACHE_MEMCACHED; # optional
$wgMessageCacheType = CACHE_MEMCACHED; # optional
$wgMemCachedServers = array( "127.0.0.1:11211" );
$wgSessionsInObjectCache = true; # optional
$wgSessionCacheType = CACHE_MEMCACHED; # optional


/*
 * Contact configuration.
 * Notiz: -
 */
$wgEmergencyContact = "1234@noris.de";
$wgPasswordSender = $wgEmergencyContact;


/*
 * Kontaktdaten
 */
$wgEmergencyContact = "1234@noris.de";
$wgPasswordSender = $wgEmergencyContact;

/*
    Pretty URLs.
    Ticket -
    Notiz: -
*/
$wgArticlePath = "/Wiki/$1";


/* Das noris Logo.
 * Ticket -
 * Notiz: -
 */
$wgLogo = "$wgScriptPath/noriswiki.gif";


/* Zeitzone richtig setzen.
 * Ticket 14593127
 * Notiz: http://www.mediawiki.org/wiki/Manual:Timezone#Unconfirmed_Methods
 */
$wgLocaltimezone = 'Europe/Berlin';
$wgLocalTZoffset = date("Z") / 60;


/*
 * Einstellungen von itchy (2005-11-24).
 * Ticket -
 * Notiz: -
 */
$wgDefaultUserOptions['numberheadings'] = 1; # Überschriften per default nummerieren
$wgAllowExternalImages = true; # Einbinden externer Bilder erlauben
$wgShowSQLErrors = true; # SQL Fehler ausgeben
$wgShowExceptionDetails = true; # Stacktrace bei Fehlern ausgeben


/*
 * Userspezifische Stylesheets erlauben.
 * Ticket 12184620
 * Notiz: -
 */
$wgAllowUserCss = true;


/*
 * Weitere random Einstellungen.
 * Ticket -
 * Notiz: -
 */
$wgUseFileCache = true;
$wgUseDatabaseMessage = false;
$wgUrlProtocols[] = 'callto://';


/*
 * Rechte.
 * Ticket 13858041, 14054701
 * Notiz: -
 */
$wgGroupPermissions['*']['edit'] = false;
$wgGroupPermissions['user']['delete'] = true;
$wgGroupPermissions['bot']['edit'] = false;
$wgGroupPermissions['bot']['delete'] = false;


/*
    Speicherlimit von PHP setzen.
    Ticket 10433951
    Notiz: Ist inkonsistent mit dem Ticket. Mehr schadet aber auch nicht.
*/
ini_set('memory_limit', '1G');


/*
    Größe von Uploads / POST requests setzen.
    Ticket 10433951
    Notiz: -
*/
ini_set('post_max_size', '256M');
ini_set('upload_max_filesize', '256M');


/*
    Ermöglicht die authentifikation über die environment variable REMOTE_USER of the server.
    Ticket: -
    Notiz: Man kann Benutzername und Passwort in der phpinfo(); sehen.
*/
require_once "$IP/extensions/Auth_remoteuser/Auth_remoteuser.php";
$wgAuth = new Auth_remoteuser();


/*
    Erlaubt es, Kategorien als Baum darzustellen.
    Ticket 512533, 552090
    Notiz: -
*/
require_once "$IP/extensions/CategoryTree/CategoryTree.php";
$wgCategoryTreeMaxDepth = array(
    CT_MODE_PAGES => 5,
    CT_MODE_ALL => 5,
    CT_MODE_CATEGORIES => 5
);


/*
    Composes a book from articles in a category and exports as a PDF file.
    Ticket 565646
    Notiz: Wird u.a. für die Notfallpläne verwendet.
*/
require_once "$IP/extensions/PdfBook/PdfBook.php";


/*
    Creates an additional set of parser functions that operate on arrays.
    Ticket 10300480
    Notiz: Wurde zwischenzeitlich nach 'Arrays' umbenannt.
*/
require_once "$IP/extensions/Arrays/Arrays.php";


/*
    Allows you to define a variable on a page, use it later, etc.
    Ticket 10300233
    Notiz: -
*/
require_once "$IP/extensions/Variables/Variables.php";


/*
    Allows to specify an initial number for <h1> tags, together with an optional text prefix.
    Ticket 10417326
    Notiz: -
*/
require_once "$IP/extensions/H1_css/H1_CSS.php";


/*
    Extends watchlist functionality to include notification about membership changes of watched categories.
    Ticket 11130244
    Notiz: -
*/
require_once "$IP/extensions/CategoryWatch/CategoryWatch.php";


/*
    Lightweight extension to display and count subpages.
    Ticket 15381620
    Notiz: -
*/
require_once "$IP/extensions/SubPageList/SubPageList.php";


/*
    Allows a user to create references as footnotes on a page.
    Ticket -
    Notiz: Kann beim Update von MediaWiki 1.24 -> MediaWiki 1.25 entfernt werden.
           Siehe http://www.mediawiki.org/wiki/Extension:Cite
*/
require_once "$IP/extensions/Cite/Cite.php";


/*
    Provides eleven additional parser functions to supplement the "magic words" of MediaWiki
    Ticket 526617
    Notiz: -
*/
require_once "$IP/extensions/ParserFunctions/ParserFunctions.php";


/*
    Provides a way for users to pick JavaScript or CSS based "gadgets" that other wiki users provide.
    Ticket 562443
    Notiz: -
*/
require_once "$IP/extensions/Gadgets/Gadgets.php";


/*
 * Beschreibung eines Eintrags.
 * Ticket <NUMMER>
 * Notiz: Mehr Text warum der Eintrag gewollt ist.
 */

// Add more extensions here

/*****************************************************************************
 * Include a deployment configuration (database settings etc.) if it exists. *
 *****************************************************************************/
$deploy_conf = "/etc/noris-wiki/LocalSettingsInclude.php";
$develop_conf = "$IP/LocalSettingsInclude.php";
if (file_exists($deploy_conf)) {
    require_once $deploy_conf;
} else {
    require_once $develop_conf;
}
