package noris::Log::Dispatch::SyslogAppender;

use strict;
use warnings;
use utf8;

our $VERSION = '0.01';

use base 'Log::Dispatch::Syslog'; # depends liblog-dispatch-perl
use Encode;

sub log_message {
    my $self = shift;
    my %p    = @_;
    $p{message} = encode_utf8( $p{message} );
    $self->SUPER::log_message(%p);
}

1;

__END__

=head1 NAME

noris::Log::Dispatch::SyslogAppender - A utf8 enabled SyslogAppender

=head1 SYNOPSIS

    use noris::Log::Dispatch::SyslogAppender;

=head1 DESCRIPTION

A utf8 enabled SyslogAppender

=head1 PUBLIC METHODS

=over 4

=item log_message()

    log_message();

=back

=head1 AUTHOR

 Michale Radziej <entwicklung@noris.net>

