<?php
   /*
    *  Folder Synch Plugin
    *  v0.8
    *
    *  Changed option names in pref file back to old values.  Now right side should
    *  not be refreshed when reading a message.  Also a few javascript fixes to prevent
    *  errors from happening.
    *  Fast loading SM Compatible, Versioning Compatible
    *
    *  v0.7b -- screwed up by Nick Bartos
    *  
    *  This should now work with sm 1.4
    *  Also unneeded refreshes should be reduced, you should now only get a refresh
    *  when the number of new messages in the folder you are viewing change.
    *
    *  v0.6 (c) 2002 (GNU GPL - see ../../COPYING)
    *  Fixes by Jimmy Conner (jimmy@advcs.org)
    *
    *  Original v0.5 by
    *  By Jay Guerette <JayGuerette@pobox.com>
    *
    *  If you need help with this, or see improvements that can be made, please
    *  email me directly at the address above.  I definately welcome suggestions
    *  and comments.  This plugin, as is the case with all SquirrelMail plugins,
    *  is not directly supported by the developers.  Please come to me off the
    *  mailing list if you have trouble with it.
    *
    */

function folder_synch_version() {
   return '0.8';
}

// hooks
function squirrelmail_plugin_init_folder_synch() {
   include(SM_PATH . 'plugins/folder_synch/includes/hooks.php');
}

// load preferences
function load_folder_synch_prefs() {
   include(SM_PATH . 'plugins/folder_synch/includes/prefs.php');
}

// display prefs
function folder_synch_display_inside() {
   include(SM_PATH . 'plugins/folder_synch/includes/display_inside.php');
}

// save prefs
function folder_synch_display_save() {
   include(SM_PATH . 'plugins/folder_synch/includes/display_save.php');
}

// this gets put on the left side

function folder_synch_left() {
   include(SM_PATH . 'plugins/folder_synch/includes/left.php');
}

// this gets called for our message list page

function folder_synch_right_list() {
	// do right stuff with the form
	folder_synch_right (1);
}

// this gets called for the read message page

function folder_synch_right_read() {
	// do right stuff without the form
	folder_synch_right (0);
}

// this gets put on the right side
// this gets called from folder_synch_right_read or folder_synch_right_list
// print_form=1 needs to be set if we want to print the form (only wanted when we
// want to be able to update the right side)

function folder_synch_right($print_form) {
   include(SM_PATH . 'plugins/folder_synch/includes/right.php');
}

?>
