<?php

/**
  * SquirrelMail Empty Folders Plugin
  * Copyright (c) 2003-2009 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage empty_folders
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_empty_folders() 
{

   global $squirrelmail_plugin_hooks;


   // SM 1.5.x - provide an RPC interface to this plugin
   //
   $squirrelmail_plugin_hooks['squirrelmail_rpc']['empty_folders']
      = 'empty_folders_rpc';


   // SM 1.4.x - places text and widgets on the folder page
   //
   $squirrelmail_plugin_hooks['folders_bottom']['empty_folders'] 
      = 'empty_folders_show_options';


   // SM 1.5.x - places text and widgets on the folder page
   //
   $squirrelmail_plugin_hooks['template_construct_folder_manip.tpl']['empty_folders'] 
      = 'empty_folders_show_options';


   // display empty links on target folders
   //
   $squirrelmail_plugin_hooks['left_main_after_each_folder']['empty_folders']
      = 'empty_folders_show_link';


   // SM 1.4.x - display purge/delete all button in target mailbox listings
   //
   $squirrelmail_plugin_hooks['mailbox_display_buttons']['empty_folders']
      = 'empty_folders_show_button';


   // SM 1.5.x - display purge/delete all button in target mailbox listings
   //
   $squirrelmail_plugin_hooks['message_list_controls']['empty_folders']
      = 'empty_folders_show_button';


   // SM 1.4.x - perform purge or delete-all actions when such a button has been clicked
   //
   $squirrelmail_plugin_hooks['move_before_move']['empty_folders']
       = 'empty_folders_handle_button_click';


   // SM 1.5.x - perform purge or delete-all actions when such a button has been clicked
   //
   $squirrelmail_plugin_hooks['mailbox_display_button_action']['empty_folders']
       = 'empty_folders_handle_button_click';


   // configuration check
   //
   $squirrelmail_plugin_hooks['configtest']['empty_folders']
      = 'empty_folders_check_configuration';

}



/**
  * Returns info about this plugin
  *
  */
function empty_folders_info()
{

   return array(
                 'english_name' => 'Empty Folders',
                 'authors' => array(
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                 ),
                 'version' => '2.0.1',
                 'required_sm_version' => '1.2',
                 'requires_configuration' => 0,
                 'required_plugins' => array(
                    'compatibility' => array(
                       'version' => '2.0.12',
                       'activate' => FALSE,
                    )
                 ),
                 'summary' => 'Places "empty" and/or "purge" links next to any folder in the folder list or "Purge" and/or "Delete All" buttons on the mailbox list page that serve to empty out the associated folder.',
                 'details' => 'This plugin places "empty" and/or "purge" links next to any of the folders in the folder list, or "Purge" and/or "Delete All" buttons on the mailbox listing page.  These buttons or links will remove all messages from the associated folder by either moving them to the trash folder or removing them permanently from the mail server, depending on the site and/or user configuration.',
                 'per_version_requirements' => array(
                    '1.5.1' => array(
                       'requires_source_patch' => 0,
                    ),
                    '1.5.0' => array(
                       'requires_source_patch' => 1,
                    ),
                    '1.4.1' => array(
                       'requires_source_patch' => 0,
                    ),
                    '1.2' => array(
                       'requires_source_patch' => 1,
                    ),
                 ),
                 'rpc' => array(
                    'commands' => array(
                       'empty_folders_purge_trash' => 'Purges the trash folder',
                       'empty_folders_purge_all'   => 'Permanently deletes all messages in a folder',
                       'empty_folders_delete_all'  => 'Moves all messages in a folder to the trash',
                    ),
                    'errors' => array(
                       500 => 'empty_folders_purge_trash failed',
                       501 => 'empty_folders_purge_all failed',
                       502 => 'empty_folders_delete_all failed',
                    ),
                 ),
               );

}



/**
  * Returns version info about this plugin
  *
  */
function empty_folders_version()
{
   $info = empty_folders_info();
   return $info['version'];
}



/**
  * Places text and widgets on the folder page
  *
  */
function empty_folders_show_options() 
{
   include_once(SM_PATH . 'plugins/empty_folders/options.php');
   return empty_folders_show_options_do();
}



/**
  * Display empty links on target folders
  *
  * @param array $parms Parameters passed to this hook by SquirrelMail -
  *                     First element is number of messages, second is
  *                     mailbox name, third is a usable IMAP server connection.
  *
  */
function empty_folders_show_link(&$parms) 
{
   include_once(SM_PATH . 'plugins/empty_folders/functions.php');
   return empty_folders_show_link_do($parms);
}



/**
  * Display purge/delete all button in target mailbox listings
  *
  */
function empty_folders_show_button(&$args)
{
   include_once(SM_PATH . 'plugins/empty_folders/functions.php');
   empty_folders_show_button_do($args);
}



/**
  * Perform purge or delete-all actions when such a button
  * has been clicked.
  *
  */
function empty_folders_handle_button_click(&$args)
{
   include_once(SM_PATH . 'plugins/empty_folders/functions.php');
   return empty_folders_handle_button_click_do($args);
}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function empty_folders_check_configuration()
{
   include_once(SM_PATH . 'plugins/empty_folders/functions.php');
   return empty_folders_check_configuration_do();
}



/**
  * Provide an RPC interface to this plugin
  *
  */
function empty_folders_rpc($args)
{
   include_once(SM_PATH . 'plugins/empty_folders/functions.php');
   return empty_folders_rpc_do($args);
}



/**
  * Force the getpot script to pick up these translations
  * (which are in the config file in non-translated form)
  *
  * @ignore
  *
  */
function ef_no_op()
{
   $ignore = _("Empty");
   $ignore = _("empty");
   $ignore = _("Empty Trash");
   $ignore = _("Empty (%d) Messages");
   $ignore = _("Purge");
   $ignore = _("purge");
   $ignore = _("Purge All");
   $ignore = _("purge all");
   $ignore = _("Purge Trash");
   $ignore = _("Purge All (%d)");
   $ignore = _("Purge (%d) Messages");
   $ignore = _("Purge All (%d) Messages");
   $ignore = _("Delete All");
   $ignore = _("delete all");
   $ignore = _("Delete All (%d)");
   $ignore = _("Delete (%d) Messages");
   $ignore = _("Delete All (%d) Messages");
   $ignore = _("This will permanently remove ALL messages from this folder.\\n\\nAre you sure you want to continue?");
   $ignore = _("This will permanently remove ALL %d messages from this folder.\\n\\nAre you sure you want to continue?");
   $ignore = _("This will delete ALL messages in this folder.\\n\\nAre you sure you want to continue?");
   $ignore = _("This will delete ALL %d messages in this folder.\\n\\nAre you sure you want to continue?");
   $ignore = _("Purge ALL messages in this folder - are you sure?");
   $ignore = _("Purge ALL %d messages in this folder - are you sure?");
   $ignore = _("Delete ALL messages in this folder - are you sure?");
   $ignore = _("Delete ALL %d messages in this folder - are you sure?");
   $ignore = _("Permanently remove ALL messages from this folder");
   $ignore = _("Permanently remove ALL %d messages from this folder");
   $ignore = _("Permanently remove all messages from this folder");
   $ignore = _("Permanently remove all %d messages from this folder");
   $ignore = _("Purge ALL messages in this folder");
   $ignore = _("Purge ALL %d messages in this folder");
   $ignore = _("Purge all messages in this folder");
   $ignore = _("Purge all %d messages in this folder");
   $ignore = _("Delete ALL messages in this folder");
   $ignore = _("Delete ALL %d messages in this folder");
   $ignore = _("Delete all messages in this folder");
   $ignore = _("Delete all %d messages in this folder");
   $ignore = _("Move ALL messages from this folder to the trash");
   $ignore = _("Move ALL %d messages from this folder to the trash");
   $ignore = _("Move all messages from this folder to the trash");
   $ignore = _("Move all %d messages from this folder to the trash");
}



