/*
 * English customizations and German localization for the jQuery FullCalendar
 * plugin.
 *
 * Usage:
 * $(sel).fullCalendar($.extend({option = 'val'}, $.fullCalendar.local['lang']))
 */

$(document).ready(function () {
	if (! $.fullCalendar.l10n)
		$.fullCalendar.l10n = {}

	$.fullCalendar.l10n['en'] = {
		timeFormat: 'HH:mm',
		axisFormat: 'HH:mm',
		titleFormat: {
			month: 'MMMM yyyy',
			week: "yyyy-MM-dd{ 'to' yyyy-MM-dd}",
			day: 'dddd, yyyy-MM-dd'
		},
		columnFormat: {
			month: 'dddd',
			week: 'ddd MM-dd',
			day: 'dddd, yyyy-MM-dd'
		}
	}

	$.fullCalendar.l10n['de'] = {
		buttonText: {
			today: 'Heute',
			month: 'Monat',
			week: 'Woche',
			day: 'Tag'
		},
		allDayText: 'Ganztägig',
		timeFormat: 'HH:mm',
		axisFormat: 'HH:mm',
		titleFormat: {
			month: 'MMMM yyyy',
			week: "yyyy-MM-dd{ 'bis' yyyy-MM-dd}",
			day: 'dddd, yyyy-MM-dd'
		},
		columnFormat: {
			month: 'dddd',
			week: 'ddd MM-dd',
			day: 'dddd, yyyy-MM-dd'
		},
		monthNames: [
			'Januar',
			'Februar',
			'März',
			'April',
			'Mai',
			'Juni',
			'Juli',
			'August',
			'September',
			'Oktober',
			'November',
			'Dezember'
		],
		monthNamesShort: [
			'Jan',
			'Feb',
			'Mär',
			'Apr',
			'Mai',
			'Jun',
			'Jul',
			'Aug',
			'Sep',
			'Okt',
			'Nov',
			'Dez'
		],
		dayNames: [
			'Sonntag',
			'Montag',
			'Dienstag',
			'Mittwoch',
			'Donnerstag',
			'Freitag',
			'Samstag'
		],
		dayNamesShort: [
			'So',
			'Mo',
			'Di',
			'Mi',
			'Do',
			'Fr',
			'Sa'
		],
	}
})
