<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
 	<xsl:import href="../common/Utils.xsl"/>
  <xsl:variable name="chassisblade" select="/OMA/Chassisinfo/chassistype"/>
  <xsl:template match="/OMA">
    <ComponentTree>
      <xsl:choose>
        <xsl:when test="$chassisblade=25">
          <Component name="Module" help="System">
            <xsl:attribute name="display"><xsl:value-of select="$strModularChassis"/></xsl:attribute>
            <xsl:call-template name="SystemTemp"/>
          </Component>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="SystemTemp"/>
        </xsl:otherwise>
      </xsl:choose>
    </ComponentTree>
  </xsl:template>

  <xsl:template name="SystemTemp">
    <Component name="System" help="System">
      <xsl:choose>
        <xsl:when test="$chassisblade=25">
          <xsl:attribute name="display"><xsl:value-of select="$strBlade"/></xsl:attribute>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="display"><xsl:value-of select="$strSystem"/></xsl:attribute>
        </xsl:otherwise>
      </xsl:choose>
      <Component name="Storage" help="Storage">
				<xsl:attribute name="display"><xsl:value-of select="$strStorage"/></xsl:attribute>
				<SNBMenuItem name="Properties" default="true">
					<xsl:attribute name="display"><xsl:value-of select="$strProperties"/></xsl:attribute>
					<LSNBMenuItem name="Health" default="true" href="/servlet/DataArea?plugin=com.dell.sm.webplugins.OMSSHealthWebPlugin&amp;amp;component=Storage" help="stprhl">
						<xsl:attribute name="display"><xsl:value-of select="$strHealth"/></xsl:attribute>
					</LSNBMenuItem>
					<LSNBMenuItem help="stprin">
						<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.StorageInfoWebPlugin&amp;amp;Action=blank</xsl:attribute>
						<xsl:attribute name="name">StorInformation</xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strInfoConfig"/></xsl:attribute>
					</LSNBMenuItem>
				</SNBMenuItem>
				<xsl:apply-templates select="TreeNode"/>
			</Component>
		</Component>
	</xsl:template>

	<!-- TreeNode is a recursive function that acts on every TreeNode element -->
	<xsl:template match="TreeNode">
		<Component>
		<xsl:message>TreeNode</xsl:message>
			<xsl:for-each select="DCStorageObject[not(preceding-sibling::DCStorageObject)]">
				<xsl:sort select="PCISlot"/>
				<xsl:call-template name="DrawNode">
				</xsl:call-template>
			</xsl:for-each>	
			<xsl:apply-templates select="TreeNode"/>
		</Component>

	</xsl:template>
	
	<!-- DrawNode: Looks up the type of the component and calls the correct template -->
	<xsl:template name="DrawNode">	
	
			
			<!-- Controller component -->
			<xsl:if test="ObjType and ObjType ='769'">
				<xsl:call-template name="ControllerComponent"/>
			</xsl:if>
			
			<!-- channel component -->
			<xsl:if test="ObjType and ObjType ='770'">			
				<xsl:message>Channel</xsl:message>					
				<xsl:variable name="paramID">
					<xsl:call-template name="ModNexus">
						<xsl:with-param name="nexus">
							<xsl:value-of select="../../DCStorageObject/Nexus"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>		 
				<xsl:variable name="ctrlAttr"><xsl:value-of select="../../DCStorageObject/AttributesMask"/></xsl:variable>

				<xsl:message><xsl:value-of select="$paramID"/></xsl:message>

		                <xsl:if test="((substring($ctrlAttr,26,1) != '1') or ((substring($ctrlAttr,26,1) = '1') and (../TreeNode/DCStorageObject)))">
				<xsl:call-template name="ChannelComponent">
					<xsl:with-param name="ControllerOID">						
							<xsl:value-of select="$paramID"/>					
					</xsl:with-param>
					<xsl:with-param name="AttributesMask">						
							<xsl:value-of select="AttributesMask"/>		
					</xsl:with-param>
					<xsl:with-param name="CntrlAttributesMask">						
							<xsl:value-of select="../../DCStorageObject/AttributesMask"/>		
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>	
			</xsl:if>	

			<!-- enclosure component -->
			<xsl:if test="ObjType and ObjType ='776'">			
				<xsl:message>Enclosure</xsl:message>					
				<xsl:variable name="channelparamID">
					<xsl:call-template name="ModNexus">
						<xsl:with-param name="nexus">
							<xsl:value-of select="../../DCStorageObject/Nexus"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="ctrlparamID">
					<xsl:call-template name="ModNexus">
						<xsl:with-param name="nexus">
							<xsl:value-of select="../../../DCStorageObject/Nexus"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
			
				<xsl:message>ctrl for enclosure:  <xsl:value-of select="$ctrlparamID"/></xsl:message>			 
				<xsl:message><xsl:value-of select="$ctrlparamID"/></xsl:message>
				<xsl:call-template name="EnclosuresComponent">
					<xsl:with-param name="ChannelOID">						
							<xsl:value-of select="$channelparamID"/>					
					</xsl:with-param>
					<xsl:with-param name="ControllerOID">						
							<xsl:value-of select="$ctrlparamID"/>					
					</xsl:with-param>					
				</xsl:call-template>
			</xsl:if>	
			
			<!-- array disk component -->
			<xsl:if test="ObjType and ObjType ='772'">			
				<xsl:message>Array Disk</xsl:message>		
				
				<!-- Check to see if the parent is a channel or an enclosure -->
				<xsl:choose>
					<!-- parent is enclosure -->
					<xsl:when test="../../DCStorageObject/ObjType = '776'">
						
						<xsl:variable name="enclosureparamID">
							<xsl:call-template name="ModNexus">
								<xsl:with-param name="nexus">
									<xsl:value-of select="../../DCStorageObject/Nexus"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:variable name="chnlparamID">
								<xsl:call-template name="ModNexus">
									<xsl:with-param name="nexus">
										<xsl:value-of select="../../../DCStorageObject/Nexus"/>
									</xsl:with-param>
								</xsl:call-template>
						</xsl:variable>
						<xsl:variable name="ctrlparamID">
							<xsl:call-template name="ModNexus">
								<xsl:with-param name="nexus">
									<xsl:value-of select="../../../../DCStorageObject/Nexus"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>	
						
						<xsl:message>enclosure <xsl:value-of select="$enclosureparamID"/></xsl:message>
						<xsl:message>channel <xsl:value-of select="$chnlparamID"/></xsl:message>
						<xsl:message>ctrl <xsl:value-of select="$ctrlparamID"/></xsl:message>
							
			
							<xsl:call-template name="ArrayDiskComponent">								
								
								<xsl:with-param name="ChannelOID">
										<xsl:value-of select="$chnlparamID"/>
								</xsl:with-param>			
								<xsl:with-param name="EnclosureOID">
										<xsl:value-of select="$enclosureparamID"/>
								</xsl:with-param>																
								
								<xsl:with-param name="ControllerOID">						
										<xsl:value-of select="$ctrlparamID"/>					
								</xsl:with-param>
								
							</xsl:call-template>					
					</xsl:when>
					<xsl:otherwise>
							<!-- assume parent is channel -->					
							<xsl:variable name="chnlparamID">
								<xsl:call-template name="ModNexus">
									<xsl:with-param name="nexus">
										<xsl:value-of select="../../DCStorageObject/Nexus"/>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:variable>
							<xsl:variable name="ctrlparamID">
								<xsl:call-template name="ModNexus">
									<xsl:with-param name="nexus">
										<xsl:value-of select="../../../DCStorageObject/Nexus"/>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:variable>	
							
							<xsl:message>channel <xsl:value-of select="$chnlparamID"/></xsl:message>
							<xsl:message>ctrl <xsl:value-of select="$ctrlparamID"/></xsl:message>
						
							<xsl:call-template name="ArrayDiskComponent">								
								<xsl:with-param name="ChannelOID">
											<xsl:value-of select="$chnlparamID"/>
								</xsl:with-param>
								<!-- enclosure string is empty -->								
								<xsl:with-param name="EnclosureOID"></xsl:with-param>
								<xsl:with-param name="ControllerOID">						
										<xsl:value-of select="$ctrlparamID"/>					
								</xsl:with-param>
							</xsl:call-template>		
					</xsl:otherwise>				
				</xsl:choose> 
				
			</xsl:if>	
					
			<!-- Note: Enclosure components should not be drawn for backplanes -->
			<!-- EMM component -->
			<xsl:if test="ObjType and ObjType ='780'">			
				<xsl:message>EMM</xsl:message>					
				<xsl:variable name="enclosureparamID">
					<xsl:call-template name="ModNexus">
						<xsl:with-param name="nexus">
							<xsl:value-of select="../../DCStorageObject/Nexus"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="ctrlparamID">
					<xsl:call-template name="ModNexus">
						<xsl:with-param name="nexus">
							<xsl:value-of select="../../../../DCStorageObject/Nexus"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>	
				
				<xsl:call-template name="EMMComponent">
						<xsl:with-param name="ControllerOID">
							<xsl:value-of select="$ctrlparamID"/>
						</xsl:with-param>
						<xsl:with-param name="EnclosureOID">
							<xsl:value-of select="$enclosureparamID"/>
						</xsl:with-param>
				</xsl:call-template>
			
			</xsl:if>
			

			<!-- Fan component -->
			<xsl:if test="ObjType and ObjType ='777'">			
				<xsl:message>Fans</xsl:message>					
				<xsl:variable name="enclosureparamID">
					<xsl:call-template name="ModNexus">
						<xsl:with-param name="nexus">
							<xsl:value-of select="../../DCStorageObject/Nexus"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="ctrlparamID">
					<xsl:call-template name="ModNexus">
						<xsl:with-param name="nexus">
							<xsl:value-of select="../../../../DCStorageObject/Nexus"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>	
				
				<xsl:call-template name="FanComponent">
						<xsl:with-param name="ControllerOID">
							<xsl:value-of select="$ctrlparamID"/>
						</xsl:with-param>
						<xsl:with-param name="EnclosureOID">
							<xsl:value-of select="$enclosureparamID"/>
						</xsl:with-param>
				</xsl:call-template>			
			</xsl:if>
			
			<!-- Temperature probe component -->
			<xsl:if test="ObjType and ObjType ='778'">			
				<xsl:message>EMM</xsl:message>					
				<xsl:variable name="enclosureparamID">
					<xsl:call-template name="ModNexus">
						<xsl:with-param name="nexus">
							<xsl:value-of select="../../DCStorageObject/Nexus"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="ctrlparamID">
					<xsl:call-template name="ModNexus">
						<xsl:with-param name="nexus">
							<xsl:value-of select="../../../../DCStorageObject/Nexus"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>	
				
				<xsl:call-template name="TempComponent">
						<xsl:with-param name="ControllerOID">
							<xsl:value-of select="$ctrlparamID"/>
						</xsl:with-param>
						<xsl:with-param name="EnclosureOID">
							<xsl:value-of select="$enclosureparamID"/>
						</xsl:with-param>
				</xsl:call-template>			
			</xsl:if>
			
			<!-- Power Supplies component -->
			<xsl:if test="ObjType and ObjType ='779'">			
				<xsl:message>Power Supplies</xsl:message>					
				<xsl:variable name="enclosureparamID">
					<xsl:call-template name="ModNexus">
						<xsl:with-param name="nexus">
							<xsl:value-of select="../../DCStorageObject/Nexus"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="ctrlparamID">
					<xsl:call-template name="ModNexus">
						<xsl:with-param name="nexus">
							<xsl:value-of select="../../../../DCStorageObject/Nexus"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>	
				
				<xsl:call-template name="PowerSuppliesComponent">
						<xsl:with-param name="ControllerOID">
							<xsl:value-of select="$ctrlparamID"/>
						</xsl:with-param>
						<xsl:with-param name="EnclosureOID">
							<xsl:value-of select="$enclosureparamID"/>
						</xsl:with-param>
				</xsl:call-template>
			
			</xsl:if>		
					
			<!-- Battery component -->		
			<xsl:if test="ObjType and ObjType ='771'">			
				<xsl:message>battery</xsl:message>					
				<xsl:variable name="paramID">
					<xsl:call-template name="ModNexus">
						<xsl:with-param name="nexus">
							<xsl:value-of select="../../DCStorageObject/Nexus"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>		 
				<xsl:message><xsl:value-of select="$paramID"/></xsl:message>
				<xsl:call-template name="BatteryComponent">
					<xsl:with-param name="ControllerOID">						
							<xsl:value-of select="$paramID"/>					
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>				

	</xsl:template>
	
	<xsl:template name="ControllerComponent">
		<xsl:param name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus">
					<xsl:value-of select="Nexus"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:param>
		<xsl:attribute name="help">Contrl</xsl:attribute>
		<xsl:attribute name="name">Controller<xsl:value-of select="$ObjID"/></xsl:attribute>
		<xsl:choose>
				<xsl:when test="PCISlot and PCISlot !=''">
					<xsl:choose>
						<xsl:when test="PCISlot = '-1' or PCISlot = '2147483648' or PCISlot = '0' ">
							<xsl:attribute name="display"><xsl:value-of select="Name"/><xsl:value-of select="$strSpace"/><xsl:value-of select="$strStartParen"/><xsl:value-of select="$strEmbedded"/><xsl:value-of select="$strEndParen"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="PCISlot = '2147483649' ">
							<xsl:attribute name="display"><xsl:value-of select="Name"/><xsl:value-of select="$strSpace"/><xsl:value-of select="$strStartParen"/><xsl:value-of select="$strNoSlot"/><xsl:value-of select="$strEndParen"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="display"><xsl:value-of select="Name"/><xsl:value-of select="$strSpace"/><xsl:value-of select="$strStartParen"/><xsl:value-of select="$strPCI"/><xsl:value-of select="PCISlot"/><xsl:value-of select="$strEndParen"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="display"><xsl:value-of select="Name"/><xsl:value-of select="$strSpace"/><xsl:value-of select="$strStartParen"/><xsl:value-of select="$strNoSlot"/><xsl:value-of select="$strEndParen"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<HealthCommand application="ss" databridge="ssda" omacmd="getPropogatedHealth">
				<param name="ObjID">
					<xsl:attribute name="value"><xsl:value-of select="$ObjID"/></xsl:attribute>
				</param>
			</HealthCommand>
			<SNBMenuItem default="true">
				<xsl:attribute name="name">Properties<xsl:value-of select="$ObjID"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strProperties"/></xsl:attribute>
				<LSNBMenuItem default="true" help="cnprhl" app="sm">
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.oma.webplugins.OverallHealthWebPlugin&amp;amp;component=Controller<xsl:value-of select="$ObjID"/></xsl:attribute>
					<xsl:attribute name="name">Health<xsl:value-of select="$ObjID"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strHealth"/></xsl:attribute>
				</LSNBMenuItem>
				<LSNBMenuItem help="cnprin" app="sm">
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin&amp;amp;ControllerOID=<xsl:value-of select="$ObjID"/>&amp;amp;ControllerName=<xsl:value-of select="Name"/>&amp;amp;FILE=false</xsl:attribute>
					<xsl:attribute name="name">Information<xsl:value-of select="$ObjID"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strInfoConfig"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

			<!-- Call firmware driver and Virtual Disk component -->

			<xsl:call-template name="FirmwareDriverComponent">
				<xsl:with-param name="ControllerOID"><xsl:value-of select="$ObjID"/>
				</xsl:with-param>
			</xsl:call-template>

			<xsl:message>before VD component</xsl:message>
			<xsl:if test="MaxVDAllowed>0 and substring(AttributesMask,23,1)='0' ">
				<!-- Extra check for non-raid attribute is for PERC 4/im since it will have a MaxVDAllowed > 0, but should be treated as non-raid -->			
				<xsl:call-template name="VirtualDiskComponent">
					<xsl:with-param name="ControllerOID">						
							<xsl:value-of select="$ObjID"/>					
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>

	</xsl:template>

		
	<xsl:template name="FirmwareDriverComponent">
		<xsl:param name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus">
					<xsl:value-of select="Nexus"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="ControllerOID"/>
		<Component>
			<xsl:attribute name="name">FD<xsl:value-of select="$ControllerOID"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strFirmwareDriverVersions"/></xsl:attribute>
			<HealthCommand application="sm" databridge="ssda" omacmd="getFirmwareDriverHealth">
				<param name="ObjID" value="{$ControllerOID}"/>
			</HealthCommand>
			<SNBMenuItem>
				<xsl:attribute name="name">FDSNB<xsl:value-of select="$ControllerOID"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strProperties"/></xsl:attribute>
				<LSNBMenuItem help="cnprhl" app="sm">
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.FirmwareDriverInfoWebPlugin&amp;amp;ControllerOID=<xsl:value-of select="$ObjID"/>&amp;amp;ControllerName=<xsl:value-of select="Name"/>&amp;amp;FILE=false&amp;amp;help=fwprin</xsl:attribute>
					<xsl:attribute name="name">Information<xsl:value-of select="$ObjID"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strInformation"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>
		</Component>
	</xsl:template>
	
	<xsl:template name="ChannelComponent">
		<xsl:param name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus">
					<xsl:value-of select="Nexus"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="ControllerOID"/>
		<xsl:param name="AttributesMask"/>
		<xsl:param name="CntrlAttributesMask"/>
		<xsl:param name="ChannelOID">
			<xsl:value-of select="$ObjID"/>
		</xsl:param>

			<xsl:attribute name="name">Channel<xsl:value-of select="$ObjID"/><xsl:value-of select="Channel"/></xsl:attribute>

			<xsl:choose>
			<xsl:when test="$AttributesMask != ''and substring($CntrlAttributesMask,26,1)='1' and substring($AttributesMask,26,1)='1'">	
				<xsl:attribute name="display"><xsl:value-of select="$strLogicalConnector"/><xsl:value-of select="Channel"/><xsl:value-of select="$strSpace"/><xsl:value-of select="$strStartParen"/><xsl:value-of select="$strMultiPath"/><xsl:value-of select="$strEndParen"/></xsl:attribute>
                  </xsl:when>
			<xsl:when test="$AttributesMask != ''and substring($CntrlAttributesMask,26,1)='1' and substring($AttributesMask,26,1)='0'">	
				<!-- DO NOTHING -->
                  </xsl:when>
                  <xsl:otherwise>
				<xsl:attribute name="display"><xsl:value-of select="$strChannelSp"/><xsl:value-of select="Channel"/><xsl:value-of select="$strSpace"/><xsl:value-of select="$strStartParen"/>
			<xsl:call-template name="GetChannelType">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
				<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>				</xsl:call-template><xsl:value-of select="$strEndParen"/></xsl:attribute>
                  </xsl:otherwise>
			</xsl:choose>
			
			<HealthCommand application="sm" databridge="ssda" omacmd="getPropogatedHealth">
				<param name="ObjID">
					<xsl:attribute name="value"><xsl:value-of select="$ObjID"/></xsl:attribute>
				</param>
			</HealthCommand>
			<SNBMenuItem>
				<xsl:attribute name="name">Channel<xsl:value-of select="$ObjID"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strProperties"/></xsl:attribute>

				<!--if nothing is hanging off of your channel, then display the channel properties page as default-->
				<xsl:if test="../TreeNode/DCStorageObject">
					<LSNBMenuItem help="chprhl" app="sm">
						<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.oma.webplugins.OverallHealthWebPlugin&amp;amp;component=Channel<xsl:value-of select="$ObjID"/><xsl:value-of select="Channel"/></xsl:attribute>
						<xsl:attribute name="name">Health<xsl:value-of select="$ObjID"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strHealth"/></xsl:attribute>
					</LSNBMenuItem>
				</xsl:if>

				<LSNBMenuItem help="chprin" app="sm">
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.ChannelInfoWebPlugin&amp;amp;ControllerOID=<xsl:value-of select="$ControllerOID"/>&amp;amp;ChannelOID=<xsl:value-of select="$ObjID"/>&amp;amp;Action=blank</xsl:attribute>
					<xsl:attribute name="name">Information<xsl:value-of select="$ObjID"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strInfoConfig"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

	</xsl:template>
	
	<xsl:template name="VirtualDiskComponent">
		<xsl:param name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus">
					<xsl:value-of select="Nexus"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="ControllerOID"/>
		<Component>
			<xsl:attribute name="name">VD<xsl:value-of select="$ControllerOID"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strVD"/></xsl:attribute>
			<HealthCommand application="sm" databridge="ssda" omacmd="getAssocHealth">
				<param name="assoc" value="vdisks"/>
				<param name="ObjID" value="{$ControllerOID}"/>
			</HealthCommand>
			<SNBMenuItem>
				<xsl:attribute name="name">VDSNB<xsl:value-of select="$ControllerOID"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strProperties"/></xsl:attribute>
				<LSNBMenuItem help="vdprin" app="sm">
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;amp;ControllerOID=<xsl:value-of select="$ObjID"/>&amp;amp;ControllerName=<xsl:value-of select="Name"/>&amp;amp;FILE=false</xsl:attribute>
					<xsl:attribute name="name">Information<xsl:value-of select="$ObjID"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strInfoConfig"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>
		</Component>
	</xsl:template>
	
	
	<xsl:template name="BatteryComponent">
		<xsl:param name="ControllerOID"/>
			<xsl:attribute name="name">battery<xsl:value-of select="$ControllerOID"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strBatteries"/></xsl:attribute>
			<HealthCommand application="sm" databridge="ssda" omacmd="getAssocHealth">
				<param name="assoc" value="batteries"/>
				<param name="ObjID" value="{$ControllerOID}"/>
			</HealthCommand>
			<SNBMenuItem>
				<xsl:attribute name="name">battery<xsl:value-of select="$ControllerOID"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strProperties"/></xsl:attribute>
				<LSNBMenuItem help="btprin" app="sm">
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.BattInfoWebPlugin&amp;amp;ControllerOID=<xsl:value-of select="$ControllerOID"/>&amp;amp;BatteryOID=blank&amp;amp;Action=none</xsl:attribute>
					<xsl:attribute name="name">Information<xsl:value-of select="$ControllerOID"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strInfoConfig"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>	
	</xsl:template>

	<xsl:template name="EnclosuresComponent">
		<xsl:param name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus">
					<xsl:value-of select="Nexus"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="ControllerOID"/>
		<xsl:param name="ChannelOID"/>	

		<xsl:attribute name="name">Enclosure<xsl:value-of select="$ObjID"/></xsl:attribute>
		<xsl:attribute name="display"><xsl:value-of select="$strEnclosure"/><xsl:value-of select="$strSpace"/><xsl:value-of select="$strStartParen"/><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="EnclosureType"/></xsl:with-param></xsl:call-template><xsl:value-of select="$strEndParen"/>
		</xsl:attribute>
		
		<HealthCommand application="sm" databridge="ssda" omacmd="getPropogatedHealth">
 			<param name="ObjID">
					<xsl:attribute name="value"><xsl:value-of select="$ObjID"/></xsl:attribute>
				</param>
			</HealthCommand>

			<SNBMenuItem>
				<xsl:attribute name="name">Enclosure<xsl:value-of select="$ObjID"/><xsl:value-of select="Channel"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strProperties"/></xsl:attribute>
				<LSNBMenuItem help="enprhl" app="sm">
   				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.oma.webplugins.OverallHealthWebPlugin&amp;amp;component=Enclosure<xsl:value-of select="$ObjID"/></xsl:attribute>
						<xsl:attribute name="name">Health<xsl:value-of select="$ObjID"/><xsl:value-of select="ObjType"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strHealth"/></xsl:attribute>
					</LSNBMenuItem>
					<LSNBMenuItem help="enprin" app="sm">
						<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.EnclosureInfoWebPlugin&amp;amp;ControllerOID=<xsl:value-of select="$ControllerOID"/>&amp;amp;Name=<xsl:value-of select="../@ControllerName"/>&amp;amp;EnclosureOID=<xsl:value-of select="$ObjID"/>&amp;amp;ChannelOID=<xsl:value-of select="$ChannelOID"/>&amp;amp;FILE=false</xsl:attribute>
						<xsl:attribute name="name">Information<xsl:value-of select="$ObjID"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strInfoConfig"/></xsl:attribute>
					</LSNBMenuItem>
				</SNBMenuItem>
	</xsl:template>
		
	
	<xsl:template name="ArrayDiskComponent">
		<xsl:param name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus">
					<xsl:value-of select="Nexus"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="ChannelOID"/>
		<xsl:param name="EnclosureOID"/>
		<xsl:param name="ControllerOID"/>
		
		<xsl:variable name="isNonRaid">
			<xsl:choose>
				<xsl:when test="substring(AttributesMask,23,1)='1'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>		
		</xsl:variable>
		
		<xsl:variable name="displayName">
			<xsl:choose>
				<xsl:when test="$isNonRaid = 'true'">
					<xsl:value-of select="$strHD"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$strAD"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

			<xsl:attribute name="name">ArrayDisks<xsl:value-of select="$ChannelOID"/><xsl:value-of select="$EnclosureOID"/>
			</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$displayName"/></xsl:attribute>
			<HealthCommand application="sm" databridge="ssda" omacmd="getAssocHealth">
				<param name="assoc" value="arraydisks"/>
				<xsl:choose>
					<xsl:when test="$EnclosureOID">
						<param name="ObjID" value="{$EnclosureOID}"/>
					</xsl:when>
					<xsl:otherwise>
				<param name="ObjID" value="{$ChannelOID}"/>
					</xsl:otherwise>
				</xsl:choose>
			</HealthCommand>
			<SNBMenuItem>
				<xsl:attribute name="name">ADs<xsl:value-of select="$ChannelOID"/><xsl:value-of select="$EnclosureOID"/>
				</xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strProperties"/></xsl:attribute>
				<LSNBMenuItem help="adprin" app="sm">
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.ADInfoWebPlugin&amp;amp;ControllerOID=<xsl:value-of select="$ControllerOID"/>&amp;amp;ChannelOID=<xsl:value-of select="$ChannelOID"/>&amp;amp;EnclosureOID=<xsl:value-of select="$EnclosureOID"/>&amp;amp;ControllerName=<xsl:value-of select="Name"/>&amp;amp;FILE=false</xsl:attribute>
					<xsl:attribute name="name">Information<xsl:value-of select="$ObjID"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strInfoConfig"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>	
	</xsl:template>
	

	<xsl:template name="EMMComponent">
		<xsl:param name="ControllerOID"/>
		<xsl:param name="EnclosureOID"/>
		<xsl:attribute name="name">EMMs<xsl:value-of select="$EnclosureOID"/></xsl:attribute>
		<xsl:attribute name="display"><xsl:value-of select="$strEMMs"/></xsl:attribute>
		<HealthCommand application="sm" databridge="ssda" omacmd="getAssocHealth">
			<param name="assoc" value="emms"/>
			<param name="ObjID">
				<xsl:attribute name="value"><xsl:value-of select="$EnclosureOID"/></xsl:attribute>
			</param>
		</HealthCommand>
		<SNBMenuItem>
			<xsl:attribute name="name">EnclosureEMMs</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strProperties"/></xsl:attribute>
			<LSNBMenuItem help="emmprin" app="sm">
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.EMMInfoWebPlugin&amp;amp;ControllerOID=<xsl:value-of select="$ControllerOID"/>&amp;amp;Name=<xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="../../DCStorageObject/EnclosureType"/></xsl:with-param></xsl:call-template>&amp;amp;EnclosureOID=<xsl:value-of select="$EnclosureOID"/>&amp;amp;FILE=false</xsl:attribute>
				<xsl:attribute name="name">Information<xsl:value-of select="$EnclosureOID"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strInformation"/></xsl:attribute>
			</LSNBMenuItem>
		</SNBMenuItem>
</xsl:template>

	<xsl:template name="FanComponent">
		<xsl:param name="ControllerOID"/>
		<xsl:param name="EnclosureOID"/>

		<xsl:attribute name="name">EncFans<xsl:value-of select="$EnclosureOID"/></xsl:attribute>
		<xsl:attribute name="display"><xsl:value-of select="$strFans"/></xsl:attribute>
		<HealthCommand application="sm" databridge="ssda" omacmd="getAssocHealth">
			<param name="assoc" value="fans"/>
			<param name="ObjID">
				<xsl:attribute name="value"><xsl:value-of select="$EnclosureOID"/></xsl:attribute>
			</param>
		</HealthCommand>
		<SNBMenuItem>
			<xsl:attribute name="name">Fan</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strProperties"/></xsl:attribute>
			<LSNBMenuItem help="fanprin" app="sm">
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.FanInfoWebPlugin&amp;amp;ControllerOID=<xsl:value-of select="$ControllerOID"/>&amp;amp;Name=<xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="../../DCStorageObject/EnclosureType"/></xsl:with-param></xsl:call-template>&amp;amp;EnclosureOID=<xsl:value-of select="$EnclosureOID"/>&amp;amp;FILE=false</xsl:attribute>
				<xsl:attribute name="name">Information<xsl:value-of select="$EnclosureOID"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strInformation"/></xsl:attribute>
			</LSNBMenuItem>
		</SNBMenuItem>	
	</xsl:template>
	
	<xsl:template name="TempComponent">
		<xsl:param name="ControllerOID"/>
		<xsl:param name="EnclosureOID"/>
		<xsl:attribute name="name">EncTemperatures<xsl:value-of select="$EnclosureOID"/></xsl:attribute>
		<xsl:attribute name="display"><xsl:value-of select="$strTemperatures"/></xsl:attribute>
		<HealthCommand application="sm" databridge="ssda" omacmd="getAssocHealth">
			<param name="assoc" value="tempprobes"/>
			<param name="ObjID">
				<xsl:attribute name="value"><xsl:value-of select="$EnclosureOID"/></xsl:attribute>
			</param>
		</HealthCommand>
		<SNBMenuItem>
			<xsl:attribute name="name">probes</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strProperties"/></xsl:attribute>
			<LSNBMenuItem help="tpprin" app="sm">
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.TempInfoWebPlugin&amp;amp;ControllerOID=<xsl:value-of select="$ControllerOID"/>&amp;amp;ChannelOID=blah&amp;amp;Name=<xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="../../DCStorageObject/EnclosureType"/></xsl:with-param></xsl:call-template>&amp;amp;EnclosureOID=<xsl:value-of select="$EnclosureOID"/>&amp;amp;FILE=false</xsl:attribute>
				<xsl:attribute name="name">Information<xsl:value-of select="$EnclosureOID"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strInfoConfig"/></xsl:attribute>
			</LSNBMenuItem>
		</SNBMenuItem>
	</xsl:template>

	<xsl:template name="PowerSuppliesComponent">
		<xsl:param name="ControllerOID"/>
		<xsl:param name="EnclosureOID"/>
		<xsl:attribute name="name">EncPowerSupplies<xsl:value-of select="$EnclosureOID"/></xsl:attribute>
		<xsl:attribute name="display"><xsl:value-of select="$strPwrSupplies"/></xsl:attribute>
		<HealthCommand application="sm" databridge="ssda" omacmd="getAssocHealth">
			<param name="assoc" value="psupplies"/>
			<param name="ObjID">
				<xsl:attribute name="value"><xsl:value-of select="$EnclosureOID"/></xsl:attribute>
			</param>
		</HealthCommand>
		<SNBMenuItem>
			<xsl:attribute name="name">PS</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strProperties"/></xsl:attribute>
			<LSNBMenuItem help="psprin" app="sm">
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.PSInfoWebPlugin&amp;amp;ControllerOID=<xsl:value-of select="$ControllerOID"/>&amp;amp;Name=<xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="../../DCStorageObject/EnclosureType"/></xsl:with-param></xsl:call-template>&amp;amp;EnclosureOID=<xsl:value-of select="$EnclosureOID"/>&amp;amp;FILE=false</xsl:attribute>
				<xsl:attribute name="name">Information<xsl:value-of select="$EnclosureOID"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strInformation"/></xsl:attribute>
			</LSNBMenuItem>
		</SNBMenuItem>

</xsl:template>

	<!-- creates the following channel types
    -->
	<xsl:template name="GetChannelType">
		<xsl:param name="BusProtocol"/>
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="$BusProtocol=1"> <!-- scsi -->
				<xsl:choose>
					<xsl:when test="substring(AttributesMask,23,1)='0'"><xsl:value-of select="$strRAIDChannel2"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNonRaid"/></xsl:otherwise>
				</xsl:choose>
			</xsl:when>			
			<xsl:when test="$BusProtocol=7 or $BusProtocol=2"> <!-- sata and ide -->
				<xsl:value-of select="$strRAID"/>
			</xsl:when>
			<xsl:when test="$BusProtocol=8">	 <!-- sas -->		
				<xsl:choose>
					<xsl:when test="substring(AttributesMask,23,1)='0'">
						<xsl:value-of select="$strRAID"/>
					</xsl:when>
					<xsl:otherwise> 
						<xsl:value-of select="$strNonRaid"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
			   <xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
