<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	<!-- VIRTUAL DISK TABLE HEADER -->
	<xsl:template name="VirtualDiskTableHeader">
		<xsl:param name="tasks"/>
		<!-- ignore on web is set to true since it's only needed for scripts using the cli -->
		<Data name="Id" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strID"/></xsl:attribute>
		</Data>
		<Data name="Status" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
		</Data>
		<Data name="Name" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
		</Data>
		<Data name="State" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
		</Data>
		<xsl:if test="$tasks='true'">
			<Data name="Delete" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strTasks"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strTasks"/></xsl:attribute>
			</Data>
			<!-- The Rows have one extra row for the execute button.  Including a blank <Data> tag here keeps the line that underlines the headers continuous -->
			<Data name="exbut" editable="false" type="ustring" ignoreoncli="true">
				<xsl:attribute name="display">Execute</xsl:attribute>
				<xsl:attribute name="value"> </xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//VirtualDisks/DCStorageObject/Progress or /OMA/@cli = 'true'">
			<!-- See if any VDisk has a progress.  If so, show the header for the table -->
			<Data name="Progress" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strProgress"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strProgress"/></xsl:attribute>
			</Data>
		</xsl:if>
		<Data name="Layout" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strLayout"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strLayout"/></xsl:attribute>
		</Data>
		<Data name="Size" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strSize"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strSize"/></xsl:attribute>
		</Data>
		<Data name="DeviceName" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strDeviceName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strDeviceName"/></xsl:attribute>
		</Data>
		<Data name="Type" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strType"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strType"/></xsl:attribute>
		</Data>
		<Data name="Read Cache" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strReadCache"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strReadCache"/></xsl:attribute>
		</Data>
		<Data name="Write Cache" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strWriteCache"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strWriteCache"/></xsl:attribute>
		</Data>
		<xsl:if test="//CachePolicy or /OMA/@cli = 'true'">
			<Data name="Cache Policy" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strCachePolicy"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strCachePolicy"/></xsl:attribute>
			</Data>
		</xsl:if>
		<Data name="StripeSize" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strStripeSize"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strStripeSize"/></xsl:attribute>
		</Data>
                <!-- Disabling Disk cache policy for ir controllers --> 
                <xsl:if test="substring(/OMA/VirtualDisks/@AttributesMask,5,1)!='1'">
		<Data name="DiskCachePolicy" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strDiskCachePolicy"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strDiskCachePolicy"/></xsl:attribute>
		</Data>
		</xsl:if>
		
	</xsl:template>
	<!-- VIRTUAL DISK TABLE ROWS -->
	<xsl:template name="VirtualDiskTableRows">
		<xsl:param name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus">
					<xsl:value-of select="Nexus"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="tasks"/>
		<xsl:param name="caller"/>
		<xsl:call-template name="scripts"/>
		<xsl:variable name="vdiskname">
			<xsl:value-of select="Name"/>
		</xsl:variable>
		<xsl:variable name="vdiskid">
			<xsl:value-of select="$ObjID"/>
		</xsl:variable>

		<xsl:variable name="blink">
			<xsl:if test="substring(CurrentMethodMask,24,1)!='0'">true</xsl:if>
		</xsl:variable>
		
		<xsl:variable name="isCluster">
			<xsl:choose>
				<xsl:when test="substring(/OMA/VirtualDisks/@AttributesMask,32,1)!='0'">1</xsl:when>
			  <xsl:otherwise>0</xsl:otherwise>
		 </xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="vdevname">
			<xsl:value-of select="DeviceName"/>
		</xsl:variable>
		<xsl:variable name="numbootpart">
			<xsl:choose>
				<xsl:when test="NumBootPart">
					<xsl:value-of select="NumBootPart"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="0"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<script language="javascript">
			//*********************************************************************************************************
			//* Javascript function to redirect the local DataArea page to the
			//* appropriate web plugin which handles the action selected from the drop-down menu.
			//*********************************************************************************************************//
			function onExecute(name, oid, blink,devname,numbootpart) {
				var VDtasks = "VDtasks" + oid;
				var cluster = <xsl:value-of select="$isCluster"/>;
				var action = document.getElementById(VDtasks).value;				
				var confirmreponse = 0;
				if (action == "-") 
				{ 
					alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
      }
      else if(action == '1')
      { // reconfigure
        document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.ReconfigureVDWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VirtualDiskOID=" + oid + "&amp;VDiskName=" + name + "&amp;VDeviceName=<xsl:value-of select="DeviceName"/>&amp;help=vdtkrcn1");
      }
      else if (action == '2')
      { // format vd
        document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.ConfirmFormatVDWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=" + oid + "&amp;VDiskName=" + name + "&amp;Blink=" + blink + "&amp;VDeviceName=" + devname + "&amp;help=vdtkfmt");
				}
				else if (action == '16') 
				{ //delete vd
					
					if(cluster == 1)
					{ 									
							var msg = "<xsl:value-of select="$strClusterDelete"/>";
							confirmresponse = confirm(msg);
					}
					
					if((cluster == 1 &amp;&amp; confirmresponse) || cluster == 0)
      {
        document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.ConfirmDeleteVDWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=" + oid + "&amp;VDiskName=" + name + "&amp;VDeviceName=" + devname + "&amp;NumBootPart=" + numbootpart + "&amp;Blink=" + blink + "&amp;help=vdtkdel");
					}
				}
				else if (action == '64' || action =='4194304' || action == '8388608') 
				{ // initialize, slow initialize, fast initialize
				
					if(cluster == 1)
					{ 									
							var msg = "<xsl:value-of select="$strClusterGeneric"/>";
							confirmresponse = confirm(msg);
					}
					
					if((cluster == 1 &amp;&amp; confirmresponse) || cluster == 0)
      {
        document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.ConfirmInitVDWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=" + oid + "&amp;VDiskName=" + name + "&amp;VDeviceName=" + devname + "&amp;NumBootPart=" + numbootpart + "&amp;Action="+action+"&amp;Blink=" + blink + "&amp;help=vdtkfmt");
					}
				}
				else if (action == '128') 
				{ // dedicated hotspare 
					if(cluster == 1)
					{ 									
							var msg = "<xsl:value-of select="$strClusterGeneric"/>";
							confirmresponse = confirm(msg);
					}
					
					if((cluster == 1 &amp;&amp; confirmresponse) || cluster == 0)
      {
        document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.DedHotspareWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=" + oid + "&amp;VDiskName=" + name + "&amp;VDeviceName=<xsl:value-of select="DeviceName"/>&amp;help=vdtkdhs");
      }
      }
      else if (action == '1024')
      { // rename
        document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.VDRenameWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=" + oid + "&amp;VDiskName=" + name + "&amp;VDeviceName=<xsl:value-of select="DeviceName"/>&amp;help=vdtknam");
      }
      else if (action == '8192')
      { // split mirror
       document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.VDSplitMirrorWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=" + oid + "&amp;VDiskName=" + name + "&amp;VDeviceName=<xsl:value-of select="DeviceName"/>&amp;help=vdtksplt");
      }
      else if (action == '16384')
      { // unmirror
        document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.VDUnMirrorWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=" + oid + "&amp;VDiskName=" + name + "&amp;VDeviceName=<xsl:value-of select="DeviceName"/>&amp;help=vdtkunmr");
				}
				else if(action == '524288') 
				{// change policy
					if(cluster == 1)
					{ 									
							var msg = "<xsl:value-of select="$strClusterGeneric"/>";
							confirmresponse = confirm(msg);
					}
					
					if((cluster == 1 &amp;&amp; confirmresponse) || cluster == 0)
      {
      document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.VDChangePolicyWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=" + oid + "&amp;VDiskName=" + name + "&amp;VDeviceName=<xsl:value-of select="DeviceName"/>&amp;help=vdtkchng");
      }
      }

      else if(action == '16777216')
      { // replace member
        document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.ReplaceMemberSelectWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=" + oid + "&amp;VDiskName=" + name + "&amp;VDeviceName=<xsl:value-of select="DeviceName"/>&amp;help=adtkcb");
      }

      else
      {
          document.dataarea.action = top.gnv.appendVID("/servlet/SubmitForm?plugin=com.dell.sm.webplugins.VDExecuteActionWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=" + oid + "&amp;VDiskName=" + name + "&amp;Action="+action+"&amp;help=vdmgmt");
					document.dataarea.submit();
				
				} 
			}
			
		</script>
		<xsl:if test="count(ParentVDID)= 0">
			<!-- Only display main virtual disks, not child VDisks -->
			<Row height="30px">
				<!-- ignore on web is set to true since it's only needed for scripts using the cli -->
				<Data name="Test" editable="false" type="ustring" display="Test" ignoreonweb="true">
					<xsl:attribute name="value"><xsl:value-of select="LogicalDriveNum"/></xsl:attribute>
				</Data>
				<Data type="status" align="center">
					<xsl:attribute name="value"><xsl:value-of select="ObjStatus"/></xsl:attribute>
				</Data>
				<Data link="true" editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strName"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="Name"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.ArrayWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VirtualDiskOID=<xsl:value-of select="$ObjID"/>&amp;VirtualDiskName=<xsl:value-of select="Name"/>&amp;RaidLayout=<xsl:value-of select="Layout"/>&amp;BackTo=<xsl:value-of select="$caller"/>&amp;help=adprin</xsl:attribute>
				</Data>
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strState"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
				<!-- isEmpty var used for tasks menu option -->
				<xsl:variable name="isEmpty">
					<xsl:call-template name="IsCurrentMethodMaskEmpty">
						<xsl:with-param name="Mask">
							<xsl:value-of select="CurrentMethodMask"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:if test="$tasks='true'">
					<xsl:choose>
						<!--check to see if methods even exist -->
						<xsl:when test="$isEmpty='0'">
							<!-- currentmethod mask isn't empty -->
							<Data value="tasks" type="select" boxwidth="width:400px">
								<xsl:attribute name="display"><xsl:value-of select="$strVDTasks"/></xsl:attribute>
								<xsl:attribute name="name">VDtasks<xsl:value-of select="$vdiskid"/></xsl:attribute>
								<Choice returnvalue="-" default="true">
									<xsl:attribute name="value"><xsl:value-of select="$strSelectTask"/></xsl:attribute>
								</Choice>
								<xsl:call-template name="for-loop-list-box">
									<xsl:with-param name="Mask" select="CurrentMethodMask"/>
									<xsl:with-param name="templateName" select="9"/>
								</xsl:call-template>
							</Data>
							<!-- add execute link -->
							<Data type="button">
								<xsl:attribute name="display"><xsl:value-of select="$strExecute"/></xsl:attribute>
								 <xsl:attribute name="id"><xsl:value-of select="$strExecute"/></xsl:attribute>
								 <xsl:attribute name="href">javascript:onExecute(\"<xsl:value-of select="$vdiskname"/>\",\"<xsl:value-of select="$vdiskid"/>\",\"<xsl:value-of select="$blink"/>\",\"<xsl:value-of select="$vdevname"/>\",\"<xsl:value-of select="$numbootpart"/>\");</xsl:attribute>
								 <xsl:attribute name="tablebutton">true</xsl:attribute> 
						    </Data>
						</xsl:when>
						<xsl:otherwise>
							<!-- current methodmask is empty -->
							<Data value="tasks" type="select" boxwidth="width:400px">
								<xsl:attribute name="display"><xsl:value-of select="$strVDTasks"/></xsl:attribute>
								<xsl:attribute name="name">VDtasks<xsl:value-of select="$vdiskid"/></xsl:attribute>
								<Choice returnvalue="" default="true">
									<xsl:attribute name="value"><xsl:value-of select="$strNoTask"/></xsl:attribute>
								</Choice>
							</Data>
						<Data type="ustring" columnspacing="true" name="execute" link="false">
							<xsl:attribute name="value"></xsl:attribute>
						</Data>
					   </xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:if test="//VirtualDisks/DCStorageObject/Progress or /OMA/@cli = 'true'">
					<xsl:choose>
						<xsl:when test="Progress">
							<Data type="ustring" align="center">
								<xsl:attribute name="value"><xsl:value-of select="Progress"/><xsl:value-of select="$strPercComp"/></xsl:attribute>
							</Data>
						</xsl:when>
						<xsl:when test="/OMA/@cli = 'true'">
							<Data type="ustring" align="center">
								<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
							</Data>
						</xsl:when>
						<xsl:otherwise>
							<Data type="ustring" align="center">
								<xsl:attribute name="value"/>
							</Data>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strLayout"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:call-template name="GetRaidLayout"><xsl:with-param name="RaidType"><xsl:value-of select="Layout"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
				<xsl:choose>
					<xsl:when test="/OMA/@cli='true'">
						<!--CLI version of the capacty data (displays bytes as well as GB)-->
						<Data name="Test" editable="false" type="ustring" display="Test" ignoreonweb="true">
							<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="Length"/></xsl:with-param></xsl:call-template> GB (<xsl:value-of select="Length"/> bytes)</xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<!-- Web Version of the length data (ONLY displays GB) -->
						<Data editable="false" type="ustring" display="Test" ignoreoncli="true">
							<xsl:attribute name="name"><xsl:value-of select="$strSize"/><xsl:value-of select="position()"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="Length"/></xsl:with-param></xsl:call-template> <xsl:value-of select="$strGB"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strDeviceName"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="DeviceName"/></xsl:attribute>
				</Data>
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strType"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:call-template name="GetBusProtocol"><xsl:with-param name="Bus"><xsl:value-of select="BusProtocol"/></xsl:with-param></xsl:call-template>
					</xsl:attribute>
				</Data>
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strReadCache"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:call-template name="GetReadPolicy"><xsl:with-param name="readpolicy"><xsl:value-of select="ReadPolicy"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strWriteCache"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:call-template name="GetWritePolicy"><xsl:with-param name="writepolicy"><xsl:value-of select="WritePolicy"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
				<xsl:if test="//CachePolicy or /OMA/@cli = 'true'">
					<Data editable="false" type="ustring" display="Test">
						<xsl:attribute name="name"><xsl:value-of select="$strCachePolicy"/><xsl:value-of select="position()"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="GetCachePolicy"><xsl:with-param name="cachepolicy"><xsl:value-of select="CachePolicy"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</Data>
				</xsl:if>
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strStripeSize"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:call-template name="GetStripeSize"><xsl:with-param name="stripesize"><xsl:value-of select="StripeSize"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
                                <xsl:if test="substring(/OMA/VirtualDisks/@AttributesMask,5,1)!='1'">
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strDiskCachePolicy"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:call-template name="GetDiskCachePolicy"><xsl:with-param name="DiskCachePolicy"><xsl:value-of select="DiskCachePolicy"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
                                </xsl:if>

			</Row>
		</xsl:if>
		<!-- End if (VDLevel = 0) -->
	</xsl:template>
</xsl:stylesheet>
