<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Virtual Disks Information page.  The associated web plugin is the VDInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="Utils.xsl"/>
	<xsl:template match="OMA">
	<xsl:call-template name="scripts"/>
		<DataArea backpagetarget="/servlet/DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin" printable="false" email="false" validate="true" Refresh="false" export="false" exportdata="false" onLoad="true">

			<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.sm.webplugins.VDExecuteActionWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=<xsl:value-of select="VDiskOID"/>&amp;VDiskName=<xsl:value-of select="VDiskName"/>&amp;Action=1024&amp;help=vdprin</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strRenameButton"/></xsl:attribute>
			
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strCancel"/></xsl:attribute>
			<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;Action=blank&amp;help=vdprin</xsl:attribute>
			
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/><xsl:value-of select="VDiskName"/><xsl:value-of select="$strTitlePart2"/></xsl:attribute>
			</PageTitle>
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strSubHeader"/></xsl:attribute>
			</SubHeader>

			<xsl:call-template name="rename"/>
		</DataArea>
	</xsl:template>
	<xsl:template name="rename">
	<ComboData>
		<ListData>
			<xsl:variable name="showtasks">false</xsl:variable>
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strSubHeader2"/></xsl:attribute>
			</SubHeader>
			<Data name="vdname" type="editbox">
				<xsl:attribute name="value"><xsl:value-of select="/OMA/VDiskName"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strVDName"/></xsl:attribute>
				<xsl:attribute name="textboxname">vdname</xsl:attribute>
				<xsl:attribute name="textboxvalue"></xsl:attribute>
				<xsl:attribute name="unit"></xsl:attribute>	
			</Data>
		</ListData>
	</ComboData>
	<script language="javascript">
		function initializationRoutine()
		{
			document.getElementById("vdname").focus();
			return;
		}

	   function isValidLength(text) 
      {
      	//Max length of VDname
        var maxlen = <xsl:value-of select="/OMA/Controllers/DCStorageObject/MaxNameLength"/>;

			if(text.length &gt; maxlen) 
			{
				alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strNameLength"/>" + maxlen);	   	   	 
	   		return false;
			}
			if(text.length &lt; 1)
			{
				alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strNameBlank"/>");	   	   	 
	   		return false;
			}
			
			return true;	
      }
		
		function validate() 
		 {

			var newvdname = document.dataarea.vdname.value;			
			var oldName = '<xsl:value-of select="/OMA/VDiskName"/>';
			
			if(oldName == newvdname)
			{
				alert("<xsl:value-of select="$strSameName"/>");
				document.getElementById("vdname").focus();
				return false;
			}
			
			if(isValidLength(document.dataarea.vdname.value)) 
			{
				if(isValidName(document.dataarea.vdname.value)) 
				{
						disableButtons("submit","back" ,"");
						return true;
				}
			}
			document.getElementById("vdname").focus();
			document.getElementById("vdname").value = "";
			return false;
		}
	</script>

	</xsl:template>
</xsl:stylesheet>

