<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Enclosure Set Tag Data page.  The associated web plugin is the SetEnclosureTagDataWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exslt="http://exslt.org/common" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	<xsl:import href="temptbl.xsl"/>
	<xsl:template name="GetTempProbeLimitsChoose">
		<!-- Return the default values from the specified temperature probe -->
		<xsl:param name="offset"/>
		<xsl:param name="choice"/>
		<xsl:choose>
			<xsl:when test="$choice = 'LowEndMinWarning'">
				<xsl:value-of select="TemperatureProbes/DCStorageObject[$offset]/LowEndMinWarning"/>
			</xsl:when>
			<xsl:when test="$choice = 'HighEndMinWarning'">
				<xsl:value-of select="TemperatureProbes/DCStorageObject[$offset]/HighEndMinWarning"/>
			</xsl:when>
			<xsl:when test="$choice = 'LowEndMaxWarning'">
				<xsl:value-of select="TemperatureProbes/DCStorageObject[$offset]/LowEndMaxWarning"/>
			</xsl:when>
			<xsl:when test="$choice = 'HighEndMaxWarning'">
				<xsl:value-of select="TemperatureProbes/DCStorageObject[$offset]/HighEndMaxWarning"/>
			</xsl:when>
			<xsl:when test="$choice = 'DefaultMinWarning'">
				<xsl:value-of select="TemperatureProbes/DCStorageObject[$offset]/DefaultMinWarning"/>
			</xsl:when>
			<xsl:when test="$choice = 'DefaultMaxWarning'">
				<xsl:value-of select="TemperatureProbes/DCStorageObject[$offset]/DefaultMaxWarning"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="0"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetTempProbeLimitsRecurse">
		<!-- Get default temp probe values from the appropriate temp probe -->
		<xsl:param name="offset"/>
		<xsl:param name="choice"/>
		<xsl:choose>
			<xsl:when test="substring(Enclosures/DCStorageObject/CurrentMethodMask,25,1)!='0'">
				<!-- Enclosure allows set all temp probe command like Pompano -->
				<xsl:choose>
					<xsl:when test="substring(TemperatureProbes/DCStorageObject[$offset]/CurrentMethodMask,29,1)='1'">
						<!-- Temperature probe's method mask is set -->
						<xsl:call-template name="GetTempProbeLimitsChoose">
							<xsl:with-param name="offset" select="$offset"/>
							<xsl:with-param name="choice" select="$choice"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<!-- Method mask is not set, check the next probe -->
						<xsl:call-template name="GetTempProbeLimitsRecurse">
							<xsl:with-param name="offset" select="$offset+1"/>
							<xsl:with-param name="choice" select="$choice"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<!-- Enclosure only allows set temp probe command like Zappa -->
				<xsl:call-template name="GetTempProbeLimitsChoose">
					<!-- Get the default values from the first temperature probe -->
					<xsl:with-param name="offset" select="'0'"/>
					<xsl:with-param name="choice" select="$choice"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="OMA">
		<xsl:call-template name="scripts"/>
		<xsl:variable name="TempProbeCount">
			<xsl:value-of select="count(TemperatureProbes/DCStorageObject)"/>
		</xsl:variable>
		<xsl:variable name="LowEndMinWarningValue">
			<xsl:call-template name="GetTempProbeLimitsRecurse">
				<xsl:with-param name="offset" select="0"/>
				<xsl:with-param name="choice" select="'LowEndMinWarning'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="HighEndMinWarningValue">
			<xsl:call-template name="GetTempProbeLimitsRecurse">
				<xsl:with-param name="offset" select="0"/>
				<xsl:with-param name="choice" select="'HighEndMinWarning'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="LowEndMaxWarningValue">
			<xsl:call-template name="GetTempProbeLimitsRecurse">
				<xsl:with-param name="offset" select="0"/>
				<xsl:with-param name="choice" select="'LowEndMaxWarning'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="HighEndMaxWarningValue">
			<xsl:call-template name="GetTempProbeLimitsRecurse">
				<xsl:with-param name="offset" select="0"/>
				<xsl:with-param name="choice" select="'HighEndMaxWarning'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DefaultMinWarningValue">
			<xsl:call-template name="GetTempProbeLimitsRecurse">
				<xsl:with-param name="offset" select="0"/>
				<xsl:with-param name="choice" select="'DefaultMinWarning'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DefaultMaxWarningValue">
			<xsl:call-template name="GetTempProbeLimitsRecurse">
				<xsl:with-param name="offset" select="0"/>
				<xsl:with-param name="choice" select="'DefaultMaxWarning'"/>
			</xsl:call-template>
		</xsl:variable>
		
		<DataArea validate="true" email="false" export="false" exportdata="false" printable="false">
			<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.sm.webplugins.SubmitTempProbeWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="Enclosures/@ControllerName"/>&amp;Name=<xsl:value-of select="Name"/>&amp;ChannelOID=<xsl:value-of select="ChannelOID"/>&amp;EnclosureOID=<xsl:value-of select="EnclosureOID"/>&amp;Action=<xsl:value-of select="Action"/>&amp;help=tpprin&amp;Type=<xsl:value-of select="substring(//Enclosures/DCStorageObject/CurrentMethodMask,25,1)"/></xsl:attribute>

			<xsl:choose>
				<xsl:when test="Action='tempinfo'">
					<xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strBackPageButton"/></xsl:attribute>
					<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.sm.webplugins.TempInfoWebPlugin&amp;HREF=<xsl:value-of select="HREF"/>&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;Name=<xsl:value-of select="Name"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;help=tpprin</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strBackPageButton"/></xsl:attribute>
					<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.sm.webplugins.EnclosureInfoWebPlugin&amp;HREF=<xsl:value-of select="HREF"/>&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="Name"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;ChannelOID=<xsl:value-of select="ChannelOID"/>&amp;help=tpprin</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitle1Part1"/><xsl:value-of select="/*/Enclosures/@ControllerName"/><xsl:value-of select="$strTitle1Part2"/></xsl:attribute>
			</PageTitle>
			<PromptText>
				<xsl:value-of select="$strInstructions"/>
			</PromptText>
			<CustomButton>
				<!-- The refresh button cannot use the below javascript to perform the refresh.  The issue is the  javascript calls the last webplug which was called
			      to render this page.  The problem is that the page can be rendered by two webplugins: the info webplugin and the action execute web plugin.
			      If the action execute webplugin was the last webplugin to render the page, pressing refresh would cause that action to be re-executed. -->
				<!--Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href"></xsl:attribute>
					<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
				</Data-->
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.SetTempProbeWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;Name=<xsl:value-of select="/OMA/Name"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;Action=4&amp;help=entktmp</xsl:attribute>
				</Data>
			</CustomButton>
			
			<ComboData>
				<ListData>
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strSubHeader"/></xsl:attribute>
						<xsl:attribute name="status"><xsl:value-of select="Enclosures/DCStorageObject/ObjStatus"/></xsl:attribute>
					</SubHeader>
					<Data name="Name" editable="false" type="ustring">
						<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="Enclosures/DCStorageObject/EnclosureType"/></xsl:with-param><xsl:with-param name="productid"><xsl:value-of select="Enclosures/DCStorageObject/ProductID"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</Data>
				</ListData>
				<TableData columnspacing="true">
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strTPSubHeader"/></xsl:attribute>
					</SubHeader>
					<xsl:call-template name="TempTableHeader">
						<xsl:with-param name="checkbox">true</xsl:with-param>
					</xsl:call-template>
					
					<xsl:for-each select="TemperatureProbes/DCStorageObject">
						<xsl:call-template name="TempTableRows">
							<xsl:with-param name="checkbox">true</xsl:with-param>
							<xsl:with-param name="methodmask">
								<xsl:value-of select="//Enclosures/DCStorageObject/CurrentMethodMask"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</TableData>
				<TableData columnspacing="true">
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strSubHeader2"/></xsl:attribute>
					</SubHeader>
					<Row>
						<Data name="radioButton" type="radio" align="left" returnvalue="reset" event="onclick" handler="radioHandler()" state="1"/>
						<Data name="reset" type="ustring" value="{$strReset}" display="{$strReset}" align="left"/>
						<Data name="blank1" type="ustring" value="" display="" align="left"/>
						<Data name="blank2" type="ustring" value="" display="" align="left"/>
						<Data name="blank3" type="ustring" value="" display="" align="left"/>
						<Data name="blank4" type="ustring" value="" display="" align="left"/>
					</Row>
					<Row>
						<Data name="radioButton" type="radio" align="left" returnvalue="new" event="onclick" handler="radioHandler()" state="0"/>
						<Data name="newValues" type="ustring" value="{$strNewValues}" display="{$strNewValues}" align="left"/>
						<Data name="WarnMin" editable="false" type="ustring">
							<xsl:attribute name="display"><xsl:value-of select="$strNewMinWarn"/> (<xsl:value-of select="$LowEndMinWarningValue"/> - <xsl:value-of select="$HighEndMinWarningValue"/><xsl:value-of select="$strRange3Part3"/>)</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strNewMinWarn"/> (<xsl:value-of select="$LowEndMinWarningValue"/> - <xsl:value-of select="$HighEndMinWarningValue"/><xsl:value-of select="$strRange3Part3"/>)</xsl:attribute>
						</Data>
						<Data name="WarnMinData" editable="false" type="editbox" state="2" maxlength="2">
							<xsl:attribute name="value"><xsl:value-of select="$DefaultMinWarningValue"/></xsl:attribute>
						</Data>
						<Data name="WarnMax" editable="false" type="ustring">
							<xsl:attribute name="display"><xsl:value-of select="$strNewMaxWarn"/> (<xsl:value-of select="$LowEndMaxWarningValue"/> - <xsl:value-of select="$HighEndMaxWarningValue"/><xsl:value-of select="$strRange3Part3"/>)</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strNewMaxWarn"/> (<xsl:value-of select="$LowEndMaxWarningValue"/> - <xsl:value-of select="$HighEndMaxWarningValue"/><xsl:value-of select="$strRange3Part3"/>)</xsl:attribute>
						</Data>
						<Data name="WarnMaxData" editable="true" type="editbox" state="2" maxlength="2">
							<xsl:attribute name="value"><xsl:value-of select="$DefaultMaxWarningValue"/></xsl:attribute>
						</Data>
					</Row>
				</TableData>
			</ComboData>
			<HiddenTable>
				<xsl:call-template name="ObjIDHiddenTable"/>
			</HiddenTable>
			<script language="javascript">
			function radioHandler() 
			{
				var RadioSelected = document.getElementsByName("radioButton");
			    	if (RadioSelected[0].checked) 
			    	{
			    		disableInput();
			    	}
			    	if (RadioSelected[1].checked) 
			    	{
			    		enableInput();
			    	}
			}
						
			function disableInput() 
			{
				document.getElementById("WarnMinData").disabled = true;
				document.getElementById("WarnMaxData").disabled = true;				
			}
			
			function enableInput() 
			{
				document.getElementById("WarnMinData").disabled =false;
				document.getElementById("WarnMaxData").disabled = false;				
			}
			
			function checkMinRange() 
			{
				var MinWarning  = document.getElementById("WarnMinData").value;
				if  (isNaN(MinWarning)) 
				{
					alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strMinNaN"/>");
					document.getElementById("WarnMinData").value = <xsl:value-of select="$DefaultMinWarningValue"/>;
					document.getElementById("WarnMaxData").value = <xsl:value-of select="$DefaultMaxWarningValue"/>;
					return -1;
				}
				
				if (MinWarning &lt; <xsl:value-of select="$LowEndMinWarningValue"/> || MinWarning &gt; <xsl:value-of select="$HighEndMinWarningValue"/>) 
				{
					alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strRange1Part1"/>
				<xsl:value-of select="$LowEndMinWarningValue"/> - <xsl:value-of select="$HighEndMinWarningValue"/>
				<xsl:value-of select="$strRange3Part3"/>");
					document.getElementById("WarnMinData").value = <xsl:value-of select="$DefaultMinWarningValue"/>;
					return -1;
				}
				
				// Check for decimal
				var validchars = validchars = /^[0-9]*$/;
				if(!validchars.test(MinWarning))
				{
					alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strMinNaN"/>");
					document.getElementById("WarnMinData").value = <xsl:value-of select="$DefaultMinWarningValue"/>;
					document.getElementById("WarnMaxData").value = <xsl:value-of select="$DefaultMaxWarningValue"/>;
					return -1;
				}
				return 0;
			}

			function checkMaxRange() 
			{
				var MaxWarning  = document.getElementById("WarnMaxData").value;
				if  (isNaN(MaxWarning)) 
				{
					alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strMaxNaN"/>");
					document.getElementById("WarnMinData").value = <xsl:value-of select="$DefaultMinWarningValue"/>;
					document.getElementById("WarnMaxData").value = <xsl:value-of select="$DefaultMaxWarningValue"/>;
					return -1;
				}

				if (MaxWarning &lt; <xsl:value-of select="$LowEndMaxWarningValue"/> || MaxWarning &gt; <xsl:value-of select="$HighEndMaxWarningValue"/>) 
				{
					alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strRange2Part2"/>
				<xsl:value-of select="$LowEndMaxWarningValue"/> - <xsl:value-of select="$HighEndMaxWarningValue"/>
				<xsl:value-of select="$strRange3Part3"/>");
					document.getElementById("WarnMaxData").value = <xsl:value-of select="$DefaultMaxWarningValue"/>;
					return -1;
				}

				// Check for decimal
				var validchars = validchars = /^[0-9]*$/;
				if(!validchars.test(MaxWarning))
				{
					alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strMaxNaN"/>");
					document.getElementById("WarnMinData").value = <xsl:value-of select="$DefaultMinWarningValue"/>;
					document.getElementById("WarnMaxData").value = <xsl:value-of select="$DefaultMaxWarningValue"/>;
					return -1;
				}
				return 0;
			}
			
			function validate() 
			{
				var RadioSelected = document.getElementsByName("radioButton");
				var MinWarning;
				var MaxWarning;
			    
				if (RadioSelected[0].checked) 
			    {
			    	MinWarning = <xsl:value-of select="$DefaultMinWarningValue"/>;
              		MaxWarning = <xsl:value-of select="$DefaultMaxWarningValue"/>;
            	}
            	else if (RadioSelected[1].checked) 
            	{
					MinWarning  = document.getElementById("WarnMinData").value;
					MaxWarning = document.getElementById("WarnMaxData").value;
					
					CheckMinRange = checkMinRange();
					CheckMaxRange = checkMaxRange();
							
					if (CheckMinRange == -1 || CheckMaxRange == -1) 
					{
						// No need for an alert here - these functions already alert user
						return false;
					}
	         	}
	         	else 
	         	{
	              	alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strNoRadio"/>");
	             	return false;
				}
	          
				if (MinWarning == "" || MaxWarning == "") 
				{
					alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strReqValue"/>");
					return false;
				}
				var Count = <xsl:value-of select="$TempProbeCount"/>;
				var list = "";
				var noSelectionMade = "true";
				var index;
				var objID;
				for (index=0; index &lt; Count; index++) 
				{
					var checked = document.getElementById("temp"+index).checked;
					if (checked) 
					{
						noSelectionMade = "false";
						objID = document.getElementById("OBJOID"+index).value;
						list = list + "&amp;TempProbeOID" + index + "=" + objID;
					}
				}
				if (noSelectionMade == "true") 
				{
            	alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strNoSelect"/>");
					return false;
          }
          else 
          {
					disableButtons("submit","back" ,"");
					for (index=0; index &lt; Count; index++) 
					{
						document.getElementById("temp"+index).disabled = false;
					}
					return true;
				}
			}
			
		</script>
		</DataArea>
	</xsl:template>
	
	<xsl:template name="ObjIDHiddenTable">
		<xsl:variable name="DefaultMinWarningValue">
			<xsl:call-template name="GetTempProbeLimitsRecurse">
				<xsl:with-param name="offset" select="0"/>
				<xsl:with-param name="choice" select="'DefaultMinWarning'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DefaultMaxWarningValue">
			<xsl:call-template name="GetTempProbeLimitsRecurse">
				<xsl:with-param name="offset" select="0"/>
				<xsl:with-param name="choice" select="'DefaultMaxWarning'"/>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:for-each select="TemperatureProbes/DCStorageObject">
			<Data>
				<xsl:attribute name="name">OBJOID<xsl:value-of select="Index"/></xsl:attribute>
				<xsl:attribute name="returnvalue"><xsl:value-of select="Nexus"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="name">OBJOID<xsl:value-of select="Index"/>CurrentMin</xsl:attribute>
				<xsl:attribute name="returnvalue"><xsl:value-of select="MinWarning"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="name">OBJOID<xsl:value-of select="Index"/>CurrentMax</xsl:attribute>
				<xsl:attribute name="returnvalue"><xsl:value-of select="MaxWarning"/></xsl:attribute>
			</Data>
		</xsl:for-each>
	
		<Data>
			<xsl:attribute name="name">DefaultMin</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="$DefaultMinWarningValue"/></xsl:attribute>
		</Data>
		<Data>
			<xsl:attribute name="name">DefaultMax</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="$DefaultMaxWarningValue"/></xsl:attribute>
		</Data>
	</xsl:template>
	
	
</xsl:stylesheet>

