<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!--The code below includes Utils.xsl which contains commonly called templates to get layout, read policy, write policy etc which can be resused/-->
	<xsl:include href="Utils.xsl"/>
	<xsl:include href="cvdutils.xsl"/>
	<xsl:template match="/OMA">
		<!-- %26 is escape character for &-->
		<xsl:variable name="returnUrl">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin%26ControllerOID=<xsl:value-of select="//ControllerOID"/>%26ControllerName=<xsl:value-of select="//ControllerName"/>%26help=vdmgmt</xsl:variable>
		<DataArea exportdata="false" printable="false" email="false" validate="true">
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strFinishCVDES"/></xsl:attribute>
			<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.sm.webplugins.SubmitReconfigureVDSummaryWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;Layout=<xsl:value-of select="/OMA/Layout"/>&amp;Length=<xsl:value-of select="/OMA/Length"/>&amp;IDList=<xsl:value-of select="/OMA/IDList"/>&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;URL=<xsl:value-of select="$returnUrl"/></xsl:attribute>
			<xsl:attribute name="cancel">true</xsl:attribute>
			<xsl:attribute name="canceltarget">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;Action=blank&amp;help=vdprin</xsl:attribute>
			<xsl:attribute name="canceldisplay"><xsl:value-of select="$strExitWizard"/></xsl:attribute>
			<xsl:attribute name="ignoreJumpBar">true</xsl:attribute>
			<script language="javascript">
				<xsl:call-template name="getCommonScripts"/>
			</script>
			<CustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strRefreshCVDES"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.ReconfigureVDSummaryWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;VirtualDiskOID=<xsl:value-of select="//VirtualDiskOID"/>&amp;Layout=<xsl:value-of select="/OMA/Layout"/>&amp;Length=<xsl:value-of select="/OMA/Length"/>&amp;IDList=<xsl:value-of select="/OMA/IDList"/>&amp;help=vdtkrcn3</xsl:attribute>
				</Data>
			</CustomButton>
			<!--
				<BottomCustomButton>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strExitWizard"/></xsl:attribute>
						<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;Action=blank&amp;help=vdprin</xsl:attribute>
					</Data>
				</BottomCustomButton>
				-->
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strReconfigure"/><xsl:value-of select="//VirtualDisks/DCStorageObject/Name"/><xsl:value-of select="$strStep3"/></xsl:attribute>
			</PageTitle>
			<PromptText ignoreoncli="true">
				<xsl:value-of select="$strClickFinish"/>
			</PromptText>
			<!-- New Configuration -->
			<TableData name="T1" display="{$strVDAttribTableCVDES}">
				<Header>
					<Data value="{$strAttributeCVDES}" width="400"/>
					<Data value="{$strValueCVDES}"/>
				</Header>
				<SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$strNewConfig"/></xsl:attribute>
				</SubHeader>
				<Row>
					<Data value="{$strTypeCVDU}" name="RaidLevel"/>
					<Data name="RaidLevelValue">
						<xsl:attribute name="value"><!--The Template in Utils.xsl is called below/--><xsl:call-template name="GetRaidLayout"><xsl:with-param name="RaidType"><xsl:value-of select="Layout"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</Data>
				</Row>
				<Row>
					<Data value="{$strSizeCVDES}" name="Size"/>
					<Data name="SizeValue">
						<xsl:attribute name="value"><xsl:value-of select="format-number((Length div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:attribute>
					</Data>
				</Row>
			</TableData>
			<TableData name="T2" display="{$strArrayDiskTableCVDES}">
				<Header>
					<Data value="{$strArrayDiskCVDES}" width="400"/>
					<Data value="{$strFreeSpaceCVDES}"/>
				</Header>
				<xsl:apply-templates select="PassThruResponse/DCStorageObject">
					<xsl:sort select="Channel" data-type="number" order="ascending"/>
					<xsl:sort select="TargetID" data-type="number" order="ascending"/>
				</xsl:apply-templates>
			</TableData>
			<!-- Old Configuration -->
			<TableData name="T1" display="{$strVDAttribTableCVDES}">
				<Header>
					<Data value="{$strAttributeCVDES}" width="400"/>
					<Data value="{$strValueCVDES}"/>
				</Header>
				<SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$strPrevConfig"/></xsl:attribute>
				</SubHeader>
				<Row>
					<Data value="{$strTypeCVDU}" name="RaidLevel"/>
					<Data name="RaidLevelValue">
						<xsl:attribute name="value"><!--The Template in Utils.xsl is called below/--><xsl:call-template name="GetRaidLayout"><xsl:with-param name="RaidType"><xsl:value-of select="/OMA/VirtualDisks/DCStorageObject/Layout"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</Data>
				</Row>
				<Row>
					<Data value="{$strSizeCVDES}" name="Size"/>
					<Data name="SizeValue">
						<xsl:attribute name="value"><xsl:value-of select="format-number((/OMA/VirtualDisks/DCStorageObject/Length div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:attribute>
					</Data>
				</Row>
			</TableData>
			<TableData name="T2" display="{$strArrayDiskTableCVDES}">
				<Header>
					<Data value="{$strArrayDiskCVDES}" width="400"/>
					<Data value="{$strFreeSpaceCVDES}"/>
				</Header>
				<xsl:apply-templates select="ArrayDisks/DCStorageObject">
					<xsl:sort select="Channel" data-type="number" order="ascending"/>
					<xsl:sort select="TargetID" data-type="number" order="ascending"/>
				</xsl:apply-templates>
			</TableData>
			<script language="javascript">
			function validate() 
			{
				//using this function to turn off submitbuttons.
				disableButtons("submit","" ,"cancel");				
				return true;
			}

			</script>
		</DataArea>
	</xsl:template>
	<xsl:template match="PassThruResponse/DCStorageObject">
		<Row>
			<Data>
				<xsl:attribute name="name">Adisk<xsl:value-of select="position()"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="EnclosureID">
						<!-- SAS -->
						<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDES"/>&#160;<xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<!-- SCSI -->
						<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDES"/>&#160;<xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
			<Data>
				<xsl:attribute name="name">AdiskFreeSpace<xsl:value-of select="position()"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="format-number((ContiguousFree div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:attribute>
			</Data>
		</Row>
	</xsl:template>
	<xsl:template match="ArrayDisks/DCStorageObject">
		<!-- test if this is a DHS, need to check here as well -->
		<xsl:variable name="isDHS">
			<!-- check to see if current disk is DHS -->
			<xsl:call-template name="IsDedicatedHotSpare">
				<xsl:with-param name="AttributesMask">
					<xsl:value-of select="AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:if test="$isDHS='0'">
			<Row>
				<Data>
					<xsl:attribute name="name">Adisk<xsl:value-of select="position()"/></xsl:attribute>
					<xsl:choose>
						<xsl:when test="EnclosureID">
							<!-- SAS -->
							<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDES"/>&#160;<xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<!-- SCSI -->
							<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDES"/>&#160;<xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</Data>
				<Data>
					<xsl:attribute name="name">AdiskFreeSpace<xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="format-number((ContiguousFree div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
