<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	<!-- VIRTUAL DISK TABLE HEADER -->
	<xsl:template name="OfflineVDTableHeader">
		
		<!-- ignore on web is set to true since it's only needed for scripts using the cli -->
		<Data name="Id" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strID"/></xsl:attribute>
		</Data>
		<Data name="Status" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
		</Data>
		<Data name="Name" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
		</Data>
		<Data name="State" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
		</Data>
		<Data name="Layout" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strLayout"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strLayout"/></xsl:attribute>
		</Data>
		<Data name="Size" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strSize"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strSize"/></xsl:attribute>
		</Data>
		<Data name="DeviceName" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strDeviceName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strDeviceName"/></xsl:attribute>
		</Data>
		<Data name="Type" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strType"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strType"/></xsl:attribute>
		</Data>
		<Data name="Read Cache" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strReadCache"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strReadCache"/></xsl:attribute>
		</Data>
		<Data name="Write Cache" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strWriteCache"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strWriteCache"/></xsl:attribute>
		</Data>
		<xsl:if test="//CachePolicy or /OMA/@cli = 'true'">
			<Data name="Cache Policy" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strCachePolicy"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strCachePolicy"/></xsl:attribute>
			</Data>
		</xsl:if>
		<Data name="StripeSize" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strStripeSize"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strStripeSize"/></xsl:attribute>
		</Data>
                <!-- Disabling Disk cache policy for ir controllers --> 
                <xsl:if test="substring(/OMA/VirtualDisks/@AttributesMask,5,1)!='1'">
		<Data name="DiskCachePolicy" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strDiskCachePolicy"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strDiskCachePolicy"/></xsl:attribute>
		</Data>
		</xsl:if>
		
	</xsl:template>
	<!-- VIRTUAL DISK TABLE ROWS -->
	<xsl:template name="OfflineVDTableRows">
		<xsl:param name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus">
					<xsl:value-of select="Nexus"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="caller"/>
		<xsl:variable name="vdiskname">
			<xsl:value-of select="Name"/>
		</xsl:variable>
		<xsl:variable name="vdiskid">
			<xsl:value-of select="$ObjID"/>
		</xsl:variable>

		<xsl:variable name="blink">
			<xsl:if test="substring(CurrentMethodMask,24,1)!='0'">true</xsl:if>
		</xsl:variable>
		
		<xsl:variable name="isCluster">
			<xsl:choose>
				<xsl:when test="substring(/OMA/VirtualDisks/@AttributesMask,32,1)!='0'">1</xsl:when>
			  <xsl:otherwise>0</xsl:otherwise>
		 </xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="vdevname">
			<xsl:value-of select="DeviceName"/>
		</xsl:variable>
		<xsl:variable name="numbootpart">
			<xsl:choose>
				<xsl:when test="NumBootPart">
					<xsl:value-of select="NumBootPart"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="0"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:if test="count(ParentVDID)= 0">
			<!-- Only display main virtual disks, not child VDisks -->
			<Row height="30px">
				<!-- ignore on web is set to true since it's only needed for scripts using the cli -->
				<Data name="Test" editable="false" type="ustring" display="Test" ignoreonweb="true">
					<xsl:attribute name="value"><xsl:value-of select="LogicalDriveNum"/></xsl:attribute>
				</Data>
				<Data type="status" align="center">
					<xsl:attribute name="value"><xsl:value-of select="ObjStatus"/></xsl:attribute>
				</Data>
				<Data link="false" editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strName"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="Name"/></xsl:attribute>
					
				</Data>
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strState"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
				<!-- isEmpty var used for tasks menu option -->
				<xsl:variable name="isEmpty">
					<xsl:call-template name="IsCurrentMethodMaskEmpty">
						<xsl:with-param name="Mask">
							<xsl:value-of select="CurrentMethodMask"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				
				
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strLayout"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:call-template name="GetRaidLayout"><xsl:with-param name="RaidType"><xsl:value-of select="Layout"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
				<xsl:choose>
					<xsl:when test="/OMA/@cli='true'">
						<!--CLI version of the capacty data (displays bytes as well as GB)-->
						<Data name="Test" editable="false" type="ustring" display="Test" ignoreonweb="true">
							<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="Length"/></xsl:with-param></xsl:call-template> GB (<xsl:value-of select="Length"/> bytes)</xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<!-- Web Version of the length data (ONLY displays GB) -->
						<Data editable="false" type="ustring" display="Test" ignoreoncli="true">
							<xsl:attribute name="name"><xsl:value-of select="$strSize"/><xsl:value-of select="position()"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="Length"/></xsl:with-param></xsl:call-template> <xsl:value-of select="$strGB"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strDeviceName"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="DeviceName"/></xsl:attribute>
				</Data>
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strType"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:call-template name="GetBusProtocol"><xsl:with-param name="Bus"><xsl:value-of select="BusProtocol"/></xsl:with-param></xsl:call-template>
					</xsl:attribute>
				</Data>
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strReadCache"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:call-template name="GetReadPolicy"><xsl:with-param name="readpolicy"><xsl:value-of select="ReadPolicy"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strWriteCache"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:call-template name="GetWritePolicy"><xsl:with-param name="writepolicy"><xsl:value-of select="WritePolicy"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
				<xsl:if test="//CachePolicy or /OMA/@cli = 'true'">
					<Data editable="false" type="ustring" display="Test">
						<xsl:attribute name="name"><xsl:value-of select="$strCachePolicy"/><xsl:value-of select="position()"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="GetCachePolicy"><xsl:with-param name="cachepolicy"><xsl:value-of select="CachePolicy"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</Data>
				</xsl:if>
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strStripeSize"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:call-template name="GetStripeSize"><xsl:with-param name="stripesize"><xsl:value-of select="StripeSize"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
                                <xsl:if test="substring(/OMA/VirtualDisks/@AttributesMask,5,1)!='1'">
				<Data editable="false" type="ustring" display="Test">
					<xsl:attribute name="name"><xsl:value-of select="$strDiskCachePolicy"/><xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:call-template name="GetDiskCachePolicy"><xsl:with-param name="DiskCachePolicy"><xsl:value-of select="DiskCachePolicy"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
                                </xsl:if>

			</Row>
		</xsl:if>
		<!-- End if (VDLevel = 0) -->
	</xsl:template>
</xsl:stylesheet>
