<!-- 
Information in this document is subject to change without notice.
(c) 1995- 2006 Dell Inc. All rights reserved.


This page renders the initialization page for Virtual Disks
There is three different kinds of initialize:
Fast Initialize, Slow Initialize, and Initialize (non-SAS)
 -->


<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="Utils.xsl"/>
	<xsl:import href="adtbl.xsl"/>
	
	<xsl:template match="OMA">
		<DataArea validate="true">
			<!-- Setting strings on XML page that varies depending on what the action is -->
			<xsl:variable name="strInitType">
					<xsl:choose>
						<xsl:when test="/OMA/Action = 4194304">
							<!-- slow init -->
							<xsl:value-of select="$strSlowInitialize"/>
						</xsl:when>
						<xsl:when test="/OMA/Action = 8388608">
							<!-- fast init -->
							<xsl:value-of select="$strFastInitialize"/>	
						</xsl:when>
						<xsl:otherwise>
         				<!-- init -->
							<xsl:value-of select="$strInitialize"/>
						</xsl:otherwise>
					</xsl:choose>
			</xsl:variable>
			<xsl:variable name="strTitlePart2InitType">
					<xsl:choose>
						<xsl:when test="/OMA/Action = 4194304">
							<!-- slow init   -->
							<xsl:value-of select="$strTitlePart2Slow"/>
						</xsl:when>	
						<xsl:when test="/OMA/Action = 8388608">
							<!-- fast init -->
							<xsl:value-of select="$strTitlePart2Fast"/>	
						</xsl:when> 
						<xsl:otherwise>
							<xsl:value-of select="$strTitlePart2"/>
						</xsl:otherwise>
					</xsl:choose>
			</xsl:variable>
			
			<xsl:variable name="strRUSureInitType">	
					<xsl:choose>
						<xsl:when test="/OMA/Action = 4194304">
							<!-- slow init -->
							<xsl:value-of select="$strRUSureSlow"/>
						</xsl:when>
						<xsl:when test="/OMA/Action = 8388608">
							<!-- fast init -->
							<xsl:value-of select="$strRUSureFast"/>
						</xsl:when> 
						<xsl:otherwise>
							<xsl:value-of select="$strRUSure"/>
						</xsl:otherwise>
					</xsl:choose>			
			</xsl:variable>
		
			<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.sm.webplugins.VDExecuteActionWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;VDiskOID=<xsl:value-of select="VDiskOID"/>&amp;VDiskName=<xsl:value-of select="VDiskName"/>&amp;Action=<xsl:value-of select="Action"/>&amp;help=vdmgmt</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strInitType"/></xsl:attribute>
			
			<xsl:variable name="canBlink">
				<xsl:choose>
					<xsl:when test="/OMA/Blink='true'">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<!-- show if blink is supported -->
			<xsl:if test="Blink='true'">
				<xsl:if test="ArrayDisks/DCStorageObject">
					<!-- We needed the ability to disable (hide) the bottom buttons when a user executes an action (DFCT117103) -->
					<!-- but we currently only have the ability to hide the submit, cancel, and back buttons.  Since this page only -->
					<!-- uses the cancel and submit buttons, I've changed the <BottomCustomButton> for Blink to be a cancel -->
					<!-- button as a way to hide it when the user selects submit.  This will need to change when the framework allows -->
					<!-- other buttons to be disabled.   - Michael Regert, 06/15/04 -->
					<xsl:attribute name="cancel">true</xsl:attribute>
					<xsl:attribute name="canceldisplay"><xsl:value-of select="$strBlink"/></xsl:attribute>
					<xsl:attribute name="canceltarget">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDBlinkBeforeInitWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;VDiskOID=<xsl:value-of select="VDiskOID"/>&amp;VDiskName=<xsl:value-of select="VDiskName"/>&amp;VDeviceName=<xsl:value-of select="VDeviceName"/>&amp;Blink=<xsl:value-of select="Blink"/>&amp;Action=<xsl:value-of select="Action"/>&amp;task=blinkvd&amp;menu=init&amp;help=vdtkfmt</xsl:attribute>
				</xsl:if>
			</xsl:if>
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strCancel"/></xsl:attribute>
			<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;help=vdprin</xsl:attribute>

			<xsl:choose>
				<!-- DF54564: Fast Init fails with an error. -->
				<!-- Check to see if there is a boot partition. If one exists, check to see if slowinit or fastinit has been selected and display the appropriate warning message. If not then display default slowinit or fastinit message -->
				<xsl:when test="NumBootPart &gt; 0">
					<xsl:if test="/OMA/Action = 4194304"> <!-- Slow initialization -->
						<PageTitle alert="true" status="3">
							<xsl:attribute name="display">
								<xsl:value-of select="$strTitleBootPart1"/>
								<!--xsl:value-of select="ArrayDisks/@VirtualDiskName"/-->
								<xsl:value-of select="$strTitleBootSlowInit"/>
							</xsl:attribute>
						</PageTitle>
					</xsl:if>
					<xsl:if test="/OMA/Action = 8388608"> <!-- Fast initialization -->
						<PageTitle alert="true" status="3">
							<xsl:attribute name="display">
								<xsl:value-of select="$strTitleBootPart1"/>
								<!--xsl:value-of select="ArrayDisks/@VirtualDiskName"/-->
								<xsl:value-of select="$strTitleBootFastInit"/>
							</xsl:attribute>
						</PageTitle>
					</xsl:if>
					<xsl:if test="/OMA/Action = 64"> <!-- Normal initialization (non-sas) -->
						<PageTitle alert="true" status="3">
							<xsl:attribute name="display">
								<xsl:value-of select="$strTitleBootPart1"/>
								<xsl:value-of select="$strTitleBootInit"/>
							</xsl:attribute>
						</PageTitle>
					</xsl:if>					
				</xsl:when>
				<xsl:otherwise>
					<PageTitle alert="true" status="3">
						<xsl:attribute name="display">
							<xsl:value-of select="$strTitlePart1"/>
							<xsl:value-of select="ArrayDisks/@VirtualDiskName"/>: <xsl:value-of select="$strTitlePart2InitType"/>
						</xsl:attribute>
					</PageTitle>
				</xsl:otherwise>
			</xsl:choose>
			
			
			<CustomButton>
				<!-- The refresh button cannot use the below javascript to perform the refresh.  The issue is the  javascript calls the last webplug which was called
			      to render this page.  The problem is that the page can be rendered by two webplugins: the info webplugin and the action execute web plugin.
			      If the action execute webplugin was the last webplugin to render the page, pressing refresh would cause that action to be re-executed. -->
				<!--Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href"></xsl:attribute>
					<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
				</Data-->
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.ConfirmInitVDWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=<xsl:value-of select="/OMA/VDiskOID"/>&amp;VDiskName=<xsl:value-of select="/OMA/VDiskName"/>&amp;VDeviceName=<xsl:value-of select="VDeviceName"/>&amp;Blink=<xsl:value-of select="Blink"/>&amp;NumBootPart=<xsl:value-of select="NumBootPart"/>&amp;help=vdtkfmt</xsl:attribute>
				</Data>
			</CustomButton>
			<TableData columnspacing="true">
				<xsl:variable name="showtasks">false</xsl:variable>
				<SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$strSubHeaderPart1"/><xsl:value-of select="VDiskName"/><xsl:value-of select="$strSubHeaderPart2"/></xsl:attribute>
				</SubHeader>
				<Header>
					<xsl:call-template name="ArrayDiskTableHeader">
						<xsl:with-param name="tasks">false</xsl:with-param>
						<xsl:with-param name="expanded">true</xsl:with-param>
					</xsl:call-template>
				</Header>
				<xsl:for-each select="ArrayDisks/DCStorageObject">
						<xsl:variable name="isDHS">
							<!-- check to see if current disk is DHS and filter it out -->
							<xsl:call-template name="IsDedicatedHotSpare">
								<xsl:with-param name="AttributesMask">
									<xsl:value-of select="AttributesMask"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:if test="$isDHS='0'">			
							<xsl:call-template name="ArrayDiskTableRows">
								<xsl:with-param name="tasks">false</xsl:with-param>
								<xsl:with-param name="expanded">true</xsl:with-param>
							</xsl:call-template>
						</xsl:if>
				</xsl:for-each>
			</TableData>

			<!-- show if blink is supported -->
			<!--xsl:if test="Blink='true'">
				<xsl:if test="ArrayDisks/DCStorageObject"-->
					<!-- extra check for DFCT104927 -->
					<!--BottomCustomButton>
						<Data-->
							<!--Both format and init call VDBlinkBeforeInitWebPlugin...parameter "menu" determines if it was called from format or init page-->
							<!--xsl:attribute name="href"> /servlet/DataArea?plugin=com.dell.sm.webplugins.VDBlinkBeforeInitWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;VDiskOID=<xsl:value-of select="VDiskOID"/>&amp;VDiskName=<xsl:value-of select="VDiskName"/>&amp;Blink=<xsl:value-of select="Blink"/>&amp;Action=blinkvd&amp;menu=init&amp;help=vdtkfmt</xsl:attribute>
							<xsl:attribute name="display"><xsl:value-of select="$strBlink"/></xsl:attribute>
						</Data>
					</BottomCustomButton>
				</xsl:if>
			</xsl:if-->

			<script language="javascript">
				function validate() 
				{
					var vdname="<xsl:value-of select="VDiskName"/>";
					//var bootdevice="<xsl:value-of select="NumBootPart"/>";
					var tempStr = "";
					delmsg = vdname + "<xsl:value-of select="$strColon"/>" + "<xsl:value-of select="$strSpace"/>" + "<xsl:value-of select="$strRUSureInitType"/>";
					
					var cfrm = confirm(delmsg);
					var isblink = <xsl:value-of select="$canBlink"/>;
				
					if(cfrm)
					{
						if(isblink == 1)
						{
							disableButtons("submit","back" ,"cancel");
						}
						else
						{
							disableButtons("submit","back" ,"");
						}							
					}					
					return (cfrm);
				}
			</script>
	
		</DataArea>
	</xsl:template>
</xsl:stylesheet>
