<!-- This is the XSL to render the Array Disks belonging to a Virtual Disk page.  The associated web plugin is the ArrayWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:include href="Utils.xsl"/>
	<xsl:include href="adtbl.xsl"/>
	<xsl:template match="OMA">
		<DataArea>
				<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.sm.webplugins.VDExecuteActionWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;VDiskOID=<xsl:value-of select="VDiskOID"/>&amp;VDiskName=<xsl:value-of select="VDiskName"/>&amp;Action=2&amp;help=vdtkfmt</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strFormat"/></xsl:attribute>
			<xsl:attribute name="validate">true</xsl:attribute>
			<!-- We needed the ability to disable (hide) the bottom buttons when a user executes an action (DFCT117103) -->
			<!-- but we currently only have the ability to hide the submit, cancel, and back buttons.  Since this page only -->
			<!-- uses the cancel and submit buttons, I've changed the <BottomCustomButton> for Blink to be a cancel -->
			<!-- button as a way to hide it when the user selects submit.  This will need to change when the framework allows -->
			<!-- other buttons to be disabled.   - Michael Regert, 06/15/04 -->
			
			<xsl:variable name="canBlink">
				<xsl:choose>
					<xsl:when test="/OMA/Blink='true'">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<xsl:if test="Blink='true'">
				<xsl:if test="ArrayDisks/DCStorageObject">
			
				<xsl:attribute name="cancel">true</xsl:attribute>
				<xsl:attribute name="canceldisplay"><xsl:value-of select="$strBlink"/></xsl:attribute>
			   <xsl:attribute name="canceltarget">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDBlinkBeforeInitWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;VDiskOID=<xsl:value-of select="VDiskOID"/>&amp;VDiskName=<xsl:value-of select="VDiskName"/>&amp;VDeviceName=<xsl:value-of select="VDeviceName"/>&amp;Action=blinkvd&amp;menu=format&amp;help=vdtkfmt&amp;Blink=true</xsl:attribute>
				</xsl:if>
			</xsl:if>
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strCancel"/></xsl:attribute>
			<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;help=vdprin</xsl:attribute>
			
			<PageTitle alert="true" status="3">
				<xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/><xsl:value-of select="ArrayDisks/@VirtualDiskName"/><xsl:value-of select="$strTitlePart2"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href"/>
					<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
				</Data>
			</CustomButton>
			<TableData columnspacing="true">
				<xsl:variable name="showtasks">false</xsl:variable>
				<SubHeader>
					<xsl:attribute name="display"/>
				</SubHeader>
				<SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$strSubHeaderPart1"/><xsl:value-of select="VDeviceName"/><xsl:value-of select="$strSubHeaderPart2"/></xsl:attribute>
				</SubHeader>
				<Header>
					<xsl:call-template name="ArrayDiskTableHeader">
						<xsl:with-param name="tasks">false</xsl:with-param>
						<xsl:with-param name="expanded">true</xsl:with-param>
					</xsl:call-template>
				</Header>
				<xsl:for-each select="ArrayDisks/DCStorageObject">
					<xsl:variable name="isDHS">
						<!-- check to see if current disk is DHS and filter it out -->
						<xsl:call-template name="IsDedicatedHotSpare">
							<xsl:with-param name="AttributesMask">
								<xsl:value-of select="AttributesMask"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:if test="$isDHS='0'">			
						<xsl:call-template name="ArrayDiskTableRows">
							<xsl:with-param name="tasks">false</xsl:with-param>
							<xsl:with-param name="expanded">true</xsl:with-param>
						</xsl:call-template>
					</xsl:if>
				</xsl:for-each>
			</TableData>
	
			<script language="javascript">
			function validate() 
			{
				// Validate doesn't need to validate any data, but just needs to prompt the user
				// to verify the want to continue with the delete.  confirm( ) will return true when
				// the user selects OK and false when the user selects CANCEL.
				var formatmsg = "<xsl:value-of select="/OMA/VDiskName"/><xsl:value-of select="$strColon"/><xsl:value-of select="$strSpace"/><xsl:value-of select="$strRUSure"/>";
				var cfrm = confirm(formatmsg);
				var isblink = "<xsl:value-of select="$canBlink"/>";
				if(cfrm)
				{
				//using this function to turn off submit and back buttons.			
				
					var isblink = <xsl:value-of select="$canBlink"/>;
					if(isblink == 1)
					{
						disableButtons("submit","back" ,"cancel");
					}
					else
					{
						disableButtons("submit","back" ,"");
					}
				}	
				return (cfrm);		
			}
						
		</script>
		</DataArea>
	</xsl:template>
</xsl:stylesheet>
