<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Enclosure Information page.  The associated web plugin is the EnclosureInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="Utils.xsl"/>
	<xsl:import href="adtbl.xsl"/>
	<xsl:import href="encltbl.xsl"/>
	<xsl:import href="emmtbl.xsl"/>
	<xsl:import href="fantbl.xsl"/>
	<xsl:import href="temptbl.xsl"/>
	<xsl:import href="pstbl.xsl"/>
	<xsl:template match="OMA">
		<xsl:variable name="checkAdmin">
			<xsl:choose>
				<xsl:when test="OMAUserRights = '7'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<DataArea backpagetarget="/servlet/DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin" IgnoreJumpBar="true">
		<xsl:call-template name="scripts"/>
		<script language="javascript">
			function onExecute(oid) {
				var encltasks = "encltasks" + oid;
				var action = document.getElementById(encltasks).value;		
				if (action == "-") { 
					alert("<xsl:value-of select="$strSelectValidTask"/>");
      }
      else if ((action =="1") || (action =="2") || (action == '64') || (action == '256')) {
      document.dataarea.action = top.gnv.appendVID("/servlet/SubmitForm?plugin=com.dell.sm.webplugins.EnclosureExecuteActionWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;Name=<xsl:value-of select="/OMA/Name"/>&amp;EnclosureOID="+ oid +"&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;Action="+action+"&amp;help=enprin");
      document.dataarea.submit();
      }
      else if (action =="4") {
        document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.SetEnclosureTagDataWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;Name=<xsl:value-of select="/OMA/Name"/>&amp;EnclosureOID="+ oid +"&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;Action="+action+"&amp;help=entktag");
      }
      else if ((action =="8") || (action == "128")) {
        document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.SetTempProbeWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;Name=<xsl:value-of select="/OMA/Name"/>&amp;EnclosureOID="+ oid +"&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;Action="+action+"&amp;help=entktmp");
				}
				else {
					//alert("AD Function '"+action+"' not yet implemented");
				}
			}
		</script>
			<PageTitle>
				<xsl:choose>
					<xsl:when test="count(//Enclosures/DCStorageObject) > 1">
						<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="count(//Enclosures/DCStorageObject) = 1">
						<xsl:attribute name="display"><xsl:value-of select="$strTitle2Part1"/><xsl:value-of select="/*/Enclosures/@ControllerName"/><xsl:value-of select="$strTitle2Part2"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="display"><xsl:value-of select="$strTitle3"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</PageTitle>

			<xsl:if test="//Enclosures/DCStorageObject/EnclosureMultipathLost = '1'">
				<PromptText alert="true" status="3">
					<xsl:value-of select="$strPathFailure"/>
				</PromptText>	
			</xsl:if>

			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">#</xsl:attribute>
					<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
				</Data>
			</CustomButton>
			<xsl:apply-templates select="/*/Enclosures/DCStorageObject">
				<xsl:with-param name="tasks">
					<xsl:value-of select="$checkAdmin"/>
				</xsl:with-param>
			</xsl:apply-templates>
		</DataArea>
	</xsl:template>
	<xsl:template match="Enclosures/DCStorageObject">
		<xsl:param name="tasks"/>
		<ComboData>
			<!-- DISPLAY THE ENCLOSURE INFORMATION IN A LIST FORMAT-->
			<ListData columnspacing="true">
				<SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$strSubHeader"/></xsl:attribute>
					<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
				</SubHeader>
				<xsl:call-template name="EnclosureTable">
					<xsl:with-param name="tasks">
						<xsl:value-of select="$tasks"/>
					</xsl:with-param>
				</xsl:call-template>
			</ListData>
			<!-- DISPLAY THE ARRAY DISK INFORMATION IN A TABLE FORMAT-->
			<xsl:if test="count(../../ArrayDisks)>0">
				<TableData columnspacing="true">
					<xsl:attribute name="display"><xsl:value-of select="$strADSubHeader"/></xsl:attribute>
					<xsl:variable name="showtasks">false</xsl:variable>
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strADSubHeader"/></xsl:attribute>
					</SubHeader>
					<Header>
						<xsl:call-template name="ArrayDiskTableHeader">
							<xsl:with-param name="tasks" select="$showtasks"/>
							<xsl:with-param name="expanded">true</xsl:with-param>
						</xsl:call-template>
					</Header>
					<xsl:for-each select="../../ArrayDisks/DCStorageObject">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:sort select="TargetID" data-type="number" order="ascending"/>
						<xsl:call-template name="ArrayDiskTableRows">
							<xsl:with-param name="tasks" select="$showtasks"/>
							<xsl:with-param name="expanded">true</xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</TableData>
			</xsl:if>
			<!-- DISPLAY THE EMM INFORMATION IN A TABLE FORMAT-->
			<xsl:if test="count(../../EMM)>0">
				<TableData columnspacing="true">
					<xsl:attribute name="display"><xsl:value-of select="$strEMMSubHeader"/></xsl:attribute>
					<xsl:variable name="showtasks">false</xsl:variable>
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strEMMSubHeader"/></xsl:attribute>
					</SubHeader>
					<Header>
						<xsl:call-template name="EMMTableHeader">
							<xsl:with-param name="tasks" select="$showtasks"/>
						</xsl:call-template>
					</Header>
					<xsl:for-each select="../../EMM/DCStorageObject">
						<xsl:sort select="Index" data-type="number" order="ascending"/>
						<xsl:call-template name="EMMTableRows">
							<xsl:with-param name="tasks" select="$showtasks"/>
						</xsl:call-template>
					</xsl:for-each>
				</TableData>
			</xsl:if>
			<!-- DISPLAY THE FAN INFORMATION IN A TABLE FORMAT-->
			<xsl:if test="count(../../Fans)>0">
				<TableData columnspacing="true">
					<xsl:attribute name="display"><xsl:value-of select="$strFanSubHeader"/></xsl:attribute>
					<xsl:variable name="showtasks">false</xsl:variable>
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strFanSubHeader"/></xsl:attribute>
					</SubHeader>
					<Header>
						<xsl:call-template name="FanTableHeader">
							<xsl:with-param name="tasks" select="$showtasks"/>
						</xsl:call-template>
					</Header>
					<xsl:for-each select="../../Fans/DCStorageObject">
						<xsl:sort select="Index" data-type="number" order="ascending"/>
						<xsl:call-template name="FanTableRows">
							<xsl:with-param name="tasks" select="$showtasks"/>
						</xsl:call-template>
					</xsl:for-each>
				</TableData>
			</xsl:if>
			<!-- DISPLAY THE POWER SUPPLY INFORMATION IN A TABLE FORMAT-->
			<xsl:if test="count(../../PowerSupply)>0">
				<TableData columnspacing="true">
					<xsl:attribute name="display"><xsl:value-of select="$strPSSubHeader"/></xsl:attribute>
					<xsl:variable name="showtasks">false</xsl:variable>
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strPSSubHeader"/></xsl:attribute>
					</SubHeader>
					<Header>
						<xsl:call-template name="PSTableHeader">
							<xsl:with-param name="tasks" select="$showtasks"/>
						</xsl:call-template>
					</Header>
					<xsl:for-each select="../../PowerSupply/DCStorageObject">
						<xsl:sort select="Index" data-type="number" order="ascending"/>
						<xsl:call-template name="PSTableRows">
							<xsl:with-param name="tasks" select="$showtasks"/>
						</xsl:call-template>
					</xsl:for-each>
				</TableData>
			</xsl:if>
			<!-- DISPLAY THE TEMPERATURE PROBE INFORMATION IN A TABLE FORMAT-->
			<xsl:if test="count(../../TemperatureProbes)>0">
				<TableData columnspacing="true">
					<xsl:attribute name="display"><xsl:value-of select="$strTPSubHeader"/></xsl:attribute>
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strTPSubHeader"/></xsl:attribute>
					</SubHeader>
					<xsl:call-template name="TempTableHeader"/>
					<xsl:for-each select="../../TemperatureProbes/DCStorageObject">
						<xsl:sort select="Index" data-type="number" order="ascending"/>
						<xsl:call-template name="TempTableRows"/>
					</xsl:for-each>
				</TableData>
			</xsl:if>
		</ComboData>
	</xsl:template>
	<!-- Enclosure TABLE (for Combo Data) -->
	<xsl:template name="EnclosureTable">
		<xsl:param name="tasks"/>
		<xsl:param name="ObjID">
		<xsl:call-template name="ModNexus">
			<xsl:with-param name="nexus">
				<xsl:value-of select="Nexus"/>
			</xsl:with-param>
		</xsl:call-template>
        	</xsl:param>
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- ignore on web is set to true since it's only needed for scripts using the cli -->
		<xsl:choose>
			<xsl:when test="BusProtocol=8">
				<!--ID for a SAS enclosure, ID is determined by the Channel:EnclosureID-->
				<Data columnspacing="true" name="Id" editable="false" type="usting">
					<xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/></xsl:attribute>
				</Data>
			</xsl:when>
			<xsl:otherwise>
				<!--ID for a SCSI enclosure is determined by the Channel number to which it is attached-->
				<Data columnspacing="true" name="Id" editable="false" type="usting">
					<xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="Channel"/></xsl:attribute>
				</Data>
			</xsl:otherwise>
		</xsl:choose>
		<Data columnspacing="true" name="Name" editable="false" type="usting">
			<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="EnclosureType"/></xsl:with-param></xsl:call-template></xsl:attribute>
		</Data>
		<Data columnspacing="true" name="State" editable="false" type="usting">
			<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
		</Data>
		<Data columnspacing="true" name="Channel" editable="false" type="usting">
			<xsl:attribute name="display"><xsl:value-of select="$strChannel"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="Channel"/></xsl:attribute>
		</Data>
		<xsl:if test="//Enclosures/DCStorageObject/TargetID or $dynamicView = 'false'">
			<xsl:choose>
				<xsl:when test="TargetID">
					<Data columnspacing="true" name="TargetID" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strTargetID"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="TargetID"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data columnspacing="true" name="TargetID" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strTargetID"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="//EnclosureConfig or $dynamicView = 'false'">
			<xsl:choose>
				<xsl:when test="EnclosureConfig">
					<Data columnspacing="true" name="Config" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strConfig"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="GetEnclosureConfig"><xsl:with-param name="config"><xsl:value-of select="EnclosureConfig"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data columnspacing="true" name="Config" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strConfig"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="//Enclosures/DCStorageObject/FirmwareVer or $dynamicView = 'false'">
			<xsl:choose>
				<xsl:when test="FirmwareVer">
					<Data columnspacing="true" name="FirmwareVer" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strFW"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="FirmwareVer"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data columnspacing="true" name="FirmwareVer" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strFW"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="//Enclosures/DCStorageObject/ServiceTag or $dynamicView = 'false'">
			<xsl:choose>
				<xsl:when test="ServiceTag">
					<Data columnspacing="true" name="ServiceTag" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strServiceTag"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data columnspacing="true" name="ServiceTag" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strServiceTag"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="//Enclosures/DCStorageObject/AssetTag or $dynamicView = 'false'">
			<xsl:choose>
				<xsl:when test="AssetTag">
					<Data columnspacing="true" name="AssetTag" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strAssetTag"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data columnspacing="true" name="AssetTag" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strAssetTag"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="//Enclosures/DCStorageObject/AssetName or $dynamicView = 'false'">
			<xsl:choose>
				<xsl:when test="AssetName">
					<Data columnspacing="true" name="AssetName" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strAssetName"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="AssetName"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data columnspacing="true" name="AssetName" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strAssetName"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="//Enclosures/DCStorageObject/BackPlanePartNum or $dynamicView = 'false'">
			<xsl:choose>
				<xsl:when test="BackPlanePartNum">
					<Data columnspacing="true" name="BackPlanePartNo" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strBPPartNo"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="BackPlanePartNum"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data columnspacing="true" name="BackPlanePartNo" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strBPPartNo"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="//Enclosures/DCStorageObject/SplitBusPartNum or $dynamicView = 'false'">
			<xsl:choose>
				<xsl:when test="SplitBusPartNum">
					<Data columnspacing="true" name="SplitBusPartNo" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strSBPartNo"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="SplitBusPartNum"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data columnspacing="true" name="SplitBusPartNo" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strSBPartNo"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="//Enclosures/DCStorageObject/EnclosurePartNum or $dynamicView = 'false'">
			<xsl:choose>
				<xsl:when test="EnclosurePartNum">
					<Data columnspacing="true" name="EnclosurePartNo" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strEnclPartNo"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="EnclosurePartNum"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data columnspacing="true" name="EnclosurePartNo" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strEnclPartNo"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="//Enclosures/DCStorageObject/SASAddress or $dynamicView = 'false'">
			<xsl:choose>
				<xsl:when test="SASAddress">
					<Data columnspacing="true" name="SASAddress" editable="false" type="usting" display="Test">
						<xsl:attribute name="display"><xsl:value-of select="$strSASAddress"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="SASAddress"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data columnspacing="true" name="SASAddress" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strSASAddress"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="//Enclosures/DCStorageObject/EnclosureAlarm or $dynamicView = 'false'">
			<xsl:choose>
				<xsl:when test="EnclosureAlarm">
					<Data columnspacing="true" name="EnclAlarm" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strEnclAlarm"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="GetEnclosureAlarm"><xsl:with-param name="state"><xsl:value-of select="EnclosureAlarm"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data columnspacing="true" name="EnclAlarm" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strEnclAlarm"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:variable name="isEmpty">
			<xsl:call-template name="IsCurrentMethodMaskEmpty">
				<xsl:with-param name="Mask">
					<xsl:value-of select="CurrentMethodMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:if test="$tasks='true'">
			<xsl:choose>
				<!--check to see if methods even exist -->
				<xsl:when test="$isEmpty='0'">
					<Data type="select" ignoreoncli="true">
		    				<xsl:attribute name="display"><xsl:value-of select="$strEncTasks"/></xsl:attribute>
						<xsl:attribute name="name">encltasks<xsl:value-of select="$ObjID"/></xsl:attribute>
						<Choice value="Select a task" returnvalue="-" default="true">
							<xsl:attribute name="value"><xsl:value-of select="$strSelectTask"/></xsl:attribute>
						</Choice>
						<xsl:if test="string-length(CurrentMethodMask) = 32">
							<xsl:call-template name="for-loop-list-box">
								<xsl:with-param name="Mask" select="CurrentMethodMask"/>
								<xsl:with-param name="templateName" select="8"/>
							</xsl:call-template>
						</xsl:if>
					</Data>
					<Data type="button">
							 <xsl:attribute name="href">javascript:onExecute(\"<xsl:value-of select="$ObjID"/>\");</xsl:attribute>
							  <xsl:attribute name="value"><xsl:value-of select="$strExecute"/></xsl:attribute>
							  <xsl:attribute name="tablebutton">true</xsl:attribute> 
							 <!-- The above property should be set for the table button to get rid of white spaces on the edges -->
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<!-- current methodmask is empty -->
					<!-- make sure to keep this code even if Master Method Mask is empty. This is a usability requirement-->
					<Data value="tasks" type="select" boxwidth="width:400px">
						<xsl:attribute name="display"><xsl:value-of select="$strEncTasks"/></xsl:attribute>
						<xsl:attribute name="name">encltasks<xsl:value-of select="ObjID"/></xsl:attribute>
						<Choice returnvalue="" default="true">
							<xsl:attribute name="value"><xsl:value-of select="$strNoTask"/></xsl:attribute>
						</Choice>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
