<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the dedicated hot spare page.  The associated web plugin is the DedicatedHotSpareWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	<xsl:import href="adtbl.xsl"/>
	<xsl:key name="ADsForChannel" match="//DHSAllDisks/ArrayDisks" use="@ChannelName"/> 
	<!-- ################################################### -->
	<!-- Main template -->
	<xsl:template match="OMA">
		<DataArea validate="true" onLoad="true" exportdata="false">
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strCancel"/></xsl:attribute>
			<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;HREF=<xsl:value-of select="HREF"/>&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;help=vdprin</xsl:attribute>
			<xsl:choose>
				<xsl:when test="//DHSAvailDisks or //DHSCurrentDisks">
					<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.sm.webplugins.SubmitDedHotspareWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=<xsl:value-of select="/OMA/VDiskOID"/>&amp;VDiskName=<xsl:value-of select="/OMA/VDiskName"/>&amp;help=vdtkdhs</xsl:attribute>
				</xsl:when>
			</xsl:choose>
			<!-- Load the javascripts used by this xsl.  I've put them into their own tempate to make the code more readable -->
			<xsl:call-template name="LocalScripts"/>
			<!-- ##### New error handling ##### -->
			<HiddenTable>
				<Data name="BackToLink" returnvalue=""/>
			</HiddenTable>
			<xsl:call-template name="errorhandling"/>
			<!-- ##### End new error handling ##### -->
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/><xsl:value-of select="VDiskName"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<!-- The refresh button cannot use the below javascript to perform the refresh.  The issue is the  javascript calls the last webplug which was called
			      to render this page.  The problem is that the page can be rendered by two webplugins: the info webplugin and the action execute web plugin.
			      If the action execute webplugin was the last webplugin to render the page, pressing refresh would cause that action to be re-executed. -->
				<!--Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href"></xsl:attribute>
					<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
				</Data-->
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.DedHotspareWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=<xsl:value-of select="/OMA/VDiskOID"/>&amp;VDiskName=<xsl:value-of select="/OMA/VDiskName"/>&amp;help=vdtkdhs</xsl:attribute>
				</Data>
			</CustomButton>

			<xsl:if test="//DHSCurrentDisks">
				<PromptText>
					<xsl:value-of select="$strExplTextUnassign"/>
				</PromptText>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="//DHSAvailDisks">
					<PromptText>
						<xsl:value-of select="$strExplTextAssign"/>
					</PromptText>
				</xsl:when>
				<xsl:otherwise>
					<PromptText>
						<xsl:value-of select="$strExplTextNoDisks"/>
					</PromptText>
				</xsl:otherwise>
			</xsl:choose>

			<xsl:choose>
				<xsl:when test="//DHSAvailDisks or //DHSCurrentDisks">
					<xsl:call-template name="DiskTable"/>
					<HiddenTable>
						<xsl:for-each select="//DHSAllDisks/ArrayDisks/DCStorageObject">
							<Data>
								<xsl:attribute name="name">
								<xsl:choose>
									<xsl:when test="EnclosureID">OBJID<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:when>
									<xsl:otherwise>OBJID<xsl:value-of select="Channel"/>0<xsl:value-of select="TargetID"/></xsl:otherwise>
								</xsl:choose>
								</xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:call-template name="ModNexus"><xsl:with-param name="nexus"><xsl:value-of select="Nexus"/></xsl:with-param></xsl:call-template></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="name">
								<xsl:choose>
									<xsl:when test="EnclosureID">AlreadyAssigned<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:when>
									<xsl:otherwise>AlreadyAssigned<xsl:value-of select="Channel"/>0<xsl:value-of select="TargetID"/></xsl:otherwise>
								</xsl:choose>
								</xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:call-template name="IsDedicatedHotSpare"><xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param></xsl:call-template></xsl:attribute>
							</Data>
						</xsl:for-each>
					</HiddenTable>
					<HiddenTable>
						<xsl:for-each select="//DHSCurrentDisks/ArrayDisks/DCStorageObject">
							<Data>
								<xsl:attribute name="name">	
								<xsl:choose>
									<xsl:when test="EnclosureID">DHSSTATE<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:when>
									<xsl:otherwise>DHSSTATE<xsl:value-of select="Channel"/>0<xsl:value-of select="TargetID"/></xsl:otherwise>
								</xsl:choose>
								</xsl:attribute>						
								<xsl:attribute name="returnvalue">1</xsl:attribute>
							</Data>
						</xsl:for-each>
						<xsl:for-each select="//DHSAvailDisks/ArrayDisks/DCStorageObject">
							<Data>
								<xsl:attribute name="name">
								<xsl:choose>
									<xsl:when test="EnclosureID">DHSSTATE<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:when>
									<xsl:otherwise>DHSSTATE<xsl:value-of select="Channel"/>0<xsl:value-of select="TargetID"/></xsl:otherwise>
								</xsl:choose>
								</xsl:attribute>
								<xsl:attribute name="returnvalue">0</xsl:attribute>
							</Data>
						</xsl:for-each>
					</HiddenTable>
					<HiddenTable>
						<Data>
							<xsl:attribute name="name">OIDListBeforeChanges</xsl:attribute>
							<xsl:attribute name="returnvalue"/>
						</Data>
						<Data>
							<xsl:attribute name="name">OldListSize</xsl:attribute>
							<xsl:attribute name="returnvalue"/>
						</Data>
						<Data>
							<xsl:attribute name="name">OIDListAfterChanges</xsl:attribute>
							<xsl:attribute name="returnvalue"/>
						</Data>
						<Data>
							<xsl:attribute name="name">NewListSize</xsl:attribute>
							<xsl:attribute name="returnvalue"/>
						</Data>
					</HiddenTable>
				</xsl:when>
			</xsl:choose>
		</DataArea>
	</xsl:template>
	<!-- ################################################### -->
	<!-- This dispays the two tables where the user selects their disks -->
	<xsl:template name="DiskTable">
		<!-- Create two tables side-by-side.  The first table (selection table) is used to display the available
         Disks capable of being used as a hotspare.  The second table (result table) will display any
         currently configured dedicated hotspare.  Adaptec allows more than one dedicated hotspare to
         be configured.  The user will be able to deselect any currently configured hotspare and select new
         new ones.  LSI has the current restriction of only allowing one, so we'll restrict this via javascript. -->
		<SelectionData multitable="true" image="both">
			<SelectionTable>
				<!-- The header for the selection table will be the channel radio buttons -->
				<Header>
					<xsl:for-each select="Channels/DCStorageObject">
						<xsl:call-template name="RenderChannelSelectionRadioButtons"/>
					</xsl:for-each>
				</Header>
				<!-- The list of available disks for dhs is divided by channel, so each channel will have a <DHSAvailDisks ChannelName=" " EnclosureName=" "> tag -->
				<xsl:for-each select="DHSAllDisks/ArrayDisks">
				
					<xsl:choose>
								<xsl:when test="DCStorageObject/EnclosureID">					
									<!-- SAS: use channel and enclosure id -->
									<xsl:call-template name="RenderAvailArrayDisksRow">
										<!-- To render each channel's disks, we need to pass in some parameters
				                              These are used to give each row, etc a correct title to be used by the
				                              javascript when querying for the elements.  The KEY is used to sort
				                              the disks by channel for the radio buttons -->
										<xsl:with-param name="PARENT_NAME">Sel<xsl:value-of select="DCStorageObject/Channel"/><xsl:value-of select="DCStorageObject/EnclosureID"/></xsl:with-param>
										<xsl:with-param name="CHILD_NAME_PREFIX">Sel</xsl:with-param>
										<xsl:with-param name="DISPLAY_NAME"><xsl:choose><xsl:when test="not(@EnclosureType) or (@EnclosureType = '')"><xsl:value-of select="$strDirectAttached"/></xsl:when><xsl:otherwise><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of  select="@EnclosureType"/></xsl:with-param>
                                                            <xsl:with-param name="productid"><xsl:value-of  select="@ProductID"/></xsl:with-param></xsl:call-template>(<xsl:value-of  select="@ChannelName"/>)</xsl:otherwise></xsl:choose></xsl:with-param>
										<xsl:with-param name="KEY_NAME">ADsForChannel</xsl:with-param>
										<xsl:with-param name="KEY_MATCH">
											<xsl:value-of select="@ChannelName"/>
										</xsl:with-param>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
										<!-- Not SAS: use channel and 0 -->
										<xsl:call-template name="RenderAvailArrayDisksRow">
										<!-- To render each channel's disks, we need to pass in some parameters
				                              These are used to give each row, etc a correct title to be used by the
				                              javascript when querying for the elements.  The KEY is used to sort
				                              the disks by channel for the radio buttons -->
										<xsl:with-param name="PARENT_NAME">Sel<xsl:value-of select="DCStorageObject/Channel"/>0</xsl:with-param>
										<xsl:with-param name="CHILD_NAME_PREFIX">Sel</xsl:with-param>
										<xsl:with-param name="DISPLAY_NAME"><xsl:choose><xsl:when test="not(@EnclosureType) or (@EnclosureType = '')"><xsl:value-of select="$strDirectAttached"/></xsl:when><xsl:otherwise><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="@EnclosureType"/></xsl:with-param><xsl:with-param name="productid"><xsl:value-of  select="@ProductID"/></xsl:with-param></xsl:call-template></xsl:otherwise></xsl:choose></xsl:with-param>
										<xsl:with-param name="KEY_NAME">ADsForChannel</xsl:with-param>
										<xsl:with-param name="KEY_MATCH">
											<xsl:value-of select="@ChannelName"/>
										</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>					
				</xsl:for-each>
			</SelectionTable>
			<ResultTable>
				<Header>
					<Data name="ResHeader">
						<xsl:attribute name="value"><xsl:value-of select="$strResHeader"/></xsl:attribute>
					</Data>
				</Header>
				<!-- The list of currently used disks is divided by channel, so each channel
                 will have a <DHSCurrentDisks ChannelName=" " EnclosureName=" "> tag -->
				<xsl:for-each select="DHSAllDisks/ArrayDisks">				
					<xsl:choose>
						<xsl:when test="DCStorageObject/EnclosureID">	
							<xsl:call-template name="RenderResultsDisksRow">
								<!-- SAS: use channel and enclosure id  -->
								<!-- To render each channel's disks, we need to pass in some parameters
		                              These are used to give each row, etc a correct title to be used by the
		                              javascript when querying for the elements.  The KEY is used to sort
		                              the disks by channel for the radio buttons -->
								<xsl:with-param name="PARENT_NAME">Res<xsl:value-of select="DCStorageObject/Channel"/><xsl:value-of select="DCStorageObject/EnclosureID"/></xsl:with-param>
								<xsl:with-param name="CHILD_NAME_PREFIX">Res</xsl:with-param>
								<xsl:with-param name="DISPLAY_NAME"><xsl:choose><xsl:when test="not(@EnclosureType) or (@EnclosureType = '')"><xsl:value-of select="$strDirectAttached"/></xsl:when><xsl:otherwise><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="@EnclosureType"/></xsl:with-param><xsl:with-param name="productid"><xsl:value-of  select="@ProductID"/></xsl:with-param></xsl:call-template>(<xsl:value-of select="@ChannelName"/>)</xsl:otherwise></xsl:choose></xsl:with-param>
								<xsl:with-param name="KEY_NAME">ADsForChannel</xsl:with-param>
								<xsl:with-param name="KEY_MATCH">
									<xsl:value-of select="@ChannelName"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<!-- non-SAS: use channel and 0 -->
							<xsl:call-template name="RenderResultsDisksRow">
								<!-- To render each channel's disks, we need to pass in some parameters
		                              These are used to give each row, etc a correct title to be used by the
		                              javascript when querying for the elements.  The KEY is used to sort
		                              the disks by channel for the radio buttons -->
								<xsl:with-param name="PARENT_NAME">Res<xsl:value-of select="DCStorageObject/Channel"/>0</xsl:with-param>
								<xsl:with-param name="CHILD_NAME_PREFIX">Res</xsl:with-param>
								<xsl:with-param name="DISPLAY_NAME"><xsl:choose><xsl:when test="not(@EnclosureType) or (@EnclosureType = '')"><xsl:value-of select="$strDirectAttached"/></xsl:when><xsl:otherwise><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="@EnclosureType"/></xsl:with-param><xsl:with-param name="productid"><xsl:value-of  select="@ProductID"/></xsl:with-param></xsl:call-template></xsl:otherwise></xsl:choose></xsl:with-param>
								<xsl:with-param name="KEY_NAME">ADsForChannel</xsl:with-param>
								<xsl:with-param name="KEY_MATCH">
									<xsl:value-of select="@ChannelName"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</ResultTable>
		</SelectionData>
	</xsl:template>
	<!-- ################################################### -->
	<!-- This dispays the channel radio buttons on the top of the table  -->
	<xsl:template name="RenderChannelSelectionRadioButtons">
		<Data name="ChannelButton" type="radio" state="0" event="onclick" handler="OnChannelSelected()">
			<xsl:attribute name="value"><xsl:value-of select="$strChannel"/><xsl:value-of select="Channel"/></xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="Channel"/></xsl:attribute>
		</Data>
	</xsl:template>
	<!-- ################################################### -->
	<!-- This dispays the each enclosure with the +/- expansion          -->
	<xsl:template name="RenderAvailArrayDisksRow">
		<xsl:param name="PARENT_NAME"/>
		<xsl:param name="CHILD_NAME_PREFIX"/>
		<xsl:param name="DISPLAY_NAME"/>
		<xsl:param name="KEY_NAME"/>
		<xsl:param name="KEY_MATCH"/>
		<!-- The Row is the enclosure -->
		<Row tree="expand" name="{$PARENT_NAME}">
			<ColumnData>
				<Data value="{$DISPLAY_NAME}"/>
			</ColumnData>
			<!-- The children rows are the individual disks -->
			<ChildrenRows>
				<!-- For each disk that matches the channel we're trying to display -->
				<xsl:for-each select="key($KEY_NAME,$KEY_MATCH)/DCStorageObject">
					<xsl:sort select="Channel" data-type="number" order="ascending"/>
					<xsl:sort select="TargetID" data-type="number" order="ascending"/>
					<xsl:call-template name="RenderArrayDiskSelectionRow">
						<xsl:with-param name="ArrayDiskSpace">
							<xsl:value-of select="Length"/>
						</xsl:with-param>
						<xsl:with-param name="PrefixName">
							<xsl:value-of select="$CHILD_NAME_PREFIX"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:for-each>
			</ChildrenRows>
		</Row>
	</xsl:template>
	<!-- ################################################### -->
	<!-- This dispays the each disk under the enclosure row                -->
	<xsl:template name="RenderArrayDiskSelectionRow">
		<xsl:param name="ArrayDiskSpace"/>
		<xsl:param name="PrefixName"/>
		<Row>
			<xsl:variable name="enclNum">
				<xsl:choose>
					<xsl:when test="EnclosureID"><xsl:value-of select="EnclosureID"/></xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="$enclNum"/><xsl:value-of select="TargetID"/></xsl:attribute>
			<SelectDataItem>
				<Data type="checkbox" width="150" columnspacing="true">
					<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="$enclNum"/><xsl:text/><xsl:value-of select="TargetID"/></xsl:attribute>
					<!-- Different name depending on SAS or SATA -->
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="EnclosureID">
								<xsl:value-of select="$strADName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$strADName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/>
							</xsl:otherwise>
						</xsl:choose>				
					</xsl:attribute>

					<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
					<xsl:attribute name="event">onClick</xsl:attribute>
					<xsl:attribute name="handler">javascript:OnArrayDiskSelected('<xsl:value-of select="Channel"/>','<xsl:value-of select="$enclNum"/>','<xsl:value-of select="TargetID"/>','<xsl:value-of select="VendorID"/>')</xsl:attribute>
				</Data>
			</SelectDataItem>
			<ColumnData>
				<Data columnspacing="true">
					<xsl:attribute name="value"><xsl:value-of select="format-number(($ArrayDiskSpace div (1024*1024*1024)),'#,##0.00 GB')"/></xsl:attribute>
				</Data>
			</ColumnData>
		</Row>
	</xsl:template>
	<!-- ################################################### -->
	<!-- This dispays the each enclosure with the +/- expansion          -->
	<xsl:template name="RenderResultsDisksRow">
		<xsl:param name="PARENT_NAME"/>
		<xsl:param name="CHILD_NAME_PREFIX"/>
		<xsl:param name="DISPLAY_NAME"/>
		<xsl:param name="KEY_NAME"/>
		<xsl:param name="KEY_MATCH"/>
		<!-- The Row is the enclosure -->
		<Row tree="expand" name="{$PARENT_NAME}">
			<ColumnData>
				<Data value="{$DISPLAY_NAME}"/>
			</ColumnData>
			<!-- The children rows are the individual disks -->
			<ChildrenRows>
				<!-- For each disk that matches the channel we're trying to display -->
				<xsl:for-each select="key($KEY_NAME,$KEY_MATCH)/DCStorageObject">
					<xsl:sort select="Channel" data-type="number" order="ascending"/>
					<xsl:sort select="TargetID" data-type="number" order="ascending"/>
					<xsl:call-template name="RenderResultsArrayDiskSelectionRow">
						<xsl:with-param name="ArrayDiskSpace">
							<xsl:value-of select="Length"/>
						</xsl:with-param>
						<xsl:with-param name="PrefixName">
							<xsl:value-of select="$CHILD_NAME_PREFIX"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:for-each>
			</ChildrenRows>
		</Row>
	</xsl:template>
	<!-- ################################################### -->
	<!-- This dispays the each disk under the enclosure row                -->
	<xsl:template name="RenderResultsArrayDiskSelectionRow">
		<xsl:param name="ArrayDiskSpace"/>
		<xsl:param name="PrefixName"/>

		<Row>
			<xsl:variable name="enclNum">
				<xsl:choose>
					<xsl:when test="EnclosureID"><xsl:value-of select="EnclosureID"/></xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="$enclNum"/><xsl:value-of select="TargetID"/></xsl:attribute>
			<SelectDataItem>
				<Data type="checkbox" width="150" state="1" columnspacing="true">
					<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="$enclNum"/><xsl:text/><xsl:value-of select="TargetID"/></xsl:attribute>
					<!-- Different name if sas/sata -->
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="EnclosureID">
								<xsl:value-of select="$strADName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$strADName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/>
							</xsl:otherwise>
						</xsl:choose>				
					</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
					<xsl:attribute name="event">onClick</xsl:attribute>
					<xsl:attribute name="handler">javascript:OnResArrayDiskSelected('<xsl:value-of select="Channel"/>','<xsl:value-of select="$enclNum"/>','<xsl:value-of select="TargetID"/>')</xsl:attribute>
				</Data>
			</SelectDataItem>
			<ColumnData>
				<Data columnspacing="true">
					<xsl:attribute name="value"><xsl:value-of select="format-number(($ArrayDiskSpace div (1024*1024*1024)),'#,##0.00 GB')"/></xsl:attribute>
				</Data>
			</ColumnData>
		</Row>
	</xsl:template>
	<!-- ################################################### -->
	<xsl:template name="LocalScripts">
		<script language="javascript">
			<!-- ######################################################### -->
			
			var JS_GLOBAL_MaxNumEnclosures=3;
			
			<!-- Set DataArea onLoad='true' to call this function.  This will call all of
                  the routines that are required to display the two disk tables correctly -->                
	     function initializationRoutine()
			{		
				SetBackToButtonLink();
				<!--this function is called when the Selection table page is first loaded-->
				
				hideSelectionTable();
				hideResultTable();
				
				initializeSelectionTable();
							
          //hideResultTable();
				initializeResultTable();
				
				<!--get the first channel that has enclosure attached to it-->
				var channelNum = getDefaultChannelSelectionRadioButtonIndex();
				<!--show selection table with array disks attached to default channel identified-->
				if(channelNum!=-1) {
					showSelectionTable(channelNum);
				}
				
				<!--Below set the default channel selection radio button-->
				setDefaultChannelSelectionRadioButton();

				<!--Below disable the Channel radio buttons that do not contain ArrayDisks-->
				disableChannelSelectionRadioButtonsWithNoArrayDisks();
			}
		
			<!-- ######################################################### -->
			<!-- ######################################################### -->
			<!--This function hides all the rows in the selection table-->
			function hideSelectionTable()
			{
				var numChannels=4;
				var numTargets=24;
				var elemName=""
				for(var i=0;i&lt;numChannels;i++)
				{
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++) 
					{
					
						if(document.getElementById("parentrow_Sel"+i.toString()+e.toString())!=null)
						{
							document.getElementById("parentrow_Sel"+i.toString()+e.toString()).style.display="none";
						}
						else
						{
							continue;
						}
					
						for(var j=0;j&lt;numTargets;j++)
						{
							elemName = "parentrow_Sel"+i.toString()+ e.toString()+j.toString();
							if(document.getElementById(elemName) != null)
							{
								document.getElementById(elemName).style.display="none"
							}
						}
					}
				}
			}

	          <!-- ######################################################### -->
			<!--This funtion displays all the rows associated with channel 'i'-->
			function initializeSelectionTable()
			{
				var numChannels=4;
				var numTargets=24;
				var dhs;
				for(var i=0;i&lt;numChannels;i++) 
				{
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++) 
					{
						for(var j=0;j&lt;numTargets;j++)
						{
							elemName="parentrow_Sel"+i.toString()+e.toString()+j.toString();
							if(document.getElementById(elemName) != null)
							{							 
							    dhs = document.getElementById("DHSSTATE" + i.toString() + e.toString() + j.toString());
							    if (dhs != null) 
							    {
							    		dhs = dhs.value;
							    		if ( dhs =="0") 
							    		{
				        			   document.getElementById("Sel"+i.toString()+ e.toString() + j.toString()).checked = false;
							        }
							        else 
							        {
									   	 document.getElementById("Sel"+i.toString()+ e.toString()+j.toString()).checked= true ;
						       	   }
									}
							}
						}
					}
				}
			}

            <!-- ######################################################### -->
			<!--This funtion displays all the rows associated with channel 'i'-->
			function showSelectionTable(i)
			{
				var numTargets=24;
				var dhs;
				for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++) 
				{					
					for(var j=0;j&lt;numTargets;j++)
					{
						elemName="parentrow_Sel"+i.toString()+ e.toString()+j.toString();
						if(document.getElementById(elemName))
						{
						    dhs = document.getElementById("DHSSTATE" + i.toString()+ e.toString() + j.toString());
						    if (dhs != null) 
						    {
		        				    	document.getElementById("parentrow_Sel"+i.toString()+ e.toString()).style.display="";
				        		    	document.getElementById("parentrow_Sel"+i.toString()+ e.toString() + j.toString()).style.display="";
	   		         }
						}
					}
				}
			}

            <!-- ######################################################### -->
			<!--This function hides all the rows in the selection table-->
			function hideResultTable()
			{
				var numChannels=4;
				var numTargets = 24;
				var elemName=""
				for(var i=0;i&lt;numChannels;i++)
				{					
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++) 
					{					
						if(document.getElementById("parentrow_Res"+i.toString()+e.toString())!=null)
						{
							document.getElementById("parentrow_Res"+i.toString()+e.toString()).style.display="none";
						}
						
						for(var j=0;j&lt;numTargets;j++)
						{
							elemName = "parentrow_Res"+i.toString()+e.toString()+j.toString();
							if(document.getElementById(elemName) != null)
							{
								document.getElementById(elemName).style.display="none"
							}
						}
					}
				}
			}

	          <!-- ######################################################### -->
			<!--This funtion displays all the rows associated with channel 'i'-->
			function initializeResultTable()
			{
				var numChannels=4;
				var numTargets=24;
				var dhs;
				var vendorID = <xsl:value-of select="//VendorID"/>;
				for(var i=0;i&lt;numChannels;i++) 
				{
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++) 
					{
						for(var j=0;j&lt;numTargets;j++)
						{
							elemName="parentrow_Res"+i.toString()+ e.toString()+j.toString();
							if(document.getElementById(elemName) != null)
							{
								dhs = document.getElementById("DHSSTATE" + i.toString() + e.toString()+  j.toString());
								if (dhs != null) 
								{
									dhs = dhs.value;
									if ( dhs =="1") 
		        				{
										document.getElementById("parentrow_Res"+i.toString()+e.toString()).style.display="";
						        	document.getElementById("parentrow_Res"+i.toString()+e.toString()+j.toString()).style.display="";
										if (vendorID != "1") //If the VIL isn't adaptec don't allow multiple DHS
										{
											disableDisks();
										}
									}
									else 
									{
										document.getElementById("Res"+i.toString()+ e.toString()+j.toString()).checked=false;
									}
								}
								else 
								{
									document.getElementById("Res"+i.toString()+ e.toString()+j.toString()).checked=false;
								}
							}
						}
					}
				}
			}

			<!-- ######################################################### -->
			<!--This funtion displays all the rows associated with channel 'i'-->
			function showResultTable()
			{
				var numChannels=4;
				var numTargets=24;
				var dhs;
				var vendorID = <xsl:value-of select="//VendorID"/>;
				for(var i=0;i&lt;numChannels;i++) 
				{
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++) 
					{
						for(var j=0;j&lt;numTargets;j++)
						{
							elemName="parentrow_Res"+i.toString()+ e.toString()+ j.toString();
							if(document.getElementById(elemName) != null)
							{
	        				 if (document.getElementById("Res"+i.toString()+ e.toString()+j.toString()).checked==true) 
	        				 {
										document.getElementById("parentrow_Res"+i.toString()+ e.toString()).style.display="";
										document.getElementById("parentrow_Res"+i.toString()+ e.toString()+ j.toString()).style.display="";
										if (vendorID != "1") //Don't allow multiple DHS's unless ADAPTEC VIL
										{
											disableDisks();
						        	}
						      }
							}
						}
					}
				}
			}


     <!-- ######################################################### -->
		<!--This function disables the channel radio buttons that do not have any array disks attached-->
			function disableChannelSelectionRadioButtonsWithNoArrayDisks()
			{
				var RadioArray = document.getElementsByName("ChannelButton");
				
				for(var i=0;i&lt;RadioArray.length;i++)
				{
					var ArrayDisks = 0;
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
					{
						var elemName="parentrow_"+"Sel"+i.toString()+e.toString();
						if(document.getElementById(elemName) != null)
						{
							ArrayDisks = 1;
						}
					}
					if (ArrayDisks == 0)
					{
						RadioArray[i].disabled=true;
					}
				}
			}
       
			<!-- ######################################################### -->	
			<!--This function returns the index of the default channel selected from the array of channels-->
			function getDefaultChannelSelectionRadioButtonIndex()
			{
				var RadioArray = document.getElementsByName("ChannelButton");
				for(var i=0;i&lt;RadioArray.length;i++)
				{			
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
					{
						var elemName="parentrow_"+"Sel"+i.toString()+e.toString();
						if(document.getElementById(elemName) != null)
						{
							return i;
						}
					}
				}
				return -1;<!--failure-->
			}

			<!-- ######################################################### -->
			<!--This function selects and sets the default channel-->
			function setDefaultChannelSelectionRadioButton()
			{
				var found=false;
				var RadioArray = document.getElementsByName("ChannelButton");
				for(var i=0;i&lt;RadioArray.length;i++)
				{
					if(found == false)
					{
						for(var e=0;e&lt;RadioArray.length;e++)
						{							
							var elemName="parentrow_"+"Sel"+i.toString()+e.toString();
							if(document.getElementById(elemName) != null)
							{							
								RadioArray[i].checked=true;
								found=true;
								break;
							}
						}
					}
				}
			}

			<!-- ######################################################### -->
			<!--This function disables the channel radio buttons that do not have any array disks attached-->
			function disableChannelSelectionRadioButtonsWithNoArrayDisks()
			{
				var RadioArray = document.getElementsByName("ChannelButton");
				
				for(var i=0;i&lt;RadioArray.length;i++)
				{
					var ArrayDisks = 0;
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
					{
						var elemName="parentrow_Sel"+i.toString()+e.toString();
						if(document.getElementById(elemName) != null)
						{
							ArrayDisks = 1;
						}
					}
					if (ArrayDisks == 0)
					{
						RadioArray[i].disabled=true;
					}
				}
			}

			<!-- ######################################################### -->
			<!--This function is a handler that is called in response to a channel selection-->
			function OnChannelSelected()
			{
				hideSelectionTable();
				var RadioArray = document.getElementsByName("ChannelButton");
				for(var i=0;i&lt;RadioArray.length;i++)
				{
					if(RadioArray [i].checked)
					{
						showSelectionTable(i);
						break;
					}
				}
			}
			

			<!-- ######################################################### -->
			function OnArrayDiskSelected(channel,encl,target,vendorID)
			{
				//alert("channel, encl, target " + channel.toString() + " " + encl.toString() + " " + target.toString());
				if (document.getElementById("Sel"+channel.toString()+ encl.toString()+target.toString()).checked==true) 
				{
					var alreadyAssigned = document.getElementById("AlreadyAssigned"+channel.toString()+ encl.toString()+target.toString()).value;
					var newForThisVDisk = document.getElementById("DHSSTATE" + channel.toString()+ encl.toString() + target.toString()).value;
					if(newForThisVDisk==0) 
					{
						if(alreadyAssigned==1) 
						{
							var Confirm = confirm("<xsl:value-of select="$strAlreadyAssigned"/>");
							if (Confirm == false) 
							{
								document.getElementById("Sel"+channel.toString()+ encl.toString()+target.toString()).checked = false;
							      return;
							}
						}
				 	}
					document.getElementById("Sel"+channel.toString()+ encl.toString()+target.toString()).checked = true;
					document.getElementById("parentrow_Res"+channel.toString()+ encl.toString()).style.display="";
					document.getElementById("parentrow_Res"+channel.toString()+ encl.toString()+target.toString()).style.display="";
					document.getElementById("Res"+channel.toString()+ encl.toString()+target.toString()).checked=true;
					if (vendorID != "1") //Don't allow multiple DHS's unless ADAPTEC VIL
					{
						disableDisks();
					}
				}
				else 
				{ // if(document.getElementById("Sel"+channel.toString()+ encl.toString()+target.toString()).checked==false)
					hideResultTable();
					document.getElementById("Sel"+channel.toString()+ encl.toString()+target.toString()).checked = false;
					document.getElementById("parentrow_Res"+channel.toString()+ encl.toString()+target.toString()).style.display="none";
					document.getElementById("Res"+channel.toString()+ encl.toString()+target.toString()).checked=false;
					showResultTable();
				}
			}
				
			<!-- ######################################################### -->
			function OnResArrayDiskSelected(channel,encl,target)
			{
				hideResultTable();
				document.getElementById("Sel"+channel.toString()+ encl.toString()+target.toString()).checked = false;
				document.getElementById("parentrow_Res"+channel.toString()+ encl.toString()+target.toString()).style.display="none";
				document.getElementById("Res"+channel.toString()+ encl.toString()+target.toString()).checked=false;
				showResultTable();
				
				if (checkResultDisks() == 0)
				{
				    enableDisks();
			        }
			}

			<!-- ######################################################### -->
			function checkResultDisks()
			{
				var numChannels=4;
				var numTargets=24;
				var count=0;
				
				for (var i=0; i &lt; numChannels; i++) 
				{
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++) 
					{
						for (var j=0; j &lt; numTargets; j++) 
						{
							if (document.getElementById("Res"+i.toString()+ e.toString()+j.toString()) != null &amp;&amp; document.getElementById("Res"+i.toString()+ e.toString()+j.toString()).checked != false) 
							{
								count = count + 1;
							}
						}
					}
				}

				return count;
			}
			
			<!-- ######################################################### -->
			function enableDisks() 
			{
				var numChannels=4;
				var numTargets=24;
				
				for (var i=0; i &lt; numChannels; i++) 
				{
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++) 
					{
						for (var j=0; j &lt; numTargets; j++) 
						{
							if (document.getElementById("Sel"+i.toString()+ e.toString()+j.toString()) != null) 
							{
								document.getElementById("Sel"+i.toString()+ e.toString()+j.toString()).disabled=false;
							}
						}
					}
				}
			}
			
			<!-- ######################################################### -->
			function disableDisks() 
			{
				var numChannels=4;
				var numTargets=24;
				for (var i=0; i &lt; numChannels; i++) 
				{
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++) 
					{
						for (var j=0; j &lt; numTargets; j++) 
						{
							if (document.getElementById("Sel"+i.toString()+ e.toString()+j.toString()) != null) 
							{
								document.getElementById("Sel"+i.toString()+ e.toString()+j.toString()).disabled=true;
							}
						}
					}
				}
			}	
			
			<!-- ######################################################### -->
			function validate() 
			{
				var OIDListBeforeChanges = "";
				var OIDListAfterChanges = "";
				var numChannels=4;
				var numTargets = 24;
				var OID = "";
				var dhs = "";
				var oldListSize = 0;
				var newListSize = 0;
				for (var i=0; i &lt; numChannels; i++) 
				{
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++) 
					{					
						for (var j=0; j &lt; numTargets; j++) 
						{
							OID = document.getElementById("OBJID" + i.toString()+ e.toString() + j.toString());						
							if(OID != null) 
							{
								dhs = document.getElementById("DHSSTATE" + i.toString()+ e.toString() + j.toString());
								if(dhs) 
								{
									if( dhs.value == "1" ) 
									{
										OIDListBeforeChanges += OID.value + ":";
										oldListSize++;
									}
								}
								if(document.getElementById("parentrow_Res" + i.toString()+ e.toString() + j.toString()) != null) 
								{
									if(document.getElementById("Res" + i.toString()+ e.toString() + j.toString()).checked) 
									{
										OIDListAfterChanges += OID.value + ":";
										newListSize++;
									}
								}
							}
						}
					}
				}
				if (newListSize ==0) 
				{
					if(oldListSize == 0) 
					{
					    alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strNoSelect"/>");
					    return false;
					}
					var Confirm = confirm("<xsl:value-of select="$strConfirm"/>");
					if (Confirm == false ) 
					{	
						javascript:location.reload();
						return false;
					}
				}

				document.getElementById("OIDListBeforeChanges").value = OIDListBeforeChanges;
				document.getElementById("OIDListAfterChanges").value = OIDListAfterChanges;
				document.getElementById("OldListSize").value = oldListSize;
				document.getElementById("NewListSize").value = newListSize;
				
				disableButtons("submit","back" ,"");	
				return true;
			}			
			<!-- ######################################################### -->
		</script>
	</xsl:template>
</xsl:stylesheet>
