<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- the xsl included below contains messages for error codes-->
	<xsl:import href="smmsgs.xsl"/>
	<xsl:template match="OMA">
		<DataArea exportdata="false">
			<script language="javascript">
			function ReturnPage() {
				// The HREF URL passed in has !! in place of the &amp;.  this was need to be able to pass it to the web plugin.
				// Reverse this and replace the !! with &amp; here.
				var url = "<xsl:value-of select="HREF"/>";
				var split_url = url.split("!!");
				var end_count = split_url.length;
				var href = "";
				for(count=0; count &lt; end_count-1; count++) {
					href += split_url[count] + "&amp;";
				}
				href += split_url[end_count-1];
				document.location.href = href;
			}
			</script>
			<PageTitle alert="true" status="4">
				<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/></xsl:attribute>
			</PageTitle>
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strTitle2"/><xsl:call-template name="GetMessage"><xsl:with-param name="ErrorID" select="ErrorCode"/></xsl:call-template></xsl:attribute>
			</SubHeader>
			<!-- Devendra: Commented out for new Adaptec messages. -->
			<!--<xsl:if test="ErrorCode != 2226">-->
			<xsl:if test="ErrorCode &lt; 2226 or ErrorCode &gt;2231">
				<SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$strWhy"/></xsl:attribute>
				</SubHeader>
				<ListData>
					<Data>
						<xsl:attribute name="display">-</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strWhy1"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display">-</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strWhy2"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display">-</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strWhy3"/></xsl:attribute>
					</Data>
				</ListData>
			</xsl:if>
			<BottomCustomButton>
				<Data>
					<xsl:attribute name="href">javascript:ReturnPage()</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
				</Data>
			</BottomCustomButton>
		</DataArea>
	</xsl:template>
</xsl:stylesheet>
