<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!--The code below includes Utils.xsl which contains commonly called templates to get layout, read policy, write policy etc which can be resused/-->
	<xsl:include href="Utils.xsl"/>
	<xsl:include href="cvdutils.xsl"/>
	<xsl:include href="dsautils.xsl"/>
	<!--main entry point into this XSL,  /-->
	
	<!-- Declare a bunch of Global variables and params-->
	<xsl:variable name="GLOBAL_VAR_GetCapsSMStatus">
		<xsl:choose>
			<xsl:when test="/OMA/ExpressResults/SMStatus"><xsl:value-of select="/OMA/ExpressResults/SMStatus"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<xsl:variable name="PARAM_DSA_Rules">
		<xsl:choose>
			<xsl:when test="/OMA/Rules"><xsl:value-of select="/OMA/Rules"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PARAM_ClearForeignConfigEnable">
		<xsl:choose>
			<xsl:when test="/OMA/ClearForeignConfigEnable">
				<xsl:value-of select="/OMA/ClearForeignConfigEnable"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PARAM_IsAnyAdiskForeign">
		<xsl:choose>
			<xsl:when test="/OMA/ForeignAdiskFound">
				<xsl:value-of select="/OMA/ForeignAdiskFound"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PARAM_DSARaidModeAndDiskCheck">
		<xsl:choose>
			<xsl:when test="/OMA/DSARaidModeAndDiskCheck">
				<xsl:value-of select="/OMA/DSARaidModeAndDiskCheck"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PARAM_DSA_OutputFileName"><xsl:value-of select="/OMA/OutputFileName"/></xsl:variable>
	<xsl:variable name="PARAM_DSA_DisplayVDConfig"><xsl:value-of select="/OMA/DisplayVDConfig"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_ControllerName"><xsl:value-of select="/OMA/ControllerName"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_ControllerOID"><xsl:value-of select="/OMA/ControllerOID"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_FILE"><xsl:value-of select="/OMA/FILE"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_OrigURL"><xsl:value-of select="/OMA/OrigURL"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_Minosdrivesize"><xsl:value-of select="/OMA/Minosdrivesize"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_Maxosdrivesize"><xsl:value-of select="/OMA/Maxosdrivesize"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_Layout"><xsl:value-of select="/OMA/Layout"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_Length"><xsl:value-of select="/OMA/Length"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_VDName"><xsl:value-of select="/OMA/VDName"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_IM"><xsl:value-of select="/OMA/IntMirror"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_SELECTALL"><xsl:value-of select="/OMA/SelectAll"/></xsl:variable>
      <xsl:variable name="PARAM_CURR_ENCLOSURESELECTEDLIST"><xsl:value-of select="/OMA/EnclosureSelectedList"/></xsl:variable>
      <xsl:variable name="PARAM_CURR_ENCLOSUREDISABLEDLIST"><xsl:value-of select="/OMA/EnclosureDisabledList"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_IDList">
		<xsl:choose>
			<xsl:when test="$PARAM_CURR_IM = 'true'">
				<xsl:value-of select="/OMA/ExpressResults/PassThruResponse/DCStorageObject/DIDList"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="/OMA/IDList"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
        <xsl:variable name="PARAM_PREV_IMIDList"><xsl:value-of select="/OMA/IMIDList"/></xsl:variable>

	<xsl:variable name="PARAM_PREV_SpanLength">
		<xsl:choose>
			<xsl:when test="$PARAM_CURR_IM = 'true'">
				<xsl:value-of select="/OMA/ExpressResults/PassThruResponse/DCStorageObject/SpanLength"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="/OMA/SpanLength"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PARAM_PREV_DiskProtocol"><xsl:value-of select="/OMA/DiskProtocol"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_ReadPolicy"><xsl:value-of select="/OMA/ReadPolicy"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_WritePolicy"><xsl:value-of select="/OMA/WritePolicy"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_CachePolicy"><xsl:value-of select="/OMA/CachePolicy"/></xsl:variable>
      <xsl:variable name="PARAM_CURR_DiskCachePolicy"><xsl:value-of select="/OMA/DiskCachePolicy"/></xsl:variable>        
	<xsl:variable name="PARAM_CURR_StripeSize"><xsl:value-of select="/OMA/StripeSize"/></xsl:variable>
	<xsl:variable name="PARAM_STATE_UserSelectedAdiskArrayNumList"><xsl:value-of select="/OMA/UserSelectedAdiskArrayNumList"/></xsl:variable>
	<xsl:variable name="PARAM_STATE_UserSelectedAdiskContiguousFreeSpaceList"><xsl:value-of select="/OMA/UserSelectedAdiskContiguousFreeSpaceList"/></xsl:variable>
	
	<xsl:variable name="DSA_PARAMS">Rules=<xsl:value-of select="$PARAM_DSA_Rules"/>&amp;DisplayVDConfig=<xsl:value-of select="$PARAM_DSA_DisplayVDConfig"/>&amp;OutputFileName=<xsl:value-of select="$PARAM_DSA_OutputFileName"/>&amp;ClearForeignConfigEnable=<xsl:value-of select="$PARAM_ClearForeignConfigEnable"/>&amp;ForeignAdiskFound=<xsl:value-of select="$PARAM_IsAnyAdiskForeign"/>&amp;DSARaidModeAndDiskCheck=<xsl:value-of select="$PARAM_DSARaidModeAndDiskCheck"/></xsl:variable>
		<xsl:variable name="REGULAR_PARAMS">ControllerOID=<xsl:value-of select="$PARAM_REGULAR_ControllerOID"/>&amp;ControllerName=<xsl:value-of select="$PARAM_REGULAR_ControllerName"/>&amp;FILE=<xsl:value-of select="$PARAM_REGULAR_FILE"/>&amp;Minosdrivesize=<xsl:value-of select="$PARAM_REGULAR_Minosdrivesize"/>&amp;Maxosdrivesize=<xsl:value-of select="$PARAM_REGULAR_Maxosdrivesize"/></xsl:variable>
		<xsl:variable name="CACHED_PARAMS">Layout=<xsl:value-of select="$PARAM_PREV_Layout"/>&amp;IDList=<xsl:value-of select="$PARAM_PREV_IDList"/>&amp;SpanLength=<xsl:value-of select="$PARAM_PREV_SpanLength"/>&amp;DiskProtocol=<xsl:value-of select="$PARAM_PREV_DiskProtocol"/>&amp;IMIDList=<xsl:value-of select="$PARAM_PREV_IMIDList"/></xsl:variable>
		<xsl:variable name="STATE_PARAMS">UserSelectedAdiskArrayNumList=<xsl:value-of select="$PARAM_STATE_UserSelectedAdiskArrayNumList"/>&amp;UserSelectedAdiskContiguousFreeSpaceList=<xsl:value-of select="$PARAM_STATE_UserSelectedAdiskContiguousFreeSpaceList"/></xsl:variable>

	<xsl:variable name="GLOBAL_VAR_RaidLevelsMask"><xsl:value-of select="//Controllers//DCStorageObject/RAIDLevelsMask"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_ReadPolicyMask"><xsl:value-of select="//Controllers//DCStorageObject/ReadPolicyMask"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_WritePolicyMask"><xsl:value-of select="//Controllers//DCStorageObject/WritePolicyMask"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_CachePolicyMask"><xsl:value-of select="//Controllers//DCStorageObject/CachePolicyMask"/></xsl:variable>
        <xsl:variable name="GLOBAL_VAR_DiskCachePolicyMask"><xsl:value-of select="//Controllers//DCStorageObject/DiskCachePolicyMask"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Oslimit"><xsl:value-of select="//Controllers//DCStorageObject/MaxOsLimitForLogicalDriveSize"/></xsl:variable>

	<xsl:variable name="GLOBAL_PARAM_Screen_Name">cvdsize_<xsl:value-of select="$PARAM_REGULAR_ControllerOID"/>_<xsl:value-of select="$PARAM_PREV_Layout"/>_<xsl:value-of select="$PARAM_PREV_IDList"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Exit_Wizard_URL">
		<xsl:choose>
			<xsl:when test="$PARAM_DSA_Rules='1'">/servlet/DSASwitch?exitRAID=1&amp;IsFromAdvanced=1</xsl:when>
			<xsl:otherwise><xsl:value-of select="translate($PARAM_REGULAR_OrigURL,'!','&amp;')"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<!-- fix for DFCT 120553-->
	<xsl:variable name="GLOBAL_VAR_IsVdiskNameFieldAllowedForSelectedLayout">
		<xsl:call-template name="bitAnd">
			<xsl:with-param name="num1">
				<xsl:choose>
					<xsl:when test="not(//Controllers//DCStorageObject/VdiskNameAllowedForRaidLevelMask)">
						<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr" select="$GLOBAL_VAR_RaidLevelsMask"/></xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr" select="//Controllers//DCStorageObject/VdiskNameAllowedForRaidLevelMask"/></xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
			<xsl:with-param name="num2" select="$PARAM_PREV_Layout"/>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_IsStripeSizeFieldAllowedForSelectedLayout">
		<!-- fix for DFCT 117335-->
		<xsl:call-template name="bitAnd">
			<xsl:with-param name="num1">
				<xsl:choose>
					<xsl:when test="not(//Controllers//DCStorageObject/StripeSizeForRaidLevelMask)">
						<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr" select="$GLOBAL_VAR_RaidLevelsMask"/></xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr" select="//Controllers//DCStorageObject/StripeSizeForRaidLevelMask"/></xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
			<xsl:with-param name="num2" select="$PARAM_PREV_Layout"/>
		</xsl:call-template>	
	</xsl:variable>
	
	<xsl:variable name="GLOBAL_VAR_StripeSizesMask"><xsl:value-of select="//Controllers//DCStorageObject/StripeSizesMask"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxVirtualDiskNameLength"><xsl:value-of select="//Controllers//DCStorageObject/MaxNameLength"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_DefaultReadPolicy"><xsl:value-of select="//Controllers//DCStorageObject/DefaultReadPolicy"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_DefaultWritePolicy"><xsl:value-of select="//Controllers//DCStorageObject/DefaultWritePolicy"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_DefaultCachePolicy"><xsl:value-of select="//Controllers//DCStorageObject/DefaultCachePolicy"/></xsl:variable>
      <xsl:variable name="GLOBAL_VAR_DefaultDiskCachePolicy"><xsl:value-of select="//Controllers//DCStorageObject/DefaultDiskCachePolicy"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_DefaultStripeSize"><xsl:value-of select="//Controllers//DCStorageObject/DefaultStripeSize"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_GetCapsMinLength"><xsl:value-of select="/OMA/ExpressResults/PassThruResponse/DCStorageObject/MinimumLength"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_GetCapsMaxLength"><xsl:value-of select="/OMA/ExpressResults/PassThruResponse/DCStorageObject/Length"/></xsl:variable>
	
	
	
	<xsl:template match="/">
		<!-- This page is rendered under three scenarios-->
		<!-- Page Load Scenario One: Page is loaded for first time.-->
		<!-- Page Load Scenario Two: Page is loaded because user clicked "back button" on wizard.-->
		<!-- Page Load Scenario Three: Page is loaded when user does some selection on current page, goes back to a previous pages on wizard and then returns to current page-->
		<!-- Page error scenarios-->
		<!-- Error scenario One: 
			Detection: When getcaps command returns value for SMStatus as "-1".
			Cause: User selected raid layout is no longer valid for selected adisks(e.g Raid-10 and Raid-50 for LSI require free disks).
					/User selected array disks do not have any free space.
					/User selected array disks belong to different disk group after page is loaded.
			User Scenario when this occurs: Can happen during all the three "Page Load Scenarios". Another user either thru CLI or browser could have used up all or some
			array disk space by the time current page is loaded -->
		<!-- Error scenario Two: 
			Detection: (ConditionOne) When user selected size is greater than max length returned by getcaps.
						Above applies for case When "$PARAM_DSA_Rules" not equal to "1", in other words no need to detect error scenarios for DSA
			Cause: Configuration change
			User scenario when this occurs: Can happen when free space on some user selected array disks have been used up either thru CLI or from another browser
												Happens during page load scenario two and three -->
		<!-- When user comes to this page using "back button" on wizard, the variable below determines whether adisks selected by user is still valid-->
		<xsl:choose>
			<xsl:when test="$PARAM_DSA_Rules != '1' and $GLOBAL_VAR_GetCapsSMStatus = '-1'  ">
				<DataArea exportdata="false" email="false" printable="false">
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strTitleCfgChngDetectCVDASS"/></xsl:attribute>
					</PageTitle>
					<PromptText><xsl:value-of select="$strTitleFreeDisksUnavailableCVDASS"/></PromptText>
					<PromptText><xsl:value-of select="$strMaxVDSizeExceededCVDASS"/></PromptText>
					<PromptText><xsl:value-of select="$strRaidSelectionInvalidCVDASS"/></PromptText>
					<PromptText><xsl:value-of select="$strAdiskSelectionInvalidCVDAAS"/></PromptText>
					<BottomCustomButton>
						<Data formSubmit="true">
							<xsl:attribute name="display"><xsl:value-of select="$strCancelCVDASS"/></xsl:attribute>
							<xsl:attribute name="href"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:attribute>
						</Data>
					</BottomCustomButton>
				</DataArea>
			</xsl:when>
			<!-- 10/06/05: RS - Fix to handle error when RAID 10 VD size exceeds the max. limit -->
			<xsl:when test="$PARAM_DSA_Rules = '1' and $GLOBAL_VAR_GetCapsSMStatus = '-1'">
				<xsl:call-template name="HandleDSARAID10MaxVDSize"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="RenderMainFrame"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="HandleDSARAID10MaxVDSize">
		<DataArea  exportdata="false" printable="false" email="false">
			<PageTitle status="4"> <xsl:attribute name="display"><xsl:value-of select="$strTitleInvalidConfigCVDASS"/></xsl:attribute> </PageTitle>

			<ListData>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strDSAMaxVDSizeExceededCVDASS"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strDSAMinVDSizeExceededCVDASS"/></xsl:attribute>
				</Data>
				<Data value=""/>
				<Data value="{$strArrayDiskSelectionorExitCVDASS}" colspan="6" align="left"/>
			</ListData>
			
			<script language="javascript">
        function backPage()
        { //not taken care of DSA case
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedAdiskSelectionWebPlugin&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;<xsl:value-of select="$CACHED_PARAMS"/>&amp;<xsl:value-of select="$STATE_PARAMS"/>&amp;UseCachedXMLData=false"+"&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>"+"&amp;SelectAllVal=<xsl:value-of select="/OMA/SelectAll"/>");
				}
			</script>
			<BottomCustomButton>
				<Data display="{$strBackButtonDisplayCVDASS}" formSubmit="true" href="javascript:backPage()"/>
			</BottomCustomButton>
			<BottomCustomButton>
				<Data formSubmit="true">
					<xsl:attribute name="display"><xsl:value-of select="$strCancelCVDASS"/></xsl:attribute>
					<xsl:attribute name="href"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:attribute>
				</Data>
			</BottomCustomButton>		
		</DataArea>
	</xsl:template>	

	<xsl:template name="RenderMainFrame">
		<DataArea onLoad="true" validate="true" exportdata="false" printable="false" email="false">
			<!-- CR54430: Values entered in the Raid configuration pages need to be cached -->
			<!-- Ashesh: These attributes are for DSA mode only -->
			<xsl:if test="$PARAM_DSA_Rules ='1'">
				<xsl:attribute name="storeonback">true</xsl:attribute>
				<!-- Ashesh: DF89053: Dump RAID cache when user changes a controller -->
				<!-- Added Controller OID to preserve caching in multiple controller scenario -->
				<xsl:attribute name="screenname"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:attribute>
				<xsl:attribute name="custombackpagedisplay"><xsl:value-of select="$strBackButtonDisplayCVDASS"/></xsl:attribute>
				<xsl:attribute name="backpagetarget">javascript:backPage()</xsl:attribute>
			</xsl:if>
			<HiddenTable>
				<Data>
					<xsl:attribute name="name">IDList</xsl:attribute>
					<xsl:attribute name="returnvalue"></xsl:attribute>
				</Data>
			</HiddenTable>
                        <HiddenTable>
				<Data>
					<xsl:attribute name="name">IMIDList</xsl:attribute>
					<xsl:attribute name="returnvalue"></xsl:attribute>
				</Data>
			</HiddenTable>
			<script language="javascript">
				<xsl:call-template name="getCommonScripts"/>
				<xsl:if test="$PARAM_DSA_Rules='1'">
					<!-- Include the DSA caching scripts if OMSS Lite mode. Specify relevant parameters to the template. -->
					<xsl:call-template name="getDSAScripts">
						<xsl:with-param name="PARAM_Screen_Name"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:with-param>
						<xsl:with-param name="PARAM_Exit_Wizard_URL"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				<xsl:call-template name="getScriptsForAdvanced"/>
			</script>
			<xsl:call-template name="scripts"/><!--includes scripts from utils.xsl...This is to invoke isNameValid(text) function to test VD name input -->
			<script language="javascript">
				function initializationRoutine()
				{ 
					var layoutValue = '<xsl:value-of select="$PARAM_PREV_Layout"/>';
					<!--commonInitializationRoutine();-->
					var defStripeSize = '<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr"><xsl:value-of select="$GLOBAL_VAR_DefaultStripeSize"/></xsl:with-param></xsl:call-template>';
					var defReadPolicy='<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr"><xsl:value-of select="$GLOBAL_VAR_DefaultReadPolicy"/></xsl:with-param></xsl:call-template>';
					var defWritePolicy='<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr"><xsl:value-of select="$GLOBAL_VAR_DefaultWritePolicy"/></xsl:with-param></xsl:call-template>';
					var defCachePolicy='<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr"><xsl:value-of select="$GLOBAL_VAR_DefaultCachePolicy"/></xsl:with-param></xsl:call-template>';
                              <!-- var defDiskCachePolicy='<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr"><xsl:value-of select="$GLOBAL_VAR_DefaultDiskCachePolicy"/></xsl:with-param></xsl:call-template>'; -->
                              //hard coding after discussing with  Bharath and Kartik default diskcachepoliy  
                              var defDiskCachePolicy=1;  //Disk cache polilcy for SATA by default Enabled
                              <xsl:if test="/OMA/ExpressResults/PassThruResponse/DCStorageObject/BusProtocolMask ='256'">
                                     defDiskCachePolicy=2; //disk Cache Policy for SAS by default Disabled 
                              </xsl:if> 
					var minSizeInBytes  = "<xsl:value-of select="$GLOBAL_VAR_GetCapsMinLength"/>";
					var maxSizeInBytes = "<xsl:value-of select="$GLOBAL_VAR_GetCapsMaxLength"/>";
					<!--var minSizeInBytes = document.getElementById("getMinSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;
					var maxSizeInBytes = document.getElementById("getMaxSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;-->
					setStripeSize(defStripeSize);
					setReadPolicy(defReadPolicy);
					setWritePolicy(defWritePolicy);
					setCachePolicy(defCachePolicy);
					setDiskCachePolicy(defDiskCachePolicy);
					<!-- DSA uses different function to append VID -->
					var Rules = "<xsl:value-of select="$PARAM_DSA_Rules"/>";
					if (Rules == "1")
					{
						top.gnv.appendVID = top.getFrame("OMA_gnv").appendDataAreaVID;
					}
					
					if(minSizeInBytes == maxSizeInBytes)
					{
						<!--var maxSizeInGB = FormatNumber(maxSizeInBytes/(1024*1024*1024),2,"true");-->
						var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";
						setValueForMinField(maxSizeInGB );
						setValueForMaxField(maxSizeInGB );
						setInputVDSizeValue(maxSizeInGB );
						disableInputVDSizeField();
					}
					else
					{
						<!--var minSizeInGB = FormatNumber(minSizeInBytes/(1024*1024*1024),2,"true");
						var maxSizeInGB = FormatNumber(maxSizeInBytes/(1024*1024*1024),2,"true");-->
						var minSizeInGB ="<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMinLength div (1024*1024*1024)),'###0.00')"/>";
						var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";
						setValueForMinField(minSizeInGB );
						setValueForMaxField(maxSizeInGB );
						setInputVDSizeValue(maxSizeInGB );
						enableInputVDSizeField();
					}
				
					UpdateWithUserSelectedInputs();
				}
				function UpdateWithUserSelectedInputs()
				{
					var layoutValue = '<xsl:value-of select="$PARAM_PREV_Layout"/>';
					var defStripeSize ="";
					var defReadPolicy="";
					var defWritePolicy="";
					var defCachePolicy="";
                                        var defDiskCachePolicy="";
					var defVDName="";
					var length = "";	
					
					defStripeSize = '<xsl:value-of select="$PARAM_CURR_StripeSize"/>';
					defReadPolicy='<xsl:value-of select="$PARAM_CURR_ReadPolicy"/>';
					defWritePolicy='<xsl:value-of select="$PARAM_CURR_WritePolicy"/>';
					defCachePolicy='<xsl:value-of select="$PARAM_CURR_CachePolicy"/>';
                                        defDiskCachePolicy='<xsl:value-of select="$PARAM_CURR_DiskCachePolicy"/>';
					defVDName = '<xsl:value-of select="$PARAM_CURR_VDName"/>';
					length = '<xsl:value-of select="$PARAM_CURR_Length"/>';
					
					<!--Next set the name of the virtual disk-->
					<!--DSA Does not support name field -->
					var Rules = "<xsl:value-of select="$PARAM_DSA_Rules"/>";

					if(defVDName != "" &amp;&amp; defVDName != "null" &amp;&amp; Rules != "1")
					{
						setInputVDNameField(defVDName);
					}
					if(length !="" &amp;&amp; length != "null")
					{
						var minSizeInBytes = document.getElementById("getMinSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;
						var maxSizeInBytes = document.getElementById("getMaxSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;
						<!-- check to see if user input length is valid-->
						if( parseInt(minSizeInBytes)&gt; parseInt(length) || parseInt(length) &gt; parseInt(maxSizeInBytes) )
						{
							var strCfgDetect = "<xsl:value-of select="$strCfgChngDetectCVDASS"/>";
							var strSizeInvalid = "<xsl:value-of select="$strSizeSelectionInvalidCVDASS"/>";
							var strReselectSize = "<xsl:value-of select="$strReselectSizeCVDASS"/>";
							var alertStrMsg = strCfgDetect+"\n"+strSizeInvalid +"\n"+strReselectSize;
							alert(alertStrMsg); 
							return;
						}
						<!-- Also ensure that user selected arraydisks still belong to same disk group and have no zero Contiguous free space-->
						<!-- Also make sure the user selected array disks  have non-zero contiguous free space.
						(All adaptec disks are considered free disks, hence the check). First check to see if cached "UserSelectedAdiskContiguousFreeSpaceList" and
						"Contiguous Free Space" for user selected disks after page load match; If there is a mismatch handle it.-->
						var UserSelectedAdiskContiguousFreeSpaceList = '<xsl:value-of select="$PARAM_STATE_UserSelectedAdiskContiguousFreeSpaceList"/>';
						var IDList = '<xsl:value-of select="$PARAM_PREV_IDList"/>';
						if(getUserSelectedAdiskContiguousFreeSpaceList(IDList) != UserSelectedAdiskContiguousFreeSpaceList)
						{
							var SizeArrayAfterPageLoad = getUserSelectedAdiskContiguousFreeSpaceList(IDList).split(":");
							for(var i=0; i&lt;SizeArrayAfterPageLoad .length; i++)
							{
								if(SizeArrayAfterPageLoad[i].toString() == "0")
								{
									var strCfgDetect = "<xsl:value-of select="$strCfgChngDetectCVDASS"/>";
									var strSizeInvalid = "<xsl:value-of select="$strSizeSelectionInvalidCVDASS"/>";
									var strReselectSize = "<xsl:value-of select="$strReselectSizeCVDASS"/>";
									var alertStrMsg = strCfgDetect+"\n"+strSizeInvalid +"\n"+strReselectSize ;
									alert(alertStrMsg); 
									return;
								}
							}
						}

						<!-- if no state change occurs, update fields with user input-->
						if(parseInt(minSizeInBytes) == parseInt(maxSizeInBytes))
						{
							<!--var maxSizeInGB = FormatNumber(maxSizeInBytes/(1024*1024*1024),2,"true");-->
							var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";
							setInputVDSizeValue(maxSizeInGB );
						}
						else if(parseInt(minSizeInBytes) == parseInt(length))
						{
							<!--var lenInGB = FormatNumber(parseInt(length)/(1024*1024*1024),2,"true");-->
							var lenInGB = "<xsl:value-of select="format-number(($PARAM_CURR_Length div (1024*1024*1024)),'###0.00')"/>";
							setInputVDSizeValue(lenInGB );
						}
						else if(parseInt(maxSizeInBytes) == parseInt(length))
						{
							<!--var lenInGB = FormatNumber(parseInt(length)/(1024*1024*1024),2,"true");-->
							var lenInGB = "<xsl:value-of select="format-number(($PARAM_CURR_Length div (1024*1024*1024)),'###0.00')"/>";
							setInputVDSizeValue(lenInGB );
						}
						else if(parseInt(minSizeInBytes)&lt;= parseInt(length)&amp;&amp; parseInt(length)&lt;= parseInt(maxSizeInBytes))
						{
							<!--var lenInGB = FormatNumber(parseInt(length)/(1024*1024*1024),2,"true");-->
							var lenInGB = "<xsl:value-of select="format-number(($PARAM_CURR_Length div (1024*1024*1024)),'###0.00')"/>";
							setInputVDSizeValue(lenInGB );
						}
						else
						{
							setInputVDSizeValue("");
						}
					}
					if(defStripeSize != "" &amp;&amp; defStripeSize != "null" )
					{
						setStripeSize(defStripeSize);
					}
					if(defReadPolicy != "" &amp;&amp; defReadPolicy != "null")
					{
						setReadPolicy(defReadPolicy);
					}
					if(defWritePolicy != "" &amp;&amp; defWritePolicy != "null")
					{
						setWritePolicy(defWritePolicy);
					}
					if(   defCachePolicy != "" &amp;&amp; defCachePolicy != "null" )
					{						
						setCachePolicy(defCachePolicy);
					}
                              if(   defDiskCachePolicy != "" &amp;&amp; defDiskCachePolicy != "null" )
					{						
						setDiskCachePolicy(defDiskCachePolicy);
					}
				}
				function submitCreateVDAdvancedSizeSelected()
				{
					<!--call validate before loading the next page-->
					if(validate() == false)
						return;
					var layoutValue = '<xsl:value-of select="$PARAM_PREV_Layout"/>';
					
					<!-- convert input size value to bytes-->
					var sizeValue="";
					var inputSizeValue=getInputVDSizeValue();
					<!--var minSizeInBytes  = '<xsl:value-of select="//ExpressResults//DCStorageObject/MinimumLength"/>';
					var maxSizeInBytes = '<xsl:value-of select="//ExpressResults//DCStorageObject/Length"/>';-->
					var minSizeInBytes = document.getElementById("getMinSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;
					var maxSizeInBytes = document.getElementById("getMaxSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;
					<!--var minSizeInGB = FormatNumber(minSizeInBytes/(1024*1024*1024),2,"true");
					var maxSizeInGB = FormatNumber(maxSizeInBytes/(1024*1024*1024),2,"true");-->
					var minSizeInGB ="<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMinLength div (1024*1024*1024)),'###0.00')"/>";
					var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";
					var intMirror = '<xsl:value-of select="$PARAM_CURR_IM"/>';
					var selectAll = '<xsl:value-of select="$PARAM_CURR_SELECTALL"/>';
					var EnclosureSelectedList= '<xsl:value-of select="$PARAM_CURR_ENCLOSURESELECTEDLIST"/>';
                              var EnclosureDisabledList= '<xsl:value-of select="$PARAM_CURR_ENCLOSUREDISABLEDLIST"/>';
                        	var maxSizeInGBDecFormat = ConvertToDecValString(maxSizeInGB);
					var minSizeInGBDecFormat = ConvertToDecValString(minSizeInGB);
					var inputSizeValueDecFormat = ConvertToDecValString(inputSizeValue);
					
					if(minSizeInBytes == maxSizeInBytes)
					{
						sizeValue = maxSizeInBytes;
					}
					else if(parseFloat(maxSizeInGBDecFormat ) == parseFloat(inputSizeValueDecFormat))
					{
						sizeValue = maxSizeInBytes;
					}
					else if(parseFloat(minSizeInGBDecFormat ) ==parseFloat( inputSizeValueDecFormat))
					{
						sizeValue = minSizeInBytes;
					}
					else 
					{
						sizeValue = parseInt(inputSizeValueDecFormat *1024*1024*1024);
					}
					
					var Rules = "<xsl:value-of select="$PARAM_DSA_Rules"/>";
					
					<!--10/11/04. For DSA, if user selected size is equal to max size for the layout selected, set the flag to let web-plugin know to write VD size=max in raidcli script-->
					var isMaxSizeUsed="0";
					if(Rules == "1" &amp;&amp; maxSizeInBytes ==sizeValue)
					{
						isMaxSizeUsed="1";
					}
					
					<!--Next get the name of the virtual disk-->
					<!--DSA Does not support name field -->
				
					var name="";
					if(Rules != "1")
					{
						name=getInputVDNameValue();
					}
					<!--Next get the readpolicy, writepolicy, cache policy and stripe size-->
					<!--There is no readpolicy for C-SATA 2s, hence handle the case-->
					var readpolicy="";
					try
					{
						readpolicy=getInputReadPolicyValue();
					}catch(e)
					{
						readpolicy="";
					}
					<!--There is no writepolicy for C-SATA 2s, hence handle the case-->
					var writepolicy="";
					try
					{
						writepolicy=getInputWritePolicyValue();
					}catch(e)
					{
						writepolicy="";
					}
					<!-- There is no stripesize for PERC4 IM, hence handle the case-->
					var stripesize="";
					try
					{
						stripesize = getInputStripeSizeValue();
					}catch(e)
					{
						stripesize="";
					}
					<!-- There is no cache policy for Adaptec, hence handle the case-->
					var cachepolicy="";
					try
					{
						cachepolicy=getInputCachePolicyValue();
					}catch(e)
					{
						cachepolicy="";
					}
                                        var diskcachepolicy="";
					try
					{
						diskcachepolicy=getInputDiskCachePolicyValue();
					}catch(e)
					{
						diskcachepolicy="";
					}
					
					<!-- CR54430: Values entered in the Raid configuration pages need to be cached -->
					<!-- Flush and reload the DSA javascript page cache on submit. -->
        if (Rules == "1")
        {
        cachePageInDSA();
        }

                                        document.getElementById("IMIDList").value = '<xsl:value-of select="/OMA/IMIDList"/>';
     		                        document.getElementById("IDList").value = '<xsl:value-of select="$PARAM_PREV_IDList"/>';
                                        document.dataarea.action = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedSummaryWebPlugin&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;Layout=<xsl:value-of select="$PARAM_PREV_Layout"/>&amp;SpanLength=<xsl:value-of select="$PARAM_PREV_SpanLength"/>&amp;DiskProtocol=<xsl:value-of select="$PARAM_PREV_DiskProtocol"/>&amp;<xsl:value-of select="$STATE_PARAMS"/>"+"&amp;Length="+sizeValue+"&amp;VDName="+name+"&amp;ReadPolicy="+readpolicy+"&amp;WritePolicy="+writepolicy+"&amp;CachePolicy="+cachepolicy+"&amp;DiskCachePolicy="+diskcachepolicy+"&amp;StripeSize="+stripesize+"&amp;IntMirror="+intMirror+"&amp;SelectAllVal="+selectAll+"&amp;EnclosureSelectedList="+EnclosureSelectedList+"&amp;EnclosureDisabledList="+EnclosureDisabledList+"&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>&amp;UseMaxSize="+isMaxSizeUsed);
                                        document.dataarea.submit();
                          

          <!-- document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedSummaryWebPlugin&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;<xsl:value-of select="$CACHED_PARAMS"/>&amp;<xsl:value-of select="$STATE_PARAMS"/>"+"&amp;Length="+sizeValue+"&amp;VDName="+name+"&amp;ReadPolicy="+readpolicy+"&amp;WritePolicy="+writepolicy+"&amp;CachePolicy="+cachepolicy+"&amp;DiskCachePolicy="+diskcachepolicy+"&amp;StripeSize="+stripesize+"&amp;IntMirror="+intMirror+"&amp;SelectAll="+selectAll+"&amp;EnclosureSelectedList="+EnclosureSelectedList+"&amp;EnclosureDisabledList="+EnclosureDisabledList+"&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>&amp;UseMaxSize="+isMaxSizeUsed);
           -->				}
				function validate()
				{
					if(IsInputSizeForVDSpecified()==false)
					{
						HandleInputSizeNotSpecifiedError();
						RestoreInputSizeFieldToMaxValueInAdvWizard();
						return false;
					}
					if(IsInputSizeForVDNaN()==true)
					{
						HandleInputSizeNotANumberError();
						RestoreInputSizeFieldToMaxValueInAdvWizard();
						return false;
					}
					if(IsInputSizeForVDWithinRangeForAdvanced()==false)
					{
						HandleInputSizeRangeErrorForAdvanced();
						return false;
					}
					if( isValidName(getInputVDNameValue())==false)
					{
						RestoreInputNameFieldToBlank();
						return false;
					}
					if ( HandleInputSizeGreaterThanOsLimitAdvanced() == false )
					{
						return false;
					}
					return true;
				}
				function HandleInputSizeGreaterThanOsLimitAdvanced()
				{
					var sizeValue = getInputVDSizeValue();
					var osLimitValueinGB = "<xsl:value-of select="format-number($GLOBAL_PARAM_Oslimit div (1024*1024*1024), '###0.00')"/>";
					var sizeValueDecFormat = parseFloat(ConvertToDecValString(sizeValue));
					var osLimitValueDecFormat = parseFloat(ConvertToDecValString(osLimitValueinGB));

					if ( sizeValueDecFormat &gt; osLimitValueDecFormat)
					{
						<!-- This means that the virtual disk size is greater than the os limit-->
						if (confirm ("<xsl:value-of select="$strOsLimitWarn"/>"))
						{
							return true;
						}
						else
						{
							return false;
						}
					}
					else
					{
						return true; 
					}
				}
				function IsInputSizeForVDWithinRangeForAdvanced()
				{
					var layoutValue = '<xsl:value-of select="$PARAM_PREV_Layout"/>';
					
					var sizeValue=getInputVDSizeValue();
					<!--var minSizeInBytes  = '<xsl:value-of select="//ExpressResults//DCStorageObject/MinimumLength"/>';
					var maxSizeInBytes = '<xsl:value-of select="//ExpressResults//DCStorageObject/Length"/>';-->
					var minSizeInBytes = document.getElementById("getMinSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;
					var maxSizeInBytes = document.getElementById("getMaxSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;
					<!--var maxSizeInGB = FormatNumber(maxSizeInBytes/(1024*1024*1024),2,"true");
					var minSizeInGB = FormatNumber(minSizeInBytes/(1024*1024*1024),2,"true");-->
					var minSizeInGB ="<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMinLength div (1024*1024*1024)),'###0.00')"/>";
					var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";
					
					var sizeValueDecFormat = parseFloat(ConvertToDecValString(sizeValue));
					var minSizeInGBDecFormat = parseFloat(ConvertToDecValString(minSizeInGB));
					var maxSizeInGBDecFormat = parseFloat(ConvertToDecValString(maxSizeInGB));
					
					if(minSizeInBytes == maxSizeInBytes &amp;&amp; maxSizeInGBDecFormat  == sizeValueDecFormat )
					{
						return true;
					}
					else if( minSizeInGBDecFormat &lt;= sizeValueDecFormat  &amp;&amp; sizeValueDecFormat  &lt;= maxSizeInGBDecFormat )
					{
						return true;
					}
					else
					{
						return false;
					}
				}
				function HandleInputSizeRangeErrorForAdvanced()
				{
					var alertInvalidSizeMsg = "<xsl:value-of select="$strInvalidSizeCVDASS"/>";
					var strError = "<xsl:value-of select="$strError"/>";
					alert(strError + alertInvalidSizeMsg);
					<!-- Next reset value of size field to max size value-->
					var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";
					document.getElementById(getElementNameForVDSize()).value=maxSizeInGB ;
				}
				function RestoreInputSizeFieldToMaxValueInAdvWizard()
				{
					var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";
					document.getElementById(getElementNameForVDSize()).value=maxSizeInGB ;
				}
				function backPage()
				{
					<!--Fix for DFCT 117891 -->
					<!-- User scenario: User selects invalid size on adisk selection page, hits back button and comes back to this page. An error message gets popped up indicating that the previous size selection is invalid.-->
					if(validate==false)
						return;
					var layoutValue = '<xsl:value-of select="$PARAM_PREV_Layout"/>';
					
					<!-- convert input size value to bytes-->
					var sizeValue="";
					var inputSizeValue=getInputVDSizeValue();
					<!--var minSizeInBytes  = '<xsl:value-of select="//ExpressResults//DCStorageObject/MinimumLength"/>';
					var maxSizeInBytes = '<xsl:value-of select="//ExpressResults//DCStorageObject/Length"/>';-->
					var minSizeInBytes = document.getElementById("getMinSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;
					var maxSizeInBytes = document.getElementById("getMaxSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;
					<!--var minSizeInGB = FormatNumber(minSizeInBytes/(1024*1024*1024),2,"true");
					var maxSizeInGB = FormatNumber(maxSizeInBytes/(1024*1024*1024),2,"true");-->
					var minSizeInGB ="<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMinLength div (1024*1024*1024)),'###0.00')"/>";
					var maxSizeInGB = "<xsl:value-of select="format-number(($GLOBAL_VAR_GetCapsMaxLength div (1024*1024*1024)),'###0.00')"/>";
					var intMirror = '<xsl:value-of select="$PARAM_CURR_IM"/>';
					var selectAll = '<xsl:value-of select="$PARAM_CURR_SELECTALL"/>';
                              var EnclosureSelectedList= '<xsl:value-of select="$PARAM_CURR_ENCLOSURESELECTEDLIST"/>';
                              var EnclosureDisabledList= '<xsl:value-of select="$PARAM_CURR_ENCLOSUREDISABLEDLIST"/>';

					if(minSizeInBytes == maxSizeInBytes)
					{
						sizeValue = maxSizeInBytes;
					}
					else if(minSizeInGB == inputSizeValue)
					{
						sizeValue = minSizeInBytes;
					}
					else if(maxSizeInGB == inputSizeValue)
					{
						sizeValue = maxSizeInBytes;
					}
					else 
					{
						var inputSizeValueDecFormat = ConvertToDecValString(inputSizeValue);
						sizeValue = parseInt(inputSizeValueDecFormat *1024*1024*1024); 
					}
					
					<!-- First get default policies-->
					var defStripeSize = '<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr"><xsl:value-of select="$GLOBAL_VAR_DefaultStripeSize"/></xsl:with-param></xsl:call-template>';
					var defReadPolicy='<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr"><xsl:value-of select="$GLOBAL_VAR_DefaultReadPolicy"/></xsl:with-param></xsl:call-template>';
					var defWritePolicy='<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr"><xsl:value-of select="$GLOBAL_VAR_DefaultWritePolicy"/></xsl:with-param></xsl:call-template>';
					var defCachePolicy='<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr"><xsl:value-of select="$GLOBAL_VAR_DefaultCachePolicy"/></xsl:with-param></xsl:call-template>';
                                        var defDiskCachePolicy='<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr"><xsl:value-of select="$GLOBAL_VAR_DefaultDiskCachePolicy"/></xsl:with-param></xsl:call-template>';
									
					<!--Next get the name of the virtual disk-->
					<!--DSA Does not support name field -->
					var Rules = "<xsl:value-of select="$PARAM_DSA_Rules"/>";
					var name="";
					if(Rules != "1")
					{
						name=getInputVDNameValue();
					}
					<!--Next get the readpolicy, writepolicy, cache policy and stripe size-->
					<!--There is no readpolicy for C-SATA 2s, hence handle the case -->
					var readpolicy="";
					try
					{
						readpolicy=getInputReadPolicyValue();
						if(readpolicy == defReadPolicy)
							readpolicy="";
					}catch(e)
					{
						readpolicy="";
					}
					<!--There is no writepolicy for C-SATA 2s, hence handle the case -->
					var writepolicy="";
					try
					{
						writepolicy=getInputWritePolicyValue();
						if(writepolicy == defWritePolicy)
							writepolicy="";
					}catch(e)
					{
						writepolicy="";
					}
					<!-- There is no stripesize for PERC4 IM, hence handle the case-->
					var stripesize="";
					try
					{
						stripesize = getInputStripeSizeValue();
						if(stripesize == defStripeSize)
							stripesize="";
					}catch(e)
					{
						stripesize="";
					}
					<!-- There is no cache policy for Adaptec, hence handle the case-->
					var cachepolicy="";
					try
					{
						cachepolicy=getInputCachePolicyValue();
						if(cachepolicy == defCachePolicy)
							cachepolicy ="";
					}catch(e)
					{
						cachepolicy="";
					}
                                        var diskcachepolicy="";
					try
					{
						diskcachepolicy=getInputDiskCachePolicyValue();
						if(diskcachepolicy == defDiskCachePolicy)
							diskcachepolicy ="";
					}catch(e)
					{
						diskcachepolicy="";
					}
					
					if(Rules == "1")
					{
						<!-- CR54430: Values entered in the Raid configuration pages need to be cached -->
						<!-- Flush and reload the DSA javascript page cache on going back. -->
                                             cachePageInDSA();
                                        }
                                        document.getElementById("IMIDList").value = '<xsl:value-of select="/OMA/IMIDList"/>';
     		                        document.getElementById("IDList").value = '<xsl:value-of select="/OMA/IMIDList"/>';
                                        
                                        document.dataarea.action = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedAdiskSelectionWebPlugin&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;Layout=<xsl:value-of select="$PARAM_PREV_Layout"/>&amp;SpanLength=<xsl:value-of select="$PARAM_PREV_SpanLength"/>&amp;DiskProtocol=<xsl:value-of select="$PARAM_PREV_DiskProtocol"/>&amp;<xsl:value-of select="$STATE_PARAMS"/>&amp;UseCachedXMLData=false"+"&amp;Length="+sizeValue+"&amp;VDName="+name+"&amp;ReadPolicy="+readpolicy+"&amp;WritePolicy="+writepolicy+"&amp;CachePolicy="+cachepolicy+"&amp;DiskCachePolicy="+diskcachepolicy+"&amp;StripeSize="+stripesize+"&amp;IntMirror="+intMirror+"&amp;SelectAllVal="+selectAll+"&amp;EnclosureSelectedList="+EnclosureSelectedList+"&amp;EnclosureDisabledList="+EnclosureDisabledList+"&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>");
                                        document.dataarea.submit();
                           

          <!-- document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedAdiskSelectionWebPlugin&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;<xsl:value-of select="$CACHED_PARAMS"/>&amp;<xsl:value-of select="$STATE_PARAMS"/>&amp;UseCachedXMLData=false"+"&amp;Length="+sizeValue+"&amp;VDName="+name+"&amp;ReadPolicy="+readpolicy+"&amp;WritePolicy="+writepolicy+"&amp;CachePolicy="+cachepolicy+"&amp;DiskCachePolicy="+diskcachepolicy+"&amp;StripeSize="+stripesize+"&amp;IntMirror="+intMirror+"&amp;SelectAll="+selectAll+"&amp;EnclosureSelectedList="+EnclosureSelectedList+"&amp;EnclosureDisabledList="+EnclosureDisabledList+"&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>");
		-->		}
				function getUserSelectedAdiskArrayNumList(IDList)
				{
					var ObjIDArray = IDList.split(":");
					var len = ObjIDArray.length;
					var retval = "";
					for(var i=0; i&lt;len; i++)
					{
						var tempStr = document.getElementById("AN"+ObjIDArray[i].toString()).value;
						if(i==0)
						{
							retval=tempStr;
						}
						else
						{
							retval+=":"+tempStr;
						}
					}
					return retval;
				}
				function getUserSelectedAdiskContiguousFreeSpaceList(IDList)
				{
					var ObjIDArray = IDList.split(":");
					var len = ObjIDArray.length;
					var retval = "";
					for(var i=0; i&lt;len; i++)
					{
						var tempStr = document.getElementById("CFS"+ObjIDArray[i].toString()).value;
						if(i==0)
						{
							retval=tempStr;
						}
						else
						{
							retval+=":"+tempStr;
						}
					}
					return retval;
				}
			</script>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitleMainStartCVDASS"/><xsl:text>&#160;</xsl:text><xsl:value-of select="$PARAM_REGULAR_ControllerName"/><xsl:text>&#160;</xsl:text><xsl:value-of select="$strTitleMainEndCVDASS"/></xsl:attribute>
			</PageTitle>
			
			<xsl:call-template name="RenderBottomCustomButtons"/>
						
			<xsl:call-template name="RenderCreateVDTable">
				<xsl:with-param name="RAIDMask"><xsl:value-of select="$GLOBAL_VAR_RaidLevelsMask"/></xsl:with-param>
				<xsl:with-param name="READMask"><xsl:value-of select="$GLOBAL_VAR_ReadPolicyMask"/></xsl:with-param>
				<xsl:with-param name="WRITEMask"><xsl:value-of select="$GLOBAL_VAR_WritePolicyMask"/></xsl:with-param>
				<xsl:with-param name="CACHEMask"><xsl:value-of select="$GLOBAL_VAR_CachePolicyMask"/></xsl:with-param>
                                <xsl:with-param name="DISKCACHEMask"><xsl:value-of select="$GLOBAL_VAR_DiskCachePolicyMask"/></xsl:with-param>
				<xsl:with-param name="STRIPESMask"><xsl:if test="$GLOBAL_VAR_IsStripeSizeFieldAllowedForSelectedLayout !='0' "><xsl:value-of select="$GLOBAL_VAR_StripeSizesMask"/></xsl:if></xsl:with-param>
				<xsl:with-param name="HIDE_RAID_DESC_ROW">true</xsl:with-param>
				<xsl:with-param name="HIDE_NAME_ROW"><xsl:if test="$PARAM_DSA_Rules='1' or $GLOBAL_VAR_IsVdiskNameFieldAllowedForSelectedLayout ='0'">true</xsl:if></xsl:with-param>
				<xsl:with-param name="VD_NAME_LENGTH"><xsl:value-of select="$GLOBAL_VAR_MaxVirtualDiskNameLength"/></xsl:with-param>
				<xsl:with-param name="SELECT_RAID_HEADER">
					<xsl:value-of select="$strTblHeaderCVDASS"/><xsl:call-template name="GetRaidLayout"><xsl:with-param name="RaidType" select="$PARAM_PREV_Layout"/></xsl:call-template>
				</xsl:with-param>
			</xsl:call-template>
			<HiddenTable>
				<!--This creates a hidden table that maps a "raid layout type" to the "max size possible" for that layout . template in CreateVDUtils.xsl/-->
				<xsl:for-each select="//ExpressResults//DCStorageObject"><xsl:call-template name="getMaxSizeInBytesForGivenLayoutType_HIDDEN_TABLE"/></xsl:for-each>
				<xsl:for-each select="//ExpressResults//DCStorageObject"><xsl:call-template name="getMinSizeInBytesForGivenLayoutType_HIDDEN_TABLE"/></xsl:for-each>
				<xsl:for-each select="/OMA/ArrayDisks/PassThruResponse/DCStorageObject">
					<xsl:call-template name="getAdiskArrayNum_HIDDEN_TABLE"/>
					<xsl:call-template name="getContiguousFreeSpace_HIDDEN_TABLE"/>
				</xsl:for-each>
			</HiddenTable>
		</DataArea>		
	</xsl:template>
	
	<xsl:template name="RenderBottomCustomButtons">
		<xsl:if test="$PARAM_DSA_Rules !='1'">
			<BottomCustomButton>
				<Data display="{$strBackButtonDisplayCVDASS}" formSubmit="true" href="javascript:backPage()"/>
			</BottomCustomButton>
		</xsl:if>
		<BottomCustomButton>
			<Data display="{$strContinueCVDASS}" formSubmit="true" href="javascript:submitCreateVDAdvancedSizeSelected()"/>
		</BottomCustomButton>
		<BottomCustomButton>
			<Data formSubmit="true">
				<xsl:attribute name="display"><xsl:value-of select="$strCancelCVDASS"/></xsl:attribute>
				<xsl:attribute name="href">
					<xsl:choose>
						<xsl:when test="$PARAM_DSA_Rules ='1'">javascript:exitWizardInDSA();</xsl:when>
						<xsl:otherwise><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</BottomCustomButton>
	</xsl:template>
	
	<!-- creates a table that maps ObjID of arraydisk to arraynum.Used for state change detection-->
	<xsl:template name="getAdiskArrayNum_HIDDEN_TABLE">
		<xsl:variable name="ArrayNumExists"><xsl:value-of select="ArrayNum"/></xsl:variable>
		<Data type="hidden">
			<xsl:choose>
				<!--Code to handle DSA display-->
				<xsl:when test="$PARAM_DSA_Rules='1' ">
					<xsl:attribute name="name">AN<xsl:value-of select="ObjID"/></xsl:attribute>
					<xsl:attribute name="returnvalue">-1</xsl:attribute>		
				</xsl:when>
				<xsl:when test="not($ArrayNumExists)">
					<xsl:attribute name="name">AN<xsl:value-of select="ObjID"/></xsl:attribute>
					<xsl:attribute name="returnvalue">-1</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="name">AN<xsl:value-of select="ObjID"/></xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="ArrayNum"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</Data>
	</xsl:template>
	<!-- creates a table that maps ObjID of arraydisk to Contiguous Free Space on disk. Used for state change detection-->
	<xsl:template name="getContiguousFreeSpace_HIDDEN_TABLE">
		<Data type="hidden">
			<xsl:choose>
				<!--Code to handle DSA display-->
				<xsl:when test="$PARAM_DSA_Rules='1' ">
					<xsl:attribute name="name">CFS<xsl:value-of select="ObjID"/></xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="Length"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="name">CFS<xsl:value-of select="ObjID"/></xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="ContiguousFree"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</Data>
	</xsl:template>
</xsl:stylesheet>
