<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!--The code below includes Utils.xsl which contains commonly called templates to get layout, read policy, write policy etc that can be resused/-->
	<xsl:include href="Utils.xsl"/>
	<!-- CreateVDUtils contains templates and scripts to render tables and validate pages-->
	<xsl:include href="cvdutils.xsl"/>
	<xsl:include href="dsautils.xsl"/>
	<!--Below defines a Key that maps virtual disks and its constituent array disks -->
	<xsl:key name="ADsForVD" match="//ArrayDisks" use="@LDN"/>
	<!--Below defines a key that maps a given controller and its associated virtual disks -->
	<xsl:key name="VDs" match="//VirtualDisks" use="@ControllerName"/>
	<!--main entry point into this XSL,  /-->

	<!-- Declare Global variables and parameters-->
	<xsl:variable name="GLOBAL_VAR_GetCapsSMStatus">
		<xsl:choose>
			<xsl:when test="//ExpressResults/SMStatus"><xsl:value-of select="//ExpressResults/SMStatus"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_RaidLevelsMask"><xsl:value-of select="//Controllers/DCStorageObject/RAIDLevelsMask"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_NumVirtualDisks"><xsl:value-of select="count(//VirtualDisks/DCStorageObject)"/></xsl:variable>
	<xsl:variable name="PARAM_DSA_Rules">
		<xsl:choose>
			<xsl:when test="/OMA/Rules"><xsl:value-of select="/OMA/Rules"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PARAM_ClearForeignConfigEnable">
		<xsl:choose>
			<xsl:when test="/OMA/ClearForeignConfigEnable">
				<xsl:value-of select="/OMA/ClearForeignConfigEnable"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_IsAnyAdiskForeign">
		<xsl:choose>
			<xsl:when test="/OMA/ForeignAdiskFound">
				<xsl:value-of select="/OMA/ForeignAdiskFound"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_DSARaidModeAndDiskCheck">
		<xsl:choose>
			<xsl:when test="/OMA/DSARaidModeAndDiskCheck">
				<xsl:value-of select="/OMA/DSARaidModeAndDiskCheck"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PARAM_DSA_OutputFileName"><xsl:value-of select="/OMA/OutputFileName"/></xsl:variable>
	<xsl:variable name="PARAM_DSA_DisplayVDConfig"><xsl:value-of select="/OMA/DisplayVDConfig"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_ControllerName"><xsl:value-of select="/OMA/ControllerName"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_ControllerOID"><xsl:value-of select="/OMA/ControllerOID"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_FILE"><xsl:value-of select="/OMA/FILE"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_OrigURL"><xsl:value-of select="/OMA/OrigURL"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_Layout"><xsl:value-of select="/OMA/Layout"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_Length"><xsl:value-of select="/OMA/Length"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_VDName"><xsl:value-of select="/OMA/VDName"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_IDList"><xsl:value-of select="/OMA/IDList"/></xsl:variable>
        <xsl:variable name="PARAM_NEXT_IMIDList"><xsl:value-of select="/OMA/IMIDList"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_SpanLength"><xsl:value-of select="/OMA/SpanLength"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_DiskProtocol"><xsl:value-of select="/OMA/DiskProtocol"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_ReadPolicy"><xsl:value-of select="/OMA/ReadPolicy"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_WritePolicy"><xsl:value-of select="/OMA/WritePolicy"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_CachePolicy"><xsl:value-of select="/OMA/CachePolicy"/></xsl:variable>
	<xsl:variable name="PARAM_NEXT_StripeSize"><xsl:value-of select="/OMA/StripeSize"/></xsl:variable>
	<xsl:variable name="PARAM_STATE_UserSelectedAdiskArrayNumList"><xsl:value-of select="/OMA/UserSelectedAdiskArrayNumList"/></xsl:variable>
	<xsl:variable name="PARAM_STATE_UserSelectedAdiskContiguousFreeSpaceList"><xsl:value-of select="/OMA/UserSelectedAdiskContiguousFreeSpaceList"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_Minosdrivesize"><xsl:value-of select="/OMA/Minosdrivesize"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_Maxosdrivesize"><xsl:value-of select="/OMA/Maxosdrivesize"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_IM"><xsl:value-of select="/OMA/IntMirror"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_SELECTALL"><xsl:value-of select="/OMA/SelectAll"/></xsl:variable>
        <xsl:variable name="PARAM_CURR_ENCLOSURESELECTEDLIST"><xsl:value-of select="/OMA/EnclosureSelectedList"/></xsl:variable>
        <xsl:variable name="PARAM_CURR_ENCLOSUREDISABLEDLIST"><xsl:value-of select="/OMA/EnclosureDisabledList"/></xsl:variable>

	<xsl:variable name="DSA_PARAMS">Rules=<xsl:value-of select="$PARAM_DSA_Rules"/>&amp;DisplayVDConfig=<xsl:value-of select="$PARAM_DSA_DisplayVDConfig"/>&amp;OutputFileName=<xsl:value-of select="$PARAM_DSA_OutputFileName"/>&amp;ClearForeignConfigEnable=<xsl:value-of select="$PARAM_ClearForeignConfigEnable"/>&amp;ForeignAdiskFound=<xsl:value-of select="$GLOBAL_PARAM_IsAnyAdiskForeign"/>&amp;DSARaidModeAndDiskCheck=<xsl:value-of select="$GLOBAL_PARAM_DSARaidModeAndDiskCheck"/></xsl:variable>

	<xsl:variable name="REGULAR_PARAMS">ControllerOID=<xsl:value-of select="$PARAM_REGULAR_ControllerOID"/>&amp;ControllerName=<xsl:value-of select="$PARAM_REGULAR_ControllerName"/>&amp;FILE=<xsl:value-of select="PARAM_REGULAR_FILE"/>&amp;Minosdrivesize=<xsl:value-of select="$PARAM_REGULAR_Minosdrivesize"/>&amp;Maxosdrivesize=<xsl:value-of select="$PARAM_REGULAR_Maxosdrivesize"/></xsl:variable>

	<xsl:variable name="CACHED_PARAMS">IDList=<xsl:value-of select="$PARAM_NEXT_IDList"/>&amp;SpanLength=<xsl:value-of select="$PARAM_NEXT_SpanLength"/>&amp;DiskProtocol=<xsl:value-of select="$PARAM_NEXT_DiskProtocol"/>&amp;VDName=<xsl:value-of select="$PARAM_NEXT_VDName"/>&amp;Length=<xsl:value-of select="$PARAM_NEXT_Length"/>&amp;ReadPolicy=<xsl:value-of select="$PARAM_NEXT_ReadPolicy"/>&amp;WritePolicy=<xsl:value-of select="$PARAM_NEXT_WritePolicy"/>&amp;CachePolicy=<xsl:value-of select="$PARAM_NEXT_CachePolicy"/>&amp;StripeSize=<xsl:value-of select="$PARAM_NEXT_StripeSize"/>&amp;IMIDList=<xsl:value-of select="$PARAM_NEXT_IMIDList"/></xsl:variable>

	<xsl:variable name="STATE_PARAMS">UserSelectedAdiskArrayNumList=<xsl:value-of select="$PARAM_STATE_UserSelectedAdiskArrayNumList"/>&amp;UserSelectedAdiskContiguousFreeSpaceList=<xsl:value-of select="$PARAM_STATE_UserSelectedAdiskContiguousFreeSpaceList"/></xsl:variable>

	<xsl:variable name="GLOBAL_PARAM_Screen_Name">cvdraid_<xsl:value-of select="$PARAM_REGULAR_ControllerOID"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Prev_Page_URL">
		<xsl:choose>
			<!-- Ashesh: If there are foreign disks take user back to foreign configuration page -->
			<xsl:when test="$GLOBAL_PARAM_IsAnyAdiskForeign='1'">/servlet/DataArea?plugin=com.dell.sm.webplugins.DSAClearForeignConfigWebPlugin&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;IsFromAdvanced=1</xsl:when>
			<xsl:otherwise>/servlet/SubmitForm?plugin=com.dell.cdu.webplugins.PreviousScreenWebPlugin&amp;IsFromAdvanced=1</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Exit_Wizard_URL">
		<xsl:choose>
			<xsl:when test="$PARAM_DSA_Rules='1'">/servlet/DSASwitch?exitRAID=1&amp;IsFromAdvanced=1</xsl:when>
			<xsl:otherwise><xsl:value-of select="translate($PARAM_REGULAR_OrigURL,'!','&amp;')"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Express_Wizard_URL">/servlet/DataArea?plugin=com.dell.sm.webplugins.CreateVDExpressWebPlugin&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/></xsl:variable>

	<xsl:template match="/">
		<!-- This page is rendered under two scenarios-->
		<!-- Page Load Scenario One: Page is loaded for first time.-->
		<!-- Page Load Scenario Two: Page is loaded because user clicked "back button" on wizard.-->
		<!-- Page error scenarios-->
		<!-- Error scenario One:
			Detection: When getcaps command returns value for SMStatus as "-1".
			Cause: Free array disks unavailable to create any raid layout.
			User Scenario when this occurs: This can happen on both "Page Load Scenario One" and "Page Load Scenario Two" if there are no array disks with free space-->
		<!-- Error scenario Two:
			Detection: When user selected raid layout does not appear in results of getcaps command
			Cause: Configuration change
			User scenario when this occurs: This can happen when somebody has simulatenously issued a command for create VD using CLI or from another browser-->
		<!-- When user comes to this page using "back button" on wizard, the variable below determines whether layout selected by user is still valid-->
		<!-- Next render page depending if there is an error or not.-->
		<xsl:choose>
			<xsl:when test="$PARAM_DSA_Rules != '1' and $GLOBAL_VAR_GetCapsSMStatus='-1'">
				<DataArea exportdata="false"  email="false" printable="false">
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strTitleFreeDisksUnavailableCVDARLS"/></xsl:attribute>
					</PageTitle>
					<BottomCustomButton>
						<Data formSubmit="true" display="{$strCancelCVDARLS}" href="{$GLOBAL_PARAM_Exit_Wizard_URL}"/>
					</BottomCustomButton>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="OMA" mode="UI"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="OMA" mode="UI">
		<!-- Ashesh: DF63251: Pressing Enter key clears selected RAID level in configuration wizard. -->
		<!-- Added nosubmitfordsa attribute to disable <Enter> key -->
		<DataArea onLoad="true" validate="true" exportdata="false" printable="false" email="false" nosubmitfordsa="true" ignoreJumpBar="true">
			<xsl:if test="$PARAM_DSA_Rules ='1'">
				<!-- CR54430: Values entered in the Raid configuration pages need to be cached -->
				<!-- In DSA mode, we want to enable the DSA caching mechanism so storeonback and screenname are defined. -->
				<xsl:attribute name="storeonback">true</xsl:attribute>
				<xsl:attribute name="screenname"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:attribute>
				
				<!-- OMSS does not have a back button but OMSS Lite does. We use the DSA caching javascript function. -->
				<xsl:attribute name="custombackpagedisplay"><xsl:value-of select="$strBackButtonDisplayCVDARLS"/></xsl:attribute>
				<xsl:attribute name="backpagetarget">javascript:goToPreviousPageInDSA();</xsl:attribute>
			</xsl:if>
			
			<script language="javascript">
				var LAYOUT_SELECTED_ON_PAGE_LOAD;<!-- This variable holds what raid layout is selected on page load.(when back button on wizard is used) -->
				function initializationRoutine()
				{
					commonInitializationRoutine();
					UpdateWithUserSelectedInputs();
					LAYOUT_SELECTED_ON_PAGE_LOAD = '<xsl:value-of select="$PARAM_CURR_Layout"/>'
					
					<!-- DSA uses different function to append VID -->
					var Rules="<xsl:value-of select="$PARAM_DSA_Rules"/>";
					if (Rules == "1")
					{					
						top.gnv.appendVID = top.getFrame("OMA_gnv").appendDataAreaVID;
					}
				}
				function UpdateWithUserSelectedInputs()
				{<!-- Need to see if anything special needs to be done for DSA here-->
					var UserSelectedLayoutValue = "";
					var Rules="<xsl:value-of select="$PARAM_DSA_Rules"/>";
					if (Rules == "1")
					{
						UserSelectedLayoutValue = document.getElementById("PARAM_CURR_Layout").value;
					}
					else
					{
						UserSelectedLayoutValue = '<xsl:value-of select="$PARAM_CURR_Layout"/>';
					}
					if(UserSelectedLayoutValue !="null" &amp;&amp; UserSelectedLayoutValue !="" )
					{
						<!-- Make sure the user selected raid layout is still valid after page load.(when back button on wizard is used)-->
						if(IsRadioButtonEnabledForGivenRaidLayoutValue(UserSelectedLayoutValue ) == true)
						{
							setInputRaidLayoutValue(UserSelectedLayoutValue );
							<!--Update Raid description text area-->
							UpdateRaidDescriptionTextBox(UserSelectedLayoutValue );
						}
						else
						{
							var alertStrCfgChng = "<xsl:value-of select="$strCfgChngDetectCVDARLS"/>";
							var alertStrInvalidRaid = "<xsl:value-of select="$strRaidSelectionInvalidCVDARLS"/>";
							var alertStrReselectRaid = "<xsl:value-of select="$strReselectRaidTypeCVDARLS"/>"
							var alertStrRaidCfgChange = alertStrCfgChng+"\n"+alertStrInvalidRaid+"\n"+alertStrReselectRaid;
							alert(alertStrRaidCfgChange);
							LAYOUT_SELECTED_ON_PAGE_LOAD = "null";
						}
					}
				}
				function validate()
				{
					if(IsRaidLayoutSelected()==false)
					{
						HandleRaidLayoutNotSelectedError();
						return false;
					}
					return true;
				}
				function OnRaidLayoutSelected()
				{
					var layoutValue = getInputRaidLayoutValue();
					UpdateRaidDescriptionTextBox(layoutValue);
				}
				function submitCreateVDAdvancedRaidLayoutSelected()
				{
					<!--call validate before loading the next page-->
					if(validate() == false)
						return;
					var layoutValue = getInputRaidLayoutValue();
					var intMirror = '<xsl:value-of select="$PARAM_CURR_IM"/>';
					var selectAll = '<xsl:value-of select="$PARAM_CURR_SELECTALL"/>';
                                        var EnclosureSelectedList= '<xsl:value-of select="$PARAM_CURR_ENCLOSURESELECTEDLIST"/>';
                                        var EnclosureDisabledList= '<xsl:value-of select="$PARAM_CURR_ENCLOSUREDISABLEDLIST"/>';
					<!--The following code is checking for three things. i)page loaded for first time ii) page loaded by using back button on wizard and user selection
					remains unchanged iii)page loaded using back button and user has changed selection, in which case CACHED_PARAMS and STATE_PARAMS should not be used for
					loading next page-->
					var Rules="<xsl:value-of select="$PARAM_DSA_Rules"/>";
					if (Rules == "1")
					{
						<!-- Flush and reload the DSA javascript page cache on submit. -->
						cachePageInDSA();
						LAYOUT_SELECTED_ON_PAGE_LOAD = document.getElementById("PARAM_CURR_Layout").value;
					}
					
					if(LAYOUT_SELECTED_ON_PAGE_LOAD == "null" || layoutValue == LAYOUT_SELECTED_ON_PAGE_LOAD )
					{
						var NextPageURL =  "/servlet/DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedAdiskSelectionWebPlugin&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;"
						if (Rules == "1")
						{
							var DSA_cachedValues = document.getElementById("CACHED_PARAMS").value + "&amp;" + document.getElementById("STATE_PARAMS").value;
							NextPageURL += DSA_cachedValues;
						}
						else
						{
							var OMSS_cachedValues = "<xsl:value-of select="$CACHED_PARAMS"/>&amp;<xsl:value-of select="$STATE_PARAMS"/>";
							NextPageURL += OMSS_cachedValues;
						}

						NextPageURL += "&amp;Layout="+layoutValue+"&amp;IntMirror="+intMirror+"&amp;SelectAllVal="+selectAll+"&amp;EnclosureSelectedList="+EnclosureSelectedList+"&amp;EnclosureDisabledList="+EnclosureDisabledList+"&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>";
						document.location.href = top.gnv.appendVID(NextPageURL);
					}
					else
					{
						document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedAdiskSelectionWebPlugin&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>"+"&amp;Layout="+layoutValue);
					}
		        }
			</script>
			<script language="javascript">
				<xsl:call-template name="getCommonScripts"/>
				<xsl:if test="$PARAM_DSA_Rules='1'">
					<!-- Include the DSA caching scripts if OMSS Lite mode. Specify relevant parameters to the template. -->
					<xsl:call-template name="getDSAScripts">
						<xsl:with-param name="PARAM_Screen_Name"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:with-param>
						<xsl:with-param name="PARAM_Prev_Page_URL"><xsl:value-of select="$GLOBAL_PARAM_Prev_Page_URL"/></xsl:with-param>
						<xsl:with-param name="PARAM_Exit_Wizard_URL"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:with-param>
					</xsl:call-template>

					function expressWizardInDSA()
					{
						cachePageInDSA();
						document.dataarea.action = top.getFrame("OMA_gnv").appendDataAreaVID("<xsl:value-of select="$GLOBAL_PARAM_Express_Wizard_URL"/>");
						document.dataarea.submit();
					}
				</xsl:if>
			</script>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitleMainStartCVDARLS"/><xsl:value-of select="$PARAM_REGULAR_ControllerName"/><xsl:value-of select="$strTitleMainEndCVDARLS"/></xsl:attribute>
			</PageTitle>
			
			<xsl:call-template name="RenderBottomCustomButtons"/>
			
			
			<!-- Check to see if the bit that takes you directly to advanced wizard is on -->
			<xsl:variable name="isDirectToAdvancedWizard">
				<xsl:choose>
					<xsl:when test="$PARAM_DSA_Rules !='1' and substring(/OMA/Controllers/DCStorageObject/AttributesMask,13,1)='1'">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>			
			
			<!-- In DSA mode if SAS 5ira has > 2 disks, Express wiz. is disabled. Disable the Express wiz. button displayed on Lefthand top corner of Advance wiz. -->
			<xsl:if test="$GLOBAL_PARAM_DSARaidModeAndDiskCheck = '0'">
				<!-- in OMSS, no express wizard button if bitmask for controller is set to advanced wizard only -->	
				<xsl:if test="$isDirectToAdvancedWizard!='1'">			
					<xsl:call-template name="RenderCustomButtons"/>		
				 </xsl:if>
			</xsl:if>

			<!--Below is displayed only on DSA screens-->
			<xsl:if test="$PARAM_DSA_DisplayVDConfig='true' and $GLOBAL_VAR_NumVirtualDisks != 0">
				<xsl:call-template name="RenderVDConfigTable">
					<xsl:with-param name="CONTROLLER_NAME"><xsl:value-of select="//VirtualDisks/@ControllerName"/></xsl:with-param>
					<xsl:with-param name="KEY_NAME_VDNODES">VDs</xsl:with-param>
					<xsl:with-param name="KEY_MATCH_VDNODES"><xsl:value-of select="//VirtualDisks/@ControllerName"/></xsl:with-param>
					<xsl:with-param name="KEY_NAME_ADNODES">ADsForVD</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:call-template name="RenderCreateVDTable">
				<xsl:with-param name="RAIDMask"><xsl:value-of select="$GLOBAL_VAR_RaidLevelsMask"/></xsl:with-param>
				<xsl:with-param name="HIDE_SIZE_ROW">true</xsl:with-param>
				<xsl:with-param name="HIDE_NAME_ROW">true</xsl:with-param>
				<xsl:with-param name="HIDE_MIN_MAX_ROW">true</xsl:with-param>
				<xsl:with-param name="SELECT_RAID_HEADER"><xsl:value-of select="$strTblHeaderCVDARLS"/></xsl:with-param>
				<xsl:with-param name="RULES"><xsl:value-of select="$PARAM_DSA_Rules"/></xsl:with-param>
			</xsl:call-template>
			<HiddenTable>
				<xsl:for-each select="//ExpressResults/DCStorageObject"><xsl:call-template name="getHelpText_HIDDEN_TABLE"/></xsl:for-each>
				<xsl:for-each select="//ExpressResults/DCStorageObject"><xsl:call-template name="AvailableRaidLayout_HIDDEN_TABLE"/></xsl:for-each>
				<!-- CR54430: Values entered in the Raid configuration pages need to be cached -->
				<!-- Ashesh: Passing cached_params and state_params as hidden values so that these values can be cached.  -->
				<xsl:call-template name="cachedValues"/>
			</HiddenTable>
		</DataArea>
	</xsl:template>
	
	<!-- CR54430: Values entered in the Raid configuration pages need to be cached -->
	<!-- Ashesh: Template for hidden values to cache for this page -->
	<xsl:template name="cachedValues">
		<Data type="hidden">
			<xsl:attribute name="name">CACHED_PARAMS</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="$CACHED_PARAMS"/></xsl:attribute>
		</Data>
		<Data type="hidden">
			<xsl:attribute name="name">STATE_PARAMS</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="$STATE_PARAMS"/></xsl:attribute>
		</Data>
		<Data type="hidden">
			<xsl:attribute name="name">PARAM_CURR_Layout</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="$PARAM_CURR_Layout"/></xsl:attribute>
		</Data>
    </xsl:template>

	<xsl:template name="RenderBottomCustomButtons">
		<BottomCustomButton>
			<Data display="{$strContinueCVDARLS}" formSubmit="true" href="javascript:submitCreateVDAdvancedRaidLayoutSelected()"/>
		</BottomCustomButton>
		<BottomCustomButton>
			<Data formSubmit="true" display="{$strCancelCVDARLS}">
				<xsl:attribute name="href">
					<xsl:choose>
						<!-- We use the DSA caching javascript function to exit the wizard in case of DSA. -->
						<xsl:when test="$PARAM_DSA_Rules ='1'">javascript:exitWizardInDSA();</xsl:when>
						<xsl:otherwise><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</BottomCustomButton>
	</xsl:template>

	<xsl:template name="RenderCustomButtons">
		<CustomButton align="left">
			<Data>
				<xsl:attribute name="href">
					<xsl:choose>
						<!-- We use the DSA caching javascript function to go to the express wizard in case of DSA. -->
						<xsl:when test="$PARAM_DSA_Rules ='1'">javascript:expressWizardInDSA();</xsl:when>
						<xsl:otherwise><xsl:value-of select="$GLOBAL_PARAM_Express_Wizard_URL"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strExpressCVDARLS"/></xsl:attribute>
			</Data>
		</CustomButton>
	</xsl:template>
</xsl:stylesheet>
