<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!--The code below includes Utils.xsl which contains commonly called templates to get layout, read policy, write policy etc which can be resused/-->
	<xsl:include href="Utils.xsl"/>
	<xsl:include href="cvdutils.xsl"/>
	<xsl:include href="dsautils.xsl"/>
	<!-- Declare Global variables and parameters-->
	<xsl:variable name="GLOBAL_PARAM_Rules">
		<xsl:choose>
			<xsl:when test="/OMA/Rules"><xsl:value-of select="/OMA/Rules"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_ClearForeignConfigEnable">
		<xsl:choose>
			<xsl:when test="/OMA/ClearForeignConfigEnable">
				<xsl:value-of select="/OMA/ClearForeignConfigEnable"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_IsAnyAdiskForeign">
		<xsl:choose>
			<xsl:when test="/OMA/ForeignAdiskFound">
				<xsl:value-of select="/OMA/ForeignAdiskFound"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="GLOBAL_PARAM_ControllerName"><xsl:value-of select="/OMA/ControllerName"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_OutputFileName"><xsl:value-of select="/OMA/OutputFileName"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_DisplayVDConfig"><xsl:value-of select="/OMA/DisplayVDConfig"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_OrigURL"><xsl:value-of select="/OMA/OrigURL"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_ControllerOID"><xsl:value-of select="/OMA/ControllerOID"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Layout"><xsl:value-of select="/OMA/Layout"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Length"><xsl:value-of select="/OMA/Length"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_VDName"><xsl:value-of select="/OMA/VDName"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_IDList"><xsl:value-of select="/OMA/IDList"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_UseMaxSize"><xsl:value-of select="/OMA/UseMaxSize"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Minosdrivesize"><xsl:value-of select="/OMA/Minosdrivesize"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Maxosdrivesize"><xsl:value-of select="/OMA/Maxosdrivesize"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_SpanLength">
		<xsl:choose>
			<xsl:when test="$GLOBAL_PARAM_Layout"><xsl:value-of select="/OMA/ExpressResults/DCStorageObject/SpanLength"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
    </xsl:variable>
    <!-- Usability#17) Default selections not apparent to the user in Express Wizard -->
    <xsl:variable name="GLOBAL_VAR_DefaultReadPolicy">
      <xsl:value-of select="/OMA/Controllers/DCStorageObject/DefaultReadPolicy"/>
    </xsl:variable>
    <xsl:variable name="decimalreadpolicy">
      <xsl:call-template name="ConvertBinaryToDecimal">
        <xsl:with-param name="BinaryStr" select="$GLOBAL_VAR_DefaultReadPolicy"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="GLOBAL_VAR_DefaultWritePolicy">
      <xsl:value-of select="/OMA/Controllers/DCStorageObject/DefaultWritePolicy"/>
    </xsl:variable>
    <xsl:variable name="decimalwritepolicy">
      <xsl:call-template name="ConvertBinaryToDecimal">
        <xsl:with-param name="BinaryStr" select="$GLOBAL_VAR_DefaultWritePolicy"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="GLOBAL_VAR_DefaultStripeSize">
      <xsl:value-of select="/OMA/Controllers/DCStorageObject/DefaultStripeSize"/>
    </xsl:variable>
    <xsl:variable name="decimalstripesize">
      <xsl:call-template name="ConvertBinaryToDecimal">
        <xsl:with-param name="BinaryStr" select="$GLOBAL_VAR_DefaultStripeSize"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="GLOBAL_VAR_DefaultCachePolicy">
      <xsl:value-of select="/OMA/Controllers/DCStorageObject/DefaultCachePolicy"/>
    </xsl:variable>
    <xsl:variable name="decimalcachepolicy">
      <xsl:call-template name="ConvertBinaryToDecimal">
        <xsl:with-param name="BinaryStr" select="$GLOBAL_VAR_DefaultCachePolicy"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="GLOBAL_VAR_DefaultDiskCachePolicy">
      <xsl:value-of select="/OMA/Controllers/DCStorageObject/DefaultDiskCachePolicy"/>
    </xsl:variable>
    <xsl:variable name="decimaldiskcachepolicy">
      <xsl:call-template name="ConvertBinaryToDecimal">
        <xsl:with-param name="BinaryStr" select="$GLOBAL_VAR_DefaultDiskCachePolicy"/>
      </xsl:call-template>
    </xsl:variable>
    <!--End of variable declaration for Usability #17-->
    
	<xsl:variable name="GLOBAL_VAR_ControllerAttributesMask"><xsl:value-of select="/OMA/Controllers/DCStorageObject/AttributesMask"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_ReturnUrlHREFValue">
		<xsl:choose>
			<xsl:when test="$GLOBAL_PARAM_Rules='1'">/servlet/DSASwitch</xsl:when>
			<!-- %26 is escape character for &-->
			<xsl:otherwise><xsl:value-of select="$GLOBAL_PARAM_OrigURL"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Screen_Name">cvdesum_<xsl:value-of select="$GLOBAL_PARAM_ControllerOID"/>_<xsl:value-of select="$GLOBAL_PARAM_Layout"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Prev_Page_URL">/servlet/DataArea?plugin=com.dell.sm.webplugins.CreateVDExpressWebPlugin&amp;OrigURL=<xsl:value-of select="$GLOBAL_PARAM_OrigURL"/>&amp;ControllerOID=<xsl:value-of select="$GLOBAL_PARAM_ControllerOID"/>&amp;ControllerName=<xsl:value-of select="$GLOBAL_PARAM_ControllerName"/>&amp;Rules=<xsl:value-of select="$GLOBAL_PARAM_Rules"/>&amp;DisplayVDConfig=<xsl:value-of select="$GLOBAL_PARAM_DisplayVDConfig"/>&amp;OutputFileName=<xsl:value-of select="$GLOBAL_PARAM_OutputFileName"/>&amp;Layout=<xsl:value-of select="$GLOBAL_PARAM_Layout"/>&amp;VDName=<xsl:value-of select="$GLOBAL_PARAM_VDName"/>&amp;Length=<xsl:value-of select="$GLOBAL_PARAM_Length"/>&amp;Minosdrivesize=<xsl:value-of select="$GLOBAL_PARAM_Minosdrivesize"/>&amp;Maxosdrivesize=<xsl:value-of select="$GLOBAL_PARAM_Maxosdrivesize"/>&amp;ClearForeignConfigEnable=<xsl:value-of select="$GLOBAL_PARAM_ClearForeignConfigEnable"/>&amp;ForeignAdiskFound=<xsl:value-of select="$GLOBAL_PARAM_IsAnyAdiskForeign"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Next_Page_URL">/servlet/SubmitForm?plugin=com.dell.sm.webplugins.SubmitCreateVDExpressSummaryWebPlugin&amp;OrigURL=<xsl:value-of select="$GLOBAL_PARAM_OrigURL"/>&amp;ControllerOID=<xsl:value-of select="$GLOBAL_PARAM_ControllerOID"/>&amp;ControllerName=<xsl:value-of select="$GLOBAL_PARAM_ControllerName"/>&amp;Layout=<xsl:value-of select="$GLOBAL_PARAM_Layout"/>&amp;Length=<xsl:value-of select="$GLOBAL_PARAM_Length"/>&amp;VDName=<xsl:value-of select="$GLOBAL_PARAM_VDName"/>&amp;IDList=<xsl:value-of select="$GLOBAL_PARAM_IDList"/>&amp;FILE=<xsl:value-of select="//FILE"/>&amp;Rules=<xsl:value-of select="$GLOBAL_PARAM_Rules"/>&amp;DisplayVDConfig=<xsl:value-of select="$GLOBAL_PARAM_DisplayVDConfig"/>&amp;OutputFileName=<xsl:value-of select="$GLOBAL_PARAM_OutputFileName"/>&amp;URL=<xsl:value-of select="$GLOBAL_VAR_ReturnUrlHREFValue"/>&amp;Force=1&amp;SpanLength=<xsl:value-of select="$GLOBAL_VAR_SpanLength"/>&amp;UseMaxSize=<xsl:value-of select="$GLOBAL_PARAM_UseMaxSize"/>&amp;Minosdrivesize=<xsl:value-of select="$GLOBAL_PARAM_Minosdrivesize"/>&amp;Maxosdrivesize=<xsl:value-of select="$GLOBAL_PARAM_Maxosdrivesize"/>&amp;ClearForeignConfigEnable=<xsl:value-of select="$GLOBAL_PARAM_ClearForeignConfigEnable"/>&amp;ForeignAdiskFound=<xsl:value-of select="$GLOBAL_PARAM_IsAnyAdiskForeign"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Exit_Wizard_URL">
		<xsl:choose>
			<xsl:when test="$GLOBAL_PARAM_Rules='1'">/servlet/DSASwitch?exitRAID=1</xsl:when>
			<xsl:otherwise><xsl:value-of select="translate($GLOBAL_PARAM_OrigURL,'!','&amp;')"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<!--main entry point into this XSL-->
	<xsl:template match="/OMA">
		<DataArea onLoad="true" nosubmitfordsa="true" validate="true" printable="false" exportdata="false" email="false" ignoreJumpBar="true">
			<xsl:attribute name="submitdisplay">
				<xsl:choose>
					<xsl:when test="$GLOBAL_PARAM_Rules='1'"><xsl:value-of select="$strContinueCVDES"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strFinishCVDES"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strBackPageButton"/></xsl:attribute>

			<!--Devendra 7/20/06: CR12532-->
			<xsl:if test="$GLOBAL_PARAM_Rules != '1'">
				<!-- OMSS invokes all URLs directly using canceltarget, backpagetarget and submit. -->
				<xsl:attribute name="cancel">true</xsl:attribute>
				<xsl:attribute name="canceltarget"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:attribute>
				<xsl:attribute name="canceldisplay"><xsl:value-of select="$strCancelCVDES"/></xsl:attribute>
				<xsl:attribute name="backpagetarget"><xsl:value-of select="$GLOBAL_PARAM_Prev_Page_URL"/></xsl:attribute>
				<xsl:attribute name="submit"><xsl:value-of select="$GLOBAL_PARAM_Next_Page_URL"/></xsl:attribute>
			</xsl:if>

			<!--Devendra 7/20/06: CR12532-->
			<xsl:if test="$GLOBAL_PARAM_Rules = '1'">
				<!-- CR54430: Values entered in the Raid configuration pages need to be cached -->
				<!-- In DSA mode, we want to enable the DSA caching mechanism so storeonback and screenname are defined. -->
				<xsl:attribute name="storeonback">true</xsl:attribute>
				<xsl:attribute name="screenname"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:attribute>
				
				<!--
				OMSS Lite uses the DSA caching javascript functions to go back, forward or exit.
				
				Buttons are used for DSA instead of canceltarget and submit since those attributes don't
				let us execute custom javascript actions. They only allow you to specify URLs. Backpagetarget
				does allow javascript functions.
				-->
				<xsl:attribute name="backpagetarget">javascript:goToPreviousPageInDSA();</xsl:attribute>
				<BottomCustomButton>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strContinueCVDES"/></xsl:attribute>
						<xsl:attribute name="href">javascript:submitCreateVDExpressSummary();</xsl:attribute>
						<!-- DF111388 : Prevent DSA from disabling buttons on submit. We will do it ourselves if validation returns true. -->
						<xsl:attribute name="disablerestrictmulcall">true</xsl:attribute>
					</Data>
				</BottomCustomButton>
				<BottomCustomButton>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strCancelCVDES"/></xsl:attribute>
						<xsl:attribute name="href">javascript:exitWizardInDSA();</xsl:attribute>
					</Data>
				</BottomCustomButton>
			</xsl:if>

			<xsl:variable name="warnDHSMsg">
				<xsl:choose>
					<xsl:when test="($GLOBAL_PARAM_Layout != '2') and (substring($GLOBAL_VAR_ControllerAttributesMask,5,1) != '1') and (count(/OMA/DHSAvailDisks/ArrayDisks/DCStorageObject) != 0)">yes</xsl:when>
					<xsl:otherwise>no</xsl:otherwise>
				</xsl:choose>				
			</xsl:variable>

			<script language="javascript">
				<xsl:call-template name="getCommonScripts"/>
				<xsl:if test="$GLOBAL_PARAM_Rules='1'">
					<!-- Include the DSA caching scripts if OMSS Lite mode. Specify relevant parameters to the template. -->
					<xsl:call-template name="getDSAScripts">
						<xsl:with-param name="PARAM_Screen_Name"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:with-param>
						<xsl:with-param name="PARAM_Prev_Page_URL"><xsl:value-of select="$GLOBAL_PARAM_Prev_Page_URL"/></xsl:with-param>
						<xsl:with-param name="PARAM_Next_Page_URL"><xsl:value-of select="$GLOBAL_PARAM_Next_Page_URL"/></xsl:with-param>
						<xsl:with-param name="PARAM_Exit_Wizard_URL"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</script>

			<script language="javascript">
				function initializationRoutine() {
					<!-- DSA uses different function to append VID -->
					var rules = "<xsl:value-of select="$GLOBAL_PARAM_Rules"/>";
					if (rules == "1")
					{
						top.gnv.appendVID = top.getFrame("OMA_gnv").appendDataAreaVID;
					}
				}
				function validate()
				{
					var rules = "<xsl:value-of select="$GLOBAL_PARAM_Rules"/>";
					var dsaWarnMsg = "<xsl:value-of select="$strDSAWarnVdisksWillBeLostCVDES"/>";
					<!-- AS: DF54548: Update pop-up mesg to indicate clearing the foreign configuration    -->
					var frgnFlag="<xsl:value-of select="$GLOBAL_PARAM_ClearForeignConfigEnable"/>";
					var frgnconfigWarnMsg = "<xsl:value-of select="$strDSAWarnVdisksFrgnDriveWillBeLostCVDES"/>";
					if (frgnFlag=="1")
					{
						if(rules=="1" &amp;&amp; !confirm(frgnconfigWarnMsg))
							return false;
					}
					else
					{
						if(rules=="1" &amp;&amp; !confirm(dsaWarnMsg))
							return false;
					}
					<!-- :Chethan 06/10/04 Fixed defect DFCT 129664: We are already displaying a pop-up message saying all the existing
					virtual disks will be deleted. We don't need an additional pop-up message-->
					<!--var isRaidIM = "<xsl:call-template name="IsRaidIntegratedMirror"><xsl:with-param name="AttributesMask" select="$GLOBAL_VAR_ControllerAttributesMask"/></xsl:call-template>";
					var msg = "<xsl:value-of select="$strConfirmMsgForIMCreation"/>";
					if(isRaidIM==1 &amp;&amp; !confirm(msg)) if PERC 4 IM controller and user says no to reboot, return false
						return false;-->


					if ('<xsl:value-of select="$warnDHSMsg"/>' == 'yes' &amp;&amp; (document.getElementById("HSDIDList") == null || document.getElementById("HSDIDList").checked == false)) 
					{
						return confirm("<xsl:value-of select="$strDHSNotAssignMsg"/>");
					}

					if( rules!="1") {
						disableButtons("submit","back" ,"cancel");
					} else {
						<!-- DF111388 : Disable buttons when validation is successful. -->
        setDisableFlag();
        disableSubmitButton()
        }

        return true;
        }
        function submitCreateVDExpressSummary() {
        cachePageInDSA();

        if (validate()) {
            document.dataarea.action = top.gnv.appendVID("<xsl:value-of select="$GLOBAL_PARAM_Next_Page_URL"/>");
						document.dataarea.submit();
					}
				}
			</script>

			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitleMainStartCVDES"/><xsl:value-of select="$GLOBAL_PARAM_ControllerName"/><xsl:value-of select="$strTitleMainEndCVDES"/></xsl:attribute>
			</PageTitle>
			<TableData name="T1" display="{$strVDAttribTableCVDES}">
				<PromptText><xsl:value-of select="$strVDAttribPromptTextCVDES"/></PromptText>
				<Header><Data value="{$strAttributeCVDES}" width="400"/><Data value="{$strValueCVDES}"/></Header>
				<Row>
					<Data value="{$strTypeCVDES}" name="RaidLevel"/>
					<Data name="RaidLevelValue">
						<xsl:attribute name="value">
							<!--The Template in Utils.xsl is called below/-->
							<xsl:call-template name="GetRaidLayout">
								<xsl:with-param name="RaidType">
									<xsl:value-of select="Layout"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
					</Data>
				</Row>
				<Row>
					<Data value="{$strSizeCVDES}" name="Size"/>
					<Data name="SizeValue"><xsl:attribute name="value"><xsl:value-of select="format-number((Length div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:attribute></Data>
				</Row>
				<xsl:if test="$GLOBAL_PARAM_Rules = '1'">
				<Row>
					<Data value="{$strType}" name="Protocol"/>
					<Data name="ProtocolValue">
						<xsl:attribute name="value">
							<!--The Template in Utils.xsl is called below/-->
							<xsl:call-template name="GetBusProtocol">
								<xsl:with-param name="Bus">
									<xsl:value-of select="//CapsArrayDisksInfo/DCStorageObject/BusProtocol"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
					</Data>
				</Row>
				</xsl:if>
				<xsl:if test="$GLOBAL_PARAM_Rules != '1'">
				<Row>
					<Data value="{$strNameCVDES}" name="Name"/>
					<Data name="NameValue" value="{$GLOBAL_PARAM_VDName}"/>
				</Row>
				</xsl:if>
        <!-- Usability Report#17-->
        <Row>
          <Data value="{$strStripeSize}" name="StripeSize"/>
          <Data name="StripeSize">
            <xsl:attribute name="value">
              <!--The Template in Utils.xsl is called below/-->
              <xsl:call-template name="GetStripeSize">
                <xsl:with-param name="stripesize">
                  <xsl:value-of select="$decimalstripesize"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:attribute>
          </Data>
        </Row>
        <Row>
          <Data value="{$strReadCache}" name="ReadPolicy"/>
          <Data name="ReadPolicy">
            <xsl:attribute name="value">
              <!--The Template in Utils.xsl is called below/-->
              <xsl:call-template name="GetReadPolicy">
                <xsl:with-param name="readpolicy">
                  <xsl:value-of select="$decimalreadpolicy"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:attribute>
          </Data>
        </Row>
        <Row>
          <Data value="{$strWriteCache}" name="WritePolicy"/>
          <Data name="WritePolicy">
            <xsl:attribute name="value">
              <!--The Template in Utils.xsl is called below/-->
              <xsl:call-template name="GetWritePolicy">
                <xsl:with-param name="writepolicy">
                  <xsl:value-of select="$decimalwritepolicy"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:attribute>
          </Data>
        </Row>
        <xsl:if test = "$GLOBAL_VAR_DefaultCachePolicy!=''" >
          <Row>
            <Data value="{$strCachePolicy}" name="CachePolicy"/>
            <Data name="CachePolicy">
              <xsl:attribute name="value">
                <xsl:call-template name="GetCachePolicy">
                  <xsl:with-param name="cachepolicy">
                    <xsl:value-of select="$decimalcachepolicy"/>
                  </xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
            </Data>
          </Row>
        </xsl:if>
        <xsl:if test = "$GLOBAL_VAR_DefaultDiskCachePolicy!=''" >
          <Row>
            <Data value="{$strDiskCachePolicy}" name="DiskCachePolicy"/>
            <Data name="DiskCachePolicy">
              <xsl:attribute name="value">
                <xsl:call-template name="GetDiskCachePolicy">
                  <xsl:with-param name="DiskCachePolicy">
                    <xsl:value-of select="$decimaldiskcachepolicy"/>
                  </xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
            </Data>
          </Row>
        </xsl:if>

        <!--end of usability CR #17-->
      </TableData>
			<TableData name="T2" display="{$strArrayDiskTableCVDES}">
				<PromptText><xsl:value-of select="$strADSelectedPromptTextCVDES"/></PromptText>
				<Header><Data value="{$strArrayDiskCVDES}" width="400"/><Data value="{$strFreeSpaceCVDES}"/></Header>
				<xsl:for-each select="//CapsArrayDisksInfo/DCStorageObject">
					<xsl:sort select="Channel" data-type="number" order="ascending"/>
					<xsl:sort select="EnclosureID" data-type="number" order="ascending"/>
					<xsl:sort select="TargetID" data-type="number" order="ascending"/>
					<xsl:call-template name="RenderSelectedArrayDiskRow"/>
				</xsl:for-each>
			</TableData>
			<!-- CR69634 : Hotspare selection in Create VD -->
                        <xsl:if test="$GLOBAL_PARAM_Layout != '2'">
			<TableData name="T3" display="{$strHSDiskTableCVDES}">
				<PromptText><xsl:value-of select="$strHSAssignHotspareCVDES"/></PromptText>
				<xsl:choose>
					<xsl:when test="//DHSAvailDisks">
						<Header>
							<Data value="{$strArrayDiskCVDES}" width="400"/>
							<Data value="{$strFreeSpaceCVDES}"/>
						</Header>
						<xsl:for-each select="//DHSAvailDisks/ArrayDisks/DCStorageObject">
							<xsl:sort select="FreeSpace" data-type="number" order="ascending"/>
							<xsl:sort select="Channel" data-type="number" order="ascending"/>
							<xsl:sort select="EnclosureID" data-type="number" order="ascending"/>
							<xsl:sort select="TargetID" data-type="number" order="ascending"/>
							<xsl:if test="position() = 1">
								<xsl:call-template name="RenderSelectedArrayDiskRow">
									<xsl:with-param name="WithCheckbox">1</xsl:with-param>
								</xsl:call-template>
							</xsl:if>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<Row>
							<Data value="{$strHSNoneAvailable}"/>
						</Row>
					</xsl:otherwise>
				</xsl:choose>
			</TableData>
                        </xsl:if>
		</DataArea>
	</xsl:template>
	<xsl:template name="RenderSelectedArrayDiskRow">
		<xsl:param name="WithCheckbox">0</xsl:param>
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="AdiskTitle">
			<xsl:choose>
				<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
					<xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<Row>
			<xsl:choose>
				<xsl:when test="$WithCheckbox='1'">
					<Data editable="true" type="checkbox" align="left" name="HSDIDList">
						<xsl:attribute name="returnvalue">
							<xsl:choose>
								<xsl:when test="$GLOBAL_PARAM_Rules='1'">
									<!-- Send hotspare disk nexus in case of OMSS-Lite -->
									<xsl:value-of select="$AdiskTitle"/>
								</xsl:when>
								<xsl:otherwise>
									<!-- Send hotspare disk OID in case of OMSS -->
									<xsl:value-of select="ObjID"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDES"/>&#160;<xsl:value-of select="$AdiskTitle"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data>
						<xsl:attribute name="name">Adisk<xsl:value-of select="position()"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$AdiskTitle"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
			<Data>
				<xsl:attribute name="name">AdiskFreeSpace<xsl:value-of select="position()"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<!--In DSA mode size of array disk is capacity of array disk-->
						<xsl:when test="$GLOBAL_PARAM_Rules='1'"><xsl:value-of select="format-number((Length div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="format-number((ContiguousFree div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</Row>
	</xsl:template>
</xsl:stylesheet>
