<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!--The code below includes Utils.xsl which contains commonly called templates to get layout, read policy, write policy etc which can be resused/-->
	<xsl:include href="Utils.xsl"/>
	<xsl:include href="cvdutils.xsl"/>
	<xsl:include href="dsautils.xsl"/>
	<!--main entry point into this XSL-->

	<!-- Declare a bunch of Global variables and params-->
	<xsl:variable name="GLOBAL_VAR_IsVdiskNameFieldAllowedForSelectedLayout">
		<xsl:call-template name="bitAnd">
			<xsl:with-param name="num1">
				<xsl:choose>
					<xsl:when test="not(//Controllers//DCStorageObject/VdiskNameAllowedForRaidLevelMask)">
						<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr" select="//Controllers//DCStorageObject/RAIDLevelsMask"/></xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr" select="//Controllers//DCStorageObject/VdiskNameAllowedForRaidLevelMask"/></xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
			<xsl:with-param name="num2" select="$PARAM_PREV_Layout"/>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_ReturnUrlHREFValue">
		<xsl:choose>
			<xsl:when test="$PARAM_DSA_Rules='1'">/servlet/DSASwitch</xsl:when>
			<!-- %26 is escape character for &-->
			<xsl:otherwise><xsl:value-of select="/OMA/OrigURL"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_GetCapsSMStatus">
		<xsl:choose>
			<xsl:when test="/OMA/ExpressResults/SMStatus"><xsl:value-of select="/OMA/ExpressResults/SMStatus"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="PARAM_DSA_Rules">
		<xsl:choose>
			<xsl:when test="/OMA/Rules"><xsl:value-of select="/OMA/Rules"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PARAM_ClearForeignConfigEnable">
		<xsl:choose>
			<xsl:when test="/OMA/ClearForeignConfigEnable">
				<xsl:value-of select="/OMA/ClearForeignConfigEnable"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PARAM_IsAnyAdiskForeign">
		<xsl:choose>
			<xsl:when test="/OMA/ForeignAdiskFound">
				<xsl:value-of select="/OMA/ForeignAdiskFound"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PARAM_DSARaidModeAndDiskCheck">
		<xsl:choose>
			<xsl:when test="/OMA/DSARaidModeAndDiskCheck">
				<xsl:value-of select="/OMA/DSARaidModeAndDiskCheck"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
        
	<xsl:variable name="GLOBAL_VAR_ProtocolVal">
		<xsl:choose>
			<xsl:when test="/OMA/ExpressResults/DCStorageObject/BusProtocolMask">
				<xsl:value-of select="/OMA/ExpressResults/DCStorageObject/BusProtocolMask"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
        
	<xsl:variable name="PARAM_DSA_OutputFileName"><xsl:value-of select="/OMA/OutputFileName"/></xsl:variable>
	<xsl:variable name="PARAM_DSA_DisplayVDConfig"><xsl:value-of select="/OMA/DisplayVDConfig"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_ControllerName"><xsl:value-of select="/OMA/ControllerName"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_ControllerOID"><xsl:value-of select="/OMA/ControllerOID"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_Minosdrivesize"><xsl:value-of select="/OMA/Minosdrivesize"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_Maxosdrivesize"><xsl:value-of select="/OMA/Maxosdrivesize"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_FILE"><xsl:value-of select="/OMA/FILE"/></xsl:variable>
	<xsl:variable name="PARAM_REGULAR_OrigURL"><xsl:value-of select="/OMA/OrigURL"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_Layout"><xsl:value-of select="/OMA/Layout"/></xsl:variable>
        

	<xsl:variable name="PARAM_SPANEDITMODE"><xsl:value-of select="/OMA/SpanEditMode"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_Length">
		<xsl:choose>
			<xsl:when test="$PARAM_SPANEDITMODE = 'true'">
				<xsl:value-of select="/OMA/ExpressResults/DCStorageObject/Length"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="/OMA/Length"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="PARAM_PREV_VDName"><xsl:value-of select="/OMA/VDName"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_IDList"><xsl:value-of select="/OMA/IDList"/></xsl:variable>
        <xsl:variable name="PARAM_PREV_IMIDList"><xsl:value-of select="/OMA/IMIDList"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_SpanLength"><xsl:value-of select="/OMA/SpanLength"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_DiskProtocol"><xsl:value-of select="/OMA/DiskProtocol"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_ReadPolicy"><xsl:value-of select="/OMA/ReadPolicy"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_WritePolicy"><xsl:value-of select="/OMA/WritePolicy"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_CachePolicy"><xsl:value-of select="/OMA/CachePolicy"/></xsl:variable>
        <xsl:variable name="PARAM_PREV_DiskCachePolicy"><xsl:value-of select="/OMA/DiskCachePolicy"/></xsl:variable>
	<xsl:variable name="PARAM_PREV_StripeSize"><xsl:value-of select="/OMA/StripeSize"/></xsl:variable>

	<xsl:variable name="PARAM_SPANMODE_DiskProtocol">
		<xsl:choose>
			<xsl:when test="$PARAM_PREV_DiskProtocol = '' or $PARAM_PREV_DiskProtocol = '0'">
				<xsl:call-template name="GetNumberFromMask">
                                    <xsl:with-param name="num" select="$GLOBAL_VAR_ProtocolVal"/>
                                </xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$PARAM_PREV_DiskProtocol"/>
			</xsl:otherwise>
		</xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="PARAM_STATE_UserSelectedAdiskArrayNumList"><xsl:value-of select="/OMA/UserSelectedAdiskArrayNumList"/></xsl:variable>
	<xsl:variable name="PARAM_STATE_UserSelectedAdiskContiguousFreeSpaceList"><xsl:value-of select="/OMA/UserSelectedAdiskContiguousFreeSpaceList"/>
</xsl:variable>
	<xsl:variable name="DSA_PARAMS">Rules=<xsl:value-of select="$PARAM_DSA_Rules"/>&amp;DisplayVDConfig=<xsl:value-of select="$PARAM_DSA_DisplayVDConfig"/>&amp;OutputFileName=<xsl:value-of select="$PARAM_DSA_OutputFileName"/>&amp;ClearForeignConfigEnable=<xsl:value-of select="$PARAM_ClearForeignConfigEnable"/>&amp;ForeignAdiskFound=<xsl:value-of select="$PARAM_IsAnyAdiskForeign"/>&amp;DSARaidModeAndDiskCheck=<xsl:value-of select="$PARAM_DSARaidModeAndDiskCheck"/></xsl:variable>
	<xsl:variable name="REGULAR_PARAMS">ControllerOID=<xsl:value-of select="$PARAM_REGULAR_ControllerOID"/>&amp;ControllerName=<xsl:value-of select="$PARAM_REGULAR_ControllerName"/>&amp;FILE=<xsl:value-of select="$PARAM_REGULAR_FILE"/>&amp;Minosdrivesize=<xsl:value-of select="$PARAM_REGULAR_Minosdrivesize"/>&amp;Maxosdrivesize=<xsl:value-of select="$PARAM_REGULAR_Maxosdrivesize"/></xsl:variable>
	<xsl:variable name="CACHED_PARAMS">Layout=<xsl:value-of select="$PARAM_PREV_Layout"/>&amp;IDList=<xsl:value-of select="$PARAM_PREV_IDList"/>&amp;SpanLength=<xsl:value-of select="$PARAM_PREV_SpanLength"/>&amp;DiskProtocol=<xsl:value-of select="$PARAM_PREV_DiskProtocol"/>&amp;VDName=<xsl:value-of select="$PARAM_PREV_VDName"/>&amp;Length=<xsl:value-of select="$PARAM_PREV_Length"/>&amp;ReadPolicy=<xsl:value-of select="$PARAM_PREV_ReadPolicy"/>&amp;WritePolicy=<xsl:value-of select="$PARAM_PREV_WritePolicy"/>&amp;CachePolicy=<xsl:value-of select="$PARAM_PREV_CachePolicy"/>&amp;DiskCachePolicy=<xsl:value-of select="$PARAM_PREV_DiskCachePolicy"/>&amp;StripeSize=<xsl:value-of select="$PARAM_PREV_StripeSize"/>&amp;IMIDList=<xsl:value-of select="$PARAM_PREV_IMIDList"/></xsl:variable>
	<xsl:variable name="STATE_PARAMS">UserSelectedAdiskArrayNumList=<xsl:value-of select="$PARAM_STATE_UserSelectedAdiskArrayNumList"/>&amp;UserSelectedAdiskContiguousFreeSpaceList=<xsl:value-of select="$PARAM_STATE_UserSelectedAdiskContiguousFreeSpaceList"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_UseMaxSize"><xsl:value-of select="/OMA/UseMaxSize"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_IM"><xsl:value-of select="/OMA/IntMirror"/></xsl:variable>
	<xsl:variable name="PARAM_CURR_SELECTALL"><xsl:value-of select="/OMA/SelectAll"/></xsl:variable>
      <xsl:variable name="PARAM_CURR_ENCLOSURESELECTEDLIST"><xsl:value-of select="/OMA/EnclosureSelectedList"/></xsl:variable>
      <xsl:variable name="PARAM_CURR_ENCLOSUREDISABLEDLIST"><xsl:value-of select="/OMA/EnclosureDisabledList"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Screen_Name">cvdasum_<xsl:value-of select="$PARAM_REGULAR_ControllerOID"/>_<xsl:value-of select="$PARAM_PREV_Layout"/>_<xsl:value-of select="$PARAM_PREV_IDList"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Prev_Page_URL">/servlet/DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedSizeSelectionWebPlugin&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;Layout=<xsl:value-of select="$PARAM_PREV_Layout"/>&amp;SpanLength=<xsl:value-of select="$PARAM_PREV_SpanLength"/>&amp;DiskProtocol=<xsl:value-of select="$PARAM_PREV_DiskProtocol"/>&amp;VDName=<xsl:value-of select="$PARAM_PREV_VDName"/>&amp;Length=<xsl:value-of select="$PARAM_PREV_Length"/>&amp;ReadPolicy=<xsl:value-of select="$PARAM_PREV_ReadPolicy"/>&amp;WritePolicy=<xsl:value-of select="$PARAM_PREV_WritePolicy"/>&amp;CachePolicy=<xsl:value-of select="$PARAM_PREV_CachePolicy"/>&amp;DiskCachePolicy=<xsl:value-of select="$PARAM_PREV_DiskCachePolicy"/>&amp;StripeSize=<xsl:value-of select="$PARAM_PREV_StripeSize"/>&amp;<xsl:value-of select="$STATE_PARAMS"/>&amp;UseCachedXMLData=false&amp;IntMirror=<xsl:value-of select="$PARAM_CURR_IM"/>&amp;SelectAllVal=<xsl:value-of select="$PARAM_CURR_SELECTALL"/>&amp;EnclosureSelectedList=<xsl:value-of select="$PARAM_CURR_ENCLOSURESELECTEDLIST"/>&amp;EnclosureDisabledList=<xsl:value-of select="$PARAM_CURR_ENCLOSUREDISABLEDLIST"/>&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Next_Page_URL">/servlet/SubmitForm?plugin=com.dell.sm.webplugins.SubmitCreateVDAdvancedSummaryWebPlugin&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;Layout=<xsl:value-of select="$PARAM_PREV_Layout"/>&amp;SpanLength=<xsl:value-of select="$PARAM_PREV_SpanLength"/>&amp;DiskProtocol=<xsl:value-of select="$PARAM_PREV_DiskProtocol"/>&amp;VDName=<xsl:value-of select="$PARAM_PREV_VDName"/>&amp;Length=<xsl:value-of select="$PARAM_PREV_Length"/>&amp;ReadPolicy=<xsl:value-of select="$PARAM_PREV_ReadPolicy"/>&amp;WritePolicy=<xsl:value-of select="$PARAM_PREV_WritePolicy"/>&amp;CachePolicy=<xsl:value-of select="$PARAM_PREV_CachePolicy"/>&amp;DiskCachePolicy=<xsl:value-of select="$PARAM_PREV_DiskCachePolicy"/>&amp;StripeSize=<xsl:value-of select="$PARAM_PREV_StripeSize"/>&amp;URL=<xsl:value-of select="$GLOBAL_VAR_ReturnUrlHREFValue"/>&amp;Force=1&amp;UseMaxSize=<xsl:value-of select="$GLOBAL_PARAM_UseMaxSize"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Exit_Wizard_URL">
		<xsl:choose>
			<xsl:when test="$PARAM_DSA_Rules='1'">/servlet/DSASwitch?exitRAID=1&amp;IsFromAdvanced=1</xsl:when>
			<xsl:otherwise><xsl:value-of select="translate($PARAM_REGULAR_OrigURL,'!','&amp;')"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:template match="/">
		<!-- This page is rendered under two scenarios-->
		<!-- Page Load Scenario One: Page is loaded for first time.-->
		<!-- Page Load Scenario Two: Page is loaded when user does some selection on current page, goes back to a previous pages on wizard and then returns to current page-->
		<!-- Page error scenarios-->
		<!-- Error scenario One:
			Detection: User selected array disks do not belong to same disk group./User selected arraydisks do not have any free space.
						/User selected size not available on selected array disks - These errors will not be handled on this page.
			Cause: Free array disks unavailable to create any raid layout.
			User Scenario when this occurs: Can happen during  the two "Page Load Scenarios". Another user either thru CLI or browser could have used up all or some
			array disk space by the time current page is loaded -->
		<!-- When user comes to this page using "back button" on wizard, the variable below determines whether adisks selected by user is still valid-->
		<!-- Next render page depending if there is an error or not.-->
		<xsl:choose>
		<!--Devendra 7/20/06: CR12532-->
			<xsl:when test="$PARAM_DSA_Rules = '1' and $GLOBAL_VAR_GetCapsSMStatus = '-1'  ">
				<DataArea exportdata="false" email="false" printable="false">
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strTitleCfgChngDetectCVDAS"/></xsl:attribute>
					</PageTitle>
					<PromptText><xsl:value-of select="$strTitleFreeDisksUnavailableCVDAS"/></PromptText>
					<PromptText><xsl:value-of select="$strRaidSelectionInvalidCVDAS"/></PromptText>
					<BottomCustomButton>
						<Data formSubmit="true">
							<xsl:attribute name="display"><xsl:value-of select="$strCancelCVDAS"/></xsl:attribute>
							<xsl:attribute name="href"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:attribute>
						</Data>
					</BottomCustomButton>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="OMA"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="/OMA">
		<DataArea onLoad="true" nosubmitfordsa="true" validate="true" exportdata="false" email="false" printable="false" ignoreJumpBar="true">
			<!--Devendra 7/20/06: CR12532-->
                        
			<xsl:if test="$PARAM_DSA_Rules != '1'">
				<xsl:attribute name="cancel">true</xsl:attribute>
				<xsl:attribute name="canceltarget"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:attribute>
				<xsl:attribute name="canceldisplay"><xsl:value-of select="$strCancelCVDAS"/></xsl:attribute>

				<xsl:attribute name="backpagedisplayfull"><xsl:choose><xsl:when test="$PARAM_SPANEDITMODE = 'true'"><xsl:value-of select="$strBackToCVDSizePage"/></xsl:when><xsl:otherwise><xsl:value-of select="$strBackPageButton"/></xsl:otherwise></xsl:choose></xsl:attribute>

				<xsl:attribute name="backpagetarget">javascript:BackPage()</xsl:attribute>
				<xsl:attribute name="submitdisplay"><xsl:value-of select="$strFinishCVDAS"/></xsl:attribute>
				<xsl:attribute name="submit"><xsl:value-of select="$GLOBAL_PARAM_Next_Page_URL"/></xsl:attribute>
			</xsl:if>
                        
			<!--Devendra 7/20/06: CR12532-->
			<xsl:if test="$PARAM_DSA_Rules = '1'">
				<xsl:attribute name="storeonback">true</xsl:attribute>
				<xsl:attribute name="screenname"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:attribute>
				<xsl:attribute name="custombackpagedisplay"><xsl:value-of select="$strBackPageButton"/></xsl:attribute>
				<xsl:attribute name="backpagetarget">javascript:goToPreviousPageInDSA();</xsl:attribute>
				<BottomCustomButton>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strContinueCVDAS"/></xsl:attribute>
						<xsl:attribute name="href">javascript:submitCreateVDAdvancedSummary();</xsl:attribute>
						<!-- DF111388 : Prevent DSA from disabling buttons on submit. We will do it ourselves if validation returns true. -->
						<xsl:attribute name="disablerestrictmulcall">true</xsl:attribute>
					</Data>
				</BottomCustomButton>
				<BottomCustomButton>
					<Data formSubmit="true">
						<xsl:attribute name="display"><xsl:value-of select="$strCancelCVDAS"/></xsl:attribute>
						<xsl:attribute name="href">javascript:exitWizardInDSA();</xsl:attribute>
					</Data>
				</BottomCustomButton>
			</xsl:if>
                        <HiddenTable>
				<Data>
					<xsl:attribute name="name">IDList</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="$PARAM_PREV_IDList"/></xsl:attribute>
				</Data>
			</HiddenTable>
                        <HiddenTable>
				<Data>
					<xsl:attribute name="name">IMIDList</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="$PARAM_PREV_IMIDList"/></xsl:attribute>
				</Data>
			</HiddenTable>

			<script language="javascript">
				<xsl:call-template name="getCommonScripts"/>
				<xsl:if test="$PARAM_DSA_Rules='1'">
					<!-- Include the DSA caching scripts if OMSS Lite mode. Specify relevant parameters to the template. -->
					<xsl:call-template name="getDSAScripts">
						<xsl:with-param name="PARAM_Screen_Name"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:with-param>
						<xsl:with-param name="PARAM_Prev_Page_URL"><xsl:value-of select="$GLOBAL_PARAM_Prev_Page_URL"/></xsl:with-param>
						<xsl:with-param name="PARAM_Next_Page_URL"><xsl:value-of select="$GLOBAL_PARAM_Next_Page_URL"/></xsl:with-param>
						<xsl:with-param name="PARAM_Exit_Wizard_URL"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</script>

			<xsl:variable name="warnDHSMsg">
				<xsl:choose>
					<xsl:when test="($PARAM_PREV_Layout != '2') and (substring(/OMA/Controllers/DCStorageObject/AttributesMask,5,1) != '1') and (count(/OMA/DHSAvailDisks/ArrayDisks/DCStorageObject) != 0)">yes</xsl:when>
					<xsl:otherwise>no</xsl:otherwise>
				</xsl:choose>				
			</xsl:variable>

			<script language="javascript">
				function initializationRoutine() {
					<!-- DSA uses different function to append VID -->
					var rules = "<xsl:value-of select="$PARAM_DSA_Rules"/>";
					if (rules == "1")
					{
						top.gnv.appendVID = top.getFrame("OMA_gnv").appendDataAreaVID;
					}
				}
				<!--
					CR69634 : Only one hotspare can be assigned at a time so checkboxes should allow only one to be
					checked at a time. -->
                                  
				function toggleUncheckedCheckboxes(checkbox)
				{
					var i = 0;
					var element;

					while (element = checkbox.form[i++])
					{
						if (element.type == "checkbox")
						{
							if (element != checkbox)
							{
								if (checkbox.checked == true)
								{
									element.disabled = true;
								}
								else
								{
									element.disabled = false;
								}
							}
						}
					}
				}
				function validate()
				{
					var rules = "<xsl:value-of select="$PARAM_DSA_Rules"/>";
					var dsaWarnMsg = "<xsl:value-of select="$strDSAWarnVdisksWillBeLostCVDAS"/>";
				<!-- AS: DF54548: Update pop-up mesg to indicate clearing the foreign configuration    -->
					var frgnFlag="<xsl:value-of select="$PARAM_ClearForeignConfigEnable"/>";
					var frgnconfigWarnMsg = "<xsl:value-of select="$strDSAWarnVdisksFrgnDriveWillBeLostCVDAS"/>";
					if (frgnFlag=="1")
					{
						if(rules=="1" &amp;&amp; !confirm(frgnconfigWarnMsg))
							return false;
					}
					else
					{
						if(rules=="1" &amp;&amp; !confirm(dsaWarnMsg))
							return false;
					}
					<!-- if( rules=="1" &amp;&amp; !confirm(dsaWarnMsg))
						return false; -->
					<!-- :Chethan 06/10/04 Fixed defect DFCT 129664: We are already displaying a pop-up message saying all the existing
					virtual disks will be deleted. We don't need an additional pop-up message-->
					<!--var isRaidIM = "<xsl:call-template name="IsRaidIntegratedMirror"><xsl:with-param name="AttributesMask" select="/OMA/Controllers/DCStorageObject/AttributesMask"/></xsl:call-template>";
					var msg = "<xsl:value-of select="$strConfirmMsgForIMCreation"/>";
					if(isRaidIM==1 &amp;&amp; !confirm(msg)) if PERC 4 IM controller and user says no to reboot, return false
						return false;-->

					if ('<xsl:value-of select="$warnDHSMsg"/>' == 'yes' &amp;&amp; getHSDIDList() == '')
					{
						return confirm("<xsl:value-of select="$strDHSNotAssignMsg"/>");
					}

					if( rules!="1") {
						disableButtons("submit","back" ,"cancel");
					} else {
						<!-- DF111388 : Disable buttons when validation is successful. -->
						setDisableFlag();
						disableSubmitButton()
					}

					return true;
				}
				function getHSDIDList() {
					var i = 0;
					var element;

					while (element = document.dataarea[i++])
					{
						if (element.type == "checkbox"
							&amp;&amp; element.name.substring(0, 5) == "HSDID"
							&amp;&amp; element.checked == true)
						{
							return "&amp;&amp;HSDIDList=" + element.value;
        }
        }
        return "";
        }
        function submitCreateVDAdvancedSummary() {
        cachePageInDSA();

        if (validate()) {
            document.dataarea.action = top.gnv.appendVID("<xsl:value-of select="$GLOBAL_PARAM_Next_Page_URL"/>" + getHSDIDList());
						document.dataarea.submit();
					}
				}
                                
       function submitSpanEditMode()
       {
           
         document.dataarea.action = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedAdiskSelectionWebPlugin&amp;<xsl:value-of select="$REGULAR_PARAMS"/>&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;Layout=<xsl:value-of select="$PARAM_PREV_Layout"/>&amp;SpanLength=<xsl:value-of select="$PARAM_PREV_SpanLength"/>&amp;DiskProtocol=<xsl:value-of select="$PARAM_SPANMODE_DiskProtocol"/>&amp;VDName=<xsl:value-of select="$PARAM_PREV_VDName"/>&amp;Length=<xsl:value-of select="$PARAM_PREV_Length"/>&amp;ReadPolicy=<xsl:value-of select="$PARAM_PREV_ReadPolicy"/>&amp;WritePolicy=<xsl:value-of select="$PARAM_PREV_WritePolicy"/>&amp;CachePolicy=<xsl:value-of select="$PARAM_PREV_CachePolicy"/>&amp;DiskCachePolicy=<xsl:value-of select="$PARAM_PREV_DiskCachePolicy"/>&amp;StripeSize=<xsl:value-of select="$PARAM_PREV_StripeSize"/>&amp;<xsl:value-of select="$STATE_PARAMS"/>&amp;UseCachedXMLData=false&amp;IntMirror=<xsl:value-of select="$PARAM_CURR_IM"/>&amp;SelectAllVal=<xsl:value-of select="$PARAM_CURR_SELECTALL"/>&amp;SpanEditMode=true&amp;OrigURL=<xsl:value-of select="$PARAM_REGULAR_OrigURL"/>&amp;EnclosureDisabledList=<xsl:value-of select="$PARAM_CURR_ENCLOSUREDISABLEDLIST"/>&amp;EnclosureSelectedList=<xsl:value-of select="$PARAM_CURR_ENCLOSURESELECTEDLIST"/>");
	 document.dataarea.submit();
        
	}
        
        function BackPage() 
        {
          document.dataarea.action = top.gnv.appendVID("<xsl:value-of select="$GLOBAL_PARAM_Prev_Page_URL"/>");
	  document.dataarea.submit();
	
	}
			</script>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitleMainStartCVDAS"/><xsl:value-of select="$PARAM_REGULAR_ControllerName"/><xsl:value-of select="$strTitleMainEndCVDAS"/></xsl:attribute>
			</PageTitle>

			<!-- Add span edit button only if Intelligent Mirroring option is selected -->
			<xsl:if test="$PARAM_CURR_IM = 'true' or $PARAM_SPANEDITMODE = 'true'">
			                          
                            <CustomButton align="left">
					<Data name="Edit" formSubmit="true">
						<xsl:attribute name="display"><xsl:value-of select="$strSpanEdit"/></xsl:attribute>
						<xsl:attribute name="href">javascript:submitSpanEditMode()</xsl:attribute>
					</Data>
				</CustomButton>
			</xsl:if>

			<TableData name="T1" display="{$strVDAttribsCVDAS}">
				<PromptText><xsl:value-of select="$strPromptTextVDAttribsCVDAS"/></PromptText>
				<Header><Data value="{$strAttributeCVDAS}" width="400"/><Data value="{$strValueCVDAS}"/></Header>
				<Row>
					<Data value="{$strTypeCVDAS}" name="RaidLevel"/>
					<Data name="RaidLevelValue">
						<xsl:attribute name="value">
							<!--The Template in Utils.xsl is called below/-->
							<xsl:call-template name="GetRaidLayout">
								<xsl:with-param name="RaidType">
									<xsl:value-of select="$PARAM_PREV_Layout"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
					</Data>
				</Row>
				<Row>
					<Data value="{$strSizeCVDAS}" name="Size"/>
					<Data name="SizeValue"><xsl:attribute name="value"><xsl:value-of select="format-number(($PARAM_PREV_Length div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:attribute></Data>
				</Row>
				<xsl:if test="$PARAM_DSA_Rules = '1'">
				<Row>
					<Data value="{$strType}" name="Protocol"/>
					<Data name="ProtocolValue">
						<xsl:attribute name="value">
							<!--The Template in Utils.xsl is called below/-->
							<xsl:call-template name="GetBusProtocol">
								<xsl:with-param name="Bus">
									<xsl:value-of select="//ArrayDisks/PassThruResponse/DCStorageObject/BusProtocol"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
					</Data>
				</Row>
				</xsl:if>
				<xsl:if test="($PARAM_DSA_Rules != '1' and not(//Controllers//DCStorageObject/VdiskNameAllowedForRaidLevelMask)) or $GLOBAL_VAR_IsVdiskNameFieldAllowedForSelectedLayout = '1'">
				<Row>
					<Data value="{$strNameCVDAS}" name="Name"/>
					<Data name="NameValue"><xsl:attribute name="value"><xsl:value-of select="$PARAM_PREV_VDName"/></xsl:attribute></Data>
				</Row>
				</xsl:if>
				<!--PERC 4 I/M does not have stripe size,-->
				<xsl:if test="$PARAM_PREV_StripeSize != '' ">
				<Row>
					<Data value="{$strStripeSizeCVDAS}" name="StripeSize"/>
					<Data name="StripeSizeValue">
						<xsl:attribute name="value">
							<xsl:call-template name="GetStripeSize">
								<xsl:with-param name="stripesize">
									<xsl:value-of select="$PARAM_PREV_StripeSize"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
					</Data>
				</Row>
				</xsl:if>
				<!--Kish : 02/09/04: Adaptec's  CERC SATA2s does not have ReadPolicy. DFCT105691-->
				<xsl:if test="$PARAM_PREV_ReadPolicy != '' ">
					<Row>
						<Data value="{$strReadPolicyCVDAS}" name="ReadPolicy"/>
						<Data name="ReadPolicyValue">
							<xsl:attribute name="value">
								<xsl:call-template name="GetReadPolicy">
									<xsl:with-param name="readpolicy">
										<xsl:value-of select="$PARAM_PREV_ReadPolicy"/>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:attribute>
						</Data>
					</Row>
				</xsl:if>
				<!--Kish : 02/09/04: Adaptec's  CERC SATA2s does not have WritePolicy. DFCT105691-->
				<xsl:if test="$PARAM_PREV_WritePolicy!= '' ">
					<Row>
						<Data value="{$strWritePolicyCVDAS}" name="WritePolicy"/>
						<Data name="WritePolicyValue">
							<xsl:attribute name="value">
								<xsl:call-template name="GetWritePolicy">
									<xsl:with-param name="writepolicy">
										<xsl:value-of select="$PARAM_PREV_WritePolicy"/>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:attribute>
						</Data>
					</Row>
				</xsl:if>
				<!--Adaptec does not have CachePolicy, hence check if LSI or Adaptec, <CachePolicy/> is Adaptec. <CachePolicy>x</CachePolicy> is LSI -->
				<xsl:if test="$PARAM_PREV_CachePolicy != '' ">
					<Row>
						<Data value="{$strCachePolicyCVDAS}" name="CachePolicy"/>
						<Data name="CachePolicyValue">
							<xsl:attribute name="value">
								<xsl:call-template name="GetCachePolicy">
									<xsl:with-param name="cachepolicy">
										<xsl:value-of select="$PARAM_PREV_CachePolicy"/>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:attribute>
						</Data>
					</Row>
				</xsl:if>
                                <xsl:if test="$PARAM_PREV_DiskCachePolicy != '' ">
					<Row>
						<Data value="{$strDiskCachePolicyCVDAS}" name="DiskCachePolicy"/>
						<Data name="DiskCachePolicyValue">
							<xsl:attribute name="value">
								<xsl:call-template name="GetDiskCachePolicy">
									<xsl:with-param name="DiskCachePolicy">
										<xsl:value-of select="$PARAM_PREV_DiskCachePolicy"/>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:attribute>
						</Data>
					</Row>
				</xsl:if>
			</TableData>
			<xsl:choose>
				<xsl:when test="$PARAM_PREV_Layout='512' or $PARAM_PREV_Layout='2048' or $PARAM_PREV_Layout='4096' or $PARAM_PREV_Layout='262144'">
					<TableData name="T2" display="{$strArrayDisksCVDAS}">
						<PromptText><xsl:value-of select="$strPromptTextAdisksSelectedCVDAS"/></PromptText>
						<Header><Data value="{$strArrayDiskCVDAS}"/><Data value="{$strFreeSpaceCVDAS}"/><Data value="{$strSpanNumCVDAS}"/></Header>
						<!--xsl:apply-templates select="//DCStorageObject" mode="SPAN"/-->
						<xsl:for-each select="//ArrayDisks">
							<xsl:call-template name="RenderArrayDisksWithSpanInfo">
								<xsl:with-param name="SpanNum" select="@span"/>
							</xsl:call-template>
						</xsl:for-each>
					</TableData>
				</xsl:when>
				<xsl:otherwise>
					<TableData name="T2" display="{$strArrayDisksCVDAS}">
						<PromptText><xsl:value-of select="$strPromptTextAdisksSelectedCVDAS"/></PromptText>
						<Header><Data value="{$strArrayDiskCVDAS}" width="400"/><Data value="{$strFreeSpaceCVDAS}" /></Header>
						<xsl:apply-templates select="//ArrayDisks/PassThruResponse/DCStorageObject" mode="NO_SPAN"/>
					</TableData>
				</xsl:otherwise>
			</xsl:choose>
			<!-- CR69634 : Hotspare selection in Create VD -->
			<!--
				DF95814 : Need to add mode="deploy" to ensure that HTMLData is processed correctly by
				          DSA's data area. This is ignored by OMSA's data area.
			-->
			<HTMLData mode="deploy">
				<!-- Make table scrollable only when there are hotspares to choose from -->
				<xsl:variable name="divstyle">
					<xsl:if test="//DHSAvailDisks">height: 200px; overflow: auto;</xsl:if>
				</xsl:variable>
				<!-- Stick the table in a scrollable DIV to support configs with several disks -->
				<div>
					<xsl:attribute name="style"><xsl:value-of select="$divstyle"/></xsl:attribute>
                                        <xsl:if test="$PARAM_PREV_Layout != '2'">
					<TableData name="T3" display="{$strHSDiskTableCVDAS}">
						<PromptText><xsl:value-of select="$strHSAssignHotspareCVDAS"/></PromptText>
						<xsl:choose>
							<xsl:when test="//DHSAvailDisks">
								<Header>
									<Data value="{$strArrayDiskCVDAS}" width="400"/>
									<Data value="{$strFreeSpaceCVDAS}"/>
								</Header>
								<xsl:apply-templates select="//DHSAvailDisks/ArrayDisks/DCStorageObject" mode="NO_SPAN">
									<xsl:with-param name="WithCheckbox">1</xsl:with-param>
									<xsl:sort select="Channel" data-type="number" order="ascending"/>
									<xsl:sort select="EnclosureID" data-type="number" order="ascending"/>
									<xsl:sort select="TargetID" data-type="number" order="ascending"/>
								</xsl:apply-templates>
							</xsl:when>
							<xsl:otherwise>
								<Row>
									<Data value="{$strHSNoneAvailable}"/>
								</Row>
							</xsl:otherwise>
						</xsl:choose>
					</TableData>
                                        </xsl:if>
				</div>
			</HTMLData>
		</DataArea>
	</xsl:template>
	<xsl:template name="RenderArrayDisksWithSpanInfo">
		<xsl:param name="SpanNum"/>
		<xsl:for-each select="PassThruResponse/DCStorageObject">
			<xsl:variable name="SASorSATA">
				<xsl:call-template name="IsSASorSATA">
					<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:variable name="DiskInEnclosure">
				<xsl:call-template name="IsDiskInEnclosure">
					<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<Row>
				<xsl:choose>
					<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
						<Data>
							<xsl:attribute name="name">Adisk<xsl:value-of select="position()"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDAS"/>&#160;<xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data>
							<xsl:attribute name="name">Adisk<xsl:value-of select="position()"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDAS"/>&#160;<xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
				<Data>
					<xsl:attribute name="name">AdiskFreeSpace<xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="$PARAM_DSA_Rules=1"><xsl:value-of select="format-number((Length div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="format-number((ContiguousFree div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
				<Data >
					<xsl:attribute name="name">AdiskSpanNum<xsl:value-of select="position()"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$SpanNum"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="DCStorageObject" mode="NO_SPAN">
		<xsl:param name="WithCheckbox">0</xsl:param>
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="AdiskTitle">
			<xsl:choose>
				<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
					<xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<Row>
			<xsl:choose>
				<xsl:when test="$WithCheckbox='1'">
					<Data editable="true" type="checkbox" align="left">
						<xsl:attribute name="name">
							<xsl:choose>
								<xsl:when test="$PARAM_DSA_Rules = '1'">HSDID_<xsl:value-of select="$AdiskTitle"/></xsl:when>
								<xsl:otherwise>HSDIDList</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
						<xsl:attribute name="returnvalue">
							<xsl:choose>
								<xsl:when test="$PARAM_DSA_Rules = '1'">
									<!-- Send hotspare disk nexus in case of OMSS-Lite -->
									<xsl:value-of select="$AdiskTitle"/>
								</xsl:when>
								<xsl:otherwise>
									<!-- Send hotspare disk OID in case of OMSS -->
									<xsl:value-of select="ObjID"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDAS"/>&#160;<xsl:value-of select="$AdiskTitle"/></xsl:attribute>
						<xsl:attribute name="event">onclick</xsl:attribute>
						<xsl:attribute name="handler">javascript:toggleUncheckedCheckboxes(this);</xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data>
						<xsl:attribute name="name">Adisk<xsl:value-of select="position()"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$AdiskTitle"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
			<Data>
				<xsl:attribute name="name">AdiskFreeSpace<xsl:value-of select="position()"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="$PARAM_DSA_Rules=1"><xsl:value-of select="format-number((Length div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="format-number((ContiguousFree div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</Row>
	</xsl:template>
</xsl:stylesheet>
