<!-- This is the XSL to render the Controller Information page.  The associated web plugin is the ControllerInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="Utils.xsl"/>
	<xsl:import href="ctrltbl.xsl"/>
	<xsl:import href="vdtbl.xsl"/>
	<xsl:import href="chnltbl.xsl"/>
	<xsl:import href="encltbl.xsl"/>
	<xsl:import href="btrytbl.xsl"/>

	<!-- Define a bunch of global variables-->
	<xsl:variable name="GLOBAL_VAR_CurrentFirmwareVersion"><xsl:value-of select="/OMA/Controllers/DCStorageObject/FirmwareVer"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_RequiredFirmwareVersion"><xsl:value-of select="/OMA/Controllers/DCStorageObject/RequiredFirmwareVersion"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_CurrentDriverVersion"><xsl:value-of select="/OMA/Controllers/DCStorageObject/CurrentDriverVersion"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_RequiredDriverVersion"><xsl:value-of select="/OMA/Controllers/DCStorageObject/RequiredDriverVersion"/></xsl:variable>

	<!-- Define Global variable for health status that can be used by other XSL files. Currently this variables are used to display status in Firmware/Driver version info page-->
	<xsl:variable name="HEALTH_STATUS_UNKNOWN_0">0</xsl:variable>
	<xsl:variable name="HEALTH_STATUS_UNKNOWN_1">1</xsl:variable>
	<xsl:variable name="HEALTH_STATUS_OK">2</xsl:variable>
	<xsl:variable name="HEALTH_STATUS_NON_CRITICAL">3</xsl:variable>
	<xsl:variable name="HEALTH_STATUS_CRITICAL">4</xsl:variable>
	<xsl:variable name="HEALTH_STATUS_NON_RECOVERABLE">5</xsl:variable>

	<xsl:template match="OMA">
		<xsl:variable name="checkAdmin">
			<xsl:choose>
				<xsl:when test="OMAUserRights = '7'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="isCluster">
				<xsl:choose>
					<xsl:when test="substring(/OMA/Controllers/DCStorageObject/AttributesMask,32,1)!='0'">1</xsl:when>
				  <xsl:otherwise>0</xsl:otherwise>
			 </xsl:choose>
		</xsl:variable>


		<DataArea onLoad="true">
			<!-- The call to the scripts template is needed to include the new common javascript function GetLocalUrl( ) for error handling -->
			<!-- This call must reside within the <DataArea> tag -->
			<xsl:call-template name="scripts"/>
			<script language="javascript">

			function initializationRoutine()
			{
				<!-- DF27306 - Selecting vdisk does not display constituent array disks in aparticular scenario
					This defect was reported in 1.4. A fix for DFCT116290 actually broke the page. At this time,
					the OMSA team is unable to root cause this issue. Reverting to original behavior since
					original issue is cosmetic in nature. (GKV)
					Original defect:
						DFCT116290 - OMSS1.0 Pointer to Storage Tree on Left not changing correponding to Page -->
				<!-- Commenting out
				compid = "Controller"+"<xsl:value-of select="/OMA/ControllerOID"/>";
				parent.ct._select(compid);
				-->
			}

			function onExecute(name, oid)
			{

				var cluster = <xsl:value-of select="$isCluster"/>;

				var confirmresponse = 0;

				var action = document.getElementById('CtrlTasks').value;
				if (action == "-")
				{
					alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
				}
				else if (action =="64")
				{ //create vd

					// need a cluster check.
					if(cluster == 1)
					{
							msg = "<xsl:value-of select="$strClusterCreate"/>";
							confirmresponse = confirm(msg);
					}

					if((cluster == 1 &amp;&amp; confirmresponse) || cluster == 0)
					{
				   	var origurl = GetLocalUrl(); //original URL
						<!--document.location.href ="/servlet/DataArea?plugin=com.dell.sm.webplugins.CreateVDExpressWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;help=vdmgmt&amp;OrigURL="+origurl;-->

          document.dataarea.action = top.gnv.appendVID("/servlet/SubmitForm?plugin=com.dell.sm.webplugins.LaunchCreateVDWizardSubmitWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;OrigURL=" + origurl);
					document.dataarea.submit();


					}


				}
				else if (action == "128")
				{  //reset config
					// need a cluster check.
					if(cluster == 1)
					{
							msg = "<xsl:value-of select="$strClusterResetCnfg"/>";
							confirmresponse = confirm(msg);
					}

					if((cluster == 1 &amp;&amp; confirmresponse) || cluster == 0)
          {
            document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.ConfirmResetConfWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;help=cntkrset");
        }
        }
        else if (action == "32") { //set rebuild rate
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.SetRebuildRateWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;help=cntkrbld&amp;RebuildRate=" + "<xsl:choose><xsl:when test="//RebuildRate"><xsl:value-of select="//RebuildRate"/></xsl:when><xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise></xsl:choose>");
        }
        else if (action == "8192") { //set bgi rate
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.SetCtrlRateAttribWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action + "&amp;help=cntkbgi&amp;Rate=" + "<xsl:choose><xsl:when test="//BGIRate"><xsl:value-of select="//BGIRate"/></xsl:when><xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise></xsl:choose>");
        }
        else if (action == "16384")  { //set checkconsistency rate
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.SetCtrlRateAttribWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action + "&amp;help=cntkchk&amp;Rate=" + "<xsl:choose><xsl:when test="//CheckConsistencyRate"><xsl:value-of select="//CheckConsistencyRate"/></xsl:when><xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise></xsl:choose>");
        }
        else if (action == "65536")  { //set reconstruct rate
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.SetCtrlRateAttribWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action + "&amp;help=cntkrcn&amp;Rate=" + "<xsl:choose><xsl:when test="//ReconstructRate"><xsl:value-of select="//ReconstructRate"/></xsl:when><xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise></xsl:choose>");
        }
        else if (action == "1") { //controller rescan
          document.location.href  = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.ConfirmCtrlRescanWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action="+action+"&amp;help=cnprin");
        }
        else if ((action == "4") || (action == 8) || (action == 16) || (action == 1024) || (action == 2048)) {
        //will eventually make this default...rescan, enable, disable, quiet alarm, resume, test alarm i/o
          document.dataarea.action = top.gnv.appendVID("/servlet/SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action="+action+"&amp;help=cnprin");
          document.dataarea.submit();
        }
        else if (action == "256") { //export log
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CtrlExportLogWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;help=cntklog");
        }
        else if (action == "8388608") { //clear foreign config
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CtrlConfirmForeignConfigWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkclfc");
//          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.ImportPreviewWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkimfc");
        }
        else if (action == "16777216") { //import foreign config
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CtrlConfirmForeignConfigWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkimfc");
        }
        else if (action == "33554432") { //forced import foreign config
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CtrlConfirmForeignConfigWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkimfc");
        }
        else if (action == "536870912") { //foreign config operations
          var origurl = GetLocalUrl(); //original URL
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.ImportPreviewWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkipfc"+"&amp;OrigUrl="+origurl);
        }
        else if (action == "2097152") { //start patrol read
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CtrlConfirmStartStopPatReadWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkpats");
        }
        else if (action == "4194304") { //stop patrol read
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CtrlConfirmStartStopPatReadWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkpats");
        }
        else if (action == "1048576") { //set patrol read mode
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.SetCtrlPatReadModeWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action + "&amp;PatrolReadMode=<xsl:value-of select="//PatrolReadMode"/>" + "&amp;PatrolReadModeMask=<xsl:value-of select="//PatrolReadModeMask"/>" + "&amp;help=cntkpatm");
	}
        else if (action == "67108864") { //Change Controller Properties
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.ChangeControllerPropertiesWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;OrigURL=" + origurl+"&amp;help=cntkchcp");
        }
         else if (action == "268435456") { //Pinned Cached
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CtrlManagePinnedCacheWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;OrigURL=" + origurl+"&amp;help=cntkmpic");
        }

				else {
					// Should never get here
					alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
        }
        }
        function callCreate(name, oid) {
        //alert("Name: " + name + ", oid: " + oid);
        //sid = "Properties"+oid;
        //lid = "Information"+oid;
        //parent.ct.select(compid);  moves tree select to controller object
          document.location.href =top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CreateVDExpressWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;FILE=false&amp;help=vdmgmt");
			}
		</script>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/><xsl:value-of select="/*/Controllers/@ControllerName"/><xsl:value-of select="$strTitlePart2"/></xsl:attribute>
			</PageTitle>
			<!-- Checks if the firmware and/or driver versions are out of date, if so displays appropriate message informing that they are out of date -->
			<SubHeader>
				<xsl:choose>
					<xsl:when test="$GLOBAL_VAR_RequiredFirmwareVersion and $GLOBAL_VAR_RequiredDriverVersion">
						<xsl:attribute name="display"><xsl:value-of select="$strSubHeaderFwDriverVerOutOfDate"/></xsl:attribute>
						<xsl:attribute name="status"><xsl:value-of select="$HEALTH_STATUS_NON_CRITICAL"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="$GLOBAL_VAR_RequiredFirmwareVersion">
						<xsl:attribute name="display"><xsl:value-of select="$strSubHeaderFwVerOutOfDate"/></xsl:attribute>
						<xsl:attribute name="status"><xsl:value-of select="$HEALTH_STATUS_NON_CRITICAL"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="$GLOBAL_VAR_RequiredDriverVersion">
						<xsl:attribute name="display"><xsl:value-of select="$strSubHeaderDriverVerOutOfDate"/></xsl:attribute>
						<xsl:attribute name="status"><xsl:value-of select="$HEALTH_STATUS_NON_CRITICAL"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise><!-- Do Nothing--></xsl:otherwise>
				</xsl:choose>
			</SubHeader>

			<CustomButton>
			<!-- The refresh button cannot use the below javascript to perform the refresh.  The issue is the  javascript calls the last webplug which was called
			      to render this page.  The problem is that the page can be rendered by two webplugins: the info webplugin and the action execute web plugin.
			      If the action execute webplugin was the last webplugin to render the page, pressing refresh would cause that action to be re-executed. -->
				<!--Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href"></xsl:attribute>
					<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
				</Data-->
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;help=cnprin</xsl:attribute>
				</Data>
			</CustomButton>
			<xsl:apply-templates select="/*/Controllers/DCStorageObject">
				<xsl:with-param name="tasks">
					<xsl:value-of select="$checkAdmin"/>
				</xsl:with-param>
			</xsl:apply-templates>
		</DataArea>
	</xsl:template>
	<!-- Template to display the controller object -->
	<xsl:template match="Controllers/DCStorageObject">
		<xsl:param name="tasks"/>
		<xsl:param name="checkAdmin"/>
		<ComboData ignoreJumpBar="true">
			<ListData columnspacing="true">
				<xsl:variable name="showtasks">
					<xsl:value-of select="$tasks"/>
				</xsl:variable>
				<SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$strSubHeader1"/></xsl:attribute>
					<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
				</SubHeader>
				<xsl:call-template name="ControllerTable">
					<xsl:with-param name="tasks" select="$showtasks"/>
				</xsl:call-template>
				<!--Data display="Name">
					<xsl:attribute name="value"><xsl:value-of select="../@ControllerName"/></xsl:attribute>
					<xsl:attribute name="href"/>
				</Data>
				<Data display="State">
				<xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state" select="ObjState"/></xsl:call-template></xsl:attribute>
				</Data>
				<Data display="Firmware Version" value="{FirmwareVer}"/-->
			</ListData>
			<xsl:if test="MaxVDAllowed>0">
				<xsl:if test="count(../../VirtualDisks/DCStorageObject)>0">
					<TableData columnspacing="true">
						<xsl:variable name="showtasks">false</xsl:variable>
						<SubHeader>
							<xsl:attribute name="display"><xsl:value-of select="$strSubHeader2"/></xsl:attribute>
						</SubHeader>
						<DescText>
							<xsl:attribute name="display"><xsl:value-of select="$strPromptText"/></xsl:attribute>
						</DescText>
						<xsl:choose>
							<xsl:when test="count(../../VirtualDisks)>0">
								<Header>
									<xsl:call-template name="VirtualDiskTableHeader">
										<xsl:with-param name="tasks" select="$showtasks"/>
									</xsl:call-template>
								</Header>
								<xsl:for-each select="../../VirtualDisks/DCStorageObject">
									<xsl:call-template name="VirtualDiskTableRows">
										<xsl:with-param name="tasks" select="$showtasks"/>
										<xsl:with-param name="caller">/servlet/DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin!ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>!help=cnprin</xsl:with-param>
									</xsl:call-template>
								</xsl:for-each>
							</xsl:when>
							<xsl:otherwise>
								<xsl:if test="$checkAdmin='true'">
									<!--check to see if user had admin rights-->
									<Row>
										<Data type="ustring" name="execute" link="true">
											<xsl:attribute name="display"/>
											<xsl:attribute name="value"><xsl:value-of select="$strNoVD"/></xsl:attribute>
											<xsl:attribute name="href">javascript:callCreate("<xsl:value-of select="../@ControllerName"/>","<xsl:value-of select="/OMA/ControllerOID"/>")</xsl:attribute>
										</Data>
									</Row>
								</xsl:if>
							</xsl:otherwise>
						</xsl:choose>
					</TableData>
				</xsl:if>
			</xsl:if>
			<xsl:if test="count(../../Batteries/DCStorageObject)>0">
				<TableData columnspacing="true">
					<xsl:variable name="showtasks">false</xsl:variable>
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strSubHeader5"/></xsl:attribute>
					</SubHeader>
					<Header>
						<xsl:call-template name="BatteryTableHeader">
							<xsl:with-param name="tasks" select="$showtasks"/>
						</xsl:call-template>
					</Header>
					<xsl:for-each select="../../Batteries/DCStorageObject">
						<xsl:call-template name="BatteryTableRows">
							<xsl:with-param name="tasks" select="$showtasks"/>
						</xsl:call-template>
					</xsl:for-each>
				</TableData>
			</xsl:if>
			<xsl:if test="count(../../Channels/DCStorageObject)>0">
				<TableData columnspacing="true">
					<xsl:variable name="showtasks">false</xsl:variable>
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strSubHeader3"/></xsl:attribute>
					</SubHeader>
					<Header>
						<xsl:call-template name="ChannelTableHeader">
							<xsl:with-param name="tasks" select="$showtasks"/>
						</xsl:call-template>
					</Header>
					<xsl:choose>
						<xsl:when test="substring(../../Channels/DCStorageObject/AttributesMask,26,1)='1'">
							<xsl:for-each select="../../Channels/DCStorageObject[1]">
								<xsl:call-template name="ChannelTableRows">
									<xsl:with-param name="tasks" select="$showtasks"/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:for-each select="../../Channels/DCStorageObject">
								<xsl:call-template name="ChannelTableRows">
									<xsl:with-param name="tasks" select="$showtasks"/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:otherwise>
					</xsl:choose>

				</TableData>
			</xsl:if>
			<xsl:if test="count(../../Enclosures/DCStorageObject)>0">
				<TableData columnspacing="true">
					<xsl:variable name="showtasks">false</xsl:variable>
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strSubHeader4"/></xsl:attribute>
					</SubHeader>
					<Header>
						<xsl:call-template name="EnclosureTableHeader">
							<xsl:with-param name="tasks" select="$showtasks"/>
							<xsl:with-param name="expanded" select="false"/>
						</xsl:call-template>
					</Header>
					<xsl:for-each select="../../Enclosures/DCStorageObject">
						<xsl:call-template name="EnclosureTableRows">
							<xsl:with-param name="tasks" select="$showtasks"/>
							<xsl:with-param name="expanded" select="false"/>
						</xsl:call-template>
					</xsl:for-each>
				</TableData>
			</xsl:if>
		</ComboData>
	</xsl:template>
	<!-- CONTROLLER TABLE -->
	<xsl:template name="ControllerTable">
		<xsl:param name="tasks"/>
		<xsl:param name="nonRaid">
			<xsl:call-template name="IsObjectNonRaid">
				<xsl:with-param name="Mask">
					<xsl:value-of select="AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:param>
	<xsl:param name="ObjID">
		<xsl:call-template name="ModNexus">
			<xsl:with-param name="nexus">
				<xsl:value-of select="Nexus"/>
			</xsl:with-param>
		</xsl:call-template>
        </xsl:param>
		<!-- The current implementation is to have the UI be dynamic in the data it shows.  Only the columns applicable
              to the objects will be displayed.  The CLI will display all columns of data however to ease script parsing. -->
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!--xsl:variable name="isCluster">
			<xsl:if test="substring(AttributesMask,32,1)!='0'">true</xsl:if>
		</xsl:variable-->
		<xsl:variable name="isCluster">
				<xsl:choose>
					<xsl:when test="ClusterMode">
						<!--Make sure Cluster Allowed bit is ON -->
						<xsl:if test="substring(ClusterMode,30,1)!='0'">true</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="substring(AttributesMask,32,1)!='0'">true</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
		</xsl:variable>
		<xsl:variable name="isAlarmPresent">
				<xsl:choose>
					<xsl:when test="AlarmState">
						<xsl:if test="substring(AlarmState,31,1)!='0'">true</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="substring(CurrentMethodMask,30,1)!='0' or substring(CurrentMethodMask,29,1)!='0' or substring(CurrentMethodMask,28,1)!='0'">true</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
		</xsl:variable>


		<Data name="ID" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="GlobalNo"/></xsl:attribute>
		</Data>
		<Data name="Name" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="Name"/></xsl:attribute>
		</Data>
		<Data name="State" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
		</Data>
		<xsl:if test="//FirmwareVer or $dynamicView = 'false' ">
			<Data name="FW" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strFW"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:choose><xsl:when test="FirmwareVer"><xsl:choose><xsl:when test="FirmwareVer = '(null)' "><xsl:value-of select="$strUnknown"/></xsl:when><xsl:otherwise><xsl:value-of select="FirmwareVer"/></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise></xsl:choose></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//RequiredFirmwareVersion or $dynamicView = 'false' ">
			<Data name="FW" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strReqFW"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:choose><xsl:when test="RequiredFirmwareVersion"><xsl:choose><xsl:when test="RequiredFirmwareVersion= '(null)' "><xsl:value-of select="$strUnknown"/></xsl:when><xsl:otherwise><xsl:value-of select="RequiredFirmwareVersion"/></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise></xsl:choose></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//CurrentDriverVersion or $dynamicView = 'false' ">
			<Data name="FW" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strDvr"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:choose><xsl:when test="CurrentDriverVersion"><xsl:choose><xsl:when test="CurrentDriverVersion= '(null)' "><xsl:value-of select="$strUnknown"/></xsl:when><xsl:otherwise><xsl:value-of select="CurrentDriverVersion"/></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise></xsl:choose></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//RequiredDriverVersion or $dynamicView = 'false' ">
			<Data name="FW" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strReqDvr"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:choose><xsl:when test="RequiredDriverVersion"><xsl:choose><xsl:when test="RequiredDriverVersion= '(null)' "><xsl:value-of select="$strUnknown"/></xsl:when><xsl:otherwise><xsl:value-of select="RequiredDriverVersion"/></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise></xsl:choose></xsl:attribute>
			</Data>
		</xsl:if>

		<xsl:if test="//Channels or $dynamicView = 'false' ">
			<Data name="NumChannels" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strNumChannels"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="Channels"/></xsl:attribute>
			</Data>
		</xsl:if>

		<xsl:if test="//RebuildRate or $dynamicView = 'false' ">
			<Data name="RbldRate" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strRebuildRate"/></xsl:attribute>
				<!-- set value -->
				<xsl:attribute name="value">
				<xsl:choose>
				   <xsl:when test="count(RebuildRate)>0">
				      <xsl:choose>
				         <xsl:when test="RebuildRate = '(null)' ">
				            <xsl:value-of select="$strUnknown"/>
				         </xsl:when>
				         <xsl:otherwise>
				            <xsl:value-of select="RebuildRate"/>
				         </xsl:otherwise>
				      </xsl:choose>
				   </xsl:when>
				   <xsl:otherwise>
				      <xsl:value-of select="$strNotApplicable"/>
				   </xsl:otherwise>
				</xsl:choose>
				</xsl:attribute>
				<!-- set rebuild rate unit -->
		      <xsl:choose>
				 <xsl:when test="count(RebuildRate)>0">
				   	    <xsl:choose> 
					       <xsl:when test="RebuildRate != '(null)' ">
        						<xsl:attribute name="unit">%</xsl:attribute>
					       </xsl:when>
					     </xsl:choose>
	                           </xsl:when>
				</xsl:choose>
				</Data>
		</xsl:if>

		<xsl:if test="//BGIRate or $dynamicView = 'false' ">
			<Data name="BGIRate" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strBGIRate"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="BGIRate"/>%</xsl:attribute>
			</Data>
		</xsl:if>

		<xsl:if test="//CheckConsistencyRate or $dynamicView = 'false' ">
			<Data name="CheckConsistencyRate" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strChkConsistencyRate"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="CheckConsistencyRate"/>%</xsl:attribute>
			</Data>
		</xsl:if>

		<xsl:if test="//ReconstructRate or $dynamicView = 'false' ">
			<Data name="ReconstructRate" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strReconstructRate"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ReconstructRate"/>%</xsl:attribute>
			</Data>
		</xsl:if>
           <!-- 6.0 changes to display values on controller information page--> 
           <xsl:if test="//ChangeControllerPropertyMask ">
			<Data name="AbortCc" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strAbortCConError"/></xsl:attribute>
				<xsl:attribute name="value">
                        <xsl:choose>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,20,1)='1'"><xsl:value-of select="$strEnabled"/></xsl:when>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,12,1)='1'"><xsl:value-of select="$strDisabled"/></xsl:when>

                        </xsl:choose> 
                        </xsl:attribute>    
                         
                        
			</Data>
		</xsl:if>
            <xsl:if test="//ChangeControllerPropertyMask ">
			<Data name="CopyBack" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strCopyback"/></xsl:attribute>
				<xsl:attribute name="value">
                        <xsl:choose>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,17,1)='1'"><xsl:value-of select="$strEnabled"/></xsl:when>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,15,1)='1'"><xsl:value-of select="$strDisabled"/></xsl:when>

                        </xsl:choose> 
                        </xsl:attribute>    
                         
                        
			</Data>
		</xsl:if>
             
            <xsl:if test="//ChangeControllerPropertyMask ">
			<Data name="LoadBalancing" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strLoadBalancing"/></xsl:attribute>
				<xsl:attribute name="value">
                        <xsl:choose>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,14,1)='1'"><xsl:value-of select="$strAuto"/></xsl:when>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,13,1)='1'"><xsl:value-of select="$strDisabled"/></xsl:when>

                        </xsl:choose> 
                        </xsl:attribute>    
                         
                        
			</Data>
		</xsl:if>

              <xsl:if test="//ChangeControllerPropertyMask ">
			<Data name="SmartErrorDisk" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strSmarterErrorDisk"/></xsl:attribute>
				<xsl:attribute name="value">
                        <xsl:choose>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,30,1)='1'"><xsl:value-of select="$strEnabled"/></xsl:when>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,29,1)='1'"><xsl:value-of select="$strDisabled"/></xsl:when>

                        </xsl:choose> 
                        </xsl:attribute>    
                         
                        
			</Data>
		</xsl:if>
                
               <xsl:if test="substring(/OMA/Channels/DCStorageObject[1]/AttributesMask,26,1)='1'">
			<Data name="ClearMultiPath" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strClearMultipath"/></xsl:attribute>
				<xsl:attribute name="value">
                        <xsl:choose>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,32,1)='1'"><xsl:value-of select="$strDetected"/></xsl:when>
                           <xsl:when test="substring(//ChangeControllerPropertyMask,31,1)='1'"><xsl:value-of select="$strCleared"/></xsl:when>

                        </xsl:choose> 
                        </xsl:attribute>    
                         
                        
			</Data>
		</xsl:if>
  <!--6.0 changes over -->
 


		<xsl:if test="$isAlarmPresent='true' or dynamicView = 'false' ">
			<Data name="Alarm" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strAlarmState"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="AlarmState">
						<xsl:attribute name="value">
							<xsl:call-template name="GetAlarmState"><xsl:with-param name="state"><xsl:value-of select="AlarmState"/></xsl:with-param></xsl:call-template>									</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value">
							<xsl:call-template name="GetControllerAlarm"><xsl:with-param name="MethodValue"><xsl:value-of select="CurrentMethodMask"/></xsl:with-param></xsl:call-template>							</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		</xsl:if>

		<xsl:if test="$isCluster='true' or $dynamicView = 'false'">
			<Data name="ClusterMode" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strClusterMode"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="ClusterMode">
						<xsl:attribute name="value">
							<xsl:call-template name="GetClusterMode"><xsl:with-param name="mode"><xsl:value-of select="ClusterMode"/></xsl:with-param></xsl:call-template>
						</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		</xsl:if>

		<xsl:if test="TargetID or $dynamicView = 'false' ">
			<Data name="ScsiTgId" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strScsiTgId"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="TargetID"><xsl:value-of select="TargetID"/></xsl:when>
						<xsl:otherwise>	<xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</xsl:if>

		<xsl:if test="//CacheSize or $dynamicView = 'false' ">
			<Data name="CacheSize" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strCacheSize"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="CacheSize"/> MB</xsl:attribute>
			</Data>
		</xsl:if>

		<xsl:if test="//PatrolReadMode or $dynamicView = 'false' ">
			<Data name="PatReadMode" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strPatrolReadMode"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:call-template name="GetPatrolReadMode"><xsl:with-param name="mode"><xsl:value-of select="PatrolReadMode"/></xsl:with-param></xsl:call-template>
				</xsl:attribute>
			</Data>
		</xsl:if>

		<xsl:if test="//PatrolReadState or $dynamicView = 'false' ">
			<Data name="PatReadState" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strPatrolReadState"/></xsl:attribute>
				<xsl:attribute name="value">
							<xsl:call-template name="GetPatrolReadState"><xsl:with-param name="state"><xsl:value-of select="PatrolReadState"/></xsl:with-param></xsl:call-template>
				</xsl:attribute>
			</Data>
		</xsl:if>

		<!--CLI only-->
		<!--xsl:if test="//PatrolReadRate or $dynamicView = 'false' ">
			<Data name="PatReadRate" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strPatrolReadRate"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="PatrolReadRate"/>%</xsl:attribute>
			</Data>
		</xsl:if-->

		<xsl:if test="//PatrolReadIterations or $dynamicView = 'false' ">
			<Data name="PatReadIterations" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strPatrolReadIterations"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="PatrolReadIterations"/></xsl:attribute>
			</Data>
		</xsl:if>

		<!-- var used for hiding tasks menu option -->
		<xsl:variable name="isEmpty">
			<xsl:call-template name="IsCurrentMethodMaskEmpty">
				<xsl:with-param name="Mask">
					<xsl:value-of select="CurrentMethodMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:if test="$tasks='true'">
			<xsl:choose>
				<!--check to see if methods even exist -->
				<xsl:when test="$isEmpty='0'">
					<!-- currentmethod mask isn't empty -->
					<Data name="CtrlTasks" type="select">
						<xsl:attribute name="display"><xsl:value-of select="$strCtrlTasks"/></xsl:attribute>
						<Choice returnvalue="-" default="true">
							<xsl:attribute name="value"><xsl:value-of select="$strSelectTask"/></xsl:attribute>
						</Choice>
						<xsl:if test="string-length(MasterMethodMask) = 32">
                                                                <xsl:call-template name="for-loop-list-box">
								<xsl:with-param name="Mask" select="CurrentMethodMask"/>
								<xsl:with-param name="templateName" select="5"/>
							</xsl:call-template>

						</xsl:if>
					</Data>
					<Data type="button">
							 <xsl:attribute name="href">javascript:onExecute(\"<xsl:value-of select="Name"/>\",\"<xsl:value-of select="$ObjID"/>\");</xsl:attribute>
							 <xsl:attribute name="value"><xsl:value-of select="$strExecute"/></xsl:attribute>
							  <xsl:attribute name="tablebutton">true</xsl:attribute>
							<!-- The above property should be set for the table button to get rid of white spaces on the edges -->
						</Data>
				</xsl:when>
				<xsl:otherwise>
					<!-- current methodmask is empty -->
					<Data value="tasks" type="select" boxwidth="width:400px">
						<xsl:attribute name="display"><xsl:value-of select="$strCtrlTasks"/></xsl:attribute>
						<xsl:attribute name="name">Ctrltasks<xsl:value-of select="ObjID"/></xsl:attribute>
						<Choice returnvalue="" default="true">
							<xsl:attribute name="value"><xsl:value-of select="$strNoTask"/></xsl:attribute>
						</Choice>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
