<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- BATTERY TABLE HEADER -->
	<xsl:template name="BatteryTableHeader">
		<xsl:param name="tasks"/>
	<!-- The current implementation is to have the UI be dynamic in the data it shows.  Only the columns applicable
to the objects will be displayed.  The CLI will display all columns of data however to ease script parsing. -->
	<xsl:variable name="dynamicView">
		<xsl:choose>
			<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
			<xsl:otherwise>true</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<Data name="ID" editable="false" type="ustring" ignoreonweb="true">
		<xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
     <xsl:attribute name="value"><xsl:value-of select="$strID"/></xsl:attribute>
	</Data>
	<Data name="Status" editable="false" type="ustring" align="center">
		<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
		<xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
	</Data>
	<Data name="Name" editable="false" type="ustring" align="center">
		<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
		<xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
	</Data>
	<Data name="State" editable="false" type="ustring" align="left">
		<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
		<xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
	</Data>
	<xsl:if test="//LSIRechargeCount or $dynamicView = 'false'">
		<Data name="RechargeCount" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strRechargeCount"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strRechargeCount"/></xsl:attribute>
		</Data>
	</xsl:if>
	<xsl:if test="//MaxRechargeCount or $dynamicView = 'false'">
		<Data name="MaxRechargeCount" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strMaxRechargeCount"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strMaxRechargeCount"/></xsl:attribute>
		</Data>
	</xsl:if> 
	<xsl:if test="//BatteryCapacityState or $dynamicView = 'false'">
		<Data name="BatteryCapacityState " editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strBatteryCapacityState"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strBatteryCapacityState"/></xsl:attribute>
		</Data>
	</xsl:if>
	<xsl:if test="//BatteryLearnState or $dynamicView = 'false'">
		<Data name="BatteryLearnState" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strBatteryLearnState"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strBatteryLearnState"/></xsl:attribute>
		</Data>
	</xsl:if>
	<xsl:if test="(not(//LearnMode) or //LearnMode != '2') and (//NextLearnCycleTime or $dynamicView = 'false')">
		<Data name="NextLearnCycleTime" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strNextLearnCycleTime"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strNextLearnCycleTime"/></xsl:attribute>
		</Data>
	</xsl:if>
	<xsl:if test="(not(//LearnMode) or //LearnMode != '2') and (//MaxLearnDelay or $dynamicView = 'false')">
		<Data name="MaxLearnDelay" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strMaxLearnDelay"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strMaxLearnDelay"/></xsl:attribute>
		</Data>
	</xsl:if>
	<xsl:if test="//LearnMode">
		<Data name="LearnMode" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strLearnMode"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strLearnMode"/></xsl:attribute>
		</Data>
	</xsl:if>
	</xsl:template>
  
	<!-- BATTERY TABLE ROWS -->
	<xsl:template name="BatteryTableRows">
		<xsl:param name="tasks"/>
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<Row>
			<Data editable="false" type="ustring" ignoreonweb="true">
				<xsl:attribute name="name"><xsl:value-of select="$strID"/><xsl:value-of select="position()"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="BatteryID"/></xsl:attribute>
			</Data>
			<Data editable="false" type="status" align="center">
				<xsl:attribute name="name"><xsl:value-of select="$strStatus"/><xsl:value-of select="position()"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ObjStatus"/></xsl:attribute>
	     </Data>
			<Data editable="false" type="ustring" align="center">
				<xsl:attribute name="name"><xsl:value-of select="$strName"/><xsl:value-of select="position()"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strBattery"/><xsl:value-of select="BatteryID"/></xsl:attribute>
			</Data>
			<Data align="left">
	     	<xsl:attribute name="name"><xsl:value-of select="$strState"/><xsl:value-of select="position()"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of 	select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
			</Data>
			<xsl:if test="//LSIRechargeCount or $dynamicView = 'false'">
				<Data align="center">
					<xsl:attribute name="name"><xsl:value-of select="$strRechargeCount"/><xsl:value-of select="position()"/>	</xsl:attribute>
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="LSIRechargeCount"><xsl:value-of select="LSIRechargeCount"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
						</xsl:choose>
	          </xsl:attribute>
				</Data>
			</xsl:if>
			<xsl:if test="//MaxRechargeCount or $dynamicView = 'false'">
				<Data align="center">
					<xsl:attribute name="name"><xsl:value-of select="$strMaxRechargeCount"/><xsl:value-of select="position()"/>							</xsl:attribute>
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="MaxRechargeCount"><xsl:value-of select="MaxRechargeCount"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
						</xsl:choose>
	          </xsl:attribute>
				</Data>
			</xsl:if>
			<xsl:if test="//BatteryCapacityState or $dynamicView = 'false'">
				<Data align="center">
					<xsl:attribute name="name"><xsl:value-of select="$strBatteryCapacityState"/><xsl:value-of select="position()"/>							</xsl:attribute>
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="BatteryCapacityState">
								<xsl:call-template name="getBtryCapacityState">
									<xsl:with-param name="state"><xsl:value-of select="BatteryCapacityState"/></xsl:with-param>
								</xsl:call-template>								
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
						</xsl:choose>
	          </xsl:attribute>
				</Data>
			</xsl:if>
			<xsl:if test="//BatteryLearnState or $dynamicView = 'false'">
				<Data align="center">
					<xsl:attribute name="name"><xsl:value-of select="$strBatteryLearnState"/><xsl:value-of select="position()"/>							</xsl:attribute>
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="BatteryLearnState">
								<xsl:call-template name="getBtryLearnState">
									<xsl:with-param name="state"><xsl:value-of select="BatteryLearnState"/></xsl:with-param>
								</xsl:call-template>								
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
						</xsl:choose>
	          </xsl:attribute>
				</Data>
			</xsl:if>
			<xsl:if test="(not(//LearnMode) or //LearnMode != '2') and (//NextLearnCycleTime or $dynamicView = 'false')">
				<Data align="center">
					<xsl:attribute name="name"><xsl:value-of select="$strNextLearnCycleTime"/><xsl:value-of select="position()"/>							</xsl:attribute>
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="NextLearnCycleTime">
									<xsl:call-template name="formatHoursToDays">
										<xsl:with-param name="time"><xsl:value-of select="NextLearnCycleTime"/></xsl:with-param>
									</xsl:call-template>									
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
						</xsl:choose>
	          </xsl:attribute>
				</Data>
			</xsl:if>
			<xsl:if test="(not(//LearnMode) or //LearnMode != '2') and (//MaxLearnDelay or $dynamicView = 'false')">
				<Data align="center">
					<xsl:attribute name="name"><xsl:value-of select="$strMaxLearnDelay"/><xsl:value-of select="position()"/>							</xsl:attribute>
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="MaxLearnDelay">
								<xsl:call-template name="formatHoursToDays">
										<xsl:with-param name="time"><xsl:value-of select="MaxLearnDelay"/></xsl:with-param>
								</xsl:call-template>								
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
						</xsl:choose>
	          </xsl:attribute>
				</Data>
			</xsl:if>
			<xsl:if test="//LearnMode">
				<Data align="center">
					<xsl:attribute name="name"><xsl:value-of select="$strLearnMode"/><xsl:value-of select="position()"/>							</xsl:attribute>
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="LearnMode">
								<xsl:call-template name="GetLearnMode">
										<xsl:with-param name="learnMode"><xsl:value-of select="LearnMode"/></xsl:with-param>
								</xsl:call-template>								
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
						</xsl:choose>
	          			</xsl:attribute>
				</Data>
			</xsl:if>
		</Row>
   </xsl:template>
   
	<xsl:template name="BatteryList">
		<xsl:param name="tasks"/>
		<xsl:param name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus">
					<xsl:value-of select="Nexus"/>
				</xsl:with-param>
			</xsl:call-template>
     </xsl:param>
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="isEmpty">
			<xsl:call-template name="IsMasterMethodMaskEmpty">
				<xsl:with-param name="Mask">
					<xsl:value-of select="MasterMethodMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="isCMMEmpty">
			<xsl:call-template name="IsCurrentMethodMaskEmpty">
				<xsl:with-param name="Mask">
					<xsl:value-of select="CurrentMethodMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<Data name="BName" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strBattery"/><xsl:value-of select="BatteryID"/></xsl:attribute>
		</Data>
		<Data name="State" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
		</Data>
	   <xsl:if test="//LSIRechargeCount or $dynamicView = 'false'">
			<Data name="Recharge" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strRechargeCount"/></xsl:attribute>
				<xsl:attribute name="value">
	                		<xsl:choose>
						<xsl:when test="LSIRechargeCount"><xsl:value-of select="LSIRechargeCount"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
     </xsl:if>
		<xsl:if test="//MaxRechargeCount or $dynamicView = 'false'">
			<Data name="MaxRecharge" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strMaxRechargeCount"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="MaxRechargeCount"><xsl:value-of select="MaxRechargeCount"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//BatteryCapacityState or $dynamicView = 'false'">
			<Data name="BatteryCapacityStatus" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strBatteryCapacityState"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="BatteryCapacityState">
							<xsl:call-template name="getBtryCapacityState">
								<xsl:with-param name="state"><xsl:value-of select="BatteryCapacityState"/></xsl:with-param>
							</xsl:call-template>							
							</xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//BatteryLearnState or $dynamicView = 'false'">
			<Data name="BatteryLearnState" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strBatteryLearnState"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="BatteryLearnState">
							<xsl:call-template name="getBtryLearnState">
								<xsl:with-param name="state"><xsl:value-of select="BatteryLearnState"/></xsl:with-param>
							</xsl:call-template>						
						</xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="(not(//LearnMode) or //LearnMode != '2') and (//NextLearnCycleTime or $dynamicView = 'false')">
			<Data name="BatteryLearnState" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strNextLearnCycleTime"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
							<xsl:when test="NextLearnCycleTime">
									<xsl:call-template name="formatHoursToDays">
										<xsl:with-param name="time"><xsl:value-of select="NextLearnCycleTime"/></xsl:with-param>
									</xsl:call-template>									
							</xsl:when>
						<xsl:when test="NextLearnCycleTime"><xsl:value-of select="NextLearnCycleTime"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="(not(//LearnMode) or //LearnMode != '2') and (//MaxLearnDelay or $dynamicView = 'false')">
			<Data name="MaxLearnDelay" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strMaxLearnDelay"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
							<xsl:when test="MaxLearnDelay">
								<xsl:call-template name="formatHoursToDays">
										<xsl:with-param name="time"><xsl:value-of select="MaxLearnDelay"/></xsl:with-param>
								</xsl:call-template>								
							</xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//LearnMode">
			<Data name="LearnMode" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="'Learn Mode'"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="LearnMode">
							<xsl:call-template name="GetLearnMode">
								<xsl:with-param name="learnMode"><xsl:value-of select="LearnMode"/></xsl:with-param>
							</xsl:call-template>								
						</xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
					</xsl:choose>
	      		</xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="$tasks='true'">
			<xsl:choose>
				<!--check if current methods are available -->
				<xsl:when test="$isCMMEmpty='0'">
					<Data value="tasks" columnspacing="true" type="select" ignoreoncli="true">
						<xsl:attribute name="display"><xsl:value-of select="$strBatteryTasks"/></xsl:attribute>
						<xsl:attribute name="name">BatteryTasks<xsl:value-of select="$ObjID"/></xsl:attribute>
						<Choice returnvalue="-" default="true">
							<xsl:attribute name="value"><xsl:value-of select="$strSelectTask"/></xsl:attribute>
						</Choice>
						<xsl:call-template name="for-loop-list-box">
							<xsl:with-param name="Mask" select="CurrentMethodMask"/>
							<xsl:with-param name="templateName" select="6"/>
						</xsl:call-template>
					</Data>		
					<Data type="button">
					 		 <xsl:attribute name="href">javascript:onExecute(\"<xsl:value-of select="$ObjID"/>\");</xsl:attribute>
							 <xsl:attribute name="value"><xsl:value-of select="$strExecute"/></xsl:attribute>
							  <xsl:attribute name="tablebutton">true</xsl:attribute> 
    						  <!-- The above property should be set for the table button to get rid of white spaces on the edges -->
						</Data>
				</xsl:when>
				<xsl:otherwise>
					<!-- current methodmask is empty -->
					<!-- make sure to keep this code even if Master Method Mask is empty. This is a usability requirement-->
					<Data value="tasks" columnspacing="true" type="select" ignoreoncli="true">
						<xsl:attribute name="display"><xsl:value-of select="$strBatteryTasks"/></xsl:attribute>
						<xsl:attribute name="name">Batterytasks<xsl:value-of select="$ObjID"/></xsl:attribute>
						<Choice returnvalue="" default="true">
							<xsl:attribute name="value"><xsl:value-of select="$strNoTask"/></xsl:attribute>
						</Choice>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
