<!-- This is the XSL to render the Array Disks belonging to a Virtual Disk page.  The associated web plugin is the ArrayWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="Utils.xsl"/>
	<xsl:import href="adtbl.xsl"/>
	<xsl:template match="OMA">
		<script language="javascript">
      			function reloadPage()
      			{
          			document.location.href = top.gnv.appendVID(document.URL);
      			}
                       
                        
    		</script>
		<DataArea>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitle1Part1"/><xsl:value-of select="VirtualDiskName"/><xsl:value-of select="$strTitle1Part2"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<!-- The refresh button cannot use the below javascript to perform the refresh.  The issue is the  javascript calls the last webplug which was called
			      to render this page.  The problem is that the page can be rendered by two webplugins: the info webplugin and the action execute web plugin.
			      If the action execute webplugin was the last webplugin to render the page, pressing refresh would cause that action to be re-executed. -->
				<!--Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href"></xsl:attribute>
					<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
				</Data-->
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">javascript:reloadPage();</xsl:attribute>
				</Data>
			</CustomButton>
			<xsl:choose>
				<xsl:when test="count(Span)>0">
					<!-- The virtual disk consists of spans, so display each of them -->
					<xsl:for-each select="Span">
						<xsl:call-template name="Table">
							<xsl:with-param name="Display">
								<xsl:value-of select="$strSpanTitlePart1"/>
								<xsl:value-of select="@SpanNumber"/>
								<xsl:value-of select="$strSpanTitlePart2"/>
							</xsl:with-param>
							<xsl:with-param name="filterOutDHS">true</xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="Table">
						<xsl:with-param name="Display">
							<xsl:value-of select="$strArrayDisksTitle"/>
						</xsl:with-param>
						<xsl:with-param name="filterOutDHS">true</xsl:with-param>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="DedicatedHotSpares">
				<xsl:for-each select="DedicatedHotSpares">
					<xsl:call-template name="Table">
						<xsl:with-param name="Display">
							<xsl:value-of select="$strDHSTitle"/>
						</xsl:with-param>
						<xsl:with-param name="filterOutDHS">false</xsl:with-param>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if>
			<!-- auto refresh code for both with and without span-->
			<xsl:if test="//ArrayDisks/DCStorageObject/Progress">
                    		<HTMLData>
                           		<script language="Javascript">
                               			<!--refresh page every 30 secs when atleast one adisk object has Progress property asscoiated with it-->
                                        	setTimeout("reloadPage()",30000) ;
                             		</script>
                      		</HTMLData>
			</xsl:if>
			<BottomCustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
					<xsl:choose>
						<xsl:when test="BackTo = '' or BackTo = ' ' or BackTo = 'null'">
							<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;help=vdprin</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
					<xsl:attribute name="href"><xsl:value-of select="translate(BackTo,'!','&amp;')"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
                                        
				</Data>
			</BottomCustomButton>
                        <HiddenTable>
				<Data>
					<xsl:attribute name="name">BackTo</xsl:attribute>
					<xsl:attribute name="returnvalue"></xsl:attribute>
				</Data>
			</HiddenTable>
		</DataArea>
	</xsl:template>
	<xsl:template name="Table">
		<xsl:param name="Display"/>
		<xsl:param name="filterOutDHS"/>
		<TableData name="{$Display}" display="{$Display}" columnspacing="true">
			<xsl:variable name="showtasks">false</xsl:variable>

			<SubHeader display="{$Display}"/>
			<xsl:choose>
				<xsl:when test="ArrayDisks/DCStorageObject">
					<Header>
						<xsl:call-template name="ArrayDiskTableHeader">
							<xsl:with-param name="tasks">true</xsl:with-param>
							<xsl:with-param name="expanded">true</xsl:with-param>
							<xsl:with-param name="foreignConfig"><xsl:value-of select="/OMA/ForeignConfig"/></xsl:with-param>
                                                        <xsl:with-param name="IsDHS">
                                                        <xsl:choose>
                                                             <xsl:when test="$filterOutDHS='false'">true</xsl:when>
                                                             <xsl:otherwise>false</xsl:otherwise>
                                                         </xsl:choose>                                                                        
                                                        </xsl:with-param>
						</xsl:call-template>
					</Header>
					<xsl:for-each select="ArrayDisks/DCStorageObject">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:sort select="TargetID" data-type="number" order="ascending"/>
						<xsl:variable name="isDHS">
							<xsl:choose>
								<xsl:when test="$filterOutDHS = 'true'">
									<!-- check to see if current disk is DHS -->
									<xsl:call-template name="IsDedicatedHotSpare">
										<xsl:with-param name="AttributesMask">
											<xsl:value-of select="AttributesMask"/>
										</xsl:with-param>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>0</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:if test="$isDHS='0'">
							<xsl:call-template name="ArrayDiskTableRows">
								<xsl:with-param name="tasks">true</xsl:with-param>
								<xsl:with-param name="expanded">true</xsl:with-param>
								<xsl:with-param name="VDMember">true</xsl:with-param>
								<xsl:with-param name="foreignConfig"><xsl:value-of select="/OMA/ForeignConfig"/></xsl:with-param>
                                                                <xsl:with-param name="IsDHS">
                                                                <xsl:choose>
                                                                      <xsl:when test="$filterOutDHS='false'">true</xsl:when>
                                                                      <xsl:otherwise>false</xsl:otherwise>
                                                                </xsl:choose> 
                                                                </xsl:with-param>
							</xsl:call-template>
						</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<Row>
						<Data type="ustring" columnspacing="true">
							<xsl:attribute name="value"><xsl:value-of select="$strNoDisks"/></xsl:attribute>
						</Data>
					</Row>
				</xsl:otherwise>
			</xsl:choose>
		</TableData>
	</xsl:template>
</xsl:stylesheet>
