<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	<!-- The adtbl.xsl is used to display a table of array and hard disks with their associated properties. -->
	<!-- This should be used by all webpages which are required to display a table of arrayand hard disks.  -->
	<!-- Having this code in a common file allows for a central location to make updates and add new  -->
	<!-- new fields for array disks which will then be displayed by all web pages as well as the CLI. -->
	<!-- This file is broken down into two main xsl templates.  The TABLE HEADER and the TABLE ROWS. -->
	<!-- Array DISK TABLE HEADER -->
	<xsl:template name="ArrayDiskTableHeader">
		<xsl:param name="tasks"/>
		<!-- tasks should be either 'true' or 'false' to indicate whether to display the drop-down menu of tasks-->
		<xsl:param name="expanded"/>
    <xsl:param name="IsDHS"/>
		<xsl:param name="foreignConfig">false</xsl:param>
		<xsl:call-template name="scripts"/>
		<!-- The current implementation is to have the UI be dynamic in the data it shows.  Only the columns applicable
to the objects will be displayed.  The CLI will display all columns of data however to ease script parsing. -->
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="nonRaid">
			<xsl:call-template name="IsObjectNonRaid">
				<xsl:with-param name="Mask">
					<xsl:value-of select="AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
	
		<Data name="Id" columnspacing="true" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strID"/></xsl:attribute>
		</Data>
		<Data name="Status" columnspacing="true" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
		</Data>
		<Data name="Name" columnspacing="true" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
		</Data>
		<xsl:choose>
			<xsl:when test="$foreignConfig='true'">
				<Data name="State" columnspacing="true" editable="false" type="ustring" align="left">
					<xsl:attribute name="display"><xsl:value-of select="$strStateBeforeImport"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strStateBeforeImport"/></xsl:attribute>
				</Data>
				<Data name="State" columnspacing="true" editable="false" type="ustring" align="left">
					<xsl:attribute name="display"><xsl:value-of select="$strStateAfterImport"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strStateAfterImport"/></xsl:attribute>
				</Data>
			</xsl:when>
			<xsl:otherwise>
		              <Data name="State" columnspacing="true" editable="false" type="ustring" align="left">
			           <xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
			           <xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
		              </Data>
			</xsl:otherwise>
		</xsl:choose>
		<Data name="PredFailure" columnspacing="true" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strPredFailure"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strPredFailure"/></xsl:attribute>
		</Data>
                <HiddenTable>
			<Data >
			<xsl:attribute name="name">BackTo</xsl:attribute>
			<xsl:attribute name="returnvalue"></xsl:attribute>
			</Data>
                               
		</HiddenTable>
		<!-- isEmpty var used for hiding tasks menu option -->
		<xsl:variable name="isEmpty">
			<xsl:call-template name="IsCurrentMethodMaskEmpty">
				<xsl:with-param name="Mask">
					<xsl:value-of select="CurrentMethodMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
			<xsl:if test="$tasks='true'">
				<Data name="taskslist" columnspacing="true" editable="false" type="ustring" ignoreoncli="true">
					<xsl:attribute name="display"><xsl:value-of select="$strTasks"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strTasks"/></xsl:attribute>
				</Data>
				<Data name="exbut" columnspacing="true" editable="false" type="ustring" ignoreoncli="true">
					<xsl:attribute name="display"><!--XLATESTART-->Execute<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><!--XLATESTART--><!--XLATESTOP--></xsl:attribute>
				</Data>
			</xsl:if>
		<xsl:if test="//Progress or /OMA/@cli = 'true'">
			<!-- See if any VDisk has a progress.  If so, show the header for the table -->
			<Data name="Progress" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strProgress"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strProgress"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//BusProtocol or /OMA/@cli = 'true'">
			<!-- See ifany disk has BusProtocol populated.  If so, show the header for the table -->
			<Data name="BusProtocol" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strType"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strType"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//Length or $dynamicView = 'false' ">
			<!-- Only display this column if any of the objects return the XML -->
			<!--xsl:if test="$expanded='true'"-->
			<Data name="Capacity" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strCapacity"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strCapacity"/></xsl:attribute>
			</Data>
			<!--/xsl:if-->
		</xsl:if>
		<!--xsl:if test="$nonRaid = '0'"-->
		<!-- Removed for DFCT129383 -->
		<xsl:if test="//UsedSpace or $dynamicView = 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="UsedSpace" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strUsedSpace"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strUsedSpace"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//FreeSpace or $dynamicView = 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="FreeSpace" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strFreeSpace"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strFreeSpace"/></xsl:attribute>
			</Data>
		</xsl:if>
		<!--/xsl:if-->
		<!-- Loop through each array disk -->
                <xsl:variable name="showHotspareTitle">
                <xsl:choose>
                <xsl:when test="$IsDHS='true' and $foreignConfig='true'"></xsl:when>
                <xsl:otherwise>
                    <xsl:for-each select="//ArrayDisks/DCStorageObject">
				<!-- Just a sanity check to make sure the master method mask xml is there for this object before checking its value -->
				<xsl:if test="AttributesMask">
					<xsl:if test="substring(AttributesMask,23,1 )= '0' or $dynamicView = 'false' ">true</xsl:if>
					<!--xsl:if test="substring(MasterMethodMask, 27, 1) = '1' or substring(MasterMethodMask, 28, 1) = '1'  or $dynamicView = 'false' ">true</xsl:if-->
				</xsl:if>
			</xsl:for-each>
                </xsl:otherwise>
                </xsl:choose>
                </xsl:variable>
		
		<!-- Using the master method mask to determine if ANY disk is capable of being a hotspare. -->
		<!-- Check to see if either the set hotspare or unset hotspare bits are set (one should be set -->
		<!-- at all times if the disk is capable of being a hotspare). -->
		<xsl:if test="$showHotspareTitle != ''">
			<Data name="Spare" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strSpare"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strSpare"/></xsl:attribute>
			</Data>
		</xsl:if>
		<!--xsl:if test="$expanded='true'"-->
		<Data name="Vendor" columnspacing="true" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strVendorID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strVendorID"/></xsl:attribute>
		</Data>
		<Data name="ProductID" columnspacing="true" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strProductID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strProductID"/></xsl:attribute>
		</Data>
		<Data name="Rev" columnspacing="true" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strRevision"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strRevision"/></xsl:attribute>
		</Data>
		<xsl:if test="//DeviceSerialNumber or $dynamicView = 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="Serial" columnspacing="true" editable="false" type="ustring" align="left">
				<xsl:attribute name="display"><xsl:value-of select="$strSerial"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strSerial"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//NegotiatedSpeed or $dynamicView = 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="NegotiatedSpeed " columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strNegotiatedSpeed"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strNegotiatedSpeed"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//CapableSpeed or $dynamicView = 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="CapableSpeed " columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strCapableSpeed"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strCapableSpeed"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//ManufactureDay or $dynamicView = 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="ManufactureDay" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strManufactureDay"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strManufactureDay"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//ManufactureWeek or $dynamicView = 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="ManufactureWeek" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strManufactureWeek"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strManufactureWeek"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//ManufactureYear or $dynamicView = 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="ManufactureYear" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strManufactureYear"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strManufactureYear"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//SASAddress or $dynamicView = 'false'">
			<!-- Only display this column if any of the objects return the XML -->
			<Data name="SASAddress" columnspacing="true" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strSASAddress"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strSASAddress"/></xsl:attribute>
			</Data>
		</xsl:if>
	</xsl:template>
	<!-- ARRAY DISK TABLE ROWS -->
	<xsl:template name="ArrayDiskTableRows">  
		<xsl:param name="tasks"/>
		<xsl:param name="expanded"/>
		<xsl:param name="VDMember">false</xsl:param>
		<xsl:param name="foreignConfig">false</xsl:param>
                 <xsl:param name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus">
					<xsl:value-of select="Nexus"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:param>
                <xsl:param name="IsDHS"/>
		<xsl:variable name="showHotspareTitle">
                <xsl:choose>
                <xsl:when test="$IsDHS='true' and $foreignConfig='true'"></xsl:when>
                <xsl:otherwise>
                        <xsl:for-each select="//ArrayDisks/DCStorageObject">
				        <xsl:if test="AttributesMask"><xsl:if test="substring(AttributesMask,23,1 )= '0'">true</xsl:if></xsl:if>
			</xsl:for-each>
                </xsl:otherwise>
                </xsl:choose>
                </xsl:variable>

		<!-- Check if we need to give a warning to assign GHS -->
		<xsl:variable name="isGHSWarning">
			<xsl:choose>
				<xsl:when test="substring(/OMA/ArrayDisks/@ControllerAttributeMask,13,1)='1'">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
				
		<xsl:call-template name="scripts"/>
		<!-- The current implementation is to have the UI be dynamic in the data it shows.  Only the columns applicable
              to the objects will be displayed.  The CLI will display all columns of data however to ease script parsing. -->
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="nonRaid">
			<xsl:call-template name="IsObjectNonRaid">
				<xsl:with-param name="Mask">
					<xsl:value-of select="AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="IsSASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol">
					<xsl:value-of select="BusProtocol"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="IsDiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask">
					<xsl:value-of select="AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="PredFailure">
			<xsl:call-template name="SmartAlertDetected">
				<xsl:with-param name="AttributesMask">
					<xsl:value-of select="AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="ADID">
			<xsl:choose>
				<xsl:when test="$IsSASorSATA='1' and $IsDiskInEnclosure='1'">
					<xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<Row height="30px">
			<Data type="ustring" columnspacing="true" align="center" ignoreonweb="true">
						<xsl:attribute name="value"><xsl:value-of select="$ADID"/></xsl:attribute>
			</Data>
			<Data type="status" columnspacing="true" align="center">
				<xsl:attribute name="value"><xsl:value-of select="ObjStatus"/></xsl:attribute>
			</Data>
			<Data name="Name" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
				<xsl:choose>
					<!-- check for ad vs hd -->
					<xsl:when test="$nonRaid = '1' ">
						<xsl:attribute name="value"><xsl:value-of select="$strHDName"/><xsl:value-of select="$ADID"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$strADName"/><xsl:value-of select="$ADID"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
			<xsl:choose>
				<xsl:when test="$foreignConfig = 'true'">
					<Data name="State" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
						<xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</Data>
					<Data name="State" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
						<xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="PDAfterImportState"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
			               <Data name="State" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
			   	             <xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
			               </Data>
				</xsl:otherwise>
			</xsl:choose>
			<Data name="PredFailure" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
				<xsl:choose>
					<!-- check for ad vs hd -->
					<xsl:when test="$PredFailure = '1' ">
						<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
			<!-- isEmpty var used for hiding tasks menu option 
			     2nd redefinition. The first definition above seems to not be picked up. -->
			<xsl:variable name="isEmpty">
				<xsl:call-template name="IsCurrentMethodMaskEmpty">
					<xsl:with-param name="Mask">
						<xsl:value-of select="CurrentMethodMask"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="$tasks='true'">
				<!--check to see if methods even exist -->
				<xsl:choose>
					<xsl:when test="$isEmpty='0'">
						<!-- currentmethod mask isn't empty -->
						<Data value="tasks" columnspacing="true" display="Array Disks Tasks" type="select" ignoreoncli="true" boxwidth="width:340px">
							<xsl:attribute name="display"><xsl:value-of select="$strADTasks"/></xsl:attribute>
							<xsl:attribute name="name">ADtasks<xsl:value-of select="$ObjID"/></xsl:attribute>
							<Choice returnvalue="-" default="true">
								<xsl:attribute name="value"><xsl:value-of select="$strSelectTask"/></xsl:attribute>
							</Choice>
							<xsl:call-template name="for-loop-list-box">
								<xsl:with-param name="Mask" select="CurrentMethodMask"/>
								<xsl:with-param name="templateName" select="10"/>
							</xsl:call-template>
						</Data>
						<Data type="button">
							<xsl:attribute name="display"><xsl:value-of select="$strExecute"/></xsl:attribute>
							 <xsl:attribute name="id"><xsl:value-of select="$strExecute"/></xsl:attribute>
							 <xsl:attribute name="href">javascript:onExecute(\"Physical Disk <xsl:value-of select="$ADID"/>\",\"<xsl:value-of select="$ObjID"/>\");</xsl:attribute>
							 <xsl:attribute name="tablebutton">true</xsl:attribute> 
							<!-- The above property should be set for the table button to get rid of white spaces on the edges -->
						</Data>			
					</xsl:when>
					<xsl:otherwise>
						<!-- currentmethod mask is empty -->
						<Data value="tasks" columnspacing="true" type="select" ignoreoncli="true" boxwidth="width:340px">
							<xsl:attribute name="display"><xsl:value-of select="$strADTasks"/></xsl:attribute>
							<xsl:attribute name="name">ADtasks<xsl:value-of select="$ObjID"/></xsl:attribute>
							<Choice returnvalue="" default="true">
								<xsl:attribute name="value"><xsl:value-of select="$strNoTask"/></xsl:attribute>
							</Choice>
						</Data>
						<Data type="ustring" columnspacing="true" name="execute" link="false">
							<xsl:attribute name="value"></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//Progress or /OMA/@cli = 'true'">
				<xsl:choose>
					<xsl:when test="Progress">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="Progress"/><xsl:value-of select="$strPercComp"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:when test="/OMA/@cli = 'true'">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"/>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//BusProtocol or /OMA/@cli = 'true'">
				<xsl:choose>
					<xsl:when test="BusProtocol">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:call-template name="GetBusProtocol"><xsl:with-param name="Bus"><xsl:value-of select="BusProtocol"/></xsl:with-param></xsl:call-template></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<!-- ************************************* -->
			<!-- CAPACITY (LENGTH) COLUMN -->
			<xsl:if test="//Length or $dynamicView = 'false' ">
				<!-- Check to see if ANY of the objects have the XML tag.  If so, then the header will be displayed, so populate the value here -->
				<xsl:choose>
					<!-- The column will be displayed so check to see if THIS object has the XML tag. -->
					<xsl:when test="Length">
						<!-- The tag exists, so display the value -->
						<!--xsl:if test="$expanded='true'"-->
						<xsl:choose>
							<xsl:when test="/OMA/@cli='true'">
								<!-- CLI Versions of the length data (displays bytes as well as GB)  -->
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="Length"/></xsl:with-param></xsl:call-template> GB (<xsl:value-of select="Length"/> bytes)</xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:otherwise>
								<!-- Web Versions of the length data (ONLY displays GB) -->
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="Length"/></xsl:with-param></xsl:call-template><xsl:value-of select="$strGB"/></xsl:attribute>
								</Data>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strUnavaliable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<!-- ***************************** -->
			<!-- USED SPACE COLUMN -->
			<xsl:if test="//UsedSpace or $dynamicView = 'false' ">
				<xsl:choose>
					<xsl:when test="/OMA/@cli='true'">
						<!-- CLI Versions of the length data (displays bytes as well as GB)  -->
						<xsl:choose>
							<xsl:when test="UsedSpace">
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="UsedSpace"/></xsl:with-param></xsl:call-template> GB (<xsl:value-of select="UsedSpace"/> bytes)</xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:when test="$nonRaid != '0'">
							<!-- Changed for DFCT129383 -->
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
								</Data>
							</xsl:when>							
							<xsl:otherwise>
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:value-of select="$strUnavaliable"/></xsl:attribute>
								</Data>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<!-- Web Versions of the length data (ONLY displays GB) -->
						<xsl:choose>
							<xsl:when test="UsedSpace">
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="UsedSpace"/></xsl:with-param></xsl:call-template><xsl:value-of select="$strGB"/></xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:when test="$nonRaid != '0'">
							<!-- Changed for DFCT129383 -->
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:otherwise>
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:value-of select="$strUnavaliable"/></xsl:attribute>
								</Data>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<!--/xsl:if-->
			<!-- ***************************** -->
			<!-- FREE SPACE COLUMN -->
			<xsl:if test="//FreeSpace or $dynamicView = 'false'">
				<xsl:choose>
					<xsl:when test="/OMA/@cli='true'">
						<!-- CLI Versions of the length data (displays bytes as well as GB)  -->
						<xsl:choose>
							<xsl:when test="FreeSpace">
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="FreeSpace"/></xsl:with-param></xsl:call-template> GB (<xsl:value-of select="FreeSpace"/> bytes)</xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:when test="$nonRaid != '0'">
								<!-- Changed for DFCT129383 -->
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:otherwise>
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:value-of select="$strUnavaliable"/></xsl:attribute>
								</Data>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<!-- Web Versions of the length data (ONLY displays GB) -->
						<xsl:choose>
							<xsl:when test="FreeSpace">
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="FreeSpace"/></xsl:with-param></xsl:call-template><xsl:value-of select="$strGB"/></xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:when test="$nonRaid != '0'">
								<!-- Changed for DFCT129383 -->
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:otherwise>
								<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
									<xsl:attribute name="value"><xsl:value-of select="$strUnavaliable"/></xsl:attribute>
								</Data>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="$showHotspareTitle != ''  or $dynamicView = 'false' ">
				<!-- Using the attributes mask to determine if THIS disk is capable of being a hotspare. -->
				<xsl:choose>
					<xsl:when test=" $nonRaid = '1' ">
						<!-- This takes care of the case when the disk is not capable of being a hotspare at any time.  i.e. Non-RAID -->
						<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="center">
							<xsl:attribute name="value"><xsl:call-template name="GetSpareInfoForArrayDisk"><xsl:with-param name="AttribsMask"><xsl:value-of select="AttributesMask"/></xsl:with-param></xsl:call-template></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
				<xsl:attribute name="value"><xsl:value-of select="Vendor"/></xsl:attribute>
			</Data>
			<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
				<xsl:attribute name="value"><xsl:value-of select="ProductID"/></xsl:attribute>
			</Data>
			<Data name="Test" columnspacing="true" editable="false" type="ustring" display="Test" align="left">
				<xsl:attribute name="value"><xsl:value-of select="Revision"/></xsl:attribute>
			</Data>
			<xsl:if test="//DeviceSerialNumber or /OMA/@cli = 'true'">
				<xsl:choose>
					<xsl:when test="DeviceSerialNumber">
						<Data type="ustring" align="left">
							<xsl:attribute name="value"><xsl:value-of select="DeviceSerialNumber"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//NegotiatedSpeed or /OMA/@cli = 'true'">
				<xsl:choose>
					<xsl:when test="NegotiatedSpeed and NegotiatedSpeed>0">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="NegotiatedSpeed"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//CapableSpeed or /OMA/@cli = 'true'">
				<xsl:choose>
					<xsl:when test="CapableSpeed and CapableSpeed>0">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="CapableSpeed"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//ManufactureDay or /OMA/@cli = 'true'">
				<xsl:choose>
					<xsl:when test="ManufactureDay">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="ManufactureDay"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//ManufactureWeek or /OMA/@cli = 'true'">
				<xsl:choose>
					<xsl:when test="ManufactureWeek">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="ManufactureWeek"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//ManufactureYear or /OMA/@cli = 'true'">
				<xsl:choose>
					<xsl:when test="ManufactureYear">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="ManufactureYear"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//SASAddress or /OMA/@cli = 'true'">
				<xsl:choose>
					<xsl:when test="SASAddress">
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="SASAddress"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="ustring" align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</Row>
               
		<script language="javascript">
			function onExecute(name, oid) {
				var ADtasks = "ADtasks" + oid;
				var action = document.getElementById(ADtasks).value;
				var fromVDpage = '<xsl:value-of select="$VDMember"/>';
				var ADExecuteUrl = "/servlet/SubmitForm?plugin=com.dell.sm.webplugins.ADExecuteActionWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;ADiskOID=" + oid + "&amp;ADiskName=" + name + "&amp;Action="+ action + "&amp;help=adprin";
				var ADConfirmUrl = "/servlet/DataArea?plugin=com.dell.sm.webplugins.ConfirmADActionWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;ADiskOID=" + oid + "&amp;ADiskName=" + name + "&amp;Action="+ action;

		         	// Actions
		         	// 1 - blink
         			// 2 - unblink
         			// 4 - diagnostics
         			// 8 - cancel diags
         			// 16 - assign global hotspare
         			// 32 - unassign global hotspare
        	 		// 64 - online
         			// 128 - offline
         			// 256 - prepare to remove
         			// 512 - format
         			// 1024 - rebuild
         			// 2048 - cancel rebuild
         			// 4096 - initialize
         			// 8192 - verify
         			// 16384 - cancel verify
         			// 32768 - recover
         			// 524288 - cancel copyback
                                 var CurrentUrl=GetLocalUrl();
                               
				if (fromVDpage == 'true')
				{
					ADExecuteUrl = ADExecuteUrl + "&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;VirtualDiskName=<xsl:value-of select="/OMA/VirtualDiskName"/>&amp;RaidLayout=<xsl:value-of select="/OMA/RaidLayout"/>&amp;BackTo=<xsl:value-of select="/OMA/BackToKey"/>&amp;VDMemberPage=true";

					ADConfirmUrl = ADConfirmUrl + "&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;VirtualDiskName=<xsl:value-of select="/OMA/VirtualDiskName"/>&amp;RaidLayout=<xsl:value-of select="/OMA/RaidLayout"/>&amp;BackTo=<xsl:value-of select="/OMA/BackToKey"/>&amp;VDMemberPage=true";
				}
				else
				{      
                                        
					ADExecuteUrl = ADExecuteUrl + "&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>";

					ADConfirmUrl = ADConfirmUrl + "&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>";
				}

				if (action == "-") { 
					alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
      }
      			else if ((action =="1") || (action =="2") || (action =="4") || (action =="8") || (action =="32")  || (action =="512") || (action =="1024") || (action =="2048") || (action =="4096") || (action =="8192") || (action =="16384") || (action =="32768") || (action =="524288") ) {
                        if(document.getElementById("BackTo")!=null)
                        {
                        document.getElementById("BackTo").value='<xsl:value-of select="/OMA/BackTo"/>';
                        }
                        
                        document.dataarea.action = top.gnv.appendVID(ADExecuteUrl+"&amp;CurrentUrl="+CurrentUrl); 
					document.dataarea.submit();
				}
				else if (action =="16") {

					//assign global hotspare
					//do a check for controllers that needs extra confirm page
					var giveghswarning = <xsl:value-of select="$isGHSWarning"/>;

      if(giveghswarning == 0)
      {
          					document.dataarea.action = top.gnv.appendVID(ADExecuteUrl + "&amp;Force=false"); 
      document.dataarea.submit();
      }

      if(giveghswarning == 1)
      {
          					document.location.href = top.gnv.appendVID(ADConfirmUrl + "&amp;help=adtkghs");
      }

      }
      else if ((action =="64") || (action =="128")) {
        // online or offline
          
                        
            document.dataarea.action = top.gnv.appendVID(ADConfirmUrl + "&amp;help=adtkonl");
            document.dataarea.submit();
      }
      else if (action =="256") {
      // prepare to remove
               document.location.href = top.gnv.appendVID(ADConfirmUrl + "&amp;help=adprin");
      }
      			else if ( (action =="65536") || (action =="131072") ) { 
					//clear or cancelclear
          				document.location.href = top.gnv.appendVID(ADConfirmUrl + "&amp;help=adtkclr");	
				}
				else {
					alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
				}
			}
		</script>
	</xsl:template>
</xsl:stylesheet>
