<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Array Disks Information page.  The associated web plugin is the ADInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	<xsl:import href="adtbl.xsl"/>
	<xsl:template match="OMA">
		<!-- check to see if AD or HD should be visible -->
		<xsl:variable name="nonRaid">
			<xsl:call-template name="IsObjectNonRaid">
				<xsl:with-param name="Mask">
					<xsl:value-of select="ArrayDisks/DCStorageObject/AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<script language="javascript">
      function reloadPage()
      {
          document.location.href = top.gnv.appendVID(document.URL);
      }
    </script>
		
		<DataArea backpagetarget="/servlet/DataArea?plugin=com.dell.sm.webplugins.ControllerWebPlugin">
			<PageTitle>
				<xsl:choose>
					<xsl:when test="$nonRaid = '1' ">
						<xsl:choose>
							<xsl:when test="ArrayDisks/@ControllerName=''">
								<xsl:choose>
									<xsl:when test="count(ArrayDisks/DCStorageObject)>0">
										<xsl:attribute name="status"><xsl:value-of select="/OMA/Health/Component/@status"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
								<xsl:attribute name="display"><xsl:value-of select="$strTitle1a"/></xsl:attribute>
							</xsl:when>
							<xsl:when test="ArrayDisks/@ControllerName!=''">							
								<xsl:choose>
									<xsl:when test="count(ArrayDisks/DCStorageObject)>0">
											<xsl:attribute name="status"><xsl:value-of select="/OMA/Health/Component/@status"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
								<xsl:attribute name="display"><xsl:value-of select="$strTitle2aPart1"/><xsl:value-of select="ArrayDisks/@ControllerName"/><xsl:value-of select="$strTitle2aPart2"/></xsl:attribute>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="ArrayDisks/@ControllerName=''">
								<xsl:choose>
									<xsl:when test="count(ArrayDisks/DCStorageObject)>0">
											<xsl:attribute name="status"><xsl:value-of select="/OMA/Health/Component/@status"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
								<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/></xsl:attribute>
							</xsl:when>
							<xsl:when test="ArrayDisks/@ControllerName!=''">
								<xsl:choose>
									<xsl:when test="count(ArrayDisks/DCStorageObject)>0">
											<xsl:attribute name="status"><xsl:value-of select="/OMA/Health/Component/@status"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>							
								<xsl:attribute name="display"><xsl:value-of select="$strTitle2Part1"/><xsl:value-of select="ArrayDisks/@ControllerName"/><xsl:value-of select="$strTitle2Part2"/></xsl:attribute>
							</xsl:when>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</PageTitle>
			<CustomButton>
			<!-- The refresh button cannot use the below javascript to perform the refresh.  The issue is the  javascript calls the last webplug which was called
			      to render this page.  The problem is that the page can be rendered by two webplugins: the info webplugin and the action execute web plugin.
			      If the action execute webplugin was the last webplugin to render the page, pressing refresh would cause that action to be re-executed. -->
				<!--Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href"></xsl:attribute>
					<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
				</Data-->
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.ADInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;help=adprin</xsl:attribute>
				</Data>
			</CustomButton>
			<xsl:call-template name="ArrayDiskTable"/>
		</DataArea>
	</xsl:template>
	<xsl:template name="ArrayDiskTable">
		<!-- check to see if AD or HD should be visible -->
		<xsl:variable name="nonRaid">
			<xsl:call-template name="IsObjectNonRaid">
				<xsl:with-param name="Mask">
					<xsl:value-of select="ArrayDisks/DCStorageObject/AttributesMask"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="checkAdmin">
			<xsl:choose>
				<xsl:when test="OMAUserRights = '7'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!--CR49916 - auto refresh code -->
		<xsl:if test="ArrayDisks/DCStorageObject/Progress">
                      <HTMLData>
                               <script language="Javascript">
                               		<!--refresh page every 30 secs when atleast one adisk object has Progress property asscoiated with it-->
                                       setTimeout("reloadPage()",30000) ;
                               </script>
                      </HTMLData>
		</xsl:if>
		
		<TableData columnspacing="true">
			<SubHeader>
				<xsl:choose>
					<xsl:when test="$nonRaid = '1' ">
						<xsl:attribute name="display"><xsl:value-of select="$strTitle1a"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</SubHeader>
			<xsl:choose>
				<xsl:when test="count(ArrayDisks/DCStorageObject)>0">
					<Header>
						<xsl:call-template name="ArrayDiskTableHeader">
							<xsl:with-param name="tasks">
								<xsl:value-of select="$checkAdmin"/>
							</xsl:with-param>
							<xsl:with-param name="expanded">true</xsl:with-param>
						</xsl:call-template>
					</Header>

					<xsl:for-each select="ArrayDisks/DCStorageObject">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:sort select="TargetID" data-type="number" order="ascending"/>
						<xsl:call-template name="ArrayDiskTableRows">
							<xsl:with-param name="tasks">
								<xsl:value-of select="$checkAdmin"/>
							</xsl:with-param>
							<xsl:with-param name="expanded">true</xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<Row>
						<Data>
							<xsl:choose>
								<xsl:when test="$nonRaid = '1' ">
									<xsl:attribute name="display"><xsl:value-of select="$HDNoHDs"/></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="display"><xsl:value-of select="$ADNoADs"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</Data>
					</Row>
				</xsl:otherwise>
			</xsl:choose>
		</TableData>
	</xsl:template>
</xsl:stylesheet>
