<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:import href="Utils.xsl"/>
	<xsl:template match="/OMA">
		<xsl:if test="//DCStorageObject">
			<Summary>
				<Section name="Storage Services">
					<xsl:attribute name="display"><xsl:value-of select="$strStorageEnclosures"/></xsl:attribute>
					<xsl:for-each select="Enclosures/DCStorageObject">
						<xsl:call-template name="summary"/>
					</xsl:for-each>
				</Section>
			</Summary>
		</xsl:if>
	</xsl:template>
	<xsl:template name="summary">
		<ListData>
			<xsl:attribute name="display"><xsl:value-of select="$strStorageEnclosures"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="AssetName">
					<Data columnspacing="true" name="AssetName" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="AssetName"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strProductID"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="EnclosureType"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="EnclosureType"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="ServiceTag">
					<Data columnspacing="true" name="ServiceTag" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strServiceTag"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
					</Data>
				</xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="AssetTag">
					<Data columnspacing="true" name="AssetTag" editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$strAssetTag"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
					</Data>
				</xsl:when>
			</xsl:choose>
		</ListData>
	</xsl:template>
</xsl:stylesheet>
