<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="../common/Utils.xsl"/>
	<xsl:include href="../common/fantbl.xsl"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:template match="OMA">
		<DataArea>
			<PageTitle>
				<xsl:if test="count(Fans/DCStorageObject)='0'">
					<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/><xsl:value-of select="Fans/@EnclosureId"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="count(Fans/DCStorageObject) > '1'">
					<xsl:attribute name="display"><xsl:value-of select="$strTitle2"/><xsl:value-of select="Fans/@EnclosureId"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="count(Fans/DCStorageObject)='1'">
					<xsl:attribute name="display"><xsl:value-of select="$strTitle3"/><xsl:value-of select="Fans/DCStorageObject/Index"/> in Enclosure <xsl:value-of select="Fans/@EnclosureId"/></xsl:attribute>
				</xsl:if>
			</PageTitle>
			<xsl:choose>
				<xsl:when test="count(Fans/DCStorageObject)!=0">
					<TableData>
						<Header>
                                <xsl:call-template name="FanTableHeader"/>
						</Header>
                            <xsl:for-each select="Fans/DCStorageObject">
								<xsl:sort select="Index" data-type="number" order="ascending"/>
                            	<xsl:call-template name="FanTableRows"/>
                            </xsl:for-each>
					</TableData>
				</xsl:when>
			</xsl:choose>				
		</DataArea>
	</xsl:template>
	<xsl:template match="OMAUserRights"/>
	<xsl:template match="*"/>
</xsl:stylesheet>


