<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="../common/Utils.xsl"/>
	<xsl:include href="../common/encltbl.xsl"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:template match="OMA">
		<DataArea>
			<xsl:variable name="slotNum">
				<xsl:choose>
					<xsl:when test="Enclosures/@PCISlotNo = '-1' or Enclosures/@PCISlotNo = '2147483648' or Enclosures/@PCISlotNo = '0' ">
						<xsl:value-of select="$strEmbedded"/>
					</xsl:when>
					<xsl:when test="Enclosures/@PCISlotNo = '2147483649'">
						Not Available
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Enclosures/@PCISlotNo"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<!-- Determine which form of the cli was invoked.  This determines the page title. -->
			<xsl:choose>
				<xsl:when test="//Enclosures/@System='true'">
					<!-- The command: omreport storage enclosure   was called -->
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strTitle2"/></xsl:attribute>
					</PageTitle>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="string-length(//Enclosures/@EnclosureName) !=0 ">
							<PageTitle>
								<xsl:choose>
									<xsl:when test="Enclosures/@PCISlotNo != '' and Enclosures/@PCISlotNo != '-1' and Enclosures/@PCISlotNo != '0' and Enclosures/@PCISlotNo != '2147483649' and Enclosures/@PCISlotNo != '2147483648'">
										<xsl:attribute name="display"><xsl:value-of select="$strTitle3"/><xsl:value-of select="Enclosures/@EnclosureName"/> on Controller <xsl:value-of select="Enclosures/@ControllerName"/> (<xsl:value-of select="$strSlot"/><xsl:value-of select="$slotNum"/>)</xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="display"><xsl:value-of select="$strTitle3"/><xsl:value-of select="Enclosures/@EnclosureName"/> on Controller <xsl:value-of select="Enclosures/@ControllerName"/> (<xsl:value-of select="$strEmbedded"/>)</xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</PageTitle>
						</xsl:when>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates select="Enclosures"/>
		</DataArea>
	</xsl:template>
	<xsl:template match="Enclosures">
		<TableData>
			<SubHeader>
				<xsl:variable name="slotNum">
					<xsl:choose>
						<xsl:when test="@PCISlotNo = '-1' or @PCISlotNo = '2147483648' or @PCISlotNo = '0' ">
							<xsl:value-of select="$strEmbedded"/>
						</xsl:when>
						<xsl:when test="@PCISlotNo = '2147483649'">
							<xsl:value-of select="'Not Available'"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="@PCISlotNo"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="@PCISlotNo != '' and @PCISlotNo != '-1' and @PCISlotNo != '0' and @PCISlotNo != '2147483649' and @PCISlotNo != '2147483648'">
						<xsl:attribute name="display"><xsl:value-of select="$strTitle4"/><xsl:value-of select="@ControllerName"/> (<xsl:value-of select="$strSlot"/><xsl:value-of select="$slotNum"/>)</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="display"><xsl:value-of select="$strTitle4"/><xsl:value-of select="@ControllerName"/> (<xsl:value-of select="$strEmbedded"/>)</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</SubHeader>
			<Header>
				<xsl:call-template name="EnclosureTableHeader">
					<xsl:with-param name="tasks">false</xsl:with-param>
				</xsl:call-template>
			</Header>
			<xsl:for-each select="DCStorageObject">
				<xsl:call-template name="EnclosureTableRows">
					<xsl:with-param name="tasks">false</xsl:with-param>
				</xsl:call-template>
			</xsl:for-each>
		</TableData>
		<xsl:if test="count(DCStorageObject)=0">
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/></xsl:attribute>
			</PageTitle>
		</xsl:if>
	</xsl:template>
	<xsl:template match="OMAUserRights"/>
	<xsl:template match="*"/>
</xsl:stylesheet>
