<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="../common/Utils.xsl"/>
	<xsl:include href="../common/chnltbl.xsl"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:template match="/">
		<DataArea>
			<xsl:variable name="slotNum">
				<xsl:choose>
					<xsl:when test="//Channels/@PCISlotNo = '-1' or //Channels/@PCISlotNo = '2147483648' or //Channels/@PCISlotNo = '0' ">
						<xsl:value-of select="$strEmbedded"/>
					</xsl:when>
					<xsl:when test="//Channels/@PCISlotNo = '2147483649'">
					<xsl:value-of select="'Not Available'"/>
					</xsl:when>
					<xsl:otherwise>Slot <xsl:value-of select="//Channels/@PCISlotNo"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="count(//Channels/DCStorageObject)!=0">
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/><xsl:value-of select="//Channels/@ControllerName"/> (<xsl:value-of select="$slotNum"/>)</xsl:attribute>
					</PageTitle>
					<xsl:apply-templates select="//Channels"/>
					</xsl:when>
				<xsl:otherwise>
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strHeader1"/></xsl:attribute>
					</PageTitle>
				</xsl:otherwise>
			</xsl:choose>							
		</DataArea>
	</xsl:template>
	<xsl:template match="Channels">
		<xsl:choose>
			<xsl:when test="substring(DCStorageObject/AttributesMask,26,1)='1'">
				<TableData>
					<Header>
						<xsl:call-template name="ChannelTableHeader">
							<xsl:with-param name="tasks">false</xsl:with-param>
						</xsl:call-template>
					</Header>
					<xsl:for-each select="DCStorageObject[1]">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:call-template name="ChannelTableRows">
							<xsl:with-param name="tasks">false</xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</TableData>
			</xsl:when>
			<xsl:otherwise>
				<TableData>
					<Header>
						<xsl:call-template name="ChannelTableHeader">
							<xsl:with-param name="tasks">false</xsl:with-param>
						</xsl:call-template>
					</Header>
					<xsl:for-each select="DCStorageObject">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:call-template name="ChannelTableRows">
							<xsl:with-param name="tasks">false</xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</TableData>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="OMAUserRights"/>
	<xsl:template match="*"/>
</xsl:stylesheet>


