<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="../common/Utils.xsl"/>
	<xsl:key name="ADList" match="//SSDAResponse/CapsArrayDisksInfo" use="@Layout"/>
	<xsl:template match="/">
		<DataArea>
			<PageTitle><xsl:attribute name="display"><xsl:value-of select="$strTitle1"/></xsl:attribute></PageTitle>
			<TableData>
				<Header>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strHeader1"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strHeader2"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strHeader3"/></xsl:attribute>
					</Data>
					<Data>	
						<xsl:attribute name="display"><xsl:value-of select="$strHeader4"/></xsl:attribute>
					</Data>					
				</Header>
				<xsl:for-each select="//Caps/DCStorageObject"><xsl:call-template name="RenderRows"/></xsl:for-each>
			</TableData>
		</DataArea>
	</xsl:template>	
	<xsl:template name="RenderRows">
		<Row>
			<Data><xsl:attribute name="value"><xsl:value-of select="MinimumLength"/>b</xsl:attribute></Data>
			<Data><xsl:attribute name="value"><xsl:value-of select="Length"/>b</xsl:attribute></Data>
			<Data><xsl:attribute name="value"><xsl:call-template name="GetCLIRaidLayoutValue"><xsl:with-param name="RaidType"><xsl:value-of select="Layout"/></xsl:with-param></xsl:call-template></xsl:attribute></Data>
			<Data><xsl:attribute name="value"><xsl:for-each select="key('ADList',Layout)"><xsl:value-of select="."/></xsl:for-each></xsl:attribute></Data>
		</Row>
	</xsl:template>
</xsl:stylesheet>
