<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<HTML>
			<head>
			<title>
			<xsl:choose>
				<!-- OEM -->
				<xsl:when test="OEM/OEMTitleCompanyName = ''">
					<xsl:choose>
						<xsl:when test="OEM/ProdName = ''">
							<xsl:value-of select="OEM/OEMTitleCoreProductName" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="ProdName"><xsl:with-param name="prodname"><xsl:value-of select="OEM/ProdName" /></xsl:with-param></xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<!-- none-OEM -->
				<xsl:otherwise>
					<xsl:value-of select="OEM/OEMTitleCompanyName" /><xsl:text> </xsl:text><xsl:value-of select="OEM/OEMTitleCoreProductName" /><xsl:text> </xsl:text><xsl:call-template name="ProdName"><xsl:with-param name="prodname"><xsl:value-of select="OEM/ProdName" /></xsl:with-param></xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
			</title>
			</head>
			<xsl:choose>
			
				<xsl:when test="load != ''">
					<xsl:choose>
						<xsl:when test="load = 'embedded'">
							<frameset rows="20,34,*" border="0" framespacing="0">
								<xsl:call-template name="body" />
							</frameset>
						</xsl:when>
						<xsl:when test="load = 'default'">
							<frameset rows="57,34,*" border="0" framespacing="0">
								<xsl:call-template name="body" />
							</frameset>
						</xsl:when>
						<xsl:otherwise>
							<meta http-equiv="Refresh">
								<xsl:attribute name="content">0;url=<xsl:value-of select="load" />?vid=<xsl:value-of select="VID" /></xsl:attribute>
							</meta>
							<body />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<script language="javascript" src="/oma/js/index.js" />
					<frameset rows="19,*" border="0" frameborder="no" framespacing="0">
						<frame name="gnv" scrolling="no" marginheight="0" marginwidth="0" frameborder="no" framespacing="0" noresize="noresize">
						<xsl:attribute name="src">
								<xsl:choose>
									<xsl:when test="Preference = 'true'">/servlet/SecureGlobalNavBarServlet?preference=true&amp;vid=<xsl:value-of select="/OMA/VID" /></xsl:when>
									<xsl:otherwise>/servlet/SecureGlobalNavBarServlet?vid=<xsl:value-of select="/OMA/VID" /></xsl:otherwise>
								</xsl:choose>
						</xsl:attribute>
						</frame>
						<frame name="body" scrolling="no" marginheight="0" marginwidth="0" frameborder="no" framespacing="0" noresize="noresize">
							<xsl:attribute name="src">/oma/loading.html</xsl:attribute>
						</frame>
					</frameset>
				</xsl:otherwise>
			</xsl:choose>
			<noframes />
		</HTML>
	</xsl:template>
	
	<xsl:template name="ProdName">
		<xsl:param name="prodname"/>
		<xsl:choose>
			<xsl:when test="$prodname = 'Preferences'"><xsl:value-of select="$strPreferences"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$prodname"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="body">
		<xsl:choose>
			<xsl:when test="load = 'embedded'">
				<frameset cols="165,*" border="0" frameborder="no" framespacing="0">
					<frame name="logo" scrolling="no" marginheight="0" marginwidth="0" frameborder="no" framespacing="0" noresize="noresize">
					<xsl:attribute name="src">/servlet/SysInfo?vid=<xsl:value-of select="/OMA/VID" /></xsl:attribute>
					</frame>
					<frame src="/oma/loading.html" name="snb" scrolling="no" marginheight="0" marginwidth="0" frameborder="no" framespacing="0" />
				</frameset>
			</xsl:when>
			<xsl:otherwise>
				<frameset cols="165,*" border="0" frameborder="no" framespacing="0">
					<frame name="logo" scrolling="no" marginheight="0" marginwidth="0" frameborder="no" framespacing="0" noresize="noresize">
					<xsl:attribute name="src">/servlet/Logo?vid=<xsl:value-of select="/OMA/VID" /></xsl:attribute>
					</frame>
					<frameset rows="37,20" border="0" frameborder="no" framespacing="0">
						<frame name="SystemInfo" scrolling="no" marginheight="0" marginwidth="0" frameborder="no" framespacing="0" noresize="noresize" >
						<xsl:attribute name="src">/servlet/SysInfo?session=true&amp;vid=<xsl:value-of select="/OMA/VID" /></xsl:attribute>
						</frame>
						<frame src="/oma/loading.html" name="snb" scrolling="no" marginheight="0" marginwidth="0" frameborder="no" framespacing="0" noresize="noresize" />
					</frameset>
				</frameset>
			</xsl:otherwise>
		</xsl:choose>
		<frameset cols="165,1,*" border="0" frameborder="no" framespacing="0">
				<frame name="sn" scrolling="no" marginheight="0" marginwidth="0" framespacing="0" noresize="noresize">
				<xsl:attribute name="src">/servlet/ServerName?vid=<xsl:value-of select="/OMA/VID" /></xsl:attribute>
				</frame>
				<frame name="vline" scrolling="no" marginheight="0" marginwidth="0" frameborder="no" framespacing="0" noresize="noresize">
					<xsl:attribute name="src">/oma/skins/<xsl:value-of select="@skin" />/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if>vline.html</xsl:attribute>
				</frame>
				<frameset rows="26,8" border="0" frameborder="no" framespacing="0">
					<frame src="/oma/loading.html" name="lsnb" scrolling="no" marginheight="0" marginwidth="0" frameborder="no" framespacing="0" noresize="noresize" />
					<frame name="hline" scrolling="no" marginheight="0" marginwidth="0" frameborder="no" framespacing="0" noresize="noresize">
						<xsl:attribute name="src">/oma/skins/<xsl:value-of select="@skin" />/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if>hline.html</xsl:attribute>
					</frame>
				</frameset>
		</frameset>
		<frameset cols="165,*" frameborder="yes" border="1" framespacing="1" bordercolor="#D8EBFC">
				<frame name="ct" scrolling="auto" marginheight="0" marginwidth="0" framespacing="0" >
				<xsl:attribute name="src">/servlet/ComponentTree?vid=<xsl:value-of select="/OMA/VID" /></xsl:attribute>
				</frame>
				<frame src="/oma/loading.html" name="da" scrolling="auto" marginheight="0" marginwidth="0" frameborder="no" framespacing="0" />
		</frameset>
	</xsl:template>
</xsl:stylesheet>
