<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html"/>
	<xsl:template match="Server">
		<html>
			<head>
				<title/>
				<link rel="stylesheet" type="text/css" href="/oma/docs/oma.css"/>
				<xsl:if test="@skin != ''">
					<link rel="stylesheet" type="text/css">
						<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if>scheme.css</xsl:attribute>
					</link>
					<xsl:if test="@language != ''">
						<link rel="stylesheet" type="text/css">
							<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/scheme.css</xsl:attribute>
						</link>
						<xsl:if test="@country != ''">
							<link rel="stylesheet" type="text/css">
								<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/<xsl:value-of select="@country"/>/scheme.css</xsl:attribute>
							</link>
						</xsl:if>
					</xsl:if>
				</xsl:if>
				<script language="javascript">
					function select () {
						try {
							if (parent.ct.g_bModal == false) {
								var vvid = top.gnv.getVID();
								parent.ct.location.href='/servlet/ComponentTree?refresh=true&amp;vid='+vvid;
							}
						}
						catch (e) {
						}
					}
				</script>
			</head>
			<body class="server-name">
				<table border="0" cellpadding="0" cellspacing="0" width="100%">
				<tr>
					<td align="center" valign="middle" style="height: 30px">
						<a class="server-name" href="#" onclick="javascript:select()">
							<xsl:attribute name="title"><xsl:value-of select="@name"/></xsl:attribute>
							<xsl:choose>
								<xsl:when test="string-length(@name)>10">
									<xsl:value-of select="substring(@name, 1, 10)"/>...</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="@name"/>
								</xsl:otherwise>
							</xsl:choose>
						</a>
					</td>
				</tr>
				</table>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
