<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<HTML>
			<HEAD>
				<TITLE/>
				<script language="javascript" src="/oma/js/gnavbar.js" />
				<link href="/oma/docs/oma.css" type="text/css" rel="stylesheet"/>
				<xsl:if test="@skin != ''">
					<link rel="stylesheet" type="text/css">
						<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if>scheme.css</xsl:attribute>
					</link>
					<xsl:if test="@language != ''">
						<link rel="stylesheet" type="text/css">
							<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/scheme.css</xsl:attribute>
						</link>
						<xsl:if test="@country != ''">
							<link rel="stylesheet" type="text/css">
								<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/<xsl:value-of select="@country"/>/scheme.css</xsl:attribute>
							</link>
						</xsl:if>
					</xsl:if>
				</xsl:if>
			</HEAD>
			
			<script language="javascript">
				function init() {
					<xsl:if test="PrevProgram">
						initPrevious();
					</xsl:if>
					<xsl:if test="VID">
					var vid ="";
						<xsl:choose>
							<xsl:when test=	"(VID = '' )">
								vid="1234";
							</xsl:when>
							<xsl:otherwise>
								vid = <xsl:value-of select="VID"/>;
							</xsl:otherwise>
						</xsl:choose>
					document.getElementById("vid").value = vid;	
					</xsl:if>
					loadFrames(vid);
				}
				function loadFrames(vidval){
					if(parent.body)
						parent.body.location='/servlet/OMSAStart?load=body&amp;vid='+vidval;
				}				
				function initPrevious() {
					document.getElementById("prevprog").noWrap = true;
				}
				function updateVID(vvid)
				{
					document.getElementById("vid").value = vvid;
				}
				
				function appendVID(url)
				{
				    
				    var vvid = document.getElementById("vid").value;
					
				    if((index=url.indexOf("javascript")) == -1){

					if((index=url.indexOf('#')) != -1){
						url = url.substring(0,index);
					}
					if( (url.indexOf("&amp;vid=") == -1) &amp;&amp; (url.indexOf("?vid=") == -1)){
					
					if(url.indexOf('?') != -1){
						url += "&amp;vid=" + vvid;
					}else{
						url += "?vid=" + vvid;
					}
				      }//vid
				    }//javascript
					return url;
				
				  }				
				function getVID()
				{
					var vvid = document.getElementById("vid").value;
					return vvid;
				}
			</script>
			
			<BODY class="gnavbar" onload="javascript:init()">
				<input type="hidden" name="vid" id="vid" value="1234" />
				<table cellpadding="0" cellspacing="0" width="100%" height="19" border="0">
					<tr>
						<td   id="prevprog" align="right" valign="middle">
							<table border="0" cellpadding="0" cellspacing="0" width="100%">
								<tr>
									<xsl:apply-templates select="OEM" />
									<td align="right" valign="middle">
										<table border="0" cellpadding="0" cellspacing="0">
											<tr>
												<xsl:choose>
													<xsl:when test="/OMA/Preference != 'true' or /OMA/About = 'true' or /OMA/Help = 'true' or /OMA/RestartReminder = 'true'"></xsl:when>
													<xsl:otherwise>														
														<xsl:choose>
															<xsl:when test="/OMA/Login = 'true'"></xsl:when>
															<xsl:otherwise>
																<xsl:if test="PrevProgram">
																	<td align="right" valign="middle">
																		<a href="#" id="Back" name="Back" class="global-nav-bar-item"><xsl:attribute name="onclick">javascript:returnProgram ('<xsl:value-of select="PrevProgram"/>')</xsl:attribute>&#160;<xsl:value-of select="$strBackTo1"/><xsl:value-of select="PrevProgram/@displayname"/><xsl:value-of select="$strBackTo3"/>&#160;</a>
																	</td>
																	<xsl:call-template name="spacer" />
																</xsl:if>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:otherwise>
												</xsl:choose>
												
												<xsl:choose>
													<xsl:when test="/OMA/Preference = 'true' or /OMA/About = 'true' or /OMA/Help = 'true' or /OMA/RestartReminder = 'true'"></xsl:when>
													<xsl:otherwise>														
														<xsl:choose>
															<xsl:when test="/OMA/Login = 'true'"></xsl:when>
															<xsl:otherwise>
																<td width="100" align="right" valign="middle">
																	<a href="#" id="Preferences" name="Preferences" onclick="javascript:openPreference ()" class="global-nav-bar-item">&#160;<xsl:value-of select="$strPreferences"/>&#160;</a>
																</td>
																<xsl:call-template name="spacer" />
															</xsl:otherwise>
														</xsl:choose>
													</xsl:otherwise>
												</xsl:choose>
												
												<xsl:choose>
													<xsl:when test="/OMA/ProductNum = '1'  or /OMA/ProductNum = '0' or  /OMA/Preference = 'true'  or /OMA/Task = 'true' or /OMA/About = 'true' or /OMA/Help = 'true' or /OMA/RestartReminder = 'true'"></xsl:when>
													<xsl:when test="/OMA/ApplicationList = 'noApp'"></xsl:when>
													<xsl:otherwise>
														<xsl:choose>
															<xsl:when test="/OMA/Login = 'true'"></xsl:when>
															<xsl:otherwise>
																<td width="100" align="center" valign="middle">
																	<a href="#" id="Applications" name="Applications" onclick="javascript:openTaskWindow ()" class="global-nav-bar-item">&#160;<xsl:value-of select="$strApplications"/>&#160;</a>
																</td>
																<xsl:call-template name="spacer" />
															</xsl:otherwise>
														</xsl:choose>
													</xsl:otherwise>
												</xsl:choose>
												
												
												<xsl:choose>
													<xsl:when test="/OMA/Help = 'true'"></xsl:when>
													<xsl:when test="/OMA/About = 'true'"></xsl:when>
													<xsl:otherwise>
														<xsl:if test="OEM/WWWSupport != ''">
															<xsl:apply-templates select="OEM//WWWSupport" />
															<xsl:call-template name="spacer" />
														</xsl:if>
													</xsl:otherwise>
												</xsl:choose>
												<xsl:choose>
													<xsl:when test="/OMA/Help = 'true'"></xsl:when>
													<xsl:when test="/OMA/About = 'true'"></xsl:when>
													<xsl:otherwise>
														<td align="center" valign="middle" class="gnavbar-menu-item">
															<xsl:choose>
																<xsl:when test="(/OMA/Login = 'true') and not(/OMA/Login/@webserverstop)">
																	<a href="#" id="Help" name="Help" onclick="javascript:help ('/servlet/UOMSAHelp' , 'null')" class="global-nav-bar-item">&#160;<xsl:value-of select="$strHelp"/>&#160;</a>
																</xsl:when>
																<xsl:otherwise>
																<xsl:if test="not(/OMA/Login/@webserverstop)">
																		<a href="#" id="Help" name="Help" class="global-nav-bar-item"><xsl:attribute name="onclick">javascript:help ('/servlet/OMSAHelp?nbflag=true' , '<xsl:value-of select="/OMA/WindowReference"/>')</xsl:attribute>&#160;<xsl:value-of select="$strHelp1"/>&#160;</a>
																	</xsl:if>
																</xsl:otherwise>
															</xsl:choose>
														</td>
														<xsl:if test="not(/OMA/Login/@webserverstop)">
															<xsl:call-template name="spacer" />
														</xsl:if>
													</xsl:otherwise>
												</xsl:choose>
												<xsl:choose>
													<xsl:when test="/OMA/About = 'true'" />
													<xsl:otherwise>
														<td align="center" valign="middle" class="gnavbar-menu-item">
															<xsl:choose>
																	<xsl:when test="(/OMA/Login = 'true') and not(/OMA/Login/@webserverstop) and not(/OMA/Login/@noscripts)">
																	<a href="#" id="About" name="About" onclick="javascript:about ('/servlet/UOMSAAbout' ,  'notlogin')" class="global-nav-bar-item">
																		&#160;<xsl:value-of select="$strAbout"/>&#160;
																	</a>
																</xsl:when>
																<xsl:otherwise>
																	<xsl:if test="not(/OMA/Login/@webserverstop) and not(/OMA/Login/@noscripts)">
																	<a href="#" id="About" name="About" class="global-nav-bar-item"><xsl:attribute name="onclick">javascript:about ('/servlet/OMSAAbout?nbflag=true'  ,  '<xsl:value-of 	select="/OMA/WindowReference"/>')</xsl:attribute>&#160;<xsl:value-of select="$strAbout1"/>&#160;</a>
																	</xsl:if>																
																	</xsl:otherwise>
															</xsl:choose>
														</td>
														<xsl:if test="not(/OMA/Login/@noscripts)">
															<xsl:call-template name="spacer" />
														</xsl:if>
													</xsl:otherwise>
												</xsl:choose>
												<xsl:choose>
													<xsl:when test="/OMA/Help = 'true' or /OMA/About = 'true' and not(/OMA/Login/@noscripts)">
														<td align="center" valign="middle" class="gnavbar-menu-item">
														<xsl:if test="not(/OMA/Login/@noscripts)">
															<a href="#" id="Close" name="Close" onclick="javascript:closePopUpWindow ()" class="global-nav-bar-item">&#160;<xsl:value-of select="$strClose"/>&#160;</a>
														</xsl:if>	
														</td>
													</xsl:when>
													
													<xsl:when test="/OMA/Login = 'true'"></xsl:when>
													<xsl:when test="/OMA/RestartReminder = 'true'"></xsl:when>
												
													<xsl:otherwise>
														<td align="center" valign="middle" class="gnavbar-menu-item">
															<a href="#" id="Logout" name="Logout" onclick="javascript:logout ()" class="global-nav-bar-item">&#160;<xsl:value-of select="$strLogOut"/>&#160;</a>
														</td>
														<xsl:call-template name="spacer" />
													</xsl:otherwise>
												</xsl:choose>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td style="height: 1px;" class="gnavbar-separator"><img style="height: 1px; width: 1px"/></td>
					</tr>
				</table>
			</BODY>
		</HTML>
	</xsl:template>
	<xsl:template match="OEM">
		<td align="left" valign="middle" class="gnavbar-menu-item">
			<a id="Prodname" name="Prodname" class="global-nav-bar-item">
			<xsl:choose>
				<!-- OEM -->
				<xsl:when test="OEMTitleCompanyName = ''">
					<xsl:choose>
						<xsl:when test="ProdName = ''">
							<xsl:value-of select="OEMTitleCoreProductName" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="ProdName"><xsl:with-param name="prodname"><xsl:value-of select="ProdName" /></xsl:with-param></xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<!-- none-OEM -->
				<xsl:otherwise>
					<xsl:value-of select="OEMTitleCompanyName" />&#160;<xsl:value-of select="OEMTitleCoreProductName" />&#160;<xsl:call-template name="ProdName"><xsl:with-param name="prodname"><xsl:value-of select="ProdName" /></xsl:with-param></xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
			</a>
		</td>
	</xsl:template>
	
	<xsl:template name="ProdName">
		<xsl:param name="prodname"/>
		<xsl:choose>
			<xsl:when test="$prodname = 'Preferences'"><xsl:value-of select="$strPreferences1"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$prodname"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="spacer">
		<td style="width: 6px;" align="left" valign="middle">
			<img style="height: 17px; width: 6px">
				<xsl:attribute name="src">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if>images/gnavsp.gif</xsl:attribute>
			</img>
		</td>
	</xsl:template>
	<xsl:template match="WWWSupport">
		<td align="center" valign="middle" class="gnavbar-menu-item">
			<xsl:variable name="href" select="."/>
			<xsl:variable name="supportpage">
				<xsl:choose>
					<xsl:when test="contains($href , 'http:')"><xsl:value-of select="."/></xsl:when>
					<xsl:when test="contains($href , 'https:')"><xsl:value-of select="."/></xsl:when>
					<xsl:otherwise>http://<xsl:value-of select="."/></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>	
			<a href="#" id="Support" name="Support" class="global-nav-bar-item">
					<xsl:attribute name="onclick">javascript:support ('<xsl:value-of select="$supportpage"/>' , '<xsl:value-of select="/OMA/WindowReference"/>')</xsl:attribute>&#160;	<xsl:value-of select="$strSupport"/>&#160;
			</a>
		</td>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>
