<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:text disable-output-escaping="yes">
			&lt;xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
		</xsl:text>
		<xsl:element name="xsl:variable">
			<xsl:attribute name="name">displayparams</xsl:attribute>
			<xsl:attribute name="select">0</xsl:attribute>
		</xsl:element>
		<xsl:apply-templates select="IncludePath"/>
		<xsl:apply-templates select="OMAUserRights"/>
		<xsl:text disable-output-escaping="yes">
			&lt;/xsl:stylesheet>
		</xsl:text>	
	</xsl:template>
	<xsl:template match="IncludePath">
		<xsl:element name="xsl:include">
			<xsl:attribute name="href">file:<xsl:value-of select="."/></xsl:attribute>
		</xsl:element>
	</xsl:template>
	<xsl:template match="OMAUserRights">
		<xsl:element name="xsl:template">
			<xsl:attribute name="match">EventLog</xsl:attribute>
			<DataArea>
				<xsl:if test="number(.) > 1">
					<script language="javascript">
					function clearLog()
					{
						document.dataarea.action=top.gnv.appendVID('/servlet/SubmitForm?plugin=com.dell.oma.webplugins.ClearCmdLogWebPlugin');
						//[pp 01/0804 - DFCT102605 Prompt user to confirm before deleting log
						if(confirm('<xsl:value-of select="$strAreYouSure"/>'))
							document.dataarea.submit();
					}
					function saveLog()
					{
						document.dataarea.action=top.gnv.appendVID('/servlet/SubmitForm?plugin=com.dell.oma.webplugins.SaveLogWebPlugin');
						
						// DFCT93265, Clicking on the "Save As" button second time and performing either save or cancel, resulted an Abend on all flavous of Netware.
                                		// The following single line has been added for fixing the problem.
				
						document.getElementById("pageCode").value = "";
						
						document.getElementById("pageCode").value = document.getElementsByTagName("HTML")[0].innerHTML;
						document.dataarea.submit();
					}
					</script>
				</xsl:if>		
				<Header><xsl:value-of select="$strPageHeader"/></Header>
				<PageTitle><xsl:attribute name="display"><xsl:value-of select="$strCommandLog"/></xsl:attribute></PageTitle>
				<PromptText><xsl:value-of select="$strCommandLogContains"/></PromptText>				
					<CustomButton>
						<xsl:if test="number(.) > 1">
							<xsl:if test="(/OMA/OMAUserRights = '7')">	
								<Data name="Clear"><xsl:attribute name="display"><xsl:value-of select="$strClearLog"/></xsl:attribute>
									<xsl:attribute name="href">javascript:clearLog()</xsl:attribute>
									<xsl:attribute name="formSubmit">true</xsl:attribute>
								</Data>
							</xsl:if>
							<Data name="Clear"><xsl:attribute name="display"><xsl:value-of select="$strSaveAs"/></xsl:attribute>
								<xsl:attribute name="href">javascript:saveLog()</xsl:attribute>
								<xsl:attribute name="formSubmit">true</xsl:attribute>
							</Data>
						</xsl:if>
						<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
							<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.oma.webplugins.CmdLogWebPlugin</xsl:attribute>
						</Data>
					</CustomButton>
				<TableData columnspacing="true">
					<Header>
						<Data name="Severity" width="80" link="true" href="/servlet/DataArea?plugin=com.dell.oma.webplugins.CmdLogSevWebPlugin"><xsl:attribute name="value"><xsl:value-of select="$strSeverity"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$strSeverity1"/></xsl:attribute></Data>
						<Data name="DateTime" width="110" link="true" href="/servlet/DataArea?plugin=com.dell.oma.webplugins.CmdLogWebPlugin"><xsl:attribute name="value"><xsl:value-of select="$strDateAmpTime"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$strDateAmpTime1"/></xsl:attribute></Data>
						<Data name="User" link="true" href="/servlet/DataArea?plugin=com.dell.oma.webplugins.CmdLogUsrWebPlugin"><xsl:attribute name="value"><xsl:value-of select="$strUser"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$strUser1"/></xsl:attribute></Data>
						<Data name="Description"><xsl:attribute name="value"><xsl:value-of select="$strDescription"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$strDescription1"/></xsl:attribute></Data>
					</Header>
					<xsl:element name="xsl:apply-templates">
						<xsl:attribute name="select">LogEntry</xsl:attribute>
						<xsl:element name="xsl:sort">
							<xsl:attribute name="select">TimeStamp</xsl:attribute>
							<xsl:attribute name="data-type">number</xsl:attribute>
							<xsl:attribute name="order">descending</xsl:attribute>
						</xsl:element>
					</xsl:element>
				</TableData>
			</DataArea>
		</xsl:element>

	</xsl:template> <!-- <xsl:template match="OMAUserRights"> -->

</xsl:stylesheet>
