<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>

	<xsl:template match="/">
		<xsl:variable name="rootnode" select="name(child::node()[position()=1])"/>
		<xsl:element name="{$rootnode}">
			<xsl:if test="count(child::node()[position()=1]/attribute::*) > 0">
				<xsl:copy-of select="child::node()[position()=1]/@*"/>
			</xsl:if>			
			<xsl:apply-templates select="child::node()[position()=1]"/>
		</xsl:element>
	</xsl:template>
	
	<xsl:template match="child::node()[position()=1]">
		<xsl:choose>
			<xsl:when test="count(ancestor-or-self::node()) > 2">
				<xsl:for-each select="child::node()">
					<xsl:sort select="@display" order="ascending"/>
					<xsl:call-template name="child-label">
						<xsl:with-param name="nodename" select="name()"/>
					</xsl:call-template>		
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="child::node()">
					<xsl:call-template name="child-label">
						<xsl:with-param name="nodename" select="name()"/>
					</xsl:call-template>		
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="child-label">
		<xsl:param name="nodename"/>
				
		<xsl:element name="{$nodename}">
			<xsl:if test="count(attribute::*) > 0">
				<xsl:copy-of select="@*"/>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="count(child::node()) > 0 and count(ancestor-or-self::node()) > 4">
					<xsl:for-each select="child::node()">
						<xsl:sort select="@display" order="ascending"/>
						<xsl:call-template name="child-label">
							<xsl:with-param name="nodename" select="name()"/>
						</xsl:call-template>		
					</xsl:for-each>
				</xsl:when>
				<xsl:when test="count(child::node()) > 0 and count(ancestor-or-self::node()) > 1">
					<xsl:for-each select="child::node()">
						<xsl:sort select="@display" order="ascending"/>
						<xsl:call-template name="child-label">
							<xsl:with-param name="nodename" select="name()"/>
						</xsl:call-template>		
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:for-each select="child::node()">
						<xsl:call-template name="child-label">
							<xsl:with-param name="nodename" select="name()"/>
						</xsl:call-template>		
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:element>	
	</xsl:template>
	
	<xsl:template match="*"/>
</xsl:stylesheet>
